//****************************************************************************
// Two slightly different office containers. 
// ***************************************************************************
// Objects provided by this file are:
//	black_plastic
//	moebelrolle
//	schublade1
//	schublade2
//	BUEROCONTAINER1
//	BUEROCONTAINER2
//
// Textures provided by this file are:
//	computerwhite_plastic
//	brightgreen_LED
//	dark_LED
// ***************************************************************************
// Scale: 1 millimeter per POV unit.
// ***************************************************************************
// *               Manfred.Agne@munich.netsurf.de  (1998)                    *
// *                     Feel free to use this file.                         *
// ***************************************************************************

#include "woods.inc"
#include "metals.inc"

//############################################################################
// Mbelrolle fr Container; Mae in mm; steht auf z=0 -Ebene, Befestigung an
// Bolzen an (0,60,0), beliebig rotierbar um z-Achse.
//----------------------------------------------------------------------------
#declare black_plastic =
texture {
  pigment { color red 0.3 green 0.3 blue 0.3}
  normal { bumps 0.5 scale 0.3 }
  finish { phong 1 }
}
//----------------------------------------------------------------------------
#declare moebelrolle =
union {
  cylinder {<25,25, 25>,<25,25, 5>, 25}
  cylinder {<25,25,-25>,<25,25,-5>, 25}
  cylinder {<25,25,-20>,<25,25,20>,  5}
  difference {
    cylinder {<25,25,25>,<25,25,-25>,30}
    cylinder {<25,25,26>,<25,25,-26>,27}
    plane {<0,1,0> 25 }
  }
  difference {
    cylinder {<0,25,0>,<0,55,0>,25}
    cylinder {<25,25,26>,<25,25,-26>,27}
    plane {<0,1,0> 25 }
  }
  cylinder {<0,55,0>,<0,60,0>,25}
}
//############################################################################
// Bro-Container: Rollcontainer, passend zu Tisch und Stuhl. Symmetrisch zur
// x-Achse, Tiefe 800mm (+-400). 700mm hoch (y). 
//----------------------------------------------------------------------------
#declare schublade1 = 
union {
  box {<-390, 0,-200>,<-380,200,200> texture {T_Wood7 scale <30,30,30>}}
  box {<-400,10,-200>,<-390,190,200> texture {T_Wood7 scale <30,30,30>}}
  cylinder{<-390, 10,-200>,<-390, 10,200>,10 texture {T_Wood7 scale <30,30,30>}}
  cylinder{<-390,190,-200>,<-390,190,200>,10 texture {T_Wood7 scale <30,30,30>}}
  difference {
    torus {30,6}
    plane {<0,0,1>,0}
    translate <-400,100,40>
    texture {T_Chrome_1A}
  }  
  difference {
    torus {30,6}
    plane {<0,0,-1>,0}
    translate <-400,100,-40>
    texture {T_Chrome_1A}
  }  
  cylinder {<-430,100,-40>,<-430,100,40>,6 texture {T_Chrome_1A}}
}
//----------------------------------------------------------------------------
#declare schublade2 = 
union {
  box {<-390, 0,-200>,<-380,402,200> texture {T_Wood7 scale <30,30,30>}}
  box {<-400,10,-200>,<-390,392,200> texture {T_Wood7 scale <30,30,30>}}
  cylinder{<-390, 10,-200>,<-390, 10,200>,10 texture {T_Wood7 scale <30,30,30>}}
  cylinder{<-390,390,-200>,<-390,390,200>,10 texture {T_Wood7 scale <30,30,30>}}
  difference {
    torus {30,6}
    plane {<0,0,1>,0}
    translate <-400,300,40>
    texture {T_Chrome_1A}
  }  
  difference {
    torus {30,6}
    plane {<0,0,-1>,0}
    translate <-400,300,-40>
    texture {T_Chrome_1A}
  }  
  cylinder {<-430,300,-40>,<-430,300,40>,6 texture {T_Chrome_1A}}
}
//----------------------------------------------------------------------------
#declare BUEROCONTAINER1 =
union {
  box {<-400,664,-200>,<400,690,200> texture {T_Wood7 rotate<0,90,0> scale <30,30,30>}}
  box {<-390,690,-200>,<390,700,200> texture {T_Wood7 rotate<0,90,0> scale <30,30,30>}}
  cylinder{<-390,690,-200>,<-390,690,200>,10 texture {T_Wood7 scale <30,30,30>}}
  cylinder{< 390,690,-200>,< 390,690,200>,10 texture {T_Wood7 scale <30,30,30>}}
  //---Korpus:---
  box{<-383,62,-198>,<383,664,198> texture {T_Wood7 rotate<0,90,0> scale <30,30,30>}}
  object{schublade1 translate<0, 60,0>}
  object{schublade1 translate<0,262,0>}
  object{schublade1 translate<0,464,0>}
  object {moebelrolle rotate<0,170,0> translate<-370,0,-170> texture {black_plastic}}
  object {moebelrolle rotate<0,170,0> translate< 370,0,-170> texture {black_plastic}}
  object {moebelrolle rotate<0,170,0> translate<-370,0, 170> texture {black_plastic}}
  object {moebelrolle rotate<0,170,0> translate< 370,0, 170> texture {black_plastic}}
}
//----------------------------------------------------------------------------
#declare BUEROCONTAINER2 =
union {
  box {<-400,664,-200>,<400,690,200> texture {T_Wood7 rotate<0,90,0> scale <30,30,30>}}
  box {<-390,690,-200>,<390,700,200> texture {T_Wood7 rotate<0,90,0> scale <30,30,30>}}
  cylinder{<-390,690,-200>,<-390,690,200>,10 texture {T_Wood7 scale <30,30,30>}}
  cylinder{< 390,690,-200>,< 390,690,200>,10 texture {T_Wood7 scale <30,30,30>}}
  //---Korpus:---
  box{<-383,62,-198>,<383,664,198> texture {T_Wood7 rotate<0,90,0> scale <30,30,30>}}
  object{schublade2 translate<0, 60,0>}
  object{schublade1 translate<0,464,0>}
  object {moebelrolle rotate<0,170,0> translate<-370,0,-170> texture {black_plastic}}
  object {moebelrolle rotate<0,170,0> translate< 370,0,-170> texture {black_plastic}}
  object {moebelrolle rotate<0,170,0> translate<-370,0, 170> texture {black_plastic}}
  object {moebelrolle rotate<0,170,0> translate< 370,0, 170> texture {black_plastic}}
}
//**************************************************************************
//*** EOF *** EOF *** EOF *** EOF *** EOF *** EOF *** EOF *** EOF *** EOF **
//**************************************************************************
