// Macros for pov.pov
#include "paper.inc"

#macro screwdriver(rcol,gcol,bcol,dleng,endtype)
union {
  difference {
    cylinder {
      <0,0,1>,<0,0,-0.25-dleng>,1/32
    }
    #if (endtype = 1)
      sphere {<0,0.125,-0.25-dleng>,0.125}
      sphere {<0,-0.125,-0.25-dleng>,0.125}
    #else
      #declare cutout = intersection {sphere {<0,0.125,-.25-dleng>,0.125} sphere {<0.125,0,-.25-dleng>,0.125} translate z*(dleng+.25) scale 4 translate -z*(dleng+.25)}
      object{cutout}
      object{cutout rotate z*90}
      object{cutout rotate z*180}
      object{cutout rotate z*270}
      difference {
        cylinder {
          <0,0,-0.25-dleng>,<0,0,-.1825-dleng>,1/16
        }
        cone {
          <0,0,-0.25-dleng>,0,<0,0,-.1825-dleng>,1/16
        }
      }
    #end
    texture {Soft_Silver}
  }
  difference {
    superellipsoid {
      <1,0.25>
      scale <1/8,1/8,1/4>
      translate <0,0,0.8>
    }
    cylinder {<0,0.2,0.5>,<0,0.2,1.75>,0.1 rotate z*0}
    cylinder {<0,0.2,0.5>,<0,0.2,1.75>,0.1 rotate z*60}
    cylinder {<0,0.2,0.5>,<0,0.2,1.75>,0.1 rotate z*120}
    cylinder {<0,0.2,0.5>,<0,0.2,1.75>,0.1 rotate z*180}
    cylinder {<0,0.2,0.5>,<0,0.2,1.75>,0.1 rotate z*240}
    cylinder {<0,0.2,0.5>,<0,0.2,1.75>,0.1 rotate z*300}
  }
  sphere {0,0.15 scale <0.8,0.8,1/3> translate z*0.55}
  pigment {rgbf <rcol,gcol,bcol,0.75>}
  finish {reflection 0.25 phong 1 phong_size 10}
  translate z*-0.5
}
#end

#declare coffee_tex = material {
  texture {
    pigment {color Brown/4} 
    finish {phong 0.25 reflection 0.125}
  }
}
#macro coffee(label)
union {
  cylinder {<0,0,0>,<0,0.125,0>,0.5}
  difference {
    union {cylinder {<0,0.125,0>,<0,1.5,0>,0.625}   torus {0.5,0.125 translate y*0.125}}
    cylinder {<0,0,0>,<0,1.6,0>,0.5} 
    texture {
      T_Grnt16
      #if (label = 0)
        pigment {rgb 0.2}
      #else
        #if (label = 2)
          pigment {rgbf <0.7,0.7,0.9,0.75>}
        #end
      #end 
      scale 0.0625
    }
    #if (label = 1)
    texture {
      pigment {
        image_map {
          gif
          "irtc-logo.gif"
          map_type 2  
          once    
          transmit 255,1
        }  
        translate y/3
        rotate y*-90      
      }
    }
    #end
  }
  torus {0.5625,0.0625 translate y*1.5}
  torus {0.4,0.1 rotate x*90 scale <0.5,1,1>*1.25 translate <0.75,0.75,0>}
  
  #if (label <= 1)                   // Coffee!
  difference {
    cylinder {<0,0.1,0>,<0,1.3,0>,0.61}
    superellipsoid {
      <1,0.125>
      scale 0.5125
      rotate x*90
      translate <0,1.75,0>
    }
    material {coffee_tex}
  }
  #end
  
  texture {
    T_Grnt16
    #if (label = 0)
      pigment {rgb 0.2}
    #else
      #if (label = 2)
        pigment {rgbf <0.7,0.7,0.9,0.75>}
      #end
    #end 
    scale 0.0625
  }
}
#end     

#macro rand2(lo,hi)
(rand(R)*(hi-lo) + lo)
#end

#macro marker(col)
union {                              
  union {
    cylinder {<0,0,10>,<0,0,20/3>,1/3}
    cylinder {<0,0,1.5>,<0,0,0>,.24}
    box {<-.25,0,9.9>,<.25,0.5,9.8>}
    box {<-.25,0.5,9.9>,<.25,.6,8>}
    pigment {rgb col}
    finish {phong 0.25 phong_size 20}
  }
  cylinder {<0,0,8>,<0,0,0.25>,.25 pigment {rgb 0.2} finish {phong 0.6 phong_size 20}}
  translate <0,1/3,-5>
  scale 1/2 
}
#end
