// 'POV,Ray--Revealed!'
// Lots of INC files, mostly for the miniature furnature.  Macros are in pov.inc.
// The monitor isn't included, because it was made in Rhino, and thus is in the forme of triangles,
// and thus takes up large amounts of space.  If you really want it for some strange reason, email me at vandiver@tiac.net
// All of the associated images were originally PNG files, but have been changed to JPGs to save space in the archive.
#declare final = 1;

global_settings {
  radiosity {
    distance_maximum 2.5
    recursion_limit 2
    count 300
  }
}

#declare R = seed(42);                

#include "colors.inc"
#include "textures.inc"
#include "stones1.inc"
#include "woods.inc"
#include "metals.inc"
#include "pov.inc"

camera {  
  location <-0.125,4,3>                   
  look_at <0.0625,0,0>
  aperture 0.25 
  blur_samples 50 
  focal_point <0,0.75,1>
  confidence 0.95
  variance 1/256
}

#if (final)
light_source {
  <5,50,-10>
  rgb .4166
  area_light <1,0,0>,<0,0,1>,5,5
  jitter
}
#end

light_source {
  <-1,10,3>
  rgb 3
  spotlight
  point_at <-1,0,3>
  radius 30
  falloff 31
  #if (final)
    area_light <.25,0,0>,<0,0,.25>,5,5
    jitter
  #end
}


// Table
superellipsoid {
  <0.125,0.125>
  scale <4,0.25,2.5>
  translate <0.5,-0.25,-0.5>
  pigment {bozo color_map {[0.0 Brown] [1.0 Brown*0.75]} turbulence 0.25 }
  finish {reflection 0.125 phong 0.25 phong_size 60}
}

// Window and wall
difference {
  box {<-10,-10,-3>,<10,50,-3.5>}
  box {<-2,0.5,-2>,<0.5,4.5,-4>}
  box {<1.5,0.5,-2>,<4,4.5,-4>}
  box {<-2,5.5,-2>,<0.5,10,-4>}
  box {<1.5,5.5,-2>,<4,10,-4>}
  pigment {
    crackle 
    color_map {
      [0 rgb 0.75]
      [1 rgb 0.65]
    }
    turbulence 0.5
    scale 0.25
  }
}

box {
  <-2.5,0,-3.125><4.5,10.5,-3.375>
  texture {NBoldglass normal {bumps 0.125 turbulence 1 scale 0.25}}
}

// Floor
plane {
  y,
  -10
  pigment {bozo color_map {[0.0 rgb 0.5] [1 rgb 0.1]} scale 1/256}
  normal {granite scale 1/16}
}

// Screwdriver
object {screwdriver(0,0,0.75,0,1) rotate z*62 rotate y*-42 translate <-1.85,0.125,1>}
object {screwdriver(0.75,0,0,0.5,2) rotate x*-5 rotate z*12 rotate y*-23 translate <-1.5,0.125,1.5>}

#declare  Hexagon = 
 intersection
  {plane {z, 1}  // Rotate 90 in z axis to stand up
   plane {z, 1 rotate < 60, 0, 0>}
   plane {z, 1 rotate <120, 0, 0>}
   plane {z, 1 rotate <180, 0, 0>}
   plane {z, 1 rotate <240, 0, 0>}
   plane {z, 1 rotate <300, 0, 0>}
   plane { x, 1}
   plane {-x, 1}
  }

// Wrench  
union {
  intersection {
    union {
      cylinder {<0,0,-0.5>,<0,0,0.5>,0.125}
      sphere {<0,0,-0.5>,0.125}
      sphere {<0,0,0.5>,0.125}
      difference {
        object {Hexagon rotate z*90 scale <0.2,0.25,0.25> translate <0,0,0.75>}
        object {Hexagon rotate z*90 scale 0.15 translate <0.125,0,0.75>}
      }
    }
    box {<-1,0.03125,-2>,<1,-0.03125,2>}
  }
  cylinder {<0.1,0,-0.5>,<0.1,0,0.5>,0.025 scale <1,3,1>}
  cylinder {<-0.1,0,-0.5>,<-0.1,0,0.5>,0.025 scale <1,3,1>}
  difference {
    union {
      torus {0.1,0.025 scale <1,3,1> translate z*0.5}
      torus {0.1,0.025 scale <1,3,1> translate z*-0.5}
    }
    box {<-1,-1,0.5>,<1,1,-0.5>}
  }
  texture {Soft_Silver}
  scale 1/2
  rotate x*20
  rotate y*-110
  translate <-2.3,0.185,1.07>
}
#if (final)

// Coffee cup
object {
  coffee(1)
  scale 0.65
  rotate y*-138
  translate <-2,0,-0.25>
}  

union {
  object {
    paper(1)    
  }
  object {
    paper(2)    
    translate y*0.02
    rotate y*4
  }
  rotate y*34     
  scale 1.5
  translate <3.05,0,1.53>
}
object {
  paper(5)
  rotate y*42
  scale 1.5
  translate <-2.52,0,-0.34>
}
object {
  paper(4)
  rotate y*103
  scale 1.5
  translate <-2.52,0,-1.97>
}
object {
  paper(3)
  rotate y*138
  scale 1.5 
  translate <1.24,0.3,1.22>
}
#end
union {
  union {
    #include "monitor.inc"
    scale 1/10
  }
//  #if (final)
  union {
    #include "hatrack.inc"
    scale 1/5
    rotate y*15
    translate <-0.75,0.75,0>
  }
  #include "containr.inc"
  object {
    BUEROCONTAINER2
    scale 1/2000
    rotate y*45
    translate <0.6,.7,-0.2>
  }
  #declare litter = 0;
  #while (litter < 20)
    object {paper(rand2(1,4)) scale 1/10 rotate y*rand(R)*360 translate <rand2(-.15,.15),1.1,rand2(-.4,.4)> rotate y*-108 translate <.15,0,0.85>}
    #declare litter = (litter+1);
  #end
  #declare litter = 0;
  #while (litter < 3)
    object {paper(rand2(1,4)) scale 1/10 rotate y*rand(R)*360 translate <rand2(-.15,.15),1.05,rand2(-.07,.07)> rotate y*45 translate <.6,0,-0.2>}
    #declare litter = (litter+1);
  #end
  #declare litter = 0;
  #while (litter < 7)
    object {paper(rand2(1,4)) scale 1/2 rotate y*rand(R)*360 translate <rand2(-1,1),0.125,rand2(0,1)> rotate x*18 translate y*2 scale 1/5 rotate y*-116 translate <0.7,0.75,0.45>}
    #declare litter = (litter+1);
  #end
  #declare litter = 0;
  #declare cols = array[6] {<0,.25,.1>,<.15,.15,.15>,<.6,0,0>,<0.647059,0.164706,0.164706>/1.5,<0,0,.3>,<1,.5,0>/1.5}
  #while (litter < 6)
    object {marker(cols[mod(litter,6)]) scale 1/10 rotate y*rand2(80,100) translate <rand2(-1,1),0,1.625> rotate x*18 translate y*2 scale 1/5 rotate y*-116 translate <0.7,0.75,0.45>}
    #declare litter = (litter+1);
  #end
  object {
    coffee(2)
    rotate y*230
    scale 1/10*0.65
    translate <0.6,1.05,-.2>
  }
  object {
    coffee(0)
    rotate y*110
    scale 1/10*0.65
    translate <0.25,1.1,0.75>
  }
  object {
    #include "overhead.inc"
    scale 1/10
    rotate y*5
    translate <0,1.1,.85>
  }
//  #end
  #declare addh = 100;
  #include "chairs.inc"
  object {
    BUEROSTUHL
    scale 1/2000
    rotate y*125
    translate <0.35,0.72,0.4>
  }
  #include "table.inc"
  object {
    BUEROTISCH2
    scale 1/2000 
    rotate y*-18
    translate <0.15,0.70,0.85>
  }
  object {
    drafting
    scale 1/5
    rotate y*-116
    translate <0.7,0.75,0.45>
  }  
  object {
    #include "sofa.inc"
    scale 1/6*<-1,1,1>
    rotate y*6
    translate <-0.78,.95,.65>
  }
  object {
    box {0,1}
    pigment {
      image_map {
        png
        "matc.jpg"
      }
      rotate x*90
    }
    translate <-.5,-1,-0.5>
    scale <-3,-1/1000,-3>/1.75
    translate <0,0.75,0.3>
  }

  rotate y*23
}
