#include "mytex.inc"
#include "woods.inc"
#include "metals.inc"
#include "golds.inc"
#include "stones1.inc"
#include "columns.inc"
//#include "walls.inc"
        
global_settings {max_trace_level 11
                 max_intersections 128
                 adc_bailout 0.01}

  camera {
    location <58, 12, -130>
    look_at <0, -3, 0>
    angle 60             
  }                 
  
  light_source { <20,2000,-2000> White*1.4 }
//  light_source { <22,2010,-2000> Gray05 }
//  light_source { <22,1990,-2000> Gray05  }
  light_source { <-10,0,10> Gray15}
  light_source { <10,0,10> Gray15 }
  
  sky_sphere {
    pigment {
        bozo 
        turbulence 4.5
        octaves 7
        omega 1
        lambda 2.5
        color_map {
            [0 color White]
            [0.02 color White]
            [0.0205 color Black]
//            [0.2 color Black]
//            [0.205 color White]
//            [0.25 color White]
//            [0.252 color Black]
            [1 color Black]
            }
          }
        }

  #declare Sz=180;
  #declare BoxZ=-Sz;
  #declare EndZ=Sz+1;
  #declare Step=9;
  #declare Lightpos=Step/2; 
  #declare Midpt=.866025;
  #declare Endpt=1.73205;
//  #declare Rnd1=seed(1776);
  #declare Stone=1;
  #declare Flag1=0;
  
  #while(BoxZ<EndZ)
    #if(Flag1=0)
        #declare Ofs=(abs(BoxZ)/36);
        #declare XLimit=Sz-(int(Ofs)*Step);
        #declare BoxX=-XLimit;
        #declare Flag1=1;
    #else
        #declare BoxX=Midpt*Lightpos-XLimit;
        #declare Flag1=0;
    #end

    #while(BoxX<XLimit+1)
  
        prism {
            linear_sweep
            linear_spline
            -25.4, -24.4, 7,
            <BoxX,BoxZ>,<BoxX,BoxZ+Lightpos>, <BoxX+Midpt*Lightpos,BoxZ+Lightpos*1.5>, <BoxX+Endpt*Lightpos,BoxZ+Lightpos>, <BoxX+Endpt*Lightpos,BoxZ>, <BoxX+Midpt*Lightpos,BoxZ-Lightpos*0.5>, <BoxX,BoxZ>
            texture {
                //#declare TexVal=int(rand(Rnd1)*11+1);
                #switch (Stone)
                #case (1)
                    T_Stone2
                    #break
                #case (2)
                    T_Stone4
                    #break
                #case (3)
                    T_Stone5
                    #break
                #case (4)
                    T_Stone7
                    #break
                #case (5)
                    T_Stone10
                    #break
                #case (6)
                    T_Stone14
                    #break
                #case (7)
                    T_Stone22
                    #break
                #case (8)
                    T_Stone24
                    #break
                #else
                    T_Stone7
                #end
                #declare Stone=Stone+1;
                #if (Stone>8)
                    #declare Stone=1;
                #end    
                finish {MainFin}
              }    
    
            normal {crackle scale <.5,.1,.3523> turbulence .5}
          }
    
        #declare BoxX=BoxX+Endpt*Lightpos;
    #end                       

    #declare BoxZ=BoxZ+Lightpos*1.5;
  #end

#declare Col_Int=ColInterior

object {MakeCol(0,0,10,-10,2.3,ColTexture)    hollow}
object {MakeCol(-20,0,10,-10,2.3,ColTexture)  hollow}
object {MakeCol(20,0,10,-10,2.3,ColTexture)   hollow}
object {MakeCol(-40,0,10,-10,2.3,ColTexture)  hollow}
object {MakeCol(40,0,10,-10,2.3,ColTexture)   hollow}
object {MakeCol(40,20,10,-10,2.3,ColTexture)  hollow}
object {MakeCol(-40,20,10,-10,2.3,ColTexture) hollow}
object {MakeCol(-40,40,10,-10,2.3,ColTexture) hollow}
object {MakeCol(40,40,10,-10,2.3,ColTexture)  hollow}
object {MakeCol(-20,40,10,-10,2.3,ColTexture) hollow}
object {MakeCol(20,40,10,-10,2.3,ColTexture)  hollow}
object {MakeCol(0,40,10,-10,2.3,ColTexture)   hollow}
    
    
// Ceiling  

    merge {
        difference {
            box { <-46,10,-6>,<46,14,46> texture {T_Wood3 finish {MainFin} rotate x*45} }// interior {GlassInterior}}
            cylinder {<-46.1,11,-6.2> <46.1,11,-6.2> .5 texture {T_Silver_2B} }// interior {GlassInterior}}
            cylinder {<-46.1,13,-6.2> <46.1,13,-6.2> .5 texture {T_Silver_2B} }// interior {GlassInterior}}
            cylinder {<-46.2,11,-6.1> <-46.2,11,46.1> .5 texture {T_Silver_2B} }// interior {GlassInterior}}
            cylinder {<-46.2,13,-6.1> <-46.2,13,46.1> .5 texture {T_Silver_2B} }// interior {GlassInterior}}
            cylinder {<46.2,11,-6.1> <46.2,11,46.1> .5 texture {T_Silver_2B} }// interior {GlassInterior}}
            cylinder {<46.2,13,-6.1> <46.2,13,46.1> .5 texture {T_Silver_2B} }// interior {GlassInterior}}
            cylinder {<-46.1,11,46.2> <46.1,11,46.2> .5 texture {T_Silver_2B} }// interior {GlassInterior}}
            cylinder {<-46.1,13,46.2> <46.1,13,46.2> .5 texture {T_Silver_2B} }// interior {GlassInterior}}
            bounded_by {box { <-46,10,-6>,<46,14,46>}} 
        }                 

    #local Left=-38;
    #local Right=38;
    #local Front=0;
    #local Back=40; 
    difference {
        box { <Left,14,Front>,<Right,17,Back> texture {T_Wood3 finish {MainFin} rotate z*60} } // interior {GlassInterior} } 

        #local LoopPos=-pi*12;
        #local LoopMax=pi*12;
        #local Width= 0.3; //  pi* (1/(2.54648*pi));    // /10;
        #local Ofs1=0;
        #local Ofs2=pi; 
        #local LoopStep = pi/4;    //Width * pi/1.331; 
        #while (LoopPos<=LoopMax+LoopStep)
            sphere {<LoopPos,sin(LoopPos+Ofs1)+15.5,0>, Width+0.0001 texture{ T_Silver_4B} }
            sphere {<LoopPos,sin(LoopPos+Ofs2)+15.5,0>, Width+0.0001 texture{ T_Silver_4B} }
            #local LoopPos=LoopPos+LoopStep;
        #end
    }
    #local LoopPos=-pi*12;

    #while (LoopPos<=LoopMax)
        difference {
            sphere {<LoopPos,sin(LoopPos+Ofs1)+15.5,0>, Width texture{ pigment{GreenPig} finish {ShinyFin}} interior {GlassInterior} }
            box {<LoopPos-LoopStep,sin(LoopPos+Ofs1)+15.5-LoopStep,-(Width+.01)>, <LoopPos+LoopStep,sin(LoopPos+Ofs1)+15.5+LoopStep,-(Width*.88)> texture{ T_Silver_2C }}    //pigment{GreenPig} finish {ShinyFin}} interior {GlassInterior}}
        }
        difference {
            sphere {<LoopPos,sin(LoopPos+Ofs2)+15.5,0>, Width texture{ pigment{RedPig} finish {ShinyFin}} interior {GlassInterior} }
            box {<LoopPos-LoopStep,sin(LoopPos+Ofs2)+15.5-LoopStep,-(Width+.01)>, <LoopPos+LoopStep,sin(LoopPos+Ofs2)+15.5+LoopStep,-(Width*.88)> texture{ T_Silver_2C }}    //pigment{RedPig} finish {ShinyFin}} interior {GlassInterior}}
        }
        #local LoopPos=LoopPos+LoopStep;
    #end
    
    prism {
        conic_sweep
        linear_spline
        .8,1, 5,
        <Right,-Back>,<Left,-Back>, <Left,-Front>, <Right,-Front>, <Right,-Back>
        texture { ColTexture}
        interior {SecondInterior}
        scale <1, 20, 1>
        rotate <180, 0, 0>
        translate <0,17+20,0>
        hollow }

   } // end of merge
    
    


// Stairs

#declare Steps=0; 
object {merge {                                           
    #while(Steps<=11) 
        merge {box {<-47-Steps*.6,-10-Steps*.4,-7-Steps*.6>,<47+Steps*.6,-10.4-Steps*.4,47+Steps*.6> texture {StairTexture} interior {GlassInterior2}}
                cylinder { <-47.05-Steps*.6,-10.05-Steps*.4,-7.05-Steps*.6>,<47.05+Steps*.6,-10.05-Steps*.4,-7.05-Steps*.6> .1 texture { StairTexture} interior {GlassInterior2}}
                cylinder { <-47.05-Steps*.6,-10.05-Steps*.4,-7.05-Steps*.6>,<-47.05-Steps*.6,-10.05-Steps*.4,47.05+Steps*.6> .1 texture { StairTexture} interior {GlassInterior2}}
                cylinder { <47.05+Steps*.6,-10.05-Steps*.4,-7.05-Steps*.6>,<47.05+Steps*.6,-10.05-Steps*.4,47.05+Steps*.6> .1 texture { StairTexture} interior {GlassInterior2}}
                cylinder { <47.05+Steps*.6,-10.05-Steps*.4,47.05+Steps*.6>,<-47.05-Steps*.6,-10.05-Steps*.4,47.05+Steps*.6> .1 texture { StairTexture} interior {GlassInterior2}}
              }
        #declare Steps=Steps+1;
    #end
    }   

}

#declare Steps=0; 
object {merge {                                           
    #while(Steps<=25) 
        merge {box {<-3,-14.4-Steps*.4,-13.6-Steps*.6>,<3,-14.8-Steps*.4,-12.4-Steps*.6> texture {StairTexture} interior {GlassInterior2}}
                cylinder { <-2.95,-14.45-Steps*.4,-13.6-Steps*.6>,<2.95,-14.45-Steps*.4,-13.6-Steps*.6> .1 texture { StairTexture} interior {GlassInterior2}}
                sphere {<-2.95,-14.45-Steps*.4,-13.6-Steps*.6> .1 texture { StairTexture} interior {GlassInterior2}}
                sphere {<2.95,-14.45-Steps*.4,-13.6-Steps*.6> .1 texture { StairTexture} interior {GlassInterior2}}
              }
              
        #declare Steps=Steps+1;
    #end
    }   
}    
#declare Steps=0; 
object {merge {                                           
    #while(Steps<=25) 
        merge {box {<-3,-14.4-Steps*.4,53.6+Steps*.6>,<3,-14.8-Steps*.4,52.4+Steps*.6> texture {StairTexture} interior {GlassInterior2}}
                cylinder { <-2.95,-14.45-Steps*.4,53.6+Steps*.6>,<2.95,-14.45-Steps*.4,53.6+Steps*.6> .1 texture { StairTexture} interior {GlassInterior2}}
                sphere {<-2.95,-14.45-Steps*.4,53.6+Steps*.6> .1 texture { StairTexture} interior {GlassInterior2}}
                sphere {<2.95,-14.45-Steps*.4,53.6+Steps*.6> .1 texture { StairTexture} interior {GlassInterior2}}
              }
        #declare Steps=Steps+1;
    #end
    }   
}              
#declare Steps=0; 
object {merge {                                           
    #while(Steps<=25) 
        merge {box {<-53.6-Steps*.6,-14.4-Steps*.4,17>,<-52.4-Steps*.6,-14.8-Steps*.4,22> texture {StairTexture} interior {GlassInterior2}}
                cylinder { <-53.6-Steps*.6,-14.45-Steps*.4,17.05>,<-53.6-Steps*.6,-14.45-Steps*.4,21.95> .1 texture { StairTexture} interior {GlassInterior2}}
                sphere {<-53.6-Steps*.6,-14.45-Steps*.4,17.05> .1 texture { StairTexture} interior {GlassInterior2}}
                sphere {<-53.6-Steps*.6,-14.45-Steps*.4,21.95> .1 texture { StairTexture} interior {GlassInterior2}}
              }
        #declare Steps=Steps+1;
    #end
    }   
}              
#declare Steps=0; 
object {merge {                                           
    #while(Steps<=25) 
        merge {box {<53.6+Steps*.6,-14.4-Steps*.4,17>,<52.4+Steps*.6,-14.8-Steps*.4,22> texture {StairTexture} interior {GlassInterior2}}
                cylinder { <53.6+Steps*.6,-14.45-Steps*.4,17.05>,<53.6+Steps*.6,-14.45-Steps*.4,21.95> .1 texture { StairTexture} interior {GlassInterior2}}
                sphere {<53.6+Steps*.6,-14.45-Steps*.4,17.05> .1 texture { StairTexture} interior {GlassInterior2}}
                sphere {<53.6+Steps*.6,-14.45-Steps*.4,21.95> .1 texture { StairTexture} interior {GlassInterior2}}
              }
              
        #declare Steps=Steps+1;
    #end
    }   

}

//object {MakeCol(0,20,-14.4,-24.4,1,ColTexture) hollow}

#declare Steps=-6;
#declare Pinnacle=object {
                    #declare P1=3.5;
                    #declare P2=4.9;
                    #declare P3=P1*.56;
                    #declare P4=P2*.65;
            union {                                                                   
            prism { conic_sweep  
                    cubic_spline
                    0.025,  // sweep the following shape from here ...
                    1,  // ... up through here
                    12, // the number of points making up the shape ...
                    <P1,-P2>, <P1,P2>, <-P2,0>, <P1, -P2>, <P1,P2>, <-P2,0>, // sub-shape #1
                    <P3,-P4>, <P3,P4>, <-P4,0>, <P3,-P4>, <P3,P4>, <-P4,0>  // sub-shape #2
                    texture {ColTexture}
                    interior { ColInterior }
                    rotate x*180
                    scale <1,30,1>
                    translate <0,30,0>
                    hollow}
            cone {<0,0,0>, 6.5
                  <0,-3,0>, 9
                  texture { ColTexture}
                  interior {SecondInterior}
                  hollow }
                  }
                  translate <0,3,0>  
                 }
/*               
    merge {
        #declare X1=.025;
        //#declare Rot=2;
        #while (Steps < 50)
            #declare P1=5.1-(abs(Steps)/11);
            #declare P2=6.1-(abs(Steps)/10);
            #declare P3=P1*.66;
            #declare P4=P2*.75;                                                                   
            
            prism { conic_sweep  
                    cubic_spline
                    X1,  // sweep the following shape from here ...
                    1,  // ... up through here
                    12, // the number of points making up the shape ...
                    <P1,-P2>, <P1,P2>, <-P2,0>, <P1, -P2>, <P1,P2>, <-P2,0>, // sub-shape #1
                    <P3,-P4>, <P3,P4>, <-P4,0>, <P3,-P4>, <P3,P4>, <-P4,0>  // sub-shape #2
                    texture {ColTexture}
                    interior { ColInterior }
                    rotate Steps*Rot*y
                    rotate x*180
                    scale <1,4,1>
                    translate <0,Steps*.4,0>
                   }
            #declare Steps=Steps+1;
        #end   
        }
    hollow
    }         
*/    
    object {Pinnacle rotate y*30 translate <-22,21,20> }
    object {Pinnacle rotate y*150 translate <-22,21,20> }
    sphere { <-22,51.5,20> 3 texture {T_Gold_5D} }
    
    object {Pinnacle rotate y*60 translate <22,21,20> }
    object {Pinnacle rotate y*180 translate <22,21,20> }
    sphere { <22,51.5,20> 3 texture {T_Gold_5D} }
    
    object {Pinnacle translate <0,21,20> }
    object {Pinnacle rotate y*120 translate <0,21,20> }
    sphere { <0,51.5,20> 3 texture {T_Gold_5D} }


#declare Planet1=union{
  sphere { <0,0,0>, .9975
    texture { Land }
    texture { Seas }
    rotate <50,-45,25>
    }
     
  sphere {<0,0,0>,1
    texture { CloudArea }
    interior { ior 1.1
                media { scattering {1, rgb <0.00000011, 0.00000011, 0.00000013> }}
             }
    rotate 30*y             
    hollow
    }                    
  }

object {Planet1 scale 5000 translate <0,-3100,8590>}


 // Sign it
object {text { ttf "timrom.ttf" "Solar Temple - Brendt W. Hess" .05 , 0
       texture {
           pigment { White }
           finish { ambient .98 diffuse 0}
           }
           scale 2.2
            }
            rotate z*1.7
            rotate y*-32
            rotate x*-1
            translate <-53.5,48.5,-45>
            no_shadow
}