// Persistence of Vision Ray Tracer INCLUDE File
// File:	Columns.inc
// Vers:	3.1e Watcom Win32
// Desc:	Macro for making a simple fluted column
// Date:	May 15, 1999
// Auth:	Brendt Hess
            
// Optional Declared Variables to control appearance
//
//  Col_Int - Apply this interior statement to the column if defined, otherwise no interior
//  Col_Segmented  - Make the column out of Col_Segmented blocks of stone
//

// A variant marble - can be used for columns
// generates a random marble pattern within certain limits.
  #declare MACRO_R1=seed(325);
 
  #macro MyStone() 
        pigment {        
        wood
        color_map {   
          [0.3 color Black]
          [0.1 color DarkBrown]
          [0.0125 color White]
                 }
        turbulence <0.29+rand(MACRO_R1)*.18,0.29+rand(MACRO_R1)*.18,0.29+rand(MACRO_R1)*.18>
        scale <0.33+rand(MACRO_R1)*.13, 0.4+rand(MACRO_R1)*.2, 1>
        rotate rand(MACRO_R1)*360 } 
  #end


// create a cylinder at a given position (vertical cylinder only)
                                                           
#macro MakeCyl(Xpos,Zpos,Top, Bottom, Diam, Textur)

    cylinder { <Xpos,Top,Zpos> <Xpos,Bottom,Zpos> Diam texture {Textur} 
    #ifdef (Col_Int)
        interior {Col_Int}
    #end
            }
#end                                 

#macro Flute(X,Z,Top,Bot,Diam,Tex)           // make a fluting
    #local Offset=abs(Bot-Top)*.15; 
        union{
             MakeCyl(X,Z,Top-Offset,Bot+Offset,Diam,Tex)           // cut the flutings in the column
             sphere {<X,Top-Offset,Z> Diam 
                     texture {Tex}
                     #ifdef (Col_Int)
                        interior {Col_Int}
                     #end
                     }
             sphere {<X,Bot+Offset,Z> Diam 
                     texture {Tex}
                     #ifdef (Col_Int)
                        interior {Col_Int}
                     #end
                    }
        }
     
#end            
                

// Make a column macro
// requires X and Z of center of the column, the top and bottom Y positions, 
// column diameter, and a texture/pigment and finish
// creates a column with 16 flutings

#macro MakeCol(X,Z,Topy,Boty, BDiam, Tex)
#local PhNum = .9;
#local Ofs1 = BDiam * 1.035;            // offset for 1st CGI difference cylinders (orthoginal directions)
#local Ofs2 = BDiam * 1.035 * .92871;   // 1st offset for 2nd CGI difference cylinders
//#local Ofs2 = Ofs1 * .92871           
#local Ofs3 = sqrt((Ofs1 * Ofs1) - (Ofs2 * Ofs2)); // 2nd offset for 2nd CGI difference cylinders
#local Ofs4 = sqrt((Ofs1 * Ofs1)/2);    // offset for third set of cylinders              
#local Bot=Boty+0.02;                   // adjust a bit when doing CGI differences
#local Top=Topy-0.02;
#local Diam2=BDiam/6;                   // flutings are cut this size
#local Diam3=BDiam/4;                   // used for making the top and bottom of the columns
object{ 
    merge {
        difference {
            #ifndef (Col_Segmented)
                MakeCyl(0,0,Topy, Boty, BDiam, Tex)
            #else
                union {             
                    #local Step=(Topy-Boty)/Col_Segmented;         // Column made of n sections
                    #local Lp=Topy-Step;
                    #local Lpt=Topy;
                    #while(Lp>Boty-0.1)
                        MakeCyl(0,0,Lpt,Lp+.01,BDiam,Tex)
                        #local Lpt=Lp;
                        #local Lp=Lp-Step;
                    #end
                  } 
            #end
            Flute(0,Ofs1,Top,Bot,Diam2,Tex)           // cut the flutings in the column            
            Flute(0,Ofs1*-1,Top,Bot,Diam2,Tex)
            Flute(Ofs1,0,Top,Bot,Diam2,Tex)
            Flute(Ofs1*-1,0,Top,Bot,Diam2,Tex)
            Flute(Ofs2,Ofs3,Top,Bot,Diam2,Tex)
            Flute(Ofs2,Ofs3*-1,Top,Bot,Diam2,Tex)
            Flute(Ofs2*-1,Ofs3,Top,Bot,Diam2,Tex)
            Flute(Ofs2*-1,Ofs3*-1,Top,Bot,Diam2,Tex)
            Flute(Ofs3,Ofs2,Top,Bot,Diam2,Tex)
            Flute(Ofs3,Ofs2*-1,Top,Bot,Diam2,Tex)
            Flute(Ofs3*-1,Ofs2,Top,Bot,Diam2,Tex)
            Flute(Ofs3*-1,Ofs2*-1,Top,Bot,Diam2,Tex)
            Flute(Ofs4,Ofs4,Top,Bot,Diam2,Tex)
            Flute(Ofs4,Ofs4*-1,Top,Bot,Diam2,Tex)
            Flute(Ofs4*-1,Ofs4,Top,Bot,Diam2,Tex)
            Flute(Ofs4*-1,Ofs4*-1,Top,Bot,Diam2,Tex)
               
            } 
         torus { BDiam,Diam3                              // make the top & bottom caps
                texture {Tex}
                #ifdef (Col_Int)
                      interior {Col_Int}
                #end
                translate <0,Top-Diam3*2.7,0>
                }
                
        torus { BDiam,Diam3
                texture {Tex}
                #ifdef (Col_Int)
                     interior {Col_Int}
                #end
                translate <0,Bot+Diam3*2.7,0>
                } 
               
        MakeCyl(0,0,Top,Top-Diam3*2.2,BDiam*1.5,Tex)
        MakeCyl(0,0,Bot+Diam3*2.2,Bot,BDiam*1.5,Tex)
        
        bounded_by {box {<0-BDiam*1.55,Bot-Diam2,0-BDiam*1.55>, <0+BDiam*1.55,Top+Diam2,0+BDiam*1.55> }}
        }
    translate <X,0,Z>}                                  // put it where you want it...
#end
                 
