// Persistence of Vision Ray Tracer Scene Description File
// File: The end of millenium and the last dragon
// Vers: 3.1
// Date: 16.June 1999. 
// Auth: Anto Matkovic
// E-mail: matkovic@geocities.com
// Main file 


#include "zmaj_tex.inc"


global_settings { max_trace_level 4
                  assumed_gamma 2.2}

sky_sphere {pigment {wrinkles turbulence 0.2
      colour_map {
            [0 colour rgb <0.9, 0.9, 0.99>]
            [0.2 colour rgb <0.6, 0.6, 0.99>]
            [1.0 colour rgb <0.5, 0.5, 0.99>]}scale 0.1}}


#declare mjesto_kamere = <29, 64, 17>;


camera {  sky z*1 up z*1 right <4/3, 0.0, 0.0>
   location  mjesto_kamere look_at   <10, 22, 6> angle 33
   aperture 0.18              
   blur_samples 40           
   focal_point <10, 22, 6> 
   } 
   

light_source {0*x colour rgb <1.7, 1.64, 1.6> area_light <1, 1, 1> <-1, -1, -1>  3, 3 adaptive 0     
jitter    translate <2000, -4800, 4000>}

light_source {0*x colour rgb <0.4, 0.4, 0.47> translate mjesto_kamere }

light_source {0*x colour rgb 0.12 translate <2000, -4800, 4000> shadowless }

#declare stanga_na_stubi =
 box {<-0.05, 0, 0><0.05, -3.84, 0.1>}
 
 #declare jedna_stuba =
 union { 
 intersection {
 difference {
 box {<-5.125, 0, 0><5.125, -7, -3>}
 cylinder {<-5.127, -8,  0>,<5.127, -8, 0>, 3.9 }}
 cylinder {<-5.12, -4,  0>,<5.12, -4, 0>, 4 }}
 
 #declare br1=-18;
   #while (br1<18)
   
 object { stanga_na_stubi translate <br1*0.3, 0, 0>}
     
      #declare br1 = br1+ 1;
   #end
 
}

#declare stube_prave =
union {
object { jedna_stuba translate <0, 5, 0.05>}
object { jedna_stuba translate <0, 1, 0.3>}
object { jedna_stuba translate <0, -2.8, 1.62>}
object { jedna_stuba translate <0, -6.3, 3.4>}
object { jedna_stuba translate <0, -9.73, 5.2>}
object { jedna_stuba translate <0, -13.3, 7.4>}
object { jedna_stuba translate <0, -16.72, 9.65>}
object { jedna_stuba translate <0, -20.22, 11.7>}
object { jedna_stuba translate <0, -23.72, 13.7>}
object { jedna_stuba translate <0, -27.2, 15.72>}
object { jedna_stuba translate <0, -30.71, 17.73>}
object { jedna_stuba translate <0, -34.2, 19.75>}
object { jedna_stuba translate <0, -37.73, 21.8>}
object { jedna_stuba translate <0, -41.3, 23.82>}
object { jedna_stuba translate <0, -44.74, 25.83>}
object { jedna_stuba translate <0, -48.2, 27.8>}
object { jedna_stuba translate <0, -51.92, 29.44>}
object { jedna_stuba translate <0, -55.9, 30>}
object { jedna_stuba translate <0, -60, 30>}
object { jedna_stuba translate <0, -64, 30>}
texture {metal_stubiste}}



#declare obrubi_gume =
union {
torus {4.5, 0.32  rotate z*90 translate <0, 12, 5.5> 
clipped_by {box {<-0.4, 12, -1><0.4, 19, 11>}}}

torus {4.5, 0.32  rotate z*90 translate <0, -64, 35.5> 
clipped_by {box {<-0.4, -64, 41><0.4, -72, 29>}}}

cylinder {<0, 4, 10><0, 12, 10>, 0.31 }

intersection {
torus {15, 0.32  rotate z*90 translate <0, 4, 25>} 
box {<-0.4, 4, 9><0.4, -3.464, 16>}}

intersection {
torus {15, 0.32  rotate z*90 translate <0, -56, 25>} 
box {<-0.4, -48.5, 37><0.4, -56, 42>}}

cylinder {<0, -3.6, 0><0, -56.4, 0>, 0.32 rotate x*-30 translate z*10}
cylinder {<0, -56, 40><0, -64, 40>, 0.32 }
}

#declare staklo_stube = 
union {
cylinder {<-0.05, 0, 0><0.05, 0, 0>, 4.5 translate <0, 12, 5.5>
clipped_by {box {<-0.4, 12, -1><0.4, 19, 11>}}}


polygon {5, <0.1, 0> <0.1, 10> <11.9, 10> <11.9, 0> <0.1, 0> rotate <90, 0, 90>}

polygon {5, <0, 0> <0, 10> <-10, 15.77> <-10, 5.77> <0, 0> rotate <90, 0, 90>}

polygon {5, <-10.1, 5.77> <-10.1, 15.77> <-20, 21.6> <-20, 11.6> <-10.1, 5.77> rotate <90, 0, 90>}

polygon {5, <-20.1, 11.6> <-20.1, 21.6> <-30, 27.4> <-30, 17.4> <-20.1, 11.6> rotate <90, 0, 90>}

polygon {5, <-30.1, 17.4> <-30.1, 27.4> <-40, 33.3> <-40, 23.3> <-30.1, 17.4> rotate <90, 0, 90>}

polygon {5, <-40.1, 23.3> <-40.1, 33.3> <-52, 39.5> <-52, 29.5> <-40.1, 23.3> rotate <90, 0, 90>}

polygon {5, <-52.1, 29.5> <-52.1, 39.8> <-64, 40> <-64, 29.5> <-52.1, 29.5> rotate <90, 0, 90>}



cylinder {<-0.05, 0, 0><0.05, 0, 0>, 4.5 translate <0, -64, 35.5>
clipped_by {box {<-0.4, -64, 28><0.4, -70, 41>}}}
texture {metal_stubiste_gdje_bi_bilo_staklo}}


#declare guma_unutra = 
union { 

intersection {
difference {
cylinder {<-0.6, 0, 0><0.6, 0, 0>, 15.32   translate <0, 4, 25>} 
cylinder {<-0.72, 0, 0><0.72, 0, 0>, 14.68   translate <0, 4, 25>}}
box {<-0.7, 4, 8><0.7, -3.464, 16>}}

intersection {
difference {
cylinder {<-0.6, 0, 0><0.6, 0, 0>, 15.32   translate <0, -56, 25>} 
cylinder {<-0.72, 0, 0><0.72, 0, 0>, 14.68   translate <0, -56, 25>}}
box {<-0.7, -48.5, 36><0.7, -56, 42>}}

difference {
cylinder {<-0.6, 0, 0><0.6, 0, 0>, 4.82   translate <0, 12, 5.5>} 
cylinder {<-0.72, 0, 0><0.72, 0, 0>, 4.4   translate <0, 12, 5.5>}
box {<-0.9, 12, -1><0.9, 4, 11>}}

difference {
cylinder {<-0.6, 0, 0><0.6, 0, 0>, 4.82   translate <0, 12, 5.5>} 
cylinder {<-0.72, 0, 0><0.72, 0, 0>, 4.4   translate <0, 12, 5.5>}
box {<-0.9, 12, -1><0.9, 19, 11>} translate <0, -76, 30>}
                                                           
box {<-0.6, -3.6, -0.1><0.6, -56.4, 0.32> rotate x*-30 translate z*10}

box {<-0.6, 4, -0.1><0.6, 12, 0.32>  translate z*10}

box {<-0.6, -56, -0.1><0.6, -64, 0.32>  translate z*40}}


#declare rukohvat_metal = 
union { 

intersection {
difference {
cylinder {<-0.3, 0, 0><0.3, 0, 0>, 16.4   translate <0, 4, 25>} 
cylinder {<-0.72, 0, 0><0.72, 0, 0>, 15.1   translate <0, 4, 25>}}
box {<-0.7, 4, 7><0.7, -3.464, 16>}}

intersection {
difference {
cylinder {<-0.3, 0, 0><0.3, 0, 0>, 14.9  translate <0, -56, 25>} 
cylinder {<-0.72, 0, 0><0.72, 0, 0>, 13.4   translate <0, -56, 25>}}
box {<-0.7, -48.5, 33><0.7, -56, 42>}}

difference {
cylinder {<-0.3, 0, 0><0.3, 0, 0>, 4.5  translate <0, 12, 5.5>} 
cylinder {<-0.72, 0, 0><0.72, 0, 0>, 3.1   translate <0, 12, 5.5>}
box {<-0.9, 12, -1><0.9, 4, 11>}}

difference {
cylinder {<-0.3, 0, 0><0.3, 0, 0>, 4.5   translate <0, 12, 5.5>} 
cylinder {<-0.72, 0, 0><0.72, 0, 0>, 3.1   translate <0, 12, 5.5>}
box {<-0.9, 12, -1><0.9, 19, 11>} translate <0, -76, 30>}
                                                           
box {<-0.3, -3.4, -1.4><0.3, -56.4, 0> rotate x*-30 translate z*10}

box {<-0.3, 4, -1.4><0.3, 12, 0>  translate z*10}

box {<-0.3, -56, -1.4><0.3, -64, 0>  translate z*40}
texture {metal_stubiste}}




#declare metal_ispod_rukohvata = 
union {
superellipsoid {<0.1, 0.1>  scale <1.6, 8.1, 3> translate <0, 4, 0> }
superellipsoid {<0.1, 0.1>  scale <1.6, 5.9, 3> translate <0, -59, 30> }
superellipsoid {<0.1, 0.1>  scale <1.6, 32.6, 2>  translate <0, -30, 0> rotate x*-30 }
texture {metal_stubiste }}


 
#declare rukohvat =
union { 
object { obrubi_gume translate x*-0.6}
object { obrubi_gume translate x*0.6}
object {guma_unutra}
texture {guma_stubiste}}


#declare stube =
union {
object { rukohvat translate x*-6}
object { rukohvat translate x*6}
object { staklo_stube translate x*-6}
object { staklo_stube translate x*6}
object { rukohvat_metal translate x*-6}
object { rukohvat_metal translate x*6}
object { metal_ispod_rukohvata translate x*-6.4}
object { metal_ispod_rukohvata translate x*6.4}
object {stube_prave}
superellipsoid {<0.2, 0.2>  scale <7.45, 7, 0.15> translate y*11 texture {metal_podni}}
}
                                
                                
//pod
//box {<-200, -200, 0><200, 200, -1> texture {za_plane1}}

#declare br5=-15;
#declare bl2 = seed (12);
   #while (br5<15)
#declare br6=-15;
   #while (br6<15)
   
 superellipsoid {<0.05, 0.05> scale <1.99, 1.99, 0.2> translate <br5*4, br6*4, -0.2> texture {zmaj_tex_pod
 translate <rand(bl2)*3.7, rand(bl2)*3.7, rand(bl2)*3.7>}}
 
     
      #declare br6 = br6+1;
   #end
   
    #declare br5 = br5+1;
   #end 

//------------------------------------------------------------------------------- 





#declare sve_stube_obicne =
union {

#declare br2=0;
#declare bl3 = seed (12);
   #while (br2<14)
   
box {<-7, -0.4, -0.2><-45.1, -4, 1.49> translate <0, br2*-3.5, br2*1.5> 
 texture {zmaj_tex_stube_obicne translate <((rand (bl3))*3)-3, (rand (bl3))*2.7, (rand (bl3))*1>}} 

superellipsoid {<0.2, 0.2> scale <26, 2, 0.2> translate <-34, -2, 1.3> translate <0, br2*-3.5, br2*1.5> 
 texture {zmaj_tex_stube_obicne translate <((rand (bl3))*3)-3, (rand (bl3))*2.7, (rand (bl3))*1>}}
   #declare br2 = br2+1;
   #end 
   }
   


#declare ograda_obicnih_stuba_kamen =
union {
union {
box {<-8.4, 0, -1><-12, -50, 1.2> rotate x*-24 }
box {<-8.5, 0, -11><-10.7, -50, 1.1> rotate x*-24  } 
box {<-8.4, 11, -1><-12, -1, 1.2>  }
box {<-8.7, 10.3, -11><-11.7, -1, 1.1> }
translate <0, 0, 8.3> texture {ispod_kamene_ograde}}
union {
box {<-8.4, 11, -1><-12, 11.1, 1.2>  }
box {<-8.7, 10.3, -11><10.5, -1, 1.1> }
texture {ispod_kamene_ograde_bez_bitmapa}}}


#declare  ograda_obicnih_stuba_metal =
union {
cylinder {<-36, 15.2, 9><-36, 0, 9>, 0.28}
cylinder {<-36, 0, 0><-36, -50, 0>, 0.28 rotate x*-24 translate <0, 0, 9>}

cylinder {<-36, 14.5, 9><-36, 15.2, 9>, 0.3}
cylinder {<-36, 4.5, 9><-36, 5.5, 9>, 0.3}
cylinder {<-36, -0.5, 9><-36, 0.5, 9>, 0.3}

cylinder {<-36, 15, 9><-47, 15, 9>, 0.21}
cylinder {<-36, 5, 9><-47, 5, 9>, 0.21}
cylinder {<-36, 0, 9><-47, 0, 9>, 0.21}


cylinder {<-36, -9.5, 0><-36, -10.5, 0>, 0.3 rotate x*-24 translate <0, 0, 9>}
 


cylinder {<-36, -10, 0><-47, -10, 0>, 0.21 rotate x*-24 translate <0, 0, 9>}



texture {metal_stubiste }}


#declare cyl_za_sjenilo_iznad =
union {
cylinder {<-400, 0, 95><400, 0, 95>, 0.14}
cylinder {<0, -400, 95><0, 400, 95>, 0.14}
}
 
//sjenilo_iznad 
union {
object { cyl_za_sjenilo_iznad}
#declare br3=-74;
   #while (br3<74) 
  
 object { cyl_za_sjenilo_iznad    translate <br3*7, br3*7, 0> rotate z*35}
 
   
   #declare br3 = br3+1;
   #end 
 texture {bijelo}}


#declare scena_sve =
union {
union {
object {stube}
object {ograda_obicnih_stuba_kamen}
object {ograda_obicnih_stuba_metal}
object {stube translate x*15} 
object {sve_stube_obicne}
//lijevi zid
box {<59, 40, -1><63, -65, 61> texture {bijelo}}
//strop
box {<-200, -2, 60><200, 200, 64> rotate <0, 0, -36> texture {bijelo}}
//iza vidljivog zida
}

union{
box {<-37.03, -50, -0.1><-42, 50, 60> texture { zmaj_tex_zid_iza}}
#declare br7=-15;
#while (br7<15)
#declare br8=0;
#while (br8<12)
   
 box {<-37, 0.03, 0.03><-62, 4.97, 4.97> translate <0, br7 *5, br8 *5>}
 
     
      #declare br8 = br8+1;
   #end
   
    #declare br7 = br7+1;
   #end
texture {zmaj_bitmap}  
}
}


object {scena_sve  translate <10, -21, 0>}



//#include "zmaj_body.inc"  object {a_zmaj_body  rotate <90, 0, 180> scale <-1, 1, 1> texture {zmaj_body_tex}}
//#include "zmaj_krila.inc" object {a_zmaj_krilo1  rotate <90, 0, 180> scale <-1, 1, 1>texture {zmaj_krilo_tex1}}
//                          object {a_zmaj_krilo2  rotate <90, 0, 180> scale <-1, 1, 1>texture {zmaj_krilo_tex2}}
                         
//#include "zmaj_noge_prednje.inc" object { a_zmaj_noge_prednje  
//rotate <90, 0, 180> scale <-1, 1, 1> texture {zmaj_body_tex_1}}
//#include "zmaj_zadnje_noge.inc"  object {  a_zmaj_zadnje_noge  
//rotate <90, 0, 180> scale <-1, 1, 1> texture {zmaj_body_tex_1}}
//
//#include "zmaj_zubi.inc"  object {a_zmaj_zubi rotate <90, 0, 180> scale <-1, 1, 1> texture {zmaj_zubi_tex}}
//
//#include "zmaj_nokti.inc" object {a_zmaj_nokti rotate <90, 0, 180> scale <-1, 1, 1> texture {zmaj_nokti_tex}}
//
//#include "zmaj_oko.inc"   object {oko rotate <0, 0, 61>   scale 0.28 translate <4.85, 26.05, 2.36>}
//
//#include "zmaj_usi.inc"   object {a_zmaj_uho1  rotate <90, 0, 180> scale <-1, 1, 1> texture {zmaj_uho_tex1}}
//                          object {a_zmaj_uho2  rotate <90, 0, 180> scale <-1, 1, 1> texture {zmaj_uho_tex2}}

//#include "zmaj_iv.inc"    object {iv scale <1.15, 1.15, -1.15> rotate <0, 0, 180> translate <-11, -26.5, 3>}


 






