
#include "glass.inc"
#include "colors.inc"
#include "skies.inc"

#declare alldayglass = merge{             // A pretty nice all-day glass.

  torus{ .2875, .0125                     // Edge of main glass.
    translate .9875*y
  }

  difference{                             // Main glass.
    cylinder{ .9875*y, .75*y, .3 }
    cylinder{ 1*y, .5*y, .275 }
  }
  difference{
    sphere{ .75*y, .3 }
    sphere{ .75*y, .275 }
    plane{ y, .75001 inverse }
  }
  
  cylinder{ .475*y, 0.0001, .1 }           // Foot
  cylinder{ .05*y, 0.00001, .225 }         

  torus{ .225, .0125                       // Smooth lower edge of foot.
    translate .0125*y     
  }
  torus{ .225, .0125
    translate .0375*y     
  }
  cylinder{ .0125*y, .0375*y, .2375 }       

  difference{
    cylinder{ .075*y, .025*y, .125 }       // Smooth lower bend of foot.
    torus{ .125, .025
      translate .075*y     
    }
  }

  difference{                              // Smooth bend between main glass and foot.
    cone{
      .75*y, 0,
      (.75-sqrt(.35*.35-.15*.15))*y, .15 }
    torus{ .15, .05
      translate (.75-sqrt(.35*.35-.15*.15))*y
    }
    plane{ y, .75-sqrt(.3*.3-.15*.15) inverse }
  }

  texture{ T_Glass3 }
  interior{ I_Glass caustics 1.5 }
}
