// Desc: Please see "pepsodent.txt".
// Date: 99-06-??
// Auth: Victor Widell ( vicce.was@home.se )

// Anyone may use this scenefile or its
// components, comercial or non-comercial,
// but please send me an e-mail
// to let me know. 

camera {
	location <4, 6, -8>
	look_at <.75, 1.5, -.4>
	angle 30

  focal_point  <.75, 1.5, -.4>
  aperture     .15
  blur_samples 1000
  confidence   .999
  variance     1/256
}

#include "alldayglass.inc"            // The glass in the foreground.
object{ alldayglass
  scale 2
  translate <0, 0, -.75>
}

#include "tube.inc"               // The tube of toothpaste.

light_source { < 0, 17.9, -30 > color rgb 1.5 }

plane { y, -17.5 pigment{ rgb <1, .4, .2> }} // floor

plane { y, 18               // celing
  pigment{ rgb <.1, .1, 1> }
  finish{ ambient .3 }
  normal{ granite .1 scale .5 }
}

box{ <-5, -40, -40>, <20, 50, 1.5> // walls
  pigment{ rgb 1 }
  finish{ ambient .3 }
  normal{ granite .1 scale .5 }
  hollow
}
  

#include "colors.inc"
#include "stones1.inc"
union{                                     // shelf
  box{ <-5, -.5, -1.5>, <5, 0, 5> }
  cylinder{ <-5, -.25, -1.5>, <5, -.25, -1.5>, .25 }
  cylinder{ <5, -.25, -1.5>, <5, -.25, 5>, .25 }
  sphere{ <5, -.25, -1.5>, .25 }
  texture{ T_Stone16 }
}

union{                               // mirror
  box{ <-4, .05, 1.45>, <5, 10, 1.5> }
  cylinder{ <-5, .025, 1.475>, <5, .025, 1.475>, .025 }
  pigment{ rgb .3 }
  finish{ reflection .6 }
}

union{                              // toothbrush
  #declare X=0;
  #declare Z=0;
  #while (X<20)
    #while(Z<10)
      cylinder{ <-.75-X*.15, .1, .75-Z*.15>, <-.75-X*.15, 1.7, .75-Z*.15>, .04
        pigment{ rgb 1 }
        finish{ phong .65 }
      }
      #declare Z=Z+1;
    #end
    #declare Z=0;
    #declare X=X+1;
  #end
  #include "toothbrush.inc"
  scale .2
  rotate z*-3.576334375
  rotate y*10
  translate <-.3, 0, .7>
}

union{                             // washbasin
  #include "washbasin.inc"
  scale 4
  rotate -90*y
  translate <-5, -1, -5.5>
}

union{                             // towel
  #include "towel.inc"
  scale <2, 2.5, 2.5>
  rotate 90*y
  translate <-3.9, 5.5, -3>
}

union{                             // small mirror
  #declare rotation_A = 82*x;
  #include "small mirror.inc"
  translate 2.1*z
  scale .5
  rotate -90*x
  rotate 60*y
  translate <-3, 0, 0>
}

union{                              // door
  box{ <-5, -17.5, -30>, <-4.8, 15, -20>
    pigment { rgb <.1, .1, 1> }
    finish { ambient .3 }
  }
}


