
// Persistence of Vision Ray Tracer Scene Description File
// File: .pov
// Vers: 3.1
// Desc: 
// Date: 
// Auth: 

// ==== Standard POV-Ray Includes ====
#include "colors.inc"	// Standard Color definitions
#include "textures.inc"	// Standard Texture definitions

camera
{
  location <-40,200,-40>
  look_at   <0 ,180 ,10>
}
/*
camera
{
  location <-100,100,0>
  look_at   <0 ,0 ,0>
}
*/
// create a regular point light source
light_source
{
  0*x // light's position (translated below)
  color  red 1.0  green 1.0  blue 1.0  // light's color
  translate -5000*x
  rotate <0,-33,-33>
}

plane
{
	y,-8
	pigment {DarkSlateBlue * .75}
	normal { bumps 1 }
	scale <10,10,100>
}

plane { 
	y, 5000
	texture {
		pigment { SkyBlue }
		finish { ambient 1 diffuse 0}
	}
	texture {
		pigment {
			bozo
			turbulence .25
			color_map {
				[0 White]
				[1 White transmit 1]
			}
		}
		normal {
			bozo
			turbulence .25
			normal_map {
				[0 bumps 1]
				[1 bumps 0]
			}
			scale <100,1,100>
		}
		finish { ambient 1 diffuse 0 }
		scale <6000, 1000, 6000>
		rotate <5, 45, 0>
	}
}

// Create an infinite sphere around scene and allow any texture on it
sky_sphere
{
  pigment
  {
    gradient y
    color_map { [0.0 color rgb <.7,.7,1.0>] [ 1.0 Blue ] }
  }
}

#include "macros.inc"                            

#include "base.inc"		// lighthouse base

#include "tower.inc"	// main body

#include "supstrct.inc"	// lighthouse superstructure

box {
	<-80,-1,-4800>,<80,0,4800>
	pigment {
		gradient x
		color_map {
			[ 0.0 color ForestGreen ]
			[ 0.84 color ForestGreen ]
			[ 0.84 color Black transmit 1 ]
			[ 1.0 color Black transmit 1 ]
		}
		scale <3200,1,9600>
		turbulence .05 
	}
	normal { bumps 1 }
}	

height_field {
	tga "hf.tga"
	translate <-.5,-.5,-.5>
	scale <3200,16,12000>
	translate -800*x
	texture
	{
		pigment { 
			White
		}
		normal { 
			gradient x
			normal_map {
				[ 0.0 bumps 1 ]
				[ 0.04 bumps 0 ]
				[ 1.0 bumps 0 ]
			}
			turbulence .05
	    }
	}
}
