
// ==== Standard POV-Ray Includes ====
#include "colors.inc"	// Standard Color definitions
#include "textures.inc"	// Standard Texture definitions

global_settings { hf_gray_16 }

camera
{
  location  <0.0 , 3200.0 ,0.0>
  look_at   <0.0 , 0.0 , 0.0>
}

// create a regular point light source
light_source
{
  0*x // light's position (translated below)
  color red 1.0  green 1.0  blue 1.0  // light's color
  translate <0,3200,0>
}
/*
plane
{
	y,0
	pigment
	{
		White
	}
	normal
	{
		bozo
		normal_map
		{
			[ 0.00 bumps 2 ]
			[ 0.50 bumps 1 ]
			[ 0.75 bumps 0 ]
			[ 0.95 bumps 0 ]
		}
	}
}
*/

plane
{
	y,0
	pigment {
		gradient x
		pigment_map
		{
			[ 0.00 White ]
			[ 0.25 White ]
			[ 0.75 Black ]
			[ 1.00 Black ]
			[ 1.00 White ]
		}
		scale <3200,1,800>
		turbulence <.05,0,0>
		translate -1000*x
	}
}
