// Persistence of Vision Ray Tracer Scene Description File
// File: macros.inc
// Vers: 3.1
// Desc: include file for bbsunset.pov. macros for generating parts of lighthouse base
// Date: 7/31/99
// Auth: Bill Bobzien

#macro MakeComponent (component_type,rad,ht1,ht2,rot,tex)
	#local end_offset = rad * tan(radians(22.5));
  	#local corner1 = <-end_offset,ht1,rad>;
  	#local ct = 0;
  	#switch (component_type)
  		#case (1)
		  	#local corner2 = <end_offset,ht2,0>;
  			#while (ct < 8)
				box {
					corner1,corner2
					texture { tex }
					rotate 45*ct*y
				}
				#local ct = ct+1;
			#end
		#break
	  	#case (2)
		  	#local corner2 = <end_offset,ht1,rad>;
			#while (ct < 4)
				union
				{
					difference {
						union {
							box {
								<-2.875,.125,-1.25>,<2.875,(ht2-ht1)-.125,.25>
								translate corner1
							}
							box {
								<2.875,.125,.25>,<-2.875,(ht2-ht1)-.125,-1.25>
								translate corner2
							}
						}
						union {
							box {
								<-3,-.5,.25>,<3,(ht2-ht1)+.5,2.5>
								translate corner1
								rotate 45*y
							}
							box {
								<3,-.5,2.5>,<-3,(ht2-ht1)+.5,.25>
								translate corner2
								rotate -45*y
							}
						}
					}
					difference {
						union {
							box {
								<-3,0,-1.375>,<3,(ht2-ht1),.125>
								translate corner1
							}
							box {
								<3,0,.125>,<-3,(ht2-ht1),-1.375>
								translate corner2
							}
						}
						union {
							box {
								<-4,-.5,.125>,<4,(ht2-ht1)+.5,3>
								translate corner1
								rotate 45*y
							}
							box {
								<4,-.5,3>,<-4,(ht2-ht1)+.5,.125>
								translate corner2
								rotate -45*y
							}
						}
					}
					texture { tex }
					rotate ((ct*90)+rot)*y
				}
				#local ct = ct + 1;
			#end
		#break
	#end	
#end

#macro MakeCylSet (rad,ht,cyl_rad,tex)
	#local end_offset = rad * tan(radians(22.5));
  	#local end1 = <-end_offset,ht,rad>;
	#local end2 = <end_offset,ht,rad>;
	#local end_adj = (cyl_rad*tan(radians(22.5)))*x;
	#local ct = 0;
	#while (ct < 8)
		difference {
			cylinder {
				end1-end_adj,end2+end_adj,cyl_rad
			}
			union {
				box {
					<0,-1.1*cyl_rad,-1.1*cyl_rad>,1.1*cyl_rad
					rotate 22.5*y
					translate end2
				}
				box {
					<0,1.1*cyl_rad,1.1*cyl_rad>,-1.1*cyl_rad
					rotate -22.5*y
					translate end1
				}							
			}
			texture { tex }
			rotate 45*ct*y
		}
		#local ct = ct+1;
	#end
#end
#macro MakeDiffSet (rad,ht,cyl_rad,tex)
	#local end_offset = rad * tan(radians(22.5));
  	#local end1 = <-end_offset,ht,rad>;
	#local end2 = <end_offset,ht,rad>;
	#local end_adj = (cyl_rad*tan(radians(22.5)))*x;
	#local ct = 0;
	#while (ct < 8)
		difference {
			difference {
				box {
					end1,end2+<0,2*cyl_rad,-rad>
				}
				cylinder {
					end1-end_adj,end2+end_adj,cyl_rad
				}
			}
			union {
				box {
					<0,-1.1*cyl_rad,-2.1*cyl_rad>,2.1*cyl_rad
					rotate 22.5*y
					translate end2
				}
				box {
					<0,-1.1*cyl_rad,-2.1*cyl_rad>,<-2.1*cyl_rad,2.1*cyl_rad,2.1*cyl_rad>
					rotate -22.5*y
					translate end1
				}							
			}
			texture { tex }
			rotate 45*ct*y
		}
		#local ct = ct+1;
	#end
#end         