// Persistence of Vision Ray Tracer Scene Description File
// File: supstrct.inc
// Vers: 3.1
// Desc: include file for bbsunset.pov. Superstructure of the Cape Hatteras Lighthouse
// Date: 7/31/99
// Auth: Bill Bobzien

#declare Lamp = 
	union {
		cylinder {
			<2,0,0>,<1.99,0,0>,1.5
			pigment { White transmit .9 }
			finish { reflection .1 specular .23 roughness .001 }
		}
		difference {
			union {
				cylinder {
					<1.1,0,0>,<.9,0,0>,2.25
				}
				cylinder {
					<1.85,0,0>,<1.15,0,0>,1.85
				}
				cylinder {
					<1.95,0,0>,<1,0,0>,1.65
				}
				cone {
					<1,0,0>,1.65,<0,0,0>,1.5
				}
			}
			cylinder {
				<2.1,0,0>,<1,0,0>,1.5
				pigment { Silver }
				finish { reflection .75 }
			}
		}
	}

#declare FancyPost = 
	union {
		cylinder {
			0,.12*y,.3
		}
		intersection {
			box {
				<-.25,0,-.25>,<.25,.62,.25>
			}
			box {
				<-.25,0,-.25>,<.25,.62,.25>
				rotate 45*y
			}
		}
		cylinder {
			.62*y,.70*y,.3
		}
		torus {
			.17,.08
			translate .7*y
		}
		sphere {
			0,.16
			scale <1.875,1,1.875>
			translate .86*y
		}
		difference {
			cylinder {
				-.08*y,.08*y,.3
			}
			union {
				torus {
					.3,.08
				}
				cylinder {
					-.09*y,-.04*y,.4
				}
			}
			translate 1.02*y
		}
		cylinder {
			1.1*y,1.16*y,.3
		}
		cylinder {
			1.16*y,1.22*y,.2
		}
		difference {
			torus {
				.2,.05
			}
			cylinder {
				0,y*.06,.26
			}
			translate 1.28*y
		}
		cone {
			0,.26,1.34*y,.12
			translate 1.28*y
		}
		cylinder {
			2.62*y,2.82*y,.12
		}
		cone {
			2.82*y,.12,2.94*y,.18
		}
		cylinder {
			2.94*y,3.18*y,.18
		}
		torus {
			.06,.12
			translate 3.18*y
		}
		cylinder {
			3.30*y,3.36*y,.06
		}
		difference {
			torus {
				.06,.06
			}
			cylinder {
				0,.07*y,.13
			}
			translate 3.36*y
		}
		cone {
			3.36*y,.12,4.02*y,.05
		}
		torus {
			.05,.06
			scale <1,.5,1>
			translate 4.05*y
		}
		torus {
			.11,.03
			translate 4.08*y
		}
		union {
			sphere {
				0,.12
				scale <1,2,1>
			}
			cone {
				.06*y,.12,0,.18
			}
			translate 4.37*y
		}
		cylinder {
			-.88*y,-1.84*y,.36
		}
		cone {
			-1.84*y,.3,-2*y,.24
		}
		difference {
			torus {
				.3,.06
			}
			cylinder {
				0,-.07*y,.37
			}
			translate -2.06*y
		}
		torus {
			.28,.12
			translate -2.21*y
		}
		cone {
			-2.33*y,.28,-2.57*y,.12
		}
		sphere {
			0,.18
			scale <1,.75,1>
			translate -2.69*y
		}
	}
#declare FancySupport = 
		union {
			union {
				box {
				<-2,3.84,-.06>,<2.64,3.24,.06>
				}
				difference {
					cylinder {
						<.75,1.92,-.06>,<.75,1.92,.06>,1.61
					}
					cylinder {
						<.75,1.92,-.37>,<.75,1.92,.37>,.94
					}
				}
				intersection
				{
					difference {
						cylinder {
							<-2.4,1.92,-.06>,<-2.4,1.92,.06>,1.8
						}
						cylinder {
							<-2.4,1.92,-.37>,<-2.4,1.92,.37>,1.2
						}
					}
					box {
						<-2.4,3.5,-.5>,<-.51,1.92,.5>
					}
				}
				intersection {
					difference {
						cylinder {
							-.06*z,.06*z,1.69
							scale <1,2,1>
						}
						cylinder {
							-.37*z,.37*z,1.39
							scale <.75,2,1>
						}
					}
					box {
						<-1.6,0,-.13>,<-.3,-4,.13>
					}
					translate 1.92*y
					translate .88*x
				}
				intersection {
					difference {
						cylinder {
							-.06*z,.06*z,1.69
							scale <1,2,1>
						}
						cylinder {
							-.37*z,.37*z,1.39
							scale <.75,2,1>
						}
					}
					box {
						<.3,.26,-.13>,<1.6,4,.13>
					}
					translate -4.1*y
					translate .28*x
				}
				box {
					<-.3,3.84,-.06>,<.3,-3.84,.06>
					rotate -5*z
					translate 2.28*x
				}
			}
			union {
				box {
				<-2,3.84,-.12>,<2.64,3.44,.12>
				}
				difference {
					cylinder {
						<.75,1.92,-.12>,<.75,1.92,.12>,1.46
					}
					cylinder {
						<.75,1.92,-.37>,<.75,1.92,.37>,.94
					}
				}
				intersection
				{
					difference {
						cylinder {
							<-2.4,1.92,-.12>,<-2.4,1.92,.12>,1.6
						}
						cylinder {
							<-2.4,1.92,-.37>,<-2.4,1.92,.37>,1.2
						}
					}
					box {
						<-2.4,3.5,-.5>,<-.51,1.92,.5>
					}
				}
				box {
					<-1.2,1.92,-.12>,<-.2,2.32,.12>
				}
				intersection {
					difference {
						cylinder {
							-.12*z,.12*z,1.69
							scale <1,2,1>
						}
						cylinder {
							-.37*z,.37*z,1.49
							scale <.937,2,1>
						}
					}
					box {
						<-1.7,0,-.13>,<-.3,-4,.13>
					}
					translate 1.92*y
					translate .88*x
				}
				intersection {
					difference {
						cylinder {
							-.12*z,.12*z,1.59
							scale <.937,2,1>
						}
						cylinder {
							-.37*z,.37*z,1.39
							scale <.75,2,1>
						}
					}
					box {
						<.3,.26,-.13>,<1.6,4,.13>
					}
					translate -4.1*y
					translate .28*x
				}
				box {
					<-.15,3.84,-.12>,<.3,-3.84,.12>
					rotate -5*z
					translate 2.28*x
				}
			}
			union {
				box {
				<-2,3.84,-.18>,<2.64,3.74,.18>
				}
				difference {
					cylinder {
						<.75,1.92,-.18>,<.75,1.92,.18>,1.06
					}
					cylinder {
						<.75,1.92,-.37>,<.75,1.92,.37>,.94
					}
				}
				intersection
				{
					difference {
						cylinder {
							<-2.4,1.92,-.18>,<-2.4,1.92,.18>,1.3
						}
						cylinder {
							<-2.4,1.92,-.37>,<-2.4,1.92,.37>,1.2
						}
					}
					box {
						<-2.4,3.5,-.5>,<-.51,1.92,.5>
					}
				}
				box {
					<-1.2,1.92,-.18>,<-.7,2.02,.18>
				}
				intersection {
					difference {
						cylinder {
							-.18*z,.18*z,1.69
							scale <1,2,1>
						}
						cylinder {
							-.37*z,.37*z,1.64
							scale <.937,2,1>
						}
					}
					box {
						<-1.7,0,-.13>,<-.3,-4,.13>
					}
					translate 1.92*y
					translate .88*x
				}
				intersection {
					difference {
						cylinder {
							-.18*z,.18*z,1.49
							scale <.775,1.95,1>
						}
						cylinder {
							-.37*z,.37*z,1.39
							scale <.75,2,1>
						}
					}
					box {
						<.3,.26,-.13>,<1.6,4,.13>
					}
					translate -4.1*y
					translate .28*x
				}
				box {
					<.2,3.84,-.18>,<.3,-3.84,.18>
					rotate -5*z
					translate 2.28*x
				}
			}
			
		}

	
#declare Superstructure = 
union
{
	// lantern room glass
	cylinder {
		-1*y,y*9.6,5.04
		pigment { White transmit .9 }
		finish { reflection .1 specular .23 roughness .001 }
	}
	union {
		// base of lantern room
		cylinder {
			-.12*y,0,8.16
		}
		cone {
			-.12*y,8.16,-.44*y,7.92
		}
		cone {
			-.44*y,7.92,-.60*y,7.36
		}
		// watch room
		cylinder {
			-.60*y,-1.08*y,7.36
		}
		cone {
			-1.08*y,7.36,-1.32*y,7.12
		}
		cylinder {
			-1.08*y,-9.6*y,7.12
		}
		// door
		union {
			box {
				<-1.44,0,-1>,<1.44,7.2,.125>
			}
			difference {
				box {
					<-.96,.48,-1>,<.96,6.72,.20>
				}
				box {
					<-.72,.72,-1.1>,<.74,6.48,.25>
				}
			}
			translate <0,-9.12,7.12>
			rotate 180*y
		}
		// middle rings of main balcony railing
		torus {
			12.72,.07
			translate -9.05*y
		}
		torus {
			12.72,.07
			translate -6.48*y
		}
		// top of main balcony railing
		difference {
			cylinder {
				-5.52*y,-5.47*y,12.9
			}
			cylinder {
				-5.53*y,-5.46*y,12.54
			}
		}	
		difference {
			torus {
				12.72,.18
				scale <1,.5,1>
			}
			cylinder {
				-.19*y,0,13
			}
			translate -5.47*y
		}
		#declare ct = 0;
		#while (ct < 16)
			// railing around main balcony/balcony supports
			object { FancyPost translate -9.6*y translate 12.72*x rotate (11.25+22.5*ct)*y }
			object { FancySupport translate -14.75*y translate -10.5*x rotate (11.25+22.5*ct)*y }
			#declare start_degrees = (13.5+(22.5*ct));
			#declare small_ct = 0;
			#while (small_ct < 17)
				cylinder {
					-9.05*y,-6.56*y,.04
					translate 12.72*x
					rotate (start_degrees+(small_ct*1.125))*y
				}
				#declare small_ct = small_ct + 1;
			#end
			// bracing around lantern room glass
			union {
				box {
					<0,0,-.06>,<.0625,9.6,.06>
				}
				box {
					<0,0,.04>,<.48,9.6,.04>
				}
				translate 5.04*x
				rotate (11.25+22.5*ct)*y
			}
			// posts for upper balcony railing
			union {
				cylinder {
					0,.24*y,.12
				}
				cylinder {
					0,2.88*y,.06
				}
				translate 7.92*x
				rotate (11.25+22.5*ct)*y
			}
			#declare ct = ct + 1;
		#end
		
		// bracing around glass
		torus {
			7.92,.05
			translate 2.8*y
		}
		// top of upper balcony railing
		torus {
			5.52,.0625
			translate 6*y
		}
		// roof
		//bottom
		difference {
			cylinder {
				0*y,.96*y,6.94
			}
			torus {
				6.7,.72
			}
			translate 9.6*y
		}
		//main roof
		cone {
			10.56*y,6.94,14.16*y,.48
		}
		// lantern vent/lightning rod
		difference {
			union
			{
				cone {
					-.72*y,1.2,.24*y,.96
				}
				torus {
					.72,.24
					translate .24*y
				}
			}
			torus {
				1.2,.33
			}
			translate 14.30*y
		}

		union {
			cylinder {
				14.54 * y,16.7*y,.72
			}
			sphere {
				15.98*y,1.2
			}
			cylinder {
				15.98*y,17.18*y,.48
			}
			cylinder {
				15.98*y,17.24*y,.4
			}
			cone {
				17.24*y,.12,17.48*y,.112
			}
			cone {
				17.48*y,.1,20.12*y,.00001
			}
		}
		// base of main balcony
		cylinder {
			-9.6*y,-9.72*y,14
		}
		cylinder {
			-9.72*y,-9.84*y,13.76
		}
		torus {
			13.52,.24
			translate -9.84*y
		}
		cylinder {
			-9.84*y,-10.08*y,13.52
		}
		cylinder {
			-10.08*y,-10.48*y,13.4
		}
		cylinder {
			-10.48*y,-10.96*y,12.44
		}
		cone {
			-9.84*y,7.12,-18.48*y,8.4
		}
		cone {
			-18.48*y,8.4,-18.72*y,9.36
		}
		cylinder {
			-18.72*y,-18.96*y,9.36
		}
		cylinder {
			-18.96*y,-19.20*y,9.12
		}
		cone {
			-19.20*y,9.36,-19.68*y,8.88
		}
		cone {
			-19.68*y,8.88,-19.92*y,8.76
		}
		cylinder {
			-19.92*y,-20.4*y,8.4
		}
		union {
			object { Lamp }
			object { Lamp rotate 180*y}
		    cylinder { 0,y*-6,.5 }
		    cone { -3*y,.5,y*-5,3 }
		    translate y*5
		}
		pigment { Black }
		finish { specular .08 roughness .5 }
	}
}

object { Superstructure translate 185.14*y}
//object { FancySupport pigment { White } translate 186*y}