/*

   "CAON (CANYON)", Jaime Vives Piqueres, (?)1999.
   ------------------------------------------------
   Entry for the IRTC, 07-08-99, topic "LANDMARKS"
   ------------------------------------------------
   See canyon.txt for a rough explanation. Or look
   trough all the .pov and .inc source files for
   some comments on details.

*/


// *** BASICS ***
#version 3.1;
global_settings{
 max_trace_level 64    // needed for the sky stack
}


// *** STANDARD INCLUDES ***
#include "colors.inc"
#include "textures.inc"
#include "stones.inc"
#include "woods.inc"


// *** CONTROL VARIABLES ***
#declare trace_bed   =1;  // 1=on, 0=off
#declare trace_water =1;
#declare trace_canyon=1;
#declare trace_bridge=1;
#declare trace_plants=1;
#declare trace_sky   =1;


// *** COMMON TEXTURES ***
#include "i_textur.inc"


// *** CANYON ***
#if (trace_canyon)
 #include "i_walls.inc"
#end


// *** (DANGEROUS) BRIDGE ***
#if (trace_bridge)
 #include "i_bridge.inc"
#end


// *** RIVER BED ***
#if (trace_bed)
 #include "i_bed.inc"
#end


// *** RUNNING WATER ***
#if (trace_water)
 #include "i_water.inc"
#end


// *** PLANTS ***
#if (trace_plants)
 #include "i_reeds.inc"
#end


// *** SKY & SUNLIGHT ****
#if (trace_sky)
 #include "i_sky.inc"
#end


// *** CAMERA, LIGHTS, ...ACTION! ***
camera{
 location <-1,45,-500>
 direction 1.3*z        // a bit short to give depth
 look_at <1.1,101,0.1>
}
