// Persistence of Vision Ray Tracer Scene Description File
// File: Forth.pov
// Vers: 3.1
// Desc: The Forth Bridge - main scene file
// Note: 1 unit = 1 ft
// Date: August 31st 1999
// Auth: Christian Radek, Ph.D.

/*
  PLEASE NOTE:
    
    Include files and objects which are commented out are not part of the zip file
    and will not be realeased now. However, permission is herewith given to use
    all other source files.
    
    My intention is to give you some insight into the construction of the image
    and I would be delighted to see a few other bridges (Golden Gate Bridge,
    Quebec Bridge etc.) in the near future
*/

#include "colors.inc"	// Standard Color definitions
#include "textures.inc"	// Standard Texture definitions

#include "forth_02.inc" // Inchgarvie Pier
//#include "forth_03.inc" // Queensferry and Fife Pier
//#include "forth_04.inc" // Cantilever 
#include "forth_05.inc" // Suspended Span, Track and approach viaduct
#include "forth_06.inc" // Masonry of the approach viaducts
#include "ship.inc"
//#include "environ.inc"

global_settings {
  ambient_light color White
  assumed_gamma 1.25
}

// Define the camera
camera{ location <3500,-10,-900> look_at <2250, -10,  0> angle 57.5} 

light_source
{
  <10000,2000,-10000>
  color rgb 1.0  
  area_light
  <3, 0, 0> <0, 0, 3> 
  3, 3                
  adaptive 1           
  jitter              
}


fog {
  distance 15000
  color rgbf<0.25, 0.25, 0.25, 0.5>
  fog_type 2
  fog_offset 0
  fog_alt 500
}

 
// Define the sky
#declare Cloud_Layer_1 =
pigment {
    wrinkles
    turbulence 0.65
    octaves 6
    omega 0.7
    lambda 2
    color_map {
        [0.0, 0.1   color red 0.15 green 0.15 blue 0.15
                    color red 0.45 green 0.45 blue 0.45]
        [0.1, 0.5   color red 0.70 green 0.70 blue 0.70
                    color rgb <0.0, 0.0, 0.357>]
        [0.5, 1.001 color rgb <0.0, 0.0, 0.357>
                    color rgb <0.0, 0.0, 0.357>]
    }
    scale <6, 1, 6>
}
#declare Cloud_Layer_2 =
pigment {
    bozo
    color_map {
        [0.0, 0.1   color red 0.85 green 0.85 blue 0.85
                    color red 0.0 green 0.0 blue 0.65]
        [0.1, 0.5   color red 0.0 green 0.0 blue 0.65
                    color rgb <0.0, 0.0, 0.309> ]
        [0.5, 1.001 color rgb <0.0, 0.0, 0.309>
                    color rgb <0.0, 0.0, 0.2>]
    }
    turbulence 0.65
    octaves 6
    omega 0.707
    lambda 2
    scale <6, 4, 6>
}

sky_sphere {
    pigment {
        gradient y
        pigment_map {
            [0.01 rgb <0.1,0.1,0.1>] // horizon
            [0.25 Cloud_Layer_1 scale 0.25 rotate z*5]
            [0.60 Cloud_Layer_2 scale <0.25, 0.15, 0.25> rotate z*10]
        }
    }
}

// Define the water surface
plane { y, -20.0
   texture {
     pigment {
       color rgb <0.39, 0.41, 0.43>
     }
     finish {
       ambient 0.15
       brilliance 5
       diffuse 0.6
       metallic
       specular 0.80
       roughness 1/100
       reflection 0.65
     }
     normal {
       waves 0.05
       frequency 5000.0
       scale 3000.0
     }
  }
}

//The bridge itself
union {
  object{Ship rotate<0,90,0> translate<2400,-10,100>}
  
  //object{Approach_Viaduct_Section translate<3579,0,0>}
  //object{Pilar translate<3495,0,0>}
  //object{Approach_Viaduct_Section translate<3411,0,0>}
  //object{Pilar translate<3327,0,0>}
  //object{Approach_Viaduct_Section translate<3243,0,0>}
  //object{Pilar translate<3159,0,0>}
  object{Approach_Viaduct_Section translate<3075,0,0>}
  object{Pilar translate<2991,0,0>}
  object{Approach_Viaduct_Section translate<2907,0,0>}
  object{Pilar translate<2823,0,0>}
  object{Approach_Viaduct_Section translate<2739,0,0>}
  object{Portal translate<2655,0,0>}
  //object{Cantilever rotate<0,180,0> translate<1975,0,0>}
  //object{Queensferry_Pier translate<1902.5,0,0>}
  //object{Cantilever translate<1830,0,0>}
  object{Suspended_Span translate<985,0,0>}
  //object{Cantilever rotate<0,180,0> translate<130,0,0>}
  object{Inchgarvie_Pier}
  //object{Cantilever translate<-130,0,0>}
  object{Suspended_Span translate<-985,0,0>}
  //object{Cantilever rotate<0,180,0> translate<-1830,0,0>}
  //object{Queensferry_Pier translate<-1902.5,0,0>}
  //object{Cantilever translate<-1975,0,0>}
  object{Portal rotate<0,180,0> translate<-2655,0,0>}
  object{Approach_Viaduct_Section translate<-2739,0,0>}
  object{Pilar translate<-2823,0,0>}
  object{Approach_Viaduct_Section translate<-2907,0,0>}          
  object{Pilar translate<-2991,0,0>}
  object{Approach_Viaduct_Section translate<-3075,0,0>}
  object{Pilar translate<-3159,0,0>}
  object{Approach_Viaduct_Section translate<-3243,0,0>}
  object{Pilar translate<-3327,0,0>}
  object{Approach_Viaduct_Section translate<-3411,0,0>}
  object{Pilar translate<-3495,0,0>}
  object{Approach_Viaduct_Section translate<-3579,0,0>}
  object{Pilar translate<-3663,0,0>}
  object{Approach_Viaduct_Section translate<-3747,0,0>}
  object{Pilar translate<-3831,0,0>}
  object{Approach_Viaduct_Section translate<-3915,0,0>}
  object{Pilar translate<-3999,0,0>}
  object{Approach_Viaduct_Section translate<-4083,0,0>}
  object{Pilar translate<-4167,0,0>}
  object{Approach_Viaduct_Section translate<-4251,0,0>}
  
  union {
    #declare Count=-4335;
      #while (Count < 3171)
        object{Track translate< Count,0, 0>}
      #declare Count=Count+12;
    #end
  } 
  
  //object{Fife}
  //object{Inchgarvie}
  //object{Lighthouse translate<-180,-21,-100>}
  //object{Lighthouse translate<3200,-21,-700>}
  //object{Barrel translate<3482,-20.5,-877>}
}
