//Modules and declares used in the other scene files
#include "colors.inc"

// Define the typical red bridge color
#declare Bridge_Color = pigment{rgb <1.0, 0.2, 0.25>}

// Girder 10x10x12
#declare Girder_1 =
union{
  cylinder{<-5, 5, -6>,<-5, 5, 6>, 0.5}
  cylinder{<-5,-5, -6>,<-5,-5, 6>, 0.5}
  cylinder{< 5, 5, -6>,< 5, 5, 6>, 0.5}
  cylinder{< 5,-5, -6>,< 5,-5, 6>, 0.5}
 
  cylinder{<-5, 5, -6>,<-5,-5, 6>, 0.3}
  cylinder{<-5,-5, -6>,<-5, 5, 6>, 0.3}
  cylinder{< 5, 5, -6>,< 5,-5, 6>, 0.3}
  cylinder{< 5,-5, -6>,< 5, 5, 6>, 0.3}
  
  cylinder{< 5,-5, -6>,<-5,-5, 6>, 0.3}
  cylinder{<-5,-5, -6>,< 5,-5, 6>, 0.3}
  cylinder{< 5, 5, -6>,<-5, 5, 6>, 0.3}
  cylinder{<-5, 5, -6>,< 5, 5, 6>, 0.3}
 
  texture{pigment{Bridge_Color} finish{phong 0.25}}
}
// Girder 10x7x8
#declare Girder_2 =
union{
  cylinder{<-5, 3.5, -4>,<-5, 3.5, 4>, 0.3}
  cylinder{<-5,-3.5, -4>,<-5,-3.5, 4>, 0.3}
  cylinder{< 5, 3.5, -4>,< 5, 3.5, 4>, 0.3}
  cylinder{< 5,-3.5, -4>,< 5,-3.5, 4>, 0.3}
 
  cylinder{<-5, 3.5, -4>,<-5,-3.5, 4>, 0.25}
  cylinder{<-5,-3.5, -4>,<-5, 3.5, 4>, 0.25}
  cylinder{< 5, 3.5, -4>,< 5,-3.5, 4>, 0.25}
  cylinder{< 5,-3.5, -4>,< 5, 3.5, 4>, 0.25}
  
  cylinder{< 5,-3.5, -4>,<-5,-3.5, 4>, 0.25}
  cylinder{<-5,-3.5, -4>,< 5,-3.5, 4>, 0.25}
  cylinder{< 5, 3.5, -4>,<-5, 3.5, 4>, 0.25}
  cylinder{<-5, 3.5, -4>,< 5, 3.5, 4>, 0.25}
 
  texture{pigment{Bridge_Color} finish{phong 0.25}}
}
//Girder 6x6x6
#declare Girder_3 =
union{
  cylinder{<-2.75, 2.75, -3>,<-2.75, 2.75, 3>, 0.25}
  cylinder{<-2.75,-2.75, -3>,<-2.75,-2.75, 3>, 0.25}
  cylinder{< 2.75, 2.75, -3>,< 2.75, 2.75, 3>, 0.25}
  cylinder{< 2.75,-2.75, -3>,< 2.75,-2.75, 3>, 0.25}
 
  cylinder{<-2.75, 2.75, -3>,<-2.75,-2.75, 3>, 0.2}
  cylinder{<-2.75,-2.75, -3>,<-2.75, 2.75, 3>, 0.2}
  cylinder{< 2.75, 2.75, -3>,< 2.75,-2.75, 3>, 0.2}
  cylinder{< 2.75,-2.75, -3>,< 2.75, 2.75, 3>, 0.2}
  
  cylinder{< 2.75,-2.75, -3>,<-2.75,-2.75, 3>, 0.2}
  cylinder{<-2.75,-2.75, -3>,< 2.75,-2.75, 3>, 0.2}
  cylinder{< 2.75, 2.75, -3>,<-2.75, 2.75, 3>, 0.2}
  cylinder{<-2.75, 2.75, -3>,< 2.75, 2.75, 3>, 0.2}
 
  texture{pigment{Bridge_Color} finish{phong 0.25}}
}
//Girder 4x4x4
#declare Girder_4 =
union{
  cylinder{<-1.75, 1.75, -2>,<-1.75, 1.75, 2>, 0.25}
  cylinder{<-1.75,-1.75, -2>,<-1.75,-1.75, 2>, 0.25}
  cylinder{< 1.75, 1.75, -2>,< 1.75, 1.75, 2>, 0.25}
  cylinder{< 1.75,-1.75, -2>,< 1.75,-1.75, 2>, 0.25}
 
  cylinder{<-1.75, 1.75, -2>,<-1.75,-1.75, 2>, 0.2}
  cylinder{<-1.75,-1.75, -2>,<-1.75, 1.75, 2>, 0.2}
  cylinder{< 1.75, 1.75, -2>,< 1.75,-1.75, 2>, 0.2}
  cylinder{< 1.75,-1.75, -2>,< 1.75, 1.75, 2>, 0.2}
  
  cylinder{< 1.75,-1.75, -2>,<-1.75,-1.75, 2>, 0.2}
  cylinder{<-1.75,-1.75, -2>,< 1.75,-1.75, 2>, 0.2}
  cylinder{< 1.75, 1.75, -2>,<-1.75, 1.75, 2>, 0.2}
  cylinder{<-1.75, 1.75, -2>,< 1.75, 1.75, 2>, 0.2}
 
  texture{pigment{Bridge_Color} finish{phong 0.25}}
}

//Girder 3x3x3
#declare Girder_5 =
union{
  cylinder{<-1.25, 1.25, -1.5>,<-1.25, 1.25, 1.5>, 0.25}
  cylinder{<-1.25,-1.25, -1.5>,<-1.25,-1.25, 1.5>, 0.25}
  cylinder{< 1.25, 1.25, -1.5>,< 1.25, 1.25, 1.5>, 0.25}
  cylinder{< 1.25,-1.25, -1.5>,< 1.25,-1.25, 1.5>, 0.25}
 
  cylinder{<-1.25, 1.25, -1.5>,<-1.25,-1.25, 1.5>, 0.2}
  cylinder{<-1.25,-1.25, -1.5>,<-1.25, 1.25, 1.5>, 0.2}
  cylinder{< 1.25, 1.25, -1.5>,< 1.25,-1.25, 1.5>, 0.2}
  cylinder{< 1.25,-1.25, -1.5>,< 1.25, 1.25, 1.5>, 0.2}
  
  cylinder{< 1.25,-1.25, -1.5>,<-1.25,-1.25, 1.5>, 0.2}
  cylinder{<-1.25,-1.25, -1.5>,< 1.25,-1.25, 1.5>, 0.2}
  cylinder{< 1.25, 1.25, -1.5>,<-1.25, 1.25, 1.5>, 0.2}
  cylinder{<-1.25, 1.25, -1.5>,< 1.25, 1.25, 1.5>, 0.2}
 
  texture{pigment{Bridge_Color} finish{phong 0.25}}
}

//Girder 8x8x8
#declare Girder_6 =
union{
  cylinder{<-3.75, 3.75, -4>,<-3.75, 3.75, 4>, 0.25}
  cylinder{<-3.75,-3.75, -4>,<-3.75,-3.75, 4>, 0.25}
  cylinder{< 3.75, 3.75, -4>,< 3.75, 3.75, 4>, 0.25}
  cylinder{< 3.75,-3.75, -4>,< 3.75,-3.75, 4>, 0.25}
 
  cylinder{<-3.75, 3.75, -4>,<-3.75,-3.75, 4>, 0.2}
  cylinder{<-3.75,-3.75, -4>,<-3.75, 3.75, 4>, 0.2}
  cylinder{< 3.75, 3.75, -4>,< 3.75,-3.75, 4>, 0.2}
  cylinder{< 3.75,-3.75, -4>,< 3.75, 3.75, 4>, 0.2}
  
  cylinder{< 3.75,-3.75, -4>,<-3.75,-3.75, 4>, 0.2}
  cylinder{<-3.75,-3.75, -4>,< 3.75,-3.75, 4>, 0.2}
  cylinder{< 3.75, 3.75, -4>,<-3.75, 3.75, 4>, 0.2}
  cylinder{<-3.75, 3.75, -4>,< 3.75, 3.75, 4>, 0.2}
 
  texture{pigment{Bridge_Color} finish{phong 0.25}}
}

// Girder 0.8 x 0.8 x 0.8
#declare Girder_7 =
union{
  cylinder{<-0.3, 0.3, -0.4>,<-0.3, 0.3, 0.4>, 0.1}
  cylinder{<-0.3,-0.3, -0.4>,<-0.3,-0.3, 0.4>, 0.1}
  cylinder{< 0.3, 0.3, -0.4>,< 0.3, 0.3, 0.4>, 0.1}
  cylinder{< 0.3,-0.3, -0.4>,< 0.3,-0.3, 0.4>, 0.1}
 
  cylinder{<-0.3, 0.3, -0.4>,<-0.3,-0.3, 0.4>, 0.05}
  cylinder{<-0.3,-0.3, -0.4>,<-0.3, 0.3, 0.4>, 0.05}
  cylinder{< 0.3, 0.3, -0.4>,< 0.3,-0.3, 0.4>, 0.05}
  cylinder{< 0.3,-0.3, -0.4>,< 0.3, 0.3, 0.4>, 0.05}
  
  cylinder{< 0.3,-0.3, -0.4>,<-0.3,-0.3, 0.4>, 0.05}
  cylinder{<-0.3,-0.3, -0.4>,< 0.3,-0.3, 0.4>, 0.05}
  cylinder{< 0.3, 0.3, -0.4>,<-0.3, 0.3, 0.4>, 0.05}
  cylinder{<-0.3, 0.3, -0.4>,< 0.3, 0.3, 0.4>, 0.05}
  
  texture{pigment{Bridge_Color} finish{phong 0.25}}
}

// For connection of the two sides of each tower / cantilever
#declare Top_Girder =
union{
  box{<-6,-6,-6>,<-3,-3, 6>}
  box{<-6, 6,-6>,<-3, 3, 6>}
  box{< 6,-6,-6>,< 3,-3, 6>}
  box{< 6, 6,-6>,< 3, 3, 6>}
  
  //Y-Z Face  
  cylinder{<-6, 4.5, -4.5>,<-6,-4.5, 4.5>, 1}
  cylinder{<-3,-4.5, -4.5>,<-3, 4.5, 4.5>, 1}
  cylinder{< 6, 4.5, -4.5>,< 6,-4.5, 4.5>, 1}
  cylinder{< 3,-4.5, -4.5>,< 3, 4.5, 4.5>, 1}
  //X-Z Face                    
  cylinder{< 4.5,-6, -4.5>,<-4.5,-6, 4.5>, 1}
  cylinder{<-4.5,-3, -4.5>,< 4.5,-3, 4.5>, 1}
  cylinder{< 4.5, 6, -4.5>,<-4.5, 6, 4.5>, 1}
  cylinder{<-4.5, 3, -4.5>,< 4.5, 3, 4.5>, 1}
 
  texture{pigment{Bridge_Color} finish{phong 0.25}}
}

// Support for the internal viaduct
#declare Tower_Viaduct_Support =
union{
  //Support
  box{<-5.25,107,-44  >,<  5.25,109,44  >}
  cylinder{<-5,107,-5.25>,<-5,67,-5.25>,0.5}
  cylinder{< 5,107,-5.25>,< 5,67,-5.25>,0.5}
  cylinder{<-5,107, 5.25>,<-5,67, 5.25>,0.5}
  cylinder{< 5,107, 5.25>,< 5,67, 5.25>,0.5}

  cylinder{<-5,67,-5.25>,<-5,67, 5.25>,0.5}
  cylinder{< 5,67,-5.25>,< 5,67, 5.25>,0.5}
  cylinder{<-5,67,-5.25>,< 5,67,-5.25>,0.5}
  cylinder{<-5,67, 5.25>,< 5,67, 5.25>,0.5}

  cylinder{<-5,79,-5.25>,<-5,79, 5.25>,0.5}
  cylinder{< 5,79,-5.25>,< 5,79, 5.25>,0.5}
  cylinder{<-5,79,-5.25>,< 5,79,-5.25>,0.5}
  cylinder{<-5,79, 5.25>,< 5,79, 5.25>,0.5}

  //Y-Z Face
  cylinder{<-5,94,-5.25>,<-5,79, 5.25>,0.3}
  cylinder{<-5,94, 5.25>,<-5,79,-5.25>,0.3}
  cylinder{< 5,94,-5.25>,< 5,79, 5.25>,0.3}
  cylinder{< 5,94, 5.25>,< 5,79,-5.25>,0.3}
  //X-Y Face
  cylinder{<-5,94,-5.25>,< 5,79,-5.25>,0.3}
  cylinder{< 5,94,-5.25>,<-5,79,-5.25>,0.3}
  cylinder{<-5,94, 5.25>,< 5,79, 5.25>,0.3}
  cylinder{< 5,94, 5.25>,<-5,79, 5.25>,0.3}

  cylinder{<-5,94,-5.25>,<-5,94, 5.25>,0.5}
  cylinder{< 5,94,-5.25>,< 5,94, 5.25>,0.5}
  cylinder{<-5,94,-5.25>,< 5,94,-5.25>,0.5}
  cylinder{<-5,94, 5.25>,< 5,94, 5.25>,0.5}

  //Y-Z Face
  cylinder{<-5,94,-5.25>,<-5,109, 5.25>,0.3}
  cylinder{<-5,94, 5.25>,<-5,109,-5.25>,0.3}
  cylinder{< 5,94,-5.25>,< 5,109, 5.25>,0.3}
  cylinder{< 5,94, 5.25>,< 5,109,-5.25>,0.3}
  //X-Y Face
  cylinder{<-5,94,-5.25>,< 5,109,-5.25>,0.3}
  cylinder{< 5,94,-5.25>,<-5,109,-5.25>,0.3}
  cylinder{<-5,94, 5.25>,< 5,109, 5.25>,0.3}
  cylinder{< 5,94, 5.25>,<-5,109, 5.25>,0.3}

  texture{pigment{Bridge_Color} finish{phong 0.25}}
}

//Skewback
#declare Skewback =
union {
  // Sides
  triangle{<  6, 7.5,-6.5>,< 12, 7.5,-6.5>,<  6,0,-7>}
  triangle{< 12, 7.5,-6.5>,<  6, 0  ,-7  >,< 12,0,-7>}
  triangle{< -6,15  ,-6  >,<  6,15  ,-6  >,< -6,0,-7>}
  triangle{<  6,15  ,-6  >,< -6, 0  ,-7  >,<  6,0,-7>}
  triangle{< -6, 7.5,-6.5>,<-18, 7.5,-6.5>,< -6,0,-7>}
  triangle{<-18, 7.5,-6.5>,< -6, 0  ,-7  >,<-21,0,-7>}

  triangle{<  6, 7.5, 6.5>,< 12, 7.5, 6.5>,<  6,0, 7>}
  triangle{< 12, 7.5, 6.5>,<  6, 0  , 7  >,< 12,0, 7>}
  triangle{< -6,15  , 6  >,<  6,15  , 6  >,< -6,0, 7>}
  triangle{<  6,15  , 6  >,< -6, 0  , 7  >,<  6,0, 7>}
  triangle{< -6, 7.5, 6.5>,<-18, 7.5, 6.5>,< -6,0, 7>}
  triangle{<-18, 7.5, 6.5>,< -6, 0  , 7  >,<-21,0, 7>}
    
  // Ends & Structure    
  triangle{<-18, 7.5,-8.5>,<-18, 7.5, 8.5>,<-21,0, 9>}
  triangle{<-18, 7.5,-8.5>,<-21,   0, 9>,<-21,0,-9>}
  triangle{<-16, 7.5,-8.5>,<-16, 7.5, 8.5>,<-18,0, 9>}
  triangle{<-16, 7.5,-8.5>,<-18,   0, 9>,<-18,0,-9>}
  triangle{<-14, 7.5,-8.5>,<-14, 7.5, 8.5>,<-15,0, 9>}
  triangle{<-14, 7.5,-8.5>,<-15,   0, 9>,<-15,0,-9>}
  triangle{<-12, 7.5,-8.5>,<-12, 7.5, 8.5>,<-12,0, 9>}
  triangle{<-12, 7.5,-8.5>,<-12,   0, 9>,<-12,0,-9>}
  triangle{< -9, 7.5,-8.5>,< -9, 7.5, 8.5>,< -9,0, 9>}
  triangle{< -9, 7.5,-8.5>,< -9,   0, 9>,< -9,0,-9>}
  triangle{< -6, 15,-8>,< -6, 15,  8>,< -6,0, 9>}
  triangle{< -6, 15,-8>,< -6,  0,  9>,< -6,0,-9>}
  triangle{< -3, 15,-8>,< -3, 15,  8>,< -3,0, 9>}
  triangle{< -3, 15,-8>,< -3,  0,  9>,< -3,0,-9>}
  triangle{<  0, 15,-8>,<  0, 15,  8>,<  0,0, 9>}
  triangle{<  0, 15,-8>,<  0,  0,  9>,<  0,0,-9>}
  triangle{<  3, 15,-8>,<  3, 15,  8>,<  3,0, 9>}
  triangle{<  3, 15,-8>,<  3,  0,  9>,<  3,0,-9>}
  triangle{<  6, 15,-8>,<  6, 15,  8>,<  6,0, 9>}
  triangle{<  6, 15,-8>,<  6,  0,  9>,<  6,0,-9>}
  triangle{<  9, 7.5,-8.5>,<  9, 7.5,  8.5>,<  9,0, 9>}
  triangle{<  9, 7.5,-8.5>,<  9,  0,  9>,<  9,0,-9>}
  triangle{< 12, 7.5,-8.5>,< 12, 7.5,  8.5>,< 12,0, 9>}
  triangle{< 12, 7.5,-8.5>,< 12,  0,  9>,< 12,0,-9>}
  // Top
  triangle{<-6, 15, 6>,< 6, 15, 6 >,<-6,15,-6>}
  triangle{< 6, 15, 6>,<-6, 15,-6 >,< 6,15,-6>}
  triangle{<-18, 7.5,-6.5>,<-18, 7.5, 6.5>,< 12,7.5, 6.5>}
  triangle{<-18, 7.5,-6.5>,< 12, 7.5, 6.5>,< 12,7.5,-6.5>}
  texture{pigment{Bridge_Color} finish{phong 0.25}}
}

//Internal Viaduct
#declare Internal_Viaduct =  
union {
  cylinder{< 0,109,-5>,< 0,119,-5>,0.5}
  cylinder{< 0,109, 5>,< 0,119, 5>,0.5}
  cylinder{< 0,109, 5>,< 0,109,-5>,0.5}
  cylinder{<-5,109,-5>,< 5,109,-5>,0.5}
  cylinder{<-5,109, 5>,< 5,109, 5>,0.5}
  
  cylinder{< 0,109,-5>,< 0,119, 5>,0.3}
  cylinder{< 0,109, 5>,< 0,119,-5>,0.3}
  //Bottom
  cylinder{<-5,109, 0>,< 0,109, 5>,0.3}
  cylinder{<-5,109, 0>,< 0,109,-5>,0.3}
  cylinder{< 5,109, 0>,< 0,109, 5>,0.3}
  cylinder{< 5,109, 0>,< 0,109,-5>,0.3}
  //Sides
  cylinder{<-5,114,-5>,< 0,119,-5>,0.3}
  cylinder{<-5,114,-5>,< 0,109,-5>,0.3}
  cylinder{< 5,114,-5>,< 0,119,-5>,0.3}
  cylinder{< 5,114,-5>,< 0,109,-5>,0.3}
  cylinder{<-5,114, 5>,< 0,119, 5>,0.3}
  cylinder{<-5,114, 5>,< 0,109, 5>,0.3}
  cylinder{< 5,114, 5>,< 0,119, 5>,0.3}
  cylinder{< 5,114, 5>,< 0,109, 5>,0.3}
  texture{pigment{Bridge_Color} finish{phong 0.25}}
}

//Small_Internal Viaduct
#declare Small_Internal_Viaduct =  
union {
  cylinder{< 0,114,-5>,< 0,119,-5>,0.5}
  cylinder{< 0,114, 5>,< 0,119, 5>,0.5}
  cylinder{< 0,114, 5>,< 0,114,-5>,0.5}
  cylinder{<-5,114,-5>,< 5,114,-5>,0.5}
  cylinder{<-5,114, 5>,< 5,114, 5>,0.5}
  
  cylinder{< 0,114,-5>,< 0,119, 5>,0.3}
  cylinder{< 0,114, 5>,< 0,119,-5>,0.3}
  //Bottom
  cylinder{<-5,114, 0>,< 0,114, 5>,0.3}
  cylinder{<-5,114, 0>,< 0,114,-5>,0.3}
  cylinder{< 5,114, 0>,< 0,114, 5>,0.3}
  cylinder{< 5,114, 0>,< 0,114,-5>,0.3}
  //Sides
  cylinder{<-5,116.5,-5>,< 0,119,-5>,0.3}
  cylinder{<-5,116.5,-5>,< 0,114,-5>,0.3}
  cylinder{< 5,116.5,-5>,< 0,119,-5>,0.3}
  cylinder{< 5,116.5,-5>,< 0,114,-5>,0.3}
  cylinder{<-5,116.5, 5>,< 0,119, 5>,0.3}
  cylinder{<-5,116.5, 5>,< 0,114, 5>,0.3}
  cylinder{< 5,116.5, 5>,< 0,119, 5>,0.3}
  cylinder{< 5,116.5, 5>,< 0,114, 5>,0.3}
  texture{pigment{Bridge_Color} finish{phong 0.25}}
}

//Girder 12x12x12 to be scaled down
#declare S_Girder =
union{
  cylinder{<-5.6,-6, 5.6>,<-5.6,6, 5.6>, 0.5}
  cylinder{<-5.6,-6,-5.6>,<-5.6,6,-5.6>, 0.5}
  cylinder{< 5.6,-6, 5.6>,< 5.6,6, 5.6>, 0.5}
  cylinder{< 5.6,-6,-5.6>,< 5.6,6,-5.6>, 0.5}
 
  cylinder{<-5.6,-6, 5.6>,<-5.6,6,-5.6>, 0.4}
  cylinder{<-5.6,-6,-5.6>,<-5.6,6, 5.6>, 0.4}
  cylinder{< 5.6,-6, 5.6>,< 5.6,6,-5.6>, 0.4}
  cylinder{< 5.6,-6,-5.6>,< 5.6,6, 5.6>, 0.4}
  
  cylinder{< 5.6,-6,-5.6>,<-5.6,6,-5.6>, 0.4}
  cylinder{<-5.6,-6,-5.6>,< 5.6,6,-5.6>, 0.4}
  cylinder{< 5.6,-6, 5.6>,<-5.6,6, 5.6>, 0.4}
  cylinder{<-5.6,-6, 5.6>,< 5.6,6, 5.6>, 0.4}
 
  texture{pigment{Bridge_Color} finish{phong 0.25}}
}

//Girder for suspended span 1.8 x 1.8 x 1.8
#declare Sp_Girder =
union{
  cylinder{<-0.85,-0.9, 0.85>,<-0.85,0.9, 0.85>, 0.05}
  cylinder{<-0.85,-0.9,-0.85>,<-0.85,0.9,-0.85>, 0.05}
  cylinder{< 0.85,-0.9, 0.85>,< 0.85,0.9, 0.85>, 0.05}
  cylinder{< 0.85,-0.9,-0.85>,< 0.85,0.9,-0.85>, 0.05}
 
  cylinder{<-0.85,-0.9, 0.85>,<-0.85,0.9,-0.85>, 0.04}
  cylinder{<-0.85,-0.9,-0.85>,<-0.85,0.9, 0.85>, 0.04}
  cylinder{< 0.85,-0.9, 0.85>,< 0.85,0.9,-0.85>, 0.04}
  cylinder{< 0.85,-0.9,-0.85>,< 0.85,0.9, 0.85>, 0.04}
  
  cylinder{< 0.85,-0.9,-0.85>,<-0.85,0.9,-0.85>, 0.04}
  cylinder{<-0.85,-0.9,-0.85>,< 0.85,0.9,-0.85>, 0.04}
  cylinder{< 0.85,-0.9, 0.85>,<-0.85,0.9, 0.85>, 0.04}
  cylinder{<-0.85,-0.9, 0.85>,< 0.85,0.9, 0.85>, 0.04}
 
  texture{pigment{Bridge_Color} finish{phong 0.25}}
}
