//Inchgarvie Pier - central tower - please note the two other towers are different!
#include "colors.inc"

#include "forth_01.inc"
#include "forth_06.inc"


//Inchgarvie Pier
#declare Inchgarvie_Pier =
union{
  //Foundation
  object{Foundation translate<-130,0, 60>}
  object{Foundation translate<-130,0,-60>}
  object{Foundation translate< 130,0, 60>}
  object{Foundation translate< 130,0,-60>}
  //Skewbacks
  object{Skewback translate<-130,0,-60>}
  object{Skewback translate<-130,0, 60>}
  object{Skewback rotate <0,180,0> translate< 130,0,-60>}
  object{Skewback rotate <0,180,0> translate< 130,0, 60>}

  //Bottom 12ft tubes
  cylinder{<-130,   6,  60>,< 130,   6,  60>, 6}
  cylinder{<-130,   6, -60>,< 130,   6, -60>, 6}
  //Bottom rectangular girder (straight)
  union {
    #declare Count=6;
      #while (Count < 60)
        object{Girder_1 translate<-130,6, Count>}
        object{Girder_1 translate<-130,6,-Count>}
        object{Girder_1 translate< 130,6, Count>}
        object{Girder_1 translate< 130,6,-Count>}
      #declare Count=Count+12;
    #end
  }
  //Erect 12ft tubes
  cylinder{<-130,   0,  60>,<-130, 308,  15>, 6}
  cylinder{<-130,   0, -60>,<-130, 308, -15>, 6}
  cylinder{< 130,   0,  60>,< 130, 308,  15>, 6}
  cylinder{< 130,   0, -60>,< 130, 308, -15>, 6}
  //Crossed 8ft tubes
  cylinder{<-130,   0, -60>,< 130, 308, -15>, 4}
  cylinder{< 130,   0, -60>,<-130, 308, -15>, 4}
  cylinder{<-130,   0,  60>,< 130, 308,  15>, 4}
  cylinder{< 130,   0,  60>,<-130, 308,  15>, 4}
    
  //Crossed Girders between Erect Tubes
  union {
    #declare Count=16;
      #while (Count < 156)
        object{Girder_2 translate <0,0,Count> rotate <-132,0,0> translate<-130,-4, 64>}
        object{Girder_2 translate <0,0,Count> rotate < -48,0,0> translate<-130,-4,-64>}
        object{Girder_2 translate <0,0,Count> rotate <-132,0,0> translate<   0,-4, 64>}
        object{Girder_2 translate <0,0,Count> rotate < -48,0,0> translate<   0,-4,-64>}
        object{Girder_2 translate <0,0,Count> rotate <-132,0,0> translate< 130,-4, 64>}
        object{Girder_2 translate <0,0,Count> rotate < -48,0,0> translate< 130,-4,-64>}
      #declare Count=Count+8;
    #end
  }
  
  //Crossed Girders between Erect Tubes
  union {
    #declare Count=40;
      #while (Count < 140)
        object{Girder_2 translate <0,0,Count> rotate <-132,0,0> translate<-130,90, 64.5>}
        object{Girder_2 translate <0,0,Count> rotate < -48,0,0> translate<-130,90,-64.5>}
        object{Girder_2 translate <0,0,Count> rotate <-132,0,0> translate< 130,90, 64.5>}
        object{Girder_2 translate <0,0,Count> rotate < -48,0,0> translate< 130,90,-64.5>}
      #declare Count=Count+8;
    #end
  }

  //Crossed Girders between Erect Tubes
  union {
    #declare Count=52;
      #while (Count < 130)
        object{Girder_2 translate <0,0,Count> rotate <-132,0,0> translate<-130,160.25, 64>}
        object{Girder_2 translate <0,0,Count> rotate < -48,0,0> translate<-130,160.25,-64>}
        object{Girder_2 translate <0,0,Count> rotate <-132,0,0> translate< 130,160.25, 64>}
        object{Girder_2 translate <0,0,Count> rotate < -48,0,0> translate< 130,160.25,-64>}
      #declare Count=Count+8;
    #end
  }
  
  //Crossed Girders between Erect Tubes
  union {
    #declare Count=68;
      #while (Count < 122)
        object{Girder_2 translate <0,0,Count> rotate <-132,0,0> translate<-130,212.25, 64>}
        object{Girder_2 translate <0,0,Count> rotate < -48,0,0> translate<-130,212.25,-64>}
        object{Girder_2 translate <0,0,Count> rotate <-132,0,0> translate< 130,212.25, 64>}
        object{Girder_2 translate <0,0,Count> rotate < -48,0,0> translate< 130,212.25,-64>}
      #declare Count=Count+8;
    #end
  }
  
  
  
  //Erect Girders
  union {
    #declare Count=12;
      #while (Count < 150)
        object{Girder_1 translate <0,0,Count> rotate< 98.313,0,0> translate< 0, 154, -37.5>}
        object{Girder_1 translate <0,0,Count> rotate<-81.687,0,0> translate< 0, 154, -37.5>}
        object{Girder_1 translate <0,0,Count> rotate< 81.687,0,0> translate< 0, 154,  37.5>}
        object{Girder_1 translate <0,0,Count> rotate<-98.313,0,0> translate< 0, 154,  37.5>}
      #declare Count=Count+12;
    #end
  }
  //Middle tilted Girders
  union {
    #declare Count=12;
      #while (Count < 126)
        object{Girder_1 translate <0,0,Count> rotate<0, 90,0> rotate<-81.687,0,0> translate< 0, 154,-37.5>}
        object{Girder_1 translate <0,0,Count> rotate<0,-90,0> rotate<-81.687,0,0> translate< 0, 154,-37.5>}
        object{Girder_1 translate <0,0,Count> rotate<0, 90,0> rotate<-98.313,0,0> translate< 0, 154, 37.5>}
        object{Girder_1 translate <0,0,Count> rotate<0,-90,0> rotate<-98.313,0,0> translate< 0, 154, 37.5>}
      #declare Count=Count+12;
    #end
  }
  // Middle crossed Girders  
  union {
    #declare Count=12;
      #while (Count < 150)
        object{Girder_1 translate <0,0,Count> rotate<0, 121,0> translate< 0, 154, 40>}
        object{Girder_1 translate <0,0,Count> rotate<0,-121,0> translate< 0, 154, 40>}
        object{Girder_1 translate <0,0,Count> rotate<0,  59,0> translate< 0, 154,-40>}
        object{Girder_1 translate <0,0,Count> rotate<0, -59,0> translate< 0, 154,-40>}
      #declare Count=Count+12;
    #end
  }

  // Bottom crossed Girders  
  union {
    #declare Count=12;
      #while (Count < 172)
        object{Girder_1 translate <0,0,Count> rotate<0, 134,0> translate< 0, 6, 62.5>}
        object{Girder_1 translate <0,0,Count> rotate<0,-134,0> translate< 0, 6, 62.5>}
        object{Girder_1 translate <0,0,Count> rotate<0,  46,0> translate< 0, 6,-62.5>}
        object{Girder_1 translate <0,0,Count> rotate<0, -46,0> translate< 0, 6,-62.5>}
      #declare Count=Count+12;
    #end
  }
  
  //Top Girder
  box{<-136,303, 9>,<-120,315, 21>}
  box{<-136,303,-9>,<-120,315,-21>}
  box{< 136,303, 9>,< 120,315, 21>}
  box{< 136,303,-9>,< 120,315,-21>}
  
  union {
    #declare Count=6;
      #while (Count < 240)
        object{Top_Girder rotate<0,90,0> translate<-120+Count,309, 15>}
        object{Top_Girder rotate<0,90,0> translate<-120+Count,309,-15>}
      #declare Count=Count+12;
    #end
  }
  
  object{Girder_3 translate<-130,309, -6>}  
  object{Girder_3 translate<-130,309,  0>}  
  object{Girder_3 translate<-130,309,  6>}  
  
  box{<-12, 303,-21>,<12, 315,-9>}
  object{Girder_3 translate<0,309, -6>}  
  object{Girder_3 translate<0,309,  0>}  
  object{Girder_3 translate<0,309,  6>}  
  box{<-12, 303, 21>,<12, 315, 9>}
  
  object{Girder_3 translate< 130,309, -6>}  
  object{Girder_3 translate< 130,309,  0>}  
  object{Girder_3 translate< 130,309,  6>}  
  
 
  object{Tower_Viaduct_Support translate<-130,0,0>}
  object{Tower_Viaduct_Support}
  object{Tower_Viaduct_Support translate< 130,0,0>}

  union {
    #declare Count=5;
      #while (Count < 135)
        object{Internal_Viaduct translate<-Count,0, 0>}
        object{Internal_Viaduct translate< Count,0, 0>}
      #declare Count=Count+10;
    #end
  }
  
  
  texture{pigment{Bridge_Color} finish{phong 0.25}}
}
