// Approach viaducts and suspended span
#include "colors.inc"

#include "Forth_01.inc"

#declare Track =
union{
 
  // Railings etc.
  box{<-6,119.5, 11.5>,<6,121  , 11  > texture{pigment{Bridge_Color} finish{phong 0.25}}}
  box{<-6,119  ,-11.5>,<6,119.5, 11.5> texture{pigment{Bridge_Color} finish{phong 0.25}}}
  box{<-6,119.5,-11.5>,<6,121  ,-11  > texture{pigment{Bridge_Color} finish{phong 0.25}}}
  
  cylinder{<-6,125,-11.5>,< 6,125,-11.5>, 0.125 texture{pigment{Bridge_Color} finish{phong 0.25}}}
  cylinder{<-6,125, 11.5>,< 6,125, 11.5>, 0.125 texture{pigment{Bridge_Color} finish{phong 0.25}}}

  cylinder{<-6,123,-11.5>,< 6,123,-11.5>, 0.100 texture{pigment{Bridge_Color} finish{phong 0.25}}}
  cylinder{<-6,123, 11.5>,< 6,123, 11.5>, 0.100 texture{pigment{Bridge_Color} finish{phong 0.25}}}
    
  cylinder{<-4,119,-11.5>,<-4,125,-11.5>, 0.125 texture{pigment{Bridge_Color} finish{phong 0.25}}}
  cylinder{< 0,119,-11.5>,< 0,125,-11.5>, 0.125 texture{pigment{Bridge_Color} finish{phong 0.25}}}
  cylinder{< 4,119,-11.5>,< 4,125,-11.5>, 0.125 texture{pigment{Bridge_Color} finish{phong 0.25}}}
  
  cylinder{<-4,119, 11.5>,<-4,125, 11.5>, 0.125 texture{pigment{Bridge_Color} finish{phong 0.25}}}
  cylinder{< 0,119, 11.5>,< 0,125, 11.5>, 0.125 texture{pigment{Bridge_Color} finish{phong 0.25}}}
  cylinder{< 4,119, 11.5>,< 4,125, 11.5>, 0.125 texture{pigment{Bridge_Color} finish{phong 0.25}}}
  
  box{<-6,117,-5.25>,<6,119,-5.75> texture{pigment{Bridge_Color} finish{phong 0.25}}}
  box{<-6,117, 5.25>,<6,119, 5.75> texture{pigment{Bridge_Color} finish{phong 0.25}}}

  cylinder{<-4,119,-11.5>,<-4,117,-5.5>, 0.125 texture{pigment{Bridge_Color} finish{phong 0.25}}}
  cylinder{< 0,119,-11.5>,< 0,117,-5.5>, 0.125 texture{pigment{Bridge_Color} finish{phong 0.25}}}
  cylinder{< 4,119,-11.5>,< 4,117,-5.5>, 0.125 texture{pigment{Bridge_Color} finish{phong 0.25}}}

  cylinder{<-4,119, 11.5>,<-4,117, 5.5>, 0.125 texture{pigment{Bridge_Color} finish{phong 0.25}}}
  cylinder{< 0,119, 11.5>,< 0,117, 5.5>, 0.125 texture{pigment{Bridge_Color} finish{phong 0.25}}}
  cylinder{< 4,119, 11.5>,< 4,117, 5.5>, 0.125 texture{pigment{Bridge_Color} finish{phong 0.25}}}
  
  triangle{< 4.125,119,-11.5>,< 4.125,119,-5.5>,< 4.125,117,-5.5> texture{pigment{Bridge_Color} finish{phong 0.25}}}
  triangle{< 3.875,119,-11.5>,< 3.875,119,-5.5>,< 3.875,117,-5.5> texture{pigment{Bridge_Color} finish{phong 0.25}}}
  
  triangle{< 0.125,119,-11.5>,< 0.125,119,-5.5>,< 0.125,117,-5.5> texture{pigment{Bridge_Color} finish{phong 0.25}}}
  triangle{<-0.125,119,-11.5>,<-0.125,119,-5.5>,<-0.125,117,-5.5> texture{pigment{Bridge_Color} finish{phong 0.25}}}
  
  triangle{<-4.125,119,-11.5>,<-4.125,119,-5.5>,<-4.125,117,-5.5> texture{pigment{Bridge_Color} finish{phong 0.25}}}
  triangle{<-3.875,119,-11.5>,<-3.875,119,-5.5>,<-3.875,117,-5.5> texture{pigment{Bridge_Color} finish{phong 0.25}}}

  triangle{< 4.125,119, 11.5>,< 4.125,119, 5.5>,< 4.125,117, 5.5> texture{pigment{Bridge_Color} finish{phong 0.25}}}
  triangle{< 3.875,119, 11.5>,< 3.875,119, 5.5>,< 3.875,117, 5.5> texture{pigment{Bridge_Color} finish{phong 0.25}}}
  
  triangle{< 0.125,119, 11.5>,< 0.125,119, 5.5>,< 0.125,117, 5.5> texture{pigment{Bridge_Color} finish{phong 0.25}}}
  triangle{<-0.125,119, 11.5>,<-0.125,119, 5.5>,<-0.125,117, 5.5> texture{pigment{Bridge_Color} finish{phong 0.25}}}
  
  triangle{<-4.125,119, 11.5>,<-4.125,119, 5.5>,<-4.125,117, 5.5> texture{pigment{Bridge_Color} finish{phong 0.25}}}
  triangle{<-3.875,119, 11.5>,<-3.875,119, 5.5>,<-3.875,117, 5.5> texture{pigment{Bridge_Color} finish{phong 0.25}}}
}

#declare Approach_Viaduct_Girder=
union{
  union{ 
    box{<-12.2, -1.0,-0.25>,< 12.2, 1.0, 0.25>}
    box{< -1.0,-12.2,-0.25>,<  1.0,12.2, 0.25>}
    rotate<0,0,45>
  }
  cylinder{<0,0,0>,<0,10,0>, 0.5}
  sphere{<0,0,0>, 0.5}
  texture{pigment{Bridge_Color} finish{phong 0.25}}
}

#declare Approach_Viaduct_Bottom_Girder=
union{
  #declare Count=0;
    #while (Count < 8)
      object{Girder_4 scale<0.5,0.5,0.5> translate<0,0, Count>}
      object{Girder_4 scale<0.5,0.5,0.5> translate<0,0,-Count>}
      object{Girder_4 scale<0.5,0.5,0.5> rotate<0,90,0> translate< Count,0, 0>}
      object{Girder_4 scale<0.5,0.5,0.5> rotate<0,90,0> translate<-Count,0, 0>}
    #declare Count=Count+2;
  #end
  
}

#declare Approach_Viaduct_Section =
union {
  box{<-83.9,99,-4.25>,< 83.9,101,-5.75> texture{pigment{Bridge_Color} finish{phong 0.25}}}
  box{<-83.9,99, 4.25>,< 83.9,101, 5.75> texture{pigment{Bridge_Color} finish{phong 0.25}}}
  
  box{<-83.9,99,-5.25>,<-82,99.5, 5.25> texture{pigment{Bridge_Color} finish{phong 0.25}}}
  box{< 83.9,99,-5.25>,< 82,99.5, 5.25> texture{pigment{Bridge_Color} finish{phong 0.25}}}

  box{<-83.9,117,-5.25>,<-82,101,-5.75> texture{pigment{Bridge_Color} finish{phong 0.25}}}
  box{<-83.9,117, 5.25>,<-82,101, 5.75> texture{pigment{Bridge_Color} finish{phong 0.25}}}
  box{< 83.9,117,-5.25>,< 82,101,-5.75> texture{pigment{Bridge_Color} finish{phong 0.25}}}
  box{< 83.9,117, 5.25>,< 82,101, 5.75> texture{pigment{Bridge_Color} finish{phong 0.25}}}
  union {
    #declare Count=10.5;
      #while (Count < 78)
        object{Approach_Viaduct_Girder translate< Count,109,-5.5>}
        object{Approach_Viaduct_Girder translate<-Count,109,-5.5>}
        object{Approach_Viaduct_Girder translate< Count,109, 5.5>}
        object{Approach_Viaduct_Girder translate<-Count,109, 5.5>}
      #declare Count=Count+21;
    #end
  }

  union {
    #declare Count=0;
      #while (Count < 78)
        object{Approach_Viaduct_Bottom_Girder rotate<0,45,0> translate< Count,100,0>}
        object{Approach_Viaduct_Bottom_Girder rotate<0,45,0> translate<-Count,100,0>}
      #declare Count=Count+11;
    #end
  }
}

#declare Suspended_Span =
union{
  // Bottom
  box{<-175,118.5,-16.5>,<175,121.5,-13.5>}
  box{<-175,118.5, 16.5>,<175,121.5, 13.5>}
 
  cylinder{< 132,119,-15>,< 175,119, 15>, 0.5}
  cylinder{< 132,119, 15>,< 175,119,-15>, 0.5}
  cylinder{<  88,119,-15>,< 132,119, 15>, 0.5}
  cylinder{<  88,119, 15>,< 132,119,-15>, 0.5}
  cylinder{<  44,119,-15>,<  88,119, 15>, 0.5}
  cylinder{<  44,119, 15>,<  88,119,-15>, 0.5}
  cylinder{<   0,119,-15>,<  44,119, 15>, 0.5}
  cylinder{<   0,119, 15>,<  44,119,-15>, 0.5}
  cylinder{<   0,119,-15>,< -44,119, 15>, 0.5}
  cylinder{<   0,119, 15>,< -44,119,-15>, 0.5}
  cylinder{< -44,119,-15>,< -88,119, 15>, 0.5}
  cylinder{< -44,119, 15>,< -88,119,-15>, 0.5}
  cylinder{< -88,119,-15>,<-132,119, 15>, 0.5}
  cylinder{< -88,119, 15>,<-132,119,-15>, 0.5}
  cylinder{<-132,119,-15>,<-175,119, 15>, 0.5}
  cylinder{<-132,119, 15>,<-175,119,-15>, 0.5}
  
  // Top
  sphere{<-175,154.5, 11.5>, 1.5}
  sphere{<-175,154.5,-11.5>, 1.5}
  sphere{<-132,161.5, 11.5>, 1.5}
  sphere{<-132,161.5,-11.5>, 1.5}
  sphere{< -88,166.5, 11.5>, 1.5}
  sphere{< -88,166.5,-11.5>, 1.5}
  sphere{< -44,169.5, 11.5>, 1.5}
  sphere{< -44,169.5,-11.5>, 1.5}
  sphere{<   0,170.5, 11.5>, 1.5}
  sphere{<   0,170.5,-11.5>, 1.5}
  
  union{
    #declare Count=0.9;
      #while (Count < 41)
        object{Sp_Girder translate <0,Count, 0> rotate< 36, 0, 139> translate< 0,170.5,-11.5>}
        object{Sp_Girder translate <0,Count, 0> rotate<-36, 0, 139> translate< 0,170.5, 11.5>}
        object{Sp_Girder translate <0,Count, 0> rotate< 36, 0,-139> translate< 0,170.5,-11.5>}
        object{Sp_Girder translate <0,Count, 0> rotate<-36, 0,-139> translate< 0,170.5, 11.5>}
      #declare Count=Count+1.8;
    #end
  }

  union{
    #declare Count=0.9;
      #while (Count < 41)
        object{Sp_Girder translate <0,Count, 0> rotate< 36, 0, 138.5> translate<-44,169.5,-11.5>}
        object{Sp_Girder translate <0,Count, 0> rotate<-36, 0, 138.5> translate<-44,169.5, 11.5>}
        object{Sp_Girder translate <0,Count, 0> rotate< 36, 0,-138.5> translate< 44,169.5,-11.5>}
        object{Sp_Girder translate <0,Count, 0> rotate<-36, 0,-138.5> translate< 44,169.5, 11.5>}
      #declare Count=Count+1.8;
    #end
  }
  
  union{
    #declare Count=0.9;
      #while (Count < 41)
        object{Sp_Girder translate <0,Count, 0> rotate< 36, 0, 137> translate<-88,166.5,-11.5>}
        object{Sp_Girder translate <0,Count, 0> rotate<-36, 0, 137> translate<-88,166.5, 11.5>}
        object{Sp_Girder translate <0,Count, 0> rotate< 36, 0,-137> translate< 88,166.5,-11.5>}
        object{Sp_Girder translate <0,Count, 0> rotate<-36, 0,-137> translate< 88,166.5, 11.5>}
      #declare Count=Count+1.8;
    #end
  }
  
  union{
    #declare Count=0.9;
      #while (Count < 41)
        object{Sp_Girder translate <0,Count, 0> rotate< 36, 0, 134> translate<-132,161.5,-11.5>}
        object{Sp_Girder translate <0,Count, 0> rotate<-36, 0, 134> translate<-132,161.5, 11.5>}
        object{Sp_Girder translate <0,Count, 0> rotate< 36, 0,-134> translate< 132,161.5,-11.5>}
        object{Sp_Girder translate <0,Count, 0> rotate<-36, 0,-134> translate< 132,161.5, 11.5>}
      #declare Count=Count+1.8;
    #end
  }
  
  
  sphere{<  44,169.5, 11.5>, 1.5}
  sphere{<  44,169.5,-11.5>, 1.5}
  sphere{<  88,166.5, 11.5>, 1.5}
  sphere{<  88,166.5,-11.5>, 1.5}
  sphere{< 132,161.5, 11.5>, 1.5}
  sphere{< 132,161.5,-11.5>, 1.5}
  sphere{< 175,154.5, 11.5>, 1.5}
  sphere{< 175,154.5,-11.5>, 1.5}
  
  cylinder{<-175,154.5,11.5>,<-132,161.5,11.5>,1.5}
  cylinder{<-132,161.5,11.5>,< -88,166.5,11.5>,1.5}
  cylinder{< -88,166.5,11.5>,< -44,169.5,11.5>,1.5}
  cylinder{< -44,169.5,11.5>,<   0,170.5,11.5>,1.5}
  
  cylinder{< 175,154.5,11.5>,< 132,161.5,11.5>,1.5}
  cylinder{< 132,161.5,11.5>,<  88,166.5,11.5>,1.5}
  cylinder{<  88,166.5,11.5>,<  44,169.5,11.5>,1.5}
  cylinder{<  44,169.5,11.5>,<   0,170.5,11.5>,1.5}

  cylinder{<-175,154.5,-11.5>,<-132,161.5,-11.5>,1.5}
  cylinder{<-132,161.5,-11.5>,< -88,166.5,-11.5>,1.5}
  cylinder{< -88,166.5,-11.5>,< -44,169.5,-11.5>,1.5}
  cylinder{< -44,169.5,-11.5>,<   0,170.5,-11.5>,1.5}

  cylinder{< 175,154.5,-11.5>,< 132,161.5,-11.5>,1.5}
  cylinder{< 132,161.5,-11.5>,<  88,166.5,-11.5>,1.5}
  cylinder{<  88,166.5,-11.5>,<  44,169.5,-11.5>,1.5}
  cylinder{<  44,169.5,-11.5>,<   0,170.5,-11.5>,1.5}

  cylinder{< 132,161.5,-11.5>,< 175,154.5, 11.5>, 1}
  cylinder{< 132,161.5, 11.5>,< 175,154.5,-11.5>, 1}
  cylinder{<  88,166.5,-11.5>,< 132,161.5, 11.5>, 1}
  cylinder{<  88,166.5, 11.5>,< 132,161.5,-11.5>, 1}
  cylinder{<  44,169.5,-11.5>,<  88,166.5, 11.5>, 1}
  cylinder{<  44,169.5, 11.5>,<  88,166.5,-11.5>, 1}
  cylinder{<   0,170.5,-11.5>,<  44,169.5, 11.5>, 1}
  cylinder{<   0,170.5, 11.5>,<  44,169.5,-11.5>, 1}
  cylinder{<   0,170.5,-11.5>,< -44,169.5, 11.5>, 1}
  cylinder{<   0,170.5, 11.5>,< -44,169.5,-11.5>, 1}
  cylinder{< -44,169.5,-11.5>,< -88,166.5, 11.5>, 1}
  cylinder{< -44,169.5, 11.5>,< -88,166.5,-11.5>, 1}
  cylinder{< -88,166.5,-11.5>,<-132,161.5, 11.5>, 1}
  cylinder{< -88,166.5, 11.5>,<-132,161.5,-11.5>, 1}
  cylinder{<-132,161.5,-11.5>,<-175,154.5, 11.5>, 1}
  cylinder{<-132,161.5, 11.5>,<-175,154.5,-11.5>, 1}
  
  //Sides
  cylinder{<-173.5,120,-15>,<-173.5,154.5,-11.5>,1.5}
  cylinder{<-173.5,120, 15>,<-173.5,154.5, 11.5>,1.5}
  cylinder{< 173.5,120,-15>,< 173.5,154.5,-11.5>,1.5}
  cylinder{< 173.5,120, 15>,< 173.5,154.5, 11.5>,1.5}

  cylinder{<-132,120  ,-15  >,<-175,154.5,-11.5>,1}
  cylinder{< -88,120  ,-15  >,<-132,161.5,-11.5>,1}
  cylinder{< -44,120  ,-15  >,< -88,166.5,-11.5>,1}
  cylinder{<   0,120  ,-15  >,< -44,169.5,-11.5>,1}
  cylinder{<-132,161.5,-11.5>,<-175,120  ,-15  >,1}
  cylinder{< -88,166.5,-11.5>,<-132,120  ,-15  >,1}
  cylinder{< -44,169.5,-11.5>,< -88,120  ,-15  >,1}
  cylinder{<   0,170.5,-11.5>,< -44,120  ,-15  >,1}

  cylinder{< 132,120  ,-15  >,< 175,154.5,-11.5>,1}
  cylinder{<  88,120  ,-15  >,< 132,161.5,-11.5>,1}
  cylinder{<  44,120  ,-15  >,<  88,166.5,-11.5>,1}
  cylinder{<   0,120  ,-15  >,<  44,169.5,-11.5>,1}
  cylinder{< 132,161.5,-11.5>,< 175,120  ,-15  >,1}
  cylinder{<  88,166.5,-11.5>,< 132,120  ,-15  >,1}
  cylinder{<  44,169.5,-11.5>,<  88,120  ,-15  >,1}
  cylinder{<   0,170.5,-11.5>,<  44,120  ,-15  >,1}
  
  cylinder{<-132,120  , 15  >,<-175,154.5, 11.5>,1}
  cylinder{< -88,120  , 15  >,<-132,161.5, 11.5>,1}
  cylinder{< -44,120  , 15  >,< -88,166.5, 11.5>,1}
  cylinder{<   0,120  , 15  >,< -44,169.5, 11.5>,1}
  cylinder{<-132,161.5, 11.5>,<-175,120  , 15  >,1}
  cylinder{< -88,166.5, 11.5>,<-132,120  , 15  >,1}
  cylinder{< -44,169.5, 11.5>,< -88,120  , 15  >,1}
  cylinder{<   0,170.5, 11.5>,< -44,120  , 15  >,1}

  cylinder{< 132,120  , 15  >,< 175,154.5, 11.5>,1}
  cylinder{<  88,120  , 15  >,< 132,161.5, 11.5>,1}
  cylinder{<  44,120  , 15  >,<  88,166.5, 11.5>,1}
  cylinder{<   0,120  , 15  >,<  44,169.5, 11.5>,1}
  cylinder{< 132,161.5, 11.5>,< 175,120  , 15  >,1}
  cylinder{<  88,166.5, 11.5>,< 132,120  , 15  >,1}
  cylinder{<  44,169.5, 11.5>,<  88,120  , 15  >,1}
  cylinder{<   0,170.5, 11.5>,<  44,120  , 15  >,1}
  
  cylinder{<-155.5,120,-15>,<-155.5,139,-13.25>, 0.5}
  cylinder{<-111  ,120,-15>,<-111  ,142,-13.25>, 0.5}
  cylinder{< -66.5,120,-15>,< -66.5,144,-13.25>, 0.5}
  cylinder{< -22  ,120,-15>,< -22  ,145,-13.25>, 0.5}
  
  cylinder{< 155.5,120,-15>,< 155.5,139,-13.25>, 0.5}
  cylinder{< 111  ,120,-15>,< 111  ,142,-13.25>, 0.5}
  cylinder{<  66.5,120,-15>,<  66.5,144,-13.25>, 0.5}
  cylinder{<  22  ,120,-15>,<  22  ,145,-13.25>, 0.5}
  
  cylinder{<-155.5,120, 15>,<-155.5,139, 13.25>, 0.5}
  cylinder{<-111  ,120, 15>,<-111  ,142, 13.25>, 0.5}
  cylinder{< -66.5,120, 15>,< -66.5,144, 13.25>, 0.5}
  cylinder{< -22  ,120, 15>,< -22  ,145, 13.25>, 0.5}
  
  cylinder{< 155.5,120, 15>,< 155.5,139, 13.25>, 0.5}
  cylinder{< 111  ,120, 15>,< 111  ,142, 13.25>, 0.5}
  cylinder{<  66.5,120, 15>,<  66.5,144, 13.25>, 0.5}
  cylinder{<  22  ,120, 15>,<  22  ,145, 13.25>, 0.5}
  texture{pigment{Bridge_Color} finish{phong 0.25}}
}
