// Persistence of Vision Ray Tracer Scene Description File
// File: .pov
// Vers: 3.1
// Desc: A small tanker 
// Note: 1 unit = 1 m (a scale statement at the end converts it into ft)
//       This file requires some local work but the image looks fine from a distance.
// Date: August 31. 1999
// Auth: Christian Radek, Ph.D.

#include "colors.inc"	// Standard Color definitions
#include "textures.inc"	// Standard Texture definitions
#include "metals.inc"

/*  
light_source { <-20.875,2.75,-6.125> color Green looks_like 
             { cylinder { <0,-0.15,0>, <0,0.15,0>, 0.1 
               texture { pigment {color Green} finish {Luminous}}}}}

light_source { <-20.875,2.75, 6.125> color Red looks_like 
             { cylinder { <0,-0.15,0>, <0,0.15,0>, 0.1  
               texture { pigment {color Red} finish {Luminous}}}}}

*/

//Ship Definitions

#declare Nuts_Bolts=
union{
 prism{
   linear_sweep
   linear_spline
   1.60,1.65,7,
   <3,5>, <-3,5>, <-5,0>, <-3,-5>, <3, -5>, <5,0>, <3,5>
   scale<0.01,1,0.01>
 }
 cylinder{<0,1.55,0>,<0,1.85,0>, 0.02}
 prism{
   linear_sweep
   linear_spline
   1.75,1.80,7,
   <3,5>, <-3,5>, <-5,0>, <-3,-5>, <3, -5>, <5,0>, <3,5>
   scale<0.01,1,0.01>
 }
 pigment{color Black}
}

/* 
#declare Tonk=
union{
  difference{
    box{<-5, 0,-2>,<5,1,2>}
    box{<-4.9,-1,-1.9>,<4.9,2,1.9>}
    texture{pigment{color White}}
  }
  sphere{<-2.9,-0.5,0>,2}
  cylinder{<-2.9,-0.5,0>,<2.9,-0.5,0>,2}
  sphere{< 2.9,-0.5,0>,2}
  
  cylinder{<-2.5,1,0>,<-2.5,1.65,0>,0.4}
  cylinder{<-2.5,1.65,0>,<-2.5,1.69,0>,0.5}
  cylinder{<-2.5,1.69,0>,<-2.5,1.71,0>,0.4}
  cylinder{<-2.5,1.71,0>,<-2.5,1.75,0>,0.5}
  union{
    object{Nuts_Bolts translate<-0.45,0,0>}
    object{Nuts_Bolts translate<-0.45,0,0> rotate<0,30,0>}
    object{Nuts_Bolts translate<-0.45,0,0> rotate<0,60,0>}
    object{Nuts_Bolts translate<-0.45,0,0> rotate<0,90,0>}
    object{Nuts_Bolts translate<-0.45,0,0> rotate<0,120,0>}
    object{Nuts_Bolts translate<-0.45,0,0> rotate<0,150,0>}
    object{Nuts_Bolts translate<-0.45,0,0> rotate<0,180,0>}
    object{Nuts_Bolts translate<-0.45,0,0> rotate<0,210,0>}
    object{Nuts_Bolts translate<-0.45,0,0> rotate<0,240,0>}
    object{Nuts_Bolts translate<-0.45,0,0> rotate<0,270,0>}
    object{Nuts_Bolts translate<-0.45,0,0> rotate<0,300,0>}
    object{Nuts_Bolts translate<-0.45,0,0> rotate<0,330,0>}
    translate<-2.50,0,0>
  }
  
  cylinder{< 2.5,1,0>,< 2.5,1.65,0>,0.4}
  cylinder{< 2.5,1.65,0>,< 2.5,1.69,0>,0.5}
  cylinder{< 2.5,1.69,0>,< 2.5,1.71,0>,0.4}
  cylinder{< 2.5,1.71,0>,< 2.5,1.75,0>,0.5}
  union{
    object{Nuts_Bolts translate<-0.45,0,0>}
    object{Nuts_Bolts translate<-0.45,0,0> rotate<0,30,0>}
    object{Nuts_Bolts translate<-0.45,0,0> rotate<0,60,0>}
    object{Nuts_Bolts translate<-0.45,0,0> rotate<0,90,0>}
    object{Nuts_Bolts translate<-0.45,0,0> rotate<0,120,0>}
    object{Nuts_Bolts translate<-0.45,0,0> rotate<0,150,0>}
    object{Nuts_Bolts translate<-0.45,0,0> rotate<0,180,0>}
    object{Nuts_Bolts translate<-0.45,0,0> rotate<0,210,0>}
    object{Nuts_Bolts translate<-0.45,0,0> rotate<0,240,0>}
    object{Nuts_Bolts translate<-0.45,0,0> rotate<0,270,0>}
    object{Nuts_Bolts translate<-0.45,0,0> rotate<0,300,0>}
    object{Nuts_Bolts translate<-0.45,0,0> rotate<0,330,0>}
    translate< 2.50,0,0>
  }
  texture{T_Chrome_2A}
}
*/ 
 
#declare Valve1_closed=
union{
  cylinder{<0,-0.125>,<0,-0.100,0>, 0.1}
  cone{<0,-0.100>,0.1,<0,-0.050,0>, 0.12}
  cylinder{<0,-0.050>,<0, 0.050,0>, 0.12}
  cone{<0, 0.050>,0.1,<0, 0.100,0>, 0.12}
  cylinder{<0, 0.100>,<0, 0.125,0>, 0.1}
  cylinder{<0,0,0.125>,<0,0,-0.15>, 0.04}
  union{
    sphere{<0.06,0,-0.15>, 0.04}
    cylinder{<0.06,0,-0.15>,<-0.06,0,-0.15>, 0.04}
    sphere{<-0.06,0,-0.15>, 0.04}
    pigment{color Orange}
  }
  pigment{color Gray50} 
}
 
#declare Valve1_opened=
union{
  cylinder{<0,-0.125>,<0,-0.100,0>, 0.1}
  cone{<0,-0.100>,0.1,<0,-0.050,0>, 0.12}
  cylinder{<0,-0.050>,<0, 0.050,0>, 0.12}
  cone{<0, 0.050>,0.1,<0, 0.100,0>, 0.12}
  cylinder{<0, 0.100>,<0, 0.125,0>, 0.1}
  cylinder{<0,0,0.125>,<0,0,-0.15>, 0.04}
  union{
    sphere{<0,0.06,-0.15>, 0.04}
    cylinder{<0,0.06,-0.15>,<0,-0.06,-0.15>, 0.04}
    sphere{<0,-0.06,-0.15>, 0.04}
    pigment{color Orange}
  }
  pigment{color Gray50} 

}

#declare T1_90_deg=
difference{
  torus{0.25,0.08 rotate<0,0,90>}
  box{<1,0, 1>,<-1,-1,-1>}
  box{<1,1, 1>,<-1,-1, 0>}
}

#declare T3_90_deg=
difference{ 
  union{
    torus{0.25,0.08 rotate<0,0,90>}
    torus{0.50,0.08 rotate<0,0,90>}
    torus{0.75,0.08 rotate<0,0,90>}
  }
  box{<1,0, 1>,<-1,-1,-1>}
  box{<1,1, 1>,<-1,-1, 0>}
}

#declare T4_90_deg=
difference{ 
  union{
    torus{0.25,0.08 rotate<0,0,90> texture{pigment{color Red*0.66} finish {roughness 1/10}}}
    torus{0.50,0.08 rotate<0,0,90> texture{pigment{color Blue*0.66} finish {roughness 1/10}}}
    torus{0.75,0.08 rotate<0,0,90> texture{pigment{color Green*0.66} finish {roughness 1/10}}}
    torus{1.00,0.08 rotate<0,0,90> texture{pigment{color Green*0.33} finish {roughness 1/10}}}
  }
  box{<1.5,0, 1.5>,<-1.5,-1.5,-1.5>}
  box{<1.5,1.5, 1.5>,<-1.5,-1.5, 0>}
}

#declare Nozzle =
union{
  cylinder{<0,0,0>,<0,-0.02,0>,0.1}
  cone{<0,-0.02,0>,0.08,<0,-0.18,0>,0.24}
  cylinder{<0,-0.18,0>,<0,-0.20,0>,0.24}
  texture{pigment {color Gray50}}
}


#declare Pump=
union{
  cylinder{<0.5,0,-0.15>,<-0.5,0,-0.15>, 0.08}
  cylinder{<0,-1.0,0>,<0,0.25,0>,0.35}
  pigment{color Gray50}
}


#declare Green_Tubes=
union{
  //Tank
  cylinder{<-12.875,0.6, 3>,<-12.875,0.6,1.25>,0.08}
  object{T1_90_deg translate<-12.875,0.35,1.25>}
  cylinder{<-12.875,0.1, 1>,<-12.875,0.35, 1>, 0.08}
  cylinder{<-11.875,-0.90,1>,<15.75,-0.90,1>,0.08}

  cylinder{<-2.875,0.6, 3>,<-2.875,0.6,1>,0.08}
  object{T1_90_deg translate<-2.875,0.35,1>}
  cylinder{<-2.875,0.1, 0.75>,<-2.875,0.35, 0.75>, 0.08}
  cylinder{<-1.875,-0.90,0.75>,<15.75,-0.90,0.75>,0.08}

  cylinder{<7.125,0.6, 3>,<7.125,0.6,0.75>,0.08}
  object{T1_90_deg translate<7.125,0.35,0.75>}
  cylinder{<7.125,0.1, 0.5>,<7.125,0.35,0.5>, 0.08}
  cylinder{<8.125,-0.90,0.5>,<15.75,-0.90,0.5>,0.08}

  object{T3_90_deg rotate<0,0,-90> translate<15.75,-0.9,1.25>}

  cylinder{<16.00,-0.9,1.25>,<16.00,-0.9,2.00>,0.08}
  object{T1_90_deg rotate<90, 0,-90> translate<15.75,-0.9,2.00>}
  cylinder{<15.75,-0.9,2.25>,<15.50,-0.9,2.25>,0.08}
  object{T1_90_deg rotate<0, 90, 0> translate<15.50,-1.15,2.25>}
  cylinder{<15.25,-1.15, 2.25>,<15.25,-1.65,2.25>,0.08}
  object{T1_90_deg rotate<0, 90, 90> translate<15.50,-1.65,2.25>}
  object{Pump translate<16.00,-1.9,2.40>}
  object{T1_90_deg rotate<0,-90,-90> translate<16.50,-1.65,2.25>}
  cylinder{<16.75,-0.4, 2.25>,<16.75,-1.65,2.25>,0.08}
  
  cylinder{<16.25,-0.9,1.25>,<16.25,-0.9,3.00>,0.08}
  object{T1_90_deg rotate<90, 0,-90> translate<16.00,-0.9,3.00>}
  cylinder{<16.00,-0.9,3.25>,<15.50,-0.9,3.25>,0.08}
  object{T1_90_deg rotate<0, 90, 0> translate<15.50,-1.15,3.25>}
  cylinder{<15.25,-1.15, 3.25>,<15.25,-1.65,3.25>,0.08}
  object{T1_90_deg rotate<0, 90, 90> translate<15.50,-1.65,3.25>}
  object{Pump translate<16.00,-1.9,3.40>}
  object{T1_90_deg rotate<0,-90,-90> translate<16.50,-1.65,3.25>}
  cylinder{<16.75,-0.4, 3.25>,<16.75,-1.65,3.25>,0.08}
  
  cylinder{<16.50,-0.9,1.25>,<16.50,-0.9,4.00>,0.08}
  object{T1_90_deg rotate<90, 0,-90> translate<16.25,-0.9,4.00>}
  cylinder{<16.25,-0.9,4.25>,<15.50,-0.9,4.25>,0.08}
  object{T1_90_deg rotate<0, 90, 0> translate<15.50,-1.15,4.25>}
  cylinder{<15.25,-1.15, 4.25>,<15.25,-1.65,4.25>,0.08}
  object{T1_90_deg rotate<0, 90, 90> translate<15.50,-1.65,4.25>}
  object{Pump translate<16.00,-1.9,4.40>}
  object{T1_90_deg rotate<0,-90,-90> translate<16.50,-1.65,4.25>}
  cylinder{<16.75,-0.4, 4.25>,<16.75,-1.65,4.25>,0.08}
  //
  cylinder{<-12.875,0.6, -3>,<-12.875,0.6,-1.25>,0.08}
  object{T1_90_deg rotate<90,0,0> translate<-12.875,0.35,-1.25>}
  cylinder{<-12.875,0.1, -1>,<-12.875,0.35, -1>, 0.08}
  cylinder{<-11.875,-0.90,-1>,<15.75,-0.90,-1>,0.08}

  cylinder{<-2.875,0.6, -3>,<-2.875,0.6,-1>,0.08}
  object{T1_90_deg rotate<90,0,0> translate<-2.875,0.35,-1>}
  cylinder{<-2.875,0.1, -0.75>,<-2.875,0.35, -0.75>, 0.08}
  cylinder{<-1.875,-0.90,-0.75>,<15.75,-0.90,-0.75>,0.08}

  cylinder{<7.125,0.6, -3>,<7.125,0.6,-0.75>,0.08}
  object{T1_90_deg rotate<90,0,0> translate<7.125,0.35,-0.75>}
  cylinder{<7.125,0.1,-0.5>,<7.125,0.35,-0.5>, 0.08}
  cylinder{<8.125,-0.90,-0.5>,<15.75,-0.90,-0.5>,0.08}

  object{T3_90_deg rotate<90,0,-90> translate<15.75,-0.9,1.25>}






  texture{
    pigment{
      color Green*0.33
    } 
    finish {
      roughness 1/10
    }
  }
}

#declare Lightgreen_Tubes=
union{
  //Tank
  cylinder{<-12.625,0.6, 3>,<-12.625,0.6,1.25>,0.08}
  object{T1_90_deg translate<-12.625,0.35,1.25>}
  cylinder{<-12.625,0.1, 1>,<-12.625,0.35, 1>, 0.08}
  cylinder{<-11.875,-0.65,1>,<17.75,-0.65,1>,0.08}

  cylinder{<-2.625,0.6, 3>,<-2.625,0.6,1.00>,0.08}
  object{T1_90_deg translate<-2.625,0.35,1.00>}
  cylinder{<-2.625,0.1, 0.75>,<-2.625,0.35, 0.75>, 0.08}
  cylinder{<-1.875,-0.65,0.75>,<17.75,-0.65,0.75>,0.08}

  cylinder{<7.375,0.6, 3>,<7.375,0.6,0.75>,0.08}
  object{T1_90_deg translate<7.375,0.35,0.75>}
  cylinder{<7.375,0.1, 0.5>,<7.375,0.35,0.5>, 0.08}
  cylinder{<8.125,-0.65,0.5>,<17.75,-0.65,0.5>,0.08}

  object{T3_90_deg rotate<0,0,-90> translate<17.75,-0.65,1.25>}

  cylinder{<18.00,-0.65,1.25>,<18.00,-0.65,2.00>,0.08}
  object{T1_90_deg rotate<90, 0,-90> translate<17.75,-0.65,2.00>}
  cylinder{<17.75,-0.65,2.25>,<17.50,-0.65,2.25>,0.08}
  object{T1_90_deg rotate<0, 90, 0> translate<17.50,-0.9,2.25>}
  cylinder{<17.25,-0.9, 2.25>,<17.25,-1.65,2.25>,0.08}
  object{T1_90_deg rotate<0, 90, 90> translate<17.50,-1.65,2.25>}
  object{Pump translate<18.00,-1.9,2.40>}
  object{T1_90_deg rotate<0,-90,-90> translate<18.50,-1.65,2.25>}
  cylinder{<18.75,-0.4, 2.25>,<18.75,-1.65,2.25>,0.08}
  
  cylinder{<18.25,-0.65,1.25>,<18.25,-0.65,3.00>,0.08}
  object{T1_90_deg rotate<90, 0,-90> translate<18.00,-0.65,3.00>}
  cylinder{<18.00,-0.65,3.25>,<17.50,-0.65,3.25>,0.08}
  object{T1_90_deg rotate<0, 90, 0> translate<17.50,-0.9,3.25>}
  cylinder{<17.25,-0.9, 3.25>,<17.25,-1.65,3.25>,0.08}
  object{T1_90_deg rotate<0, 90, 90> translate<17.50,-1.65,3.25>}
  object{Pump translate<18.00,-1.9,3.40>}
  object{T1_90_deg rotate<0,-90,-90> translate<18.50,-1.65,3.25>}
  cylinder{<18.75,-0.4, 3.25>,<18.75,-1.65,3.25>,0.08}
  
  cylinder{<18.50,-0.65,1.25>,<18.50,-0.65,4.00>,0.08}
  object{T1_90_deg rotate<90, 0,-90> translate<18.25,-0.65,4.00>}
  cylinder{<18.25,-0.65,4.25>,<17.50,-0.65,4.25>,0.08}
  object{T1_90_deg rotate<0, 90, 0> translate<17.50,-0.9,4.25>}
  cylinder{<17.25,-0.9, 4.25>,<17.25,-1.65,4.25>,0.08}
  object{T1_90_deg rotate<0, 90, 90> translate<17.50,-1.65,4.25>}
  object{Pump translate<18.00,-1.9,4.40>}
  object{T1_90_deg rotate<0,-90,-90> translate<18.50,-1.65,4.25>}
  cylinder{<18.75,-0.4, 4.25>,<18.75,-1.65,4.25>,0.08}
  //
  cylinder{<-12.625,0.6,-3>,<-12.625,0.6,-1.25>,0.08}
  object{T1_90_deg rotate<90,0,0> translate<-12.625,0.35,-1.25>}
  cylinder{<-12.625,0.1, -1>,<-12.625,0.35, -1>, 0.08}
  cylinder{<-11.875,-0.65,-1>,<17.75,-0.65,-1>,0.08}

  cylinder{<-2.625,0.6, -3>,<-2.625,0.6,-1.00>,0.08}
  object{T1_90_deg rotate<90,0,0> translate<-2.625,0.35,-1.00>}
  cylinder{<-2.625,0.1, -0.75>,<-2.625,0.35, -0.75>, 0.08}
  cylinder{<-1.875,-0.65,-0.75>,<17.75,-0.65,-0.75>,0.08}

  cylinder{<7.375,0.6, -3>,<7.375,0.6,-0.75>,0.08}
  object{T1_90_deg rotate<90,0,0> translate<7.375,0.35,-0.75>}
  cylinder{<7.375,0.1, -0.5>,<7.375,0.35,-0.5>, 0.08}
  cylinder{<8.125,-0.65,-0.5>,<17.75,-0.65,-0.5>,0.08}

  object{T3_90_deg rotate<90,0,-90> translate<17.75,-0.65,-1.25>}




  
  
  texture{
    pigment{
      color Green*0.66
    } 
    finish {
      roughness 1/10
    }
  }
}
#declare Blue_Tubes=
union{
  //Tank
  cylinder{<7.625,0.6, 3>,<7.625,0.6,0.75>,0.08}
  object{T1_90_deg translate<7.625,0.35,0.75>}
  cylinder{<7.625,0.1, 0.5>,<7.625,0.35,0.5>, 0.08}
  object{Valve1_closed rotate<0,0,90> translate<8.50,-0.4,0.5>}
  cylinder{<8.125,-0.4,0.5>,<18.5,-0.4,0.5>,0.08}
  object{T1_90_deg rotate<0,-90,0> translate<18.5,-0.65,0.5>}
  cylinder{<18.75,-2.00,0.50>,<18.75,-0.65,0.50>,0.08}  
  cylinder{<-2.375,0.6, 3>,<-2.375,0.6,1.00>,0.08}
  object{T1_90_deg translate<-2.375,0.35,1.00>}
  cylinder{<-2.375,0.1, 0.75>,<-2.375,0.35, 0.75>, 0.08}
  object{Valve1_closed rotate<0,0,90> translate<-1.50,-0.4,0.75>}
  cylinder{<-1.875,-0.4,0.75>,<18.5,-0.4,0.75>,0.08}
  object{T1_90_deg rotate<0,-90,0> translate<18.5,-0.65,0.75>}
  cylinder{<18.75,-2.00,0.75>,<18.75,-0.65,0.75>,0.08}  
  cylinder{<-12.375,0.6, 3>,<-12.375,0.6,1.25>,0.08}
  object{T1_90_deg translate<-12.375,0.35,1.25>}
  cylinder{<-12.375,0.1, 1>,<-12.375,0.35, 1>, 0.08}
  object{Valve1_closed rotate<0,0,90> translate<-11.50,-0.4,1.00>}
  cylinder{<-11.875,-0.4,1>,<18.5,-0.4,1>,0.08}
  object{T1_90_deg rotate<0,-90,0> translate<18.5,-0.65,1.00>}
  cylinder{<18.75,-2.00,1.00>,<18.75,-0.65,1.00>,0.08}  
  
  object{T1_90_deg translate<18.75,-0.65,1.75>}
  cylinder{<18.75,-2.00,1.5>,<18.75,-0.65,1.5>,0.08}  
  object{T1_90_deg rotate<0,0,90> translate<17.00,-0.4,1.5>}
  cylinder{<17.00,-0.4,1.25>,<18.50,-0.4,1.25>,0.08}
  object{T1_90_deg rotate<0,-90,0> translate<18.5,-0.65,1.25>}
  cylinder{<18.75,-2.00,1.25>,<18.75,-0.65,1.25>,0.08}  
  //
  cylinder{<7.625,0.6,-3>,<7.625,0.6,-0.75>,0.08}
  object{T1_90_deg rotate<0,180,0> translate<7.625,0.35,-0.75>}
  cylinder{<7.625,0.1,-0.5>,<7.625,0.35,-0.5>, 0.08}
  object{Valve1_closed rotate<0,180,90> translate<8.50,-0.4,-0.5>}
  cylinder{<8.125,-0.4,-0.5>,<18.5,-0.4,-0.5>,0.08}
  object{T1_90_deg rotate<0,-90,0> translate<18.5,-0.65,-0.5>}
  cylinder{<18.75,-2.00,-0.50>,<18.75,-0.65,-0.50>,0.08}  
  cylinder{<-2.375,0.6,-3>,<-2.375,0.6,-1.00>,0.08}
  object{T1_90_deg rotate<0,180,0> translate<-2.375,0.35,-1.00>}
  cylinder{<-2.375,0.1,-0.75>,<-2.375,0.35, -0.75>, 0.08}
  object{Valve1_closed rotate<0,180,90> translate<-1.50,-0.4,-0.75>}
  cylinder{<-1.875,-0.4,-0.75>,<18.5,-0.4,-0.75>,0.08}
  object{T1_90_deg rotate<0,-90,0> translate<18.5,-0.65,-0.75>}
  cylinder{<18.75,-2.00,-0.75>,<18.75,-0.65,-0.75>,0.08}  
  cylinder{<-12.375,0.6, -3>,<-12.375,0.6,-1.25>,0.08}
  object{T1_90_deg rotate<0,180,0> translate<-12.375,0.35,-1.25>}
  cylinder{<-12.375,0.1, -1>,<-12.375,0.35, -1>, 0.08}
  object{Valve1_closed rotate<0,180,90> translate<-11.50,-0.4,-1.00>}
  cylinder{<-11.875,-0.4,-1>,<18.5,-0.4,-1>,0.08}
  object{T1_90_deg rotate<0,-90,0> translate<18.5,-0.65,-1.00>}
  cylinder{<18.75,-2.00,-1.00>,<18.75,-0.65,-1.00>,0.08}  
  
  object{T1_90_deg rotate<90,0,0> translate<18.75,-0.65,-1.75>}
  cylinder{<18.75,-2.00,-1.5>,<18.75,-0.65,-1.5>,0.08}  
  object{T1_90_deg rotate<90,0,90> translate<17.00,-0.4,-1.5>}
  cylinder{<17.00,-0.4,-1.25>,<18.50,-0.4,-1.25>,0.08}
  object{T1_90_deg rotate<0,-90,0> translate<18.5,-0.65,-1.25>}
  cylinder{<18.75,-2.00,-1.25>,<18.75,-0.65,-1.25>,0.08}  
  //
  object{Valve1_closed rotate<0,90,0> translate<18.75,-0.9,1.50>}
  object{Valve1_closed rotate<0,90,0> translate<18.75,-0.9,1.25>}
  object{Valve1_closed rotate<0,90,0> translate<18.75,-0.9,1.00>}
  object{Valve1_closed rotate<0,90,0> translate<18.75,-0.9,0.75>}
  object{Valve1_closed rotate<0,90,0> translate<18.75,-0.9,0.50>}

  object{Valve1_closed rotate<0,90,0> translate<18.75,-0.9,-1.50>}
  object{Valve1_closed rotate<0,90,0> translate<18.75,-0.9,-1.25>}
  object{Valve1_closed rotate<0,90,0> translate<18.75,-0.9,-1.00>}
  object{Valve1_closed rotate<0,90,0> translate<18.75,-0.9,-0.75>}
  object{Valve1_closed rotate<0,90,0> translate<18.75,-0.9,-0.50>}



  
  texture{
    pigment{
      color Blue*0.66
    } 
    finish {
      roughness 1/10
    }
  }
}

#declare Red_Tubes=
union{
  //Tank

  

  cylinder{<7.875,0.6, 3>,<7.875,0.6,0.75>,0.08}
  object{T1_90_deg translate<7.875,0.35,0.75>}
  cylinder{<7.875,0.1,0.50>,<7.875,0.35,0.50>, 0.08}
  cylinder{< 8.125,-0.15, 0.50>,<18.75,-0.15, 0.50>,0.08}
  object{T1_90_deg rotate<0,-90,0> translate<18.75,-0.4,0.50>}
  cylinder{<19,-2,0.50>,<19,-0.4,0.50>,0.08}

  cylinder{<-2.125,0.6, 3>,<-2.125,0.6,1.00>,0.08}
  object{T1_90_deg translate<-2.125,0.35,1.00>}
  cylinder{<-2.125,0.1, 0.75>,<-2.125,0.35, 0.75>, 0.08}
  cylinder{<-1.875,-0.15, 0.75>,<18.75,-0.15, 0.75>,0.08}
  object{T1_90_deg rotate<0,-90,0> translate<18.75,-0.4,0.75>}
  cylinder{<19,-2,0.75>,<19,-0.4,0.75>,0.08}
  
  cylinder{<-12.125,0.6, 3>,<-12.125,0.6,1.25>,0.08}
  object{T1_90_deg translate<-12.125,0.35,1.25>}
  cylinder{<-12.125,0.1, 1>,<-12.125,0.35, 1>, 0.08}
  cylinder{<-11.875,-0.15, 1.00>,<18.75,-0.15, 1.00>,0.08}
  object{T1_90_deg rotate<0,-90,0> translate<18.75,-0.4,1.00>}
  cylinder{<19,-2,1.00>,<19,-0.4,1.00>,0.08}
  //
  object{Nozzle translate<-15.35,1,3>}
  object{T1_90_deg rotate<0,180,0> translate<-15.35,1, 2.75>}
  cylinder{<-15.35,1.25, 1.5>,<-15.35,1.25, 2.75>,0.08}
  object{T1_90_deg translate<-15.35,1,1.5>}
  cylinder{<-15.35,0.1,1.25>,<-15.35,1,1.25>, 0.08}
  object{T1_90_deg rotate<0,90,90> translate<-15.10,0.1,1.25>}
  object{Nozzle translate<-9.55,1,3>}
  object{T1_90_deg rotate<0,180,0> translate<-9.55,1, 2.75>}
  cylinder{<-9.55,1.25, 1.5>,<-9.55,1.25, 2.75>,0.08}
  object{T1_90_deg translate<-9.55,1,1.5>}
  cylinder{<-9.55,-0.15,1.25>,<-9.55,1,1.25>, 0.08}
  cylinder{<-15.10,-0.15, 1.25>,<18.75,-0.15, 1.25>,0.08}
  object{T1_90_deg rotate<0,-90,0> translate<18.75,-0.4,1.25>}
  cylinder{<19,-2,1.25>,<19,-0.4,1.25>,0.08}
  //
  object{Nozzle translate<-5.35,1,3>}
  object{T1_90_deg rotate<0,180,0> translate<-5.35,1, 2.75>}
  cylinder{<-5.35,1.25, 1.75>,<-5.35,1.25, 2.75>,0.08}
  object{T1_90_deg translate<-5.35,1,1.75>}
  cylinder{<-5.35,0.1,1.5>,<-5.35,1,1.5>, 0.08}
  object{T1_90_deg rotate<0,90,90> translate<-5.10,0.1,1.5>}
  object{Nozzle translate<0.45,1,3>}
  object{T1_90_deg rotate<0,180,0> translate< 0.45,1, 2.75>}
  cylinder{<0.45,1.25, 1.75>,<0.45,1.25, 2.75>,0.08}
  object{T1_90_deg translate<0.45,1,1.75>}
  cylinder{<0.45,-0.15,1.5>,<0.45,1,1.5>, 0.08}
  cylinder{<-5.10,-0.15, 1.5>,<18.75,-0.15, 1.50>,0.08}
  object{T1_90_deg rotate<0,-90,0> translate<18.75,-0.4,1.50>}
  cylinder{<19,-2,1.5>,<19,-0.4,1.50>,0.08}
  //
  object{Nozzle translate<4.65,1,3>}
  object{T1_90_deg rotate<0,180,0> translate< 4.65,1, 2.75>}
  cylinder{<4.65,1.25, 2>,<4.65,1.25, 2.75>,0.08}
  object{T1_90_deg translate<4.65,1,2>}
  cylinder{<4.65,0.1,1.75>,<4.65,1,1.75>, 0.08}
  object{T1_90_deg rotate<0,90,90> translate<4.90,0.1,1.75>}
  object{Nozzle translate<10.45,1,3>}
  object{T1_90_deg rotate<0,180,0> translate<10.45,1, 2.75>}
  cylinder{<10.45,1.25, 2>,<10.45,1.25, 2.75>,0.08}
  object{T1_90_deg translate<10.45,1,2>}
  cylinder{<10.45,-0.15,1.75>,<10.45,1,1.75>, 0.08}
  cylinder{<4.90,-0.15, 1.75>,<18.75,-0.15, 1.75>,0.08}
  object{T1_90_deg rotate<0,-90,0> translate<18.75,-0.4,1.75>}
  cylinder{<19,-2,1.75>,<19,-0.4,1.75>,0.08}


  

  cylinder{<7.875,0.6,-3>,<7.875,0.6,-0.75>,0.08}
  object{T1_90_deg rotate<0,180,0> translate<7.875,0.35,-0.75>}
  cylinder{<7.875,0.1,-0.50>,<7.875,0.35,-0.50>, 0.08}
  cylinder{< 8.125,-0.15, -0.50>,<18.75,-0.15, -0.50>,0.08}
  object{T1_90_deg rotate<0,-90,0> translate<18.75,-0.4,-0.50>}
  cylinder{<19,-2,-0.50>,<19,-0.4,-0.50>,0.08}

  cylinder{<-2.125,0.6,-3>,<-2.125,0.6,-1.00>,0.08}
  object{T1_90_deg rotate<0,180,0> translate<-2.125,0.35,-1.00>}
  cylinder{<-2.125,0.1, -0.75>,<-2.125,0.35, -0.75>, 0.08}
  cylinder{<-1.875,-0.15, -0.75>,<18.75,-0.15, -0.75>,0.08}
  object{T1_90_deg rotate<0,-90,0> translate<18.75,-0.4,-0.75>}
  cylinder{<19,-2,-0.75>,<19,-0.4,-0.75>,0.08}
  
  cylinder{<-12.125,0.6, -3>,<-12.125,0.6,-1.25>,0.08}
  object{T1_90_deg rotate<0,180,0> translate<-12.125,0.35,-1.25>}
  cylinder{<-12.125,0.1, -1>,<-12.125,0.35, -1>, 0.08}
  cylinder{<-11.875,-0.15, -1.00>,<18.75,-0.15, -1.00>,0.08}
  object{T1_90_deg rotate<0,-90,0> translate<18.75,-0.4,-1.00>}
  cylinder{<19,-2,-1.00>,<19,-0.4,-1.00>,0.08}
  //
  object{Nozzle translate<-15.35,1,-3>}
  object{T1_90_deg translate<-15.35,1, -2.75>}
  cylinder{<-15.35,1.25, -1.5>,<-15.35,1.25, -2.75>,0.08}
  object{T1_90_deg rotate<0,180,0> translate<-15.35,1,-1.5>}
  cylinder{<-15.35,0.1,-1.25>,<-15.35,1,-1.25>, 0.08}
  object{T1_90_deg rotate<0,90,90> translate<-15.10,0.1,-1.25>}
  object{Nozzle translate<-9.55,1,-3>}
  object{T1_90_deg translate<-9.55,1, -2.75>}
  cylinder{<-9.55,1.25, -1.5>,<-9.55,1.25, -2.75>,0.08}
  object{T1_90_deg rotate<0,180,0> translate<-9.55,1,-1.5>}
  cylinder{<-9.55,-0.15,-1.25>,<-9.55,1,-1.25>, 0.08}
  cylinder{<-15.10,-0.15, -1.25>,<18.75,-0.15, -1.25>,0.08}
  object{T1_90_deg rotate<0,-90,0> translate<18.75,-0.4,-1.25>}
  cylinder{<19,-2,-1.25>,<19,-0.4,-1.25>,0.08}
  //
  object{Nozzle translate<-5.35,1,-3>}
  object{T1_90_deg translate<-5.35,1, -2.75>}
  cylinder{<-5.35,1.25, -1.75>,<-5.35,1.25, -2.75>,0.08}
  object{T1_90_deg rotate<0,180,0> translate<-5.35,1,-1.75>}
  cylinder{<-5.35,0.1,-1.5>,<-5.35,1,-1.5>, 0.08}
  object{T1_90_deg rotate<0,90,90> translate<-5.10,0.1,-1.5>}
  object{Nozzle translate<0.45,1,-3>}
  object{T1_90_deg translate< 0.45,1, -2.75>}
  cylinder{<0.45,1.25, -1.75>,<0.45,1.25, -2.75>,0.08}
  object{T1_90_deg rotate<0,180,0> translate<0.45,1,-1.75>}
  cylinder{<0.45,-0.15,-1.5>,<0.45,1,-1.5>, 0.08}
  cylinder{<-5.10,-0.15, -1.5>,<18.75,-0.15, -1.50>,0.08}
  object{T1_90_deg rotate<0,-90,0> translate<18.75,-0.4,-1.50>}
  cylinder{<19,-2,-1.5>,<19,-0.4,-1.50>,0.08}
  //
  object{Nozzle translate<4.65,1,-3>}
  object{T1_90_deg translate< 4.65,1, -2.75>}
  cylinder{<4.65,1.25, -2>,<4.65,1.25, -2.75>,0.08}
  object{T1_90_deg rotate<0,180,0> translate<4.65,1,-2>}
  cylinder{<4.65,0.1,-1.75>,<4.65,1,-1.75>, 0.08}
  object{T1_90_deg rotate<0,90,90> translate<4.90,0.1,-1.75>}
  object{Nozzle translate<10.45,1,-3>}
  object{T1_90_deg translate<10.45,1, -2.75>}
  cylinder{<10.45,1.25, -2>,<10.45,1.25, -2.75>,0.08}
  object{T1_90_deg rotate<0,180,0> translate<10.45,1,-2>}
  cylinder{<10.45,-0.15,-1.75>,<10.45,1,-1.75>, 0.08}
  cylinder{<4.90,-0.15, -1.75>,<18.75,-0.15, -1.75>,0.08}
  object{T1_90_deg rotate<0,-90,0> translate<18.75,-0.4,-1.75>}
  cylinder{<19,-2,-1.75>,<19,-0.4,-1.75>,0.08}
  //
  object{Valve1_opened rotate<0,-90,0> translate<19,-0.9,1.75>}
  object{Valve1_opened rotate<0,-90,0> translate<19,-0.9,1.50>}
  object{Valve1_opened rotate<0,-90,0> translate<19,-0.9,1.25>}
  object{Valve1_opened rotate<0,-90,0> translate<19,-0.9,1.00>}
  object{Valve1_opened rotate<0,-90,0> translate<19,-0.9,0.75>}
  object{Valve1_opened rotate<0,-90,0> translate<19,-0.9,0.50>}

  object{Valve1_opened rotate<0,-90,0> translate<19,-0.9,-1.75>}
  object{Valve1_opened rotate<0,-90,0> translate<19,-0.9,-1.50>}
  object{Valve1_opened rotate<0,-90,0> translate<19,-0.9,-1.25>}
  object{Valve1_opened rotate<0,-90,0> translate<19,-0.9,-1.00>}
  object{Valve1_opened rotate<0,-90,0> translate<19,-0.9,-0.75>}
  object{Valve1_opened rotate<0,-90,0> translate<19,-0.9,-0.50>}

  texture{
    pigment{
      color Red*0.66
    } 
    finish {
      roughness 1/10
    }
  }
}

#declare Gray_Tubes=
union{
  //Distribution
  object{T1_90_deg rotate<0, 90,0> translate<13,0.35,4.25>}
  cylinder{<12.75,-2, 4.25>,<12.75, 0.35,4.25>,0.08}
  object{T1_90_deg rotate<0,-90,0> translate<16.50,0.35,4.25>}
  cylinder{<16.75,-0.4, 4.25>,<16.75, 0.35,4.25>,0.08}
  cylinder{<13, 0.6, 4.25>,<18.50, 0.6, 4.25>,0.08}
  object{T1_90_deg rotate<0,-90,0> translate<18.50,0.35,4.25>}
  cylinder{<18.75,-0.4, 4.25>,<18.75, 0.35,4.25>,0.08}

  object{T1_90_deg rotate<0, 90,0> translate<13,0.35,3.25>}
  cylinder{<12.75,-2, 3.25>,<12.75, 0.35,3.25>,0.08}
  object{T1_90_deg rotate<0,-90,0> translate<16.50,0.35,3.25>}
  cylinder{<16.75,-0.4, 3.25>,<16.75, 0.35,3.25>,0.08}
  cylinder{<13, 0.6, 3.25>,<18.50, 0.6, 3.25>,0.08}
  object{T1_90_deg rotate<0,-90,0> translate<18.50,0.35,3.25>}
  cylinder{<18.75,-0.4, 3.25>,<18.75, 0.35,3.25>,0.08}

  object{T1_90_deg rotate<0, 90,0> translate<13,0.35,2.25>}
  cylinder{<12.75,-2, 2.25>,<12.75, 0.35,2.25>,0.08}
  object{T1_90_deg rotate<0,-90,0> translate<16.50,0.35,2.25>}
  cylinder{<16.75,-0.4, 2.25>,<16.75, 0.35,2.25>,0.08}
  cylinder{<13, 0.6, 2.25>,<18.50, 0.6, 2.25>,0.08}
  object{T1_90_deg rotate<0,-90,0> translate<18.50,0.35,2.25>}
  cylinder{<18.75,-0.4, 2.25>,<18.75, 0.35,2.25>,0.08}

  cylinder{<18.75,-0.4,1.75>,<18.75,-0.4,4.25>, 0.08}
  cylinder{<16.75,-0.4,1.50>,<16.75,-0.4,4.25>, 0.08}
  //
  object{T1_90_deg rotate<0, 90,0> translate<13,0.35,-4.25>}
  cylinder{<12.75,-2, -4.25>,<12.75, 0.35,-4.25>,0.08}
  object{T1_90_deg rotate<0,-90,0> translate<16.50,0.35,-4.25>}
  cylinder{<16.75,-0.4, -4.25>,<16.75, 0.35,-4.25>,0.08}
  cylinder{<13, 0.6, -4.25>,<18.50, 0.6,-4.25>,0.08}
  object{T1_90_deg rotate<0,-90,0> translate<18.50,0.35,-4.25>}
  cylinder{<18.75,-0.4, -4.25>,<18.75, 0.35,-4.25>,0.08}

  object{T1_90_deg rotate<0, 90,0> translate<13,0.35,-3.25>}
  cylinder{<12.75,-2, -3.25>,<12.75, 0.35,-3.25>,0.08}
  object{T1_90_deg rotate<0,-90,0> translate<16.50,0.35,-3.25>}
  cylinder{<16.75,-0.4, -3.25>,<16.75, 0.35,-3.25>,0.08}
  cylinder{<13, 0.6, -3.25>,<18.50, 0.6, -3.25>,0.08}
  object{T1_90_deg rotate<0,-90,0> translate<18.50,0.35,-3.25>}
  cylinder{<18.75,-0.4, -3.25>,<18.75, 0.35,-3.25>,0.08}

  object{T1_90_deg rotate<0, 90,0> translate<13,0.35,-2.25>}
  cylinder{<12.75,-2, -2.25>,<12.75, 0.35,-2.25>,0.08}
  object{T1_90_deg rotate<0,-90,0> translate<16.50,0.35,-2.25>}
  cylinder{<16.75,-0.4, -2.25>,<16.75, 0.35,-2.25>,0.08}
  cylinder{<13, 0.6, -2.25>,<18.50, 0.6, -2.25>,0.08}
  object{T1_90_deg rotate<0,-90,0> translate<18.50,0.35,-2.25>}
  cylinder{<18.75,-0.4, -2.25>,<18.75, 0.35,-2.25>,0.08}

  cylinder{<18.75,-0.4,-1.75>,<18.75,-0.4,-4.25>, 0.08}
  cylinder{<16.75,-0.4,-1.50>,<16.75,-0.4,-4.25>, 0.08}
    
  texture{
    pigment{
      color Gray60
    } 
    finish {
      roughness 1/10
    }
  }
}

#declare Wheel=
union{
  torus{0.15,0.015}
  cylinder{<0,0,-0.15>,<0,0,0.15>, 0.01 rotate<0, 45,0>}
  cylinder{<0,0,-0.15>,<0,0,0.15>, 0.01 rotate<0,-45,0>}
  cylinder{<0,0,-0.15>,<0,0.15,-0.15>, 0.015 rotate<0,45,0>}
  sphere{<0,0,0>,0.02}
  sphere{<0,0,-0.15>, 0.03 rotate<0,45,0>}
  sphere{<0,0.15,-0.15>, 0.03 rotate<0,45,0>}
  //no color given! 
}
#declare Anchorchain=
union{
  union{
    difference{
      torus{0.06,0.02}
      box{<-0.3,-0.1,0>,<0.3,0.1, 0.3>}
      translate<0,0,-0.06>
    }
    difference{
      torus{0.06,0.02}
      box{<-0.3,-0.1,0>,<0.3,0.1,-0.3>}
      translate<0,0,0.06>
    }
    cylinder{<-0.06,0,-0.06>,<-0.06,0,0.06>,0.02} 
    cylinder{<-0.06,0,0>,<0.06,0,0>,0.02}
    cylinder{< 0.06,0,-0.06>,< 0.06,0,0.06>,0.02} 
    translate<0,-0.08,0.1>
  }  
  union{
    difference{
      torus{0.06,0.02}
      box{<-0.3,-0.1,0>,<0.3,0.1, 0.3>}
      translate<0,0,-0.06>
    }
    difference{
      torus{0.06,0.02}
      box{<-0.3,-0.1,0>,<0.3,0.1,-0.3>}
      translate<0,0,0.06>
    }
    cylinder{<-0.06,0,-0.06>,<-0.06,0,0.06>,0.02} 
    cylinder{<-0.06,0,0>,<0.06,0,0>,0.02}
    cylinder{< 0.06,0,-0.06>,< 0.06,0,0.06>,0.02} 
    rotate<0,0,90> translate<0,-0.08,-0.1>
  }  
  
  texture{pigment {color Blue} finish{phong 1.0}}
}


#declare Winch=
union{
  box{< 1.15,0,-0.65>,<-1.15,0.05,0.35>}
  box{<-0.70,0.05,-0.3>,<-0.30,0.50,0.3>}
  cylinder{<-0.70,0.5,0>,<-0.30,0.5,0>,0.3}
  box{<-0.20,0.05,-0.3>,< 0.20,0.50,0.3>}
  cylinder{<-0.20,0.5,0>,< 0.20,0.5,0>,0.3}
  box{< 0.30,0.05,-0.3>,< 0.70,0.50,0.3>}
  cylinder{< 0.30,0.5,0>,< 0.70,0.5,0>,0.3}
  
  difference{
    cylinder{<-0.8 ,0.5,0>,<-1.0 ,0.5,0>, 0.25}
    torus{0.25,0.075 rotate<0,0,90> translate<-0.9,0.5,0>}
  }  
  cylinder{<-1.05,0.5,0>,< 1.05,0.5,0>, 0.1}
  difference{
    cylinder{< 0.8 ,0.5,0>,< 1.0 ,0.5,0>, 0.25}
    torus{0.25,0.075 rotate<0,0,90> translate< 0.9,0.5,0>}
  }
  
  cylinder{<-0.6,0,0.3>,<-0.6,0.85,0.3>, 0.025}
  cylinder{<-0.6,0,0.3>,<-0.6,0.65,0.3>, 0.05}
  object{Wheel translate<-0.6,0.85,0.3>}
  cylinder{<-0.1,0,0.3>,<-0.1,0.85,0.3>, 0.025}
  cylinder{<-0.1,0,0.3>,<-0.1,0.65,0.3>, 0.05}
  object{Wheel translate<-0.1,0.85,0.3>}
  cylinder{< 0.4,0,0.3>,< 0.4,0.85,0.3>, 0.025}
  cylinder{< 0.4,0,0.3>,< 0.4,0.65,0.3>, 0.05}
  object{Wheel translate< 0.4,0.85,0.3>}
  
  cylinder{<-0.4,0,0>,<-0.4,0.75,0.45>, 0.025}
  sphere{<-0.4,0.75,0.45>,0.04}
  cylinder{< 0.1,0,0>,< 0.1,0.75,0.45>, 0.025}
  sphere{< 0.1,0.75,0.45>,0.04}
  cylinder{< 0.6,0,0>,< 0.6,0.75,0.45>, 0.025}
  sphere{< 0.6,0.75,0.45>,0.04}

  box{<-0.65,0.05,-0.6>,<-0.70,0.65,0>}
  cylinder{<-1.0,0.15,-0.55>,<-1.0,0.55,-0.55>, 0.05}
  cylinder{<-0.8,0.15,-0.55>,<-0.8,0.55,-0.55>, 0.05}
  cylinder{<-1.0,0.15,-0.55>,<-0.8,0.15,-0.55>, 0.05}
  cylinder{<-1.0,0.55,-0.55>,<-0.8,0.55,-0.55>, 0.05}
  box{<-1.10,0.05,-0.5>,<-1.0,0.65,-0.6>}
  box{<-0.70,0.05,-0.5>,<-0.8,0.65,-0.6>}
  box{<-1.10,0.05,-0.5>,<-0.75,0.15,-0.6>}
  box{<-1.10,0.55,-0.5>,<-0.75,0.65,-0.6>}
  
  box{< 0.65,0.05,-0.6>,<0.70,0.65,0>}
  cylinder{< 1.0,0.15,-0.55>,< 1.0,0.55,-0.55>, 0.05}
  cylinder{< 0.8,0.15,-0.55>,< 0.8,0.55,-0.55>, 0.05}
  cylinder{< 1.0,0.15,-0.55>,< 0.8,0.15,-0.55>, 0.05}
  cylinder{< 1.0,0.55,-0.55>,< 0.8,0.55,-0.55>, 0.05}
  box{<1.10,0.05,-0.5>,<1.0,0.65,-0.6>}
  box{<0.70,0.05,-0.5>,<0.8,0.65,-0.6>}
  box{<1.10,0.05,-0.5>,<0.75,0.15,-0.6>}
  box{<1.10,0.55,-0.5>,<0.75,0.65,-0.6>}
   
  union{
    #declare Count=0;
      #while (Count < 2)
       object{Anchorchain translate<0,0,-Count>}
      #declare Count=Count+0.4;
    #end
  }
  torus{0.24,0.08 rotate<90,0,0> translate<0,0,-2.42> pigment{color Gray50}}
  translate <0,0,-1.5>
  texture{pigment {color Blue} finish{phong 1.0}}
}

#declare Tank=
union{
  sphere{<-2.95,0,0>,2}
  cylinder{<-2.95,0,0>,<2.95,0,0>,2}
  sphere{<2.95,0,0>,2}
  
  cylinder{<-1,1,0>,<-1,2.35,0>,0.5}
  box{<-1,1,-0.5>,<1,2.35,0.5>}
  cylinder{< 1,1,0>,< 1,2.35,0>,0.5}
  
  cylinder{<-1,2.25,0>,<-1,2.3,0>,0.7}
  box{<-1,2.25,-0.7>,<1,2.3,0.7>}
  cylinder{< 1,2.25,0>,< 1,2.3,0>,0.7}

  cylinder{<-1,2.35,0>,<-1,2.4,0>,0.7}
  box{<-1,2.35,-0.7>,<1,2.4,0.7>}
  cylinder{< 1,2.35,0>,< 1,2.4,0>,0.7}
  
  difference{
    union{
      sphere{<-1,2.4,0>,0.5}
      cylinder{<-1,2.4,0>,<1,2.4,0>,0.5}
      sphere{< 1,2.4,0>,0.5}
    }
    sphere{<-1,2.4,0>,0.49}
    cylinder{<-1,2.4,0>,<1,2.4,0>,0.49}
    sphere{< 1,2.4,0>,0.49}
    cylinder{<-0.3,2.6, 1>,<-0.3,2.6,-1>, 0.1}
    box{<-0.3,2.5,1>,<0.3,2.7,-1>}
    cylinder{< 0.3,2.6, 1>,< 0.3,2.6,-1>, 0.1}
    pigment{color White}    
  }
  //pigment{color Yellow}
  texture{T_Chrome_2A}
}




#declare Boat=
union{
  difference{
    union{
      sphere{<0,0,-1.5>,1}
      cylinder{<0,0,-1.5>,<0,0,1.5>,1}
      sphere{<0,0, 1.5>,1}
    }
    sphere{<0,0,-1.5>,0.9}
    cylinder{<0,0,-1.5>,<0,0,1.5>,0.9}
    sphere{<0,0, 1.5>,0.9}
    box{<-2,0,-8>,<2,2,8>}
  }
  box{<-0.9,-0.1,-1.4>,<0.9,-0.15,-1.6>}
  box{<-0.9,-0.1,-0.4>,<0.9,-0.15,-0.6>}
  box{<-0.9,-0.1, 0.4>,<0.9,-0.15, 0.6>}
  box{<-0.9,-0.1, 1.4>,<0.9,-0.15, 1.6>}
  
  
  texture{pigment{color White}}
}

#declare Clamp=
union{
  box{<-0.5,0   , 0.2>,< 0.5,0.05,-0.2>}
  cylinder{< 0.25,0.05,0>,< 0.25,0.5,0>, 0.15}
  cylinder{<-0.25,0.05,0>,<-0.25,0.5,0>, 0.15}
  cylinder{< 0.25,0.525,0>,< 0.25,0.5,0>, 0.2}
  cylinder{<-0.25,0.525,0>,<-0.25,0.5,0>, 0.2}
  pigment{color Black}
}

#declare Door_1=
union{
  box{<-0.4,-0.7,0>,<0.4,0.7,-0.10>}
  cylinder{<0.4, 0.6,-0.025>,<0.4, 0.2,-0.025>,0.05}
  cylinder{<0.4,-0.6,-0.025>,<0.4,-0.2,-0.025>,0.05}
  //Frame
  box{<-0.4,-0.8,0>,<0.4,0.8,-0.025>}
  box{<-0.5,-0.7,0>,<0.5,0.7,-0.025>}
  cylinder{<-0.4,-0.7,0>,<-0.4,-0.7,-0.025>,0.1}
  cylinder{<-0.4, 0.7,0>,<-0.4, 0.7,-0.025>,0.1}
  cylinder{< 0.4,-0.7,0>,< 0.4,-0.7,-0.025>,0.1}
  cylinder{< 0.4, 0.7,0>,< 0.4, 0.7,-0.025>,0.1}
  //Door handles
  cone{<-0.2,0.5,-0.10>,0.075,<-0.2,0.5,-0.20>,0.05}
  cylinder{<-0.18,0.5,-0.15>,<-0.18,0,-0.15>,0.03}
  sphere{<-0.18,0,-0.15>,0.03}
  
  cone{<-0.2,-0.2,-0.10>,0.075,<-0.2,-0.2,-0.20>,0.05}
  cylinder{<-0.18,-0.2,-0.15>,<-0.18,-0.7,-0.15>,0.03}
  sphere{<-0.18,-0.7,-0.15>,0.03}
  //no color given
}

#declare Fire_extinguisher=
union{
  //Body
  union{
    cylinder{<0,-0.3,0>,<0,0.3,0>, 0.15}
    sphere{<0,0.3,0>,0.15}
    cylinder{<0,0.45,0>,<0,0.5,0>,0.04}
    difference{
      cone{<0,0.3,0>,0.075,<0,0.65,0>,0.15}
      cone{<0,0.3,0>,0.07,<0,0.7,0>,0.145}
      cylinder{<-0.2,0.55,0>,<0.2,0.55,0>,0.075}
    }
    torus{0.1475,0.005 translate<0,0.65,0>}
    texture{pigment {color Red} finish{phong 1.0}}
  }
  cylinder{<0,-0.5,0>,<0,-0.3,0>,0.15 pigment{color Black}}
  //Nozzle
  union{
    cone{<0,0.5,0>,0.04,<0,0.6,0>,0.03}
    cylinder{<0,0.55,0>,<-0.225,0.55,0>,0.03}
    sphere{<-0.225,0.55,0>,0.03}
    cylinder{<-0.225,0.55,0>,<-0.225,-0.35,0>,0.03 pigment{color Black}}
        
    cone{<-0.225,-0.35,0>,0.03,<-0.225,-0.45,0>,0.075}
    cylinder{<-0.225,-0.45,0>,<-0.225,-0.55,0>,0.075}
    texture{T_Chrome_2A}
  }
  //Valve
  union{
    cylinder{<0,0.6,0>,<0,0.68,0>,0.02}
    cylinder{<0,0.65,0>,<0,0.67,0>,0.05}
    torus{0.05,0.02 translate<0,0.66,0>}
    
    texture{pigment {color Black} finish{phong 1.0}}
  }
}

#declare Hull=
union{
  difference{
    union{
      sphere{<-31,0,0>,4}
      cone{<-31.40,0,0>,3.98,<-15.60,0,0>,5.97}
      sphere{<-15,0,0>,6}
      cylinder{<-15,0,0>,<15,0,0>,6}
      sphere{< 15,0,0>,6}
      cone{< 31.40,0,0>,3.98,< 15.60,0,0>,5.97}
      sphere{< 31,0,0>,4}
    }
    box{<-40, 0,-10>,<15,10,10>}
    box{<-20,-2,-10>,<26.5,10,10>}
    //box{< 0,-1,-10>,<30,10,10>}
    box{< 0, 0,-10>,<40,10,10>}
    //Anchor Window
    cylinder{<0, 0,-1.5>,<0, 0,-10>,0.16 rotate<0,-30,0>  translate<31,0,0>}
    cylinder{<0, 0,-3.92>,<0, 0,-10>,0.24 rotate<0,-30,0>  translate<31,0,0>}
    cylinder{<0, 0,-1.5>,<0, 0,-10>,0.16 rotate<0,-150,0>  translate<31,0,0>}
    cylinder{<0, 0,-3.92>,<0, 0,-10>,0.24 rotate<0,-150,0>  translate<31,0,0>}
  }
  box{<-17.5,-2,-5>,<18.5,-1,-5.1>}
  box{<-17.5,-2, 5>,<18.5,-1, 5.1>}
  
  box{<-17.45,-2,-5.1>,<-17.55,-1, 5.1>}
  box{< -7.45,-2,-5.1>,< -7.55,-1, 5.1>}
  box{<  2.45,-2,-5.1>,<  2.55,-1, 5.1>}
  box{< 12.45,-2,-5.1>,< 12.55,-1, 5.1>}
  box{< 19.25,-2,-5.1>,< 19.30,-1, 5.1>}
   
  // Bridge etc.
  
  
  box{<-20.0,-0.25,-6.0>,<-23.0,0.0,6.0>}
  box{<-19.5, 2.25,-6.5>,<-23.0,2.5,6.5>}
  
  box{<-23.0,0.0, 6.0>,<-22.9,1.2, 3.0>}
  box{<-20.0,0.0, 6.0>,<-23.0,1.2, 5.9>}
  box{<-20.0,0.0,-6.0>,<-20.1,1.2, 6.0>}
  box{<-20.0,0.0,-6.0>,<-23.0,1.2,-5.9>}
  box{<-23.0,0.0,-6.0>,<-22.9,1.2,-3.0>}
  
  
  
  cylinder{<-22.95,1.2, 5.95>,<-22.95,1.2, 3>, 0.05}
  cylinder{<-20.05,1.2, 5.95>,<-22.95,1.2, 5.95>, 0.05}
  cylinder{<-20.05,1.2,-5.95>,<-20.05,1.2, 5.95>, 0.05}
  cylinder{<-20.05,1.2,-5.95>,<-22.95,1.2,-5.95>, 0.05}
  cylinder{<-22.95,1.2,-5.95>,<-22.95,1.2,-3>, 0.05}
  
  cylinder{<-22.95,2.25, 6.45>,<-22.95,2.25, 3.0 >, 0.05}
  cylinder{<-19.55,2.25, 6.45>,<-22.95,2.25, 6.45>, 0.05}
  cylinder{<-19.55,2.25,-6.45>,<-19.55,2.25, 6.45>, 0.05}
  cylinder{<-19.55,2.25,-6.45>,<-22.95,2.25,-6.45>, 0.05}
  cylinder{<-22.95,2.25,-6.45>,<-22.95,2.25,-3.0 >, 0.05}
  
  cylinder{<-22.95,1.2,-3.00>,<-22.95,2.25,-3.00>, 0.05}
  cylinder{<-22.95,1.2,-5.95>,<-22.95,2.25,-6.45>, 0.05}
  cylinder{<-21.50,1.2,-5.95>,<-21.50,2.25,-6.45>, 0.05}
  cylinder{<-20.05,1.2,-5.95>,<-19.55,2.25,-6.45>, 0.05}
    
  cylinder{<-20.05,1.2, 4.5>,<-19.55,2.25, 4.5>, 0.05}
  cylinder{<-20.05,1.2, 3.0>,<-19.55,2.25, 3.0>, 0.05}
  cylinder{<-20.05,1.2, 1.5>,<-19.55,2.25, 1.5>, 0.05}
  cylinder{<-20.05,1.2, 0.0>,<-19.55,2.25, 0.0>, 0.05}
  cylinder{<-20.05,1.2,-1.5>,<-19.55,2.25,-1.5>, 0.05}
  cylinder{<-20.05,1.2,-3.0>,<-19.55,2.25,-3.0>, 0.05}
  cylinder{<-20.05,1.2,-4.5>,<-19.55,2.25,-4.5>, 0.05}
    
  cylinder{<-20.05,1.2, 5.95>,<-19.55,2.25, 6.45>, 0.05}
  cylinder{<-21.50,1.2, 5.95>,<-21.50,2.25, 6.45>, 0.05}
  cylinder{<-22.95,1.2, 5.95>,<-22.95,2.25, 6.45>, 0.05}
  cylinder{<-22.95,1.2, 3.00>,<-22.95,2.25, 3.00>, 0.05}
  
  //Windows
  mesh{
    triangle{<-22.95,2.25,6.45>,<-22.95,2.25,3.0>,<-22.95,1.20,3.00>}
    triangle{<-22.95,1.20,5.95>,<-22.95,1.20,3.0>,<-22.95,2.25,6.45>}
    triangle{<-22.95,2.25,6.45>,<-22.95,1.20,5.95>,<-20.05,1.20,5.95>}
    triangle{<-19.55,2.25,6.45>,<-20.05,1.20,5.95>,<-22.95,2.25,6.45>}
    triangle{<-19.55,2.25,-6.45>,<-19.55,2.25,6.45>,<-20.05,1.2,5.95>}
    triangle{<-20.05,1.2,5.95>,<-20.05,1.2,-5.95>,<-19.55,2.25,-6.45>}
    triangle{<-22.95,2.25,-6.45>,<-22.95,1.20,-5.95>,<-20.05,1.20,-5.95>}
    triangle{<-19.55,2.25,-6.45>,<-20.05,1.20,-5.95>,<-22.95,2.25,-6.45>}
    triangle{<-22.95,2.25,-6.45>,<-22.95,2.25,-3.0>,<-22.95,1.20,-3.00>}
    triangle{<-22.95,1.20,-5.95>,<-22.95,1.20,-3.0>,<-22.95,2.25,-6.45>}
    texture{pigment{color Blue*0.1} finish{phong 1.0}}
  }
  
  //Lights
  cylinder{<-21.15,2.75, 6.25>,<-21.1,2.75,6.25>, 0.25}
  box{<-21.15,2.50, 6.50>,<-21.1,2.75,5.85>}
  box{<-21.15,2.75, 6.25>,<-21.1,3.00,5.85>}
  cylinder{<-19.75,2.75,5.85>,<-19.75,2.75,5.9>, 0.25}
  box{<-21.1,2.50, 5.9>,<-19.5,2.75,5.85>}
  box{<-21.1,2.75, 5.9>,<-19.75,3.00,5.85>}

  union {
    cylinder{<-21.00,2.75,6.25>,<-21.1,2.75,6.25>, 0.25}
    box{<-21,2.50,6.50>,<-21.1,2.75,5.9>}
    box{<-21,2.75,6.25>,<-21.1,3.00,5.9>}
    cylinder{<-19.75,2.75,6.00>,<-19.75,2.75,5.9>, 0.25}
    box{<-21.1,2.50,6.0>,<-19.5,2.75,5.9>}
    box{<-21.1,2.75,6.0>,<-19.75,3.00,5.9>}

    cylinder{<-20.875,2.5, 6.125>,<-20.875,2.6, 6.125>, 0.125}
    cylinder{<-20.875,2.9, 6.125>,<-20.875,3.0, 6.125>, 0.125}
    box{<-21.00,2.5, 6.125>,<-20.875,2.6, 6>}
    box{<-20.875,2.5, 6.125>,<-20.75,2.6, 6>}
    box{<-21.00,2.9, 6.250>,<-20.875,3.0, 6>}
    box{<-20.875,2.9, 6.125>,<-20.75,3.0, 6>}

    pigment {color Red*0.5}
  }
    
  cylinder{<-21.15,2.75,-6.25>,<-21.1,2.75,-6.25>, 0.25}
  box{<-21.15,2.50,-6.50>,<-21.1,2.75,-5.85>}
  box{<-21.15,2.75,-6.25>,<-21.1,3.00,-5.85>}
  cylinder{<-19.75,2.75,-5.85>,<-19.75,2.75,-5.9>, 0.25}
  box{<-21.1,2.50,-5.9>,<-19.5,2.75,-5.85>}
  box{<-21.1,2.75,-5.9>,<-19.75,3.00,-5.85>}

  union{
    cylinder{<-21.00,2.75,-6.25>,<-21.1,2.75,-6.25>, 0.25}
    box{<-21,2.50,-6.50>,<-21.1,2.75,-5.9>}
    box{<-21,2.75,-6.25>,<-21.1,3.00,-5.9>}
    cylinder{<-19.75,2.75,-6.00>,<-19.75,2.75,-5.9>, 0.25}
    box{<-21.1,2.50,-6.0>,<-19.5,2.75,-5.9>}
    box{<-21.1,2.75,-6.0>,<-19.75,3.00,-5.9>}
      
    cylinder{<-20.875,2.5,-6.125>,<-20.875,2.6,-6.125>, 0.125}
    cylinder{<-20.875,2.9,-6.125>,<-20.875,3.0,-6.125>, 0.125}
    box{<-21.00,2.5,-6.125>,<-20.875,2.6,-6>}
    box{<-20.875,2.5,-6.125>,<-20.75,2.6,-6>}
    box{<-21.00,2.9,-6.250>,<-20.875,3.0,-6>}
    box{<-20.875,2.9,-6.125>,<-20.75,3.0,-6>}

    pigment{color Green*0.5}
  }

  box{<-23,0,-3>,<-30,2.5,3>}

  cylinder{<-34.5,0,-1>,<-34.5,0.4,-1>,0.05} sphere{<-34.5,0.4,-1>,0.05}
  cylinder{<-34.5,0, 1>,<-34.5,0.4, 1>,0.05} sphere{<-34.5,0.4, 1>,0.05}
  cylinder{<-33  ,0,-1>,<-33,0.4,-1>,0.05} sphere{<-33  ,0.4,-1>,0.05}
  cylinder{<-33  ,0, 1>,<-33,0.4, 1>,0.05} sphere{<-33  ,0.4, 1>,0.05}
  //Funnel
  cone{<-25,2.5,0>,1,<-25,3.5,0>,0.75}
  cone{<-27,2.5,0>,1,<-27,3.5,0>,0.75}
  triangle{<-25,2.5,1>,<-25,3.5,0.75>,<-27,2.5,1>}
  triangle{<-27,2.5,1>,<-27,3.5,0.75>,<-25,3.5,0.75>}
  triangle{<-25,2.5,-1>,<-25,3.5,-0.75>,<-27,2.5,-1>}
  triangle{<-27,2.5,-1>,<-27,3.5,-0.75>,<-25,3.5,-0.75>}
  
  cylinder{<-27,3.5,0>,<-27,3.6,0>,0.75}
  box{<-27,3.5,0.75>,<-20,3.6,-0.75>}
  
  cylinder{<-25,3.5,0>,<-25,3.8,0>, 0.5 pigment {color Black}}
  cylinder{<-27,3.5,0>,<-27,3.8,0>, 0.5 pigment {color Black}}
  
  
  //Mast
  cylinder{<-22.5,3.5,-0.65>,<-21,7.5,-0.35>,0.1 pigment{color White} finish{phong 1.0}}
  sphere{<-22.5,3.5,-0.65>,0.1 pigment{color White} finish{phong 1.0}}
  cylinder{<-22.5,2.5,-0.65>,<-22.5,3.5, -0.65>,0.1 pigment{color White} finish{phong 1.0}}
  cylinder{<-20  ,2.5, 0   >,<-20,7.5,0>,0.15 pigment{color White} finish{phong 1.0}}
  sphere{<-20,7.5,0,>,0.15 pigment{color White} finish{phong 1.0}}
  //Radio
  cylinder{<-19.84  ,7.5, 0   >,<-19.84,10.0,0>,0.015 pigment{color White} finish{phong 1.0}}
  sphere{<-19.84,10,0,>,0.025 pigment{color White} finish{phong 1.0}}
  // End
  cylinder{<-22.5,3.5, 0.65>,<-21,7.5, 0.35>,0.1 pigment{color White} finish{phong 1.0}}
  sphere{<-22.5,3.5, 0.65>,0.1 pigment{color White} finish{phong 1.0}}
  cylinder{<-22.5,2.5, 0.65>,<-22.5,3.5, 0.65>,0.1 pigment{color White} finish{phong 1.0}}
  box{<-20,7.5,0.5>,<-21.5,7.6,-0.5> pigment{color White} finish{phong 1.0}}
  box{<-21,7.6,0.25>,<-21.5,8.1,-0.25> pigment{color White} finish{phong 1.0}}
  cylinder{<-21.25,8.0,0>,<-21.25,8.2,0>, 0.05 pigment{color White} finish{phong 1.0}}  
  box{<-21.2,8.15,1.2>,<-21.3,8.35,-1.2> pigment{color White} finish{phong 1.0}}
  
  cylinder{<-20,7.5,-1.5>,<-20,7.5,1.5>,0.075 pigment{color White} finish{phong 1.0}}
  cylinder{<-20,3.5,-1.5>,<-20,3.5,1.5>,0.075 pigment{color White} finish{phong 1.0}}
  
  union{
  cylinder{<-20,3.5,-1.25>,<-20,7.5,-1.25>,0.01}
  cylinder{<-20,3.5,-1.00>,<-20,7.5,-1.00>,0.01}
  cylinder{<-20,3.5,-0.75>,<-20,7.5,-0.75>,0.01}
  cylinder{<-20,3.5,-0.50>,<-20,7.5,-0.50>,0.01}
  cylinder{<-20,3.5, 0.50>,<-20,7.5, 0.50>,0.01}
  cylinder{<-20,3.5, 0.75>,<-20,7.5, 0.75>,0.01}
  cylinder{<-20,3.5, 1.00>,<-20,7.5, 1.00>,0.01}
  cylinder{<-20,3.5, 1.25>,<-20,7.5, 1.25>,0.01}
  pigment{color White} finish{phong 1.0}
  }
  
  
  
  cylinder{<30.6,3.95,0>,<30.6,4,0>,0.2}
  cylinder{<30.6,3.5,0>,<30.6,3.55,0>,0.2}
  cylinder{<30.5,0,0>,<30.5,4,0>,0.1}
  cylinder{<29.5,-1,-1>,<30.5,3,0>,0.05}
  cylinder{<29.5,-1, 1>,<30.5,3,0>,0.05}
  //Doors
  object{Door_1 rotate<0,90,0> translate<26.5,-1,-2>}
  object{Door_1 rotate<0,90,0> translate<26.5,-1, 2>}
  object{Door_1 rotate<0,-90,0> translate<-20.0,-1,-2>}
  object{Door_1 rotate<0,-90,0> translate<-20.0,-1, 2>}
  object{Door_1 rotate<0,-90,0> translate<-20.0,-1,-4>}
  object{Door_1 rotate<0,-90,0> translate<-20.0,-1, 4>}
  
  union{
    object{Door_1}
    box{<-0.4,-0.8,0.5>,<0.4,0.8,-0.025>}
    box{<-0.5,-0.7,0.5>,<0.5,0.7,-0.025>}
    cylinder{<-0.4,-0.7,0.5>,<-0.4,-0.7,-0.025>,0.1}
    cylinder{<-0.4, 0.7,0.5>,<-0.4, 0.7,-0.025>,0.1}
    cylinder{< 0.4,-0.7,0.5>,< 0.4,-0.7,-0.025>,0.1}
    cylinder{< 0.4, 0.7,0.5>,< 0.4, 0.7,-0.025>,0.1}
    rotate<0,90,0> rotate<0,0,-90> translate<28.5, 0.5, -2>
  }
  union{
    object{Door_1}
    box{<-0.4,-0.8,0.5>,<0.4,0.8,-0.025>}
    box{<-0.5,-0.7,0.5>,<0.5,0.7,-0.025>}
    cylinder{<-0.4,-0.7,0.5>,<-0.4,-0.7,-0.025>,0.1}
    cylinder{<-0.4, 0.7,0.5>,<-0.4, 0.7,-0.025>,0.1}
    cylinder{< 0.4,-0.7,0.5>,< 0.4,-0.7,-0.025>,0.1}
    cylinder{< 0.4, 0.7,0.5>,< 0.4, 0.7,-0.025>,0.1}
    rotate<0,-90,0> rotate<0,0,90> translate<28.5, 0.5, 2>
  }
  //Air Inlets
  cylinder{<28.5,0, 3.25>,<28.5,1, 3.25>,0.25}
  difference{
    torus{0.5,0.25 rotate<90,0,0>}
    torus{0.5,0.24 rotate<90,0,0>}
    box{<1,0, 1>,<-1,-1,-1>}
    box{<1,1, 1>,< 0,-1,-1>}
    translate<29,1,3.25>
  }
  cylinder{<28.5,0,-3.25>,<28.5,1,-3.25>,0.25}
  difference{
    torus{0.5,0.25 rotate<90,0,0>}
    torus{0.5,0.24 rotate<90,0,0>}
    box{<1,0, 1>,<-1,-1,-1>}
    box{<1,1, 1>,< 0,-1,-1>}
    translate<29,1,-3.25>
  }
  
  difference{
    box{<18.625,-2,0.375>,<19.125,-1.25,1.875>}
    box{<18.640,-2,0.390>,<19.110, 0.00,1.860>}
  } 

  difference{
    box{<18.625,-2,-0.375>,<19.125,-1.25,-1.875>}
    box{<18.640,-2,-0.390>,<19.110, 0.00,-1.860>}
  } 
  
  
  //pigment{color White}
  
  texture {
    gradient y
      texture_map {
               
        [0.000 pigment{color rgb <0.8, 0.2, 0.25>}]
        [0.248 pigment{color rgb <0.8, 0.2, 0.25>}]    
        [0.249 pigment{color Black} finish{phong 1.0}]
        [0.250 pigment{color Black} finish{phong 1.0}]
        [0.259 pigment{color Black} finish{phong 1.0}]
        [0.260 pigment{color White} finish{phong 1.0}]
        [0.9   pigment{color White} finish{phong 1.0}]
      } 
      scale 12
      translate<0,-6,0>
    }
  
  }

#declare Ship =
union {
  object{Hull}
  object{Boat translate<-33.75,1.2,0>}
  object{Clamp rotate<0, 45,0> translate<-33.5,0,-2.5>}
  object{Clamp rotate<0,-45,0> translate<-33.5,0, 2.5>}

  object{Clamp translate<-25,0, 4.5>}
  object{Clamp translate<-15,-2, 5.375>}
  object{Clamp translate< 10,-2, 5.375>}
  object{Clamp translate<0,0, 3.5> rotate<0,  5,0> translate<31,0,0>}
  object{Clamp translate<0,0, 3.5> rotate<0, 55,0> translate<31,0,0>}

  object{Clamp translate<-25,0,-4.5>}
  object{Clamp translate<-15,-2,-5.375>}
  object{Clamp translate< 10,-2,-5.375>}
  object{Clamp translate<0,0,-3.5> rotate<0, -5,0> translate<31,0,0>}
  object{Clamp translate<0,0,-3.5> rotate<0,-55,0> translate<31,0,0>}
  object{Winch rotate<0,-30,0> translate<31,0, 0>}
  object{Winch rotate<0,210,0> translate<31,0, 0>}

  object{Tank translate<-12.5,-2,-3>}
  object{Tank translate< -2.5,-2,-3>}
  object{Tank translate<  7.5,-2,-3>}
  object{Tank translate<-12.5,-2, 3>}
  object{Tank translate< -2.5,-2, 3>}
  object{Tank translate<  7.5,-2, 3>}
  object{Green_Tubes}
  object{Lightgreen_Tubes}
  object{Blue_Tubes}
  object{Red_Tubes}
  object{Gray_Tubes}
  object{T4_90_deg rotate<-90,90,0> translate<-11.875,0.1,-1.0>}
  object{T4_90_deg rotate<-90,90,0> translate<-11.875,0.1, 1.0>}
  object{T4_90_deg rotate<-90,90,0> translate< -1.875,0.1,-0.75>}
  object{T4_90_deg rotate<-90,90,0> translate< -1.875,0.1, 0.75>}
  object{T4_90_deg rotate<-90,90,0> translate<  8.125,0.1,-0.5>}
  object{T4_90_deg rotate<-90,90,0> translate<  8.125,0.1, 0.5>}
  
  object{Fire_extinguisher translate<26.35,-1.5,-0.5>}
  object{Fire_extinguisher translate<26.35,-1.5,-0.8>}
  object{Fire_extinguisher translate<26.35,-1.5,-1.1>}
  object{Fire_extinguisher translate<26.35,-1.5, 0.5>}
  object{Fire_extinguisher translate<26.35,-1.5, 0.8>}
  object{Fire_extinguisher translate<26.35,-1.5, 1.1>}
  
  object{Fire_extinguisher rotate<0,80,0> translate<-19.85,-1.5,-0.5>}
  object{Fire_extinguisher rotate<0,80,0> translate<-19.85,-1.5,-0.8>}
  object{Fire_extinguisher rotate<0,80,0> translate<-19.85,-1.5,-1.1>}
  object{Fire_extinguisher rotate<0,80,0> translate<-19.85,-1.5, 0.5>}
  object{Fire_extinguisher rotate<0,80,0> translate<-19.85,-1.5, 0.8>}
  object{Fire_extinguisher rotate<0,80,0> translate<-19.85,-1.5, 1.1>}

  scale 3
}