// IRTC entry 4 - Landmarks
// David Morgan-Mar

#include "cameras.inc"
#include "shell.inc"
#include "halls.inc"
#include "podium.inc"

// development switches
#declare FillLights = 1;
#declare ShowConcertHall = 1;
#declare ShowOperaTheatre = 1;
#declare RotateHall = 1;
#declare ShowPodium = 1;
#declare Bubbles = 0;
#declare HollowShells = 1;
#declare Axis = 0;

global_settings {
//    max_trace_level 10
}

camera {
    CameraNW
    translate <0,10,-70>
}

sky_sphere {
    pigment { gradient y
        colour_map {
            [0.0 rgb <0.4, 0.6, 1> ]
            [0.5 rgb <1, 0.4, 0.1> ]
            [0.6 rgb <0.7, 0.5, 0.3> ]
            [0.8 rgb <0.05, 0.1, 0.4> ]
            [1.0 rgb <0.05, 0.1, 0.4> ]
        }
        scale 2
        translate -1
        turbulence 0.1
    }
    pigment { bozo
        colour_map {
            [0.0 rgbt <1, 1, 1, 1>]
            [0.7 rgbt <1, 1, 1, 1>]
            [0.8 rgbt <1, 1, 0.5, 0.3>]
            [1.0 rgbt <0.8, 0.6, 0.5, 0>]
        }
        scale <0.27, 0.07, 0.27>
        turbulence 0.7
        omega 0.7
    }
}

background { <0.3,0.7,1.0> }

#if (Axis)
// coordinate axis
cylinder { <0,0,0> <0,20,0> 1
    texture {
        pigment { rgb <1,0,0> }
        finish { ambient 1 }
    }
}
#end

#if (FillLights)
#declare Ball = sphere { <0,0,0> 1
    texture {
        pigment { rgb <1,0,0> }
        finish { ambient 1 }
    }
}
#declare Bright = 1;
light_source { <50,200,-200> rgb <Bright,0.6,0.5> }
light_source { <10,50, -100> rgb <Bright,0.7,0.7>
//    looks_like { Ball }
}
light_source { <10,-50, -100> rgb <Bright,0.7,0.8>
//    looks_like { Ball }
}
light_source { <-200,100, 200> rgb <Bright,0.6,0.7> }
light_source { <200,100, -100> rgb <Bright,0.8,0.8> }
#end // #if (FillLights)

#if (ShowConcertHall)
    // Concert Hall Shells
    #if (RotateHall)
        Hall(-HallAxis, 1, 10, 7, -80, HollowShells, Bubbles)
    #else
        Hall(0, 1, 10, 7, -80, HollowShells, Bubbles)
    #end
#end
#if (ShowOperaTheatre)
    // Opera Theatre Shells
    Hall(HallAxis, 0.8, -43, 7, -80, HollowShells, Bubbles)
#end // if (Shells)

#if (ShowPodium)
Podium(30,0,-80)
#end
// water
plane { y, 0
    texture {
        pigment { rgb <0.1,0.25,0.7> }
        normal { ripples 0.5
            scale 5
            turbulence 0.5
        }
        finish {
            reflection 0.7
        }
    }
}

