// podium.inc
// Sydney Opera House Podium

// steps
#declare StepHeight = 0.132;
#declare StepWidth = 0.369;
#declare LandingAB = 1.261;
#declare LandingBC = 1.090;
#declare LandingDE = 1.761;
#declare LandingEF = LandingBC;
#declare StepsA = 6;
#declare StepsB = 18;
#declare StepsC = 18;
#declare StepsABC = StepsA + StepsB + StepsC;
#declare StepsD = 8;
#declare StepsABCD = StepsABC + StepsD;
#declare StepsE = 7;
#declare StepsF = 15;
#declare StepsABCDEF = StepsA + StepsB + StepsC + StepsD + StepsE + StepsF;
#declare S_StairWidth = 80.01;
#declare SE_StairWidth = 7.01;
#declare E_StairWidth = 35.052;
#declare C_StairWidth = 11.1; // fix
#declare W_StairWidth = 3.2; // fix
#declare WR_StairWidth = 25.7; // fix
#declare SE_StairOffset = 27.6; // fix
#declare E_StairOffset = 47.6; // fix
#declare C_StairOffset = 37.7; // fix
#declare ER_StairOffset = 33.6; // fix
#declare WR_StairOffset = 3.2; // fix
#declare LR_StairOffset = 1.3; // fix
// podium
#declare P_Width = 88.696;
#declare P_Length = 137.95; // fix
#declare P_HeightABCDEF = StepsABCDEF * StepHeight;
#declare P_ModLength = P_Length - LandingAB - LandingBC;
#declare C_GapWidth = 12.192;
// hall steps
#declare Steps_CA = 18;
#declare Steps_CB = 31;
#declare Steps_CC = 15;
#declare Steps_OA = Steps_CA;
#declare Steps_OB = 23;
#declare Steps_OC = 9;
#declare H_StairOffset = 14.72;
#declare H_StairWidth = 30;
#declare HC_StairExtra = 42;
#declare HO_StairExtra = 35;
#declare HCA_StairOffset = 11.5;
#declare HOA_StairOffset = 9.2;
#declare HCB_StairOffset = 47.6;
#declare HOB_StairOffset = 52.6;
#declare HCC_StairOffset = 6.1;
#declare HOC_StairOffset = 5.5;
#declare HP_Height = (StepsABCDEF + Steps_CA) * StepHeight;
#declare HCP_Height = (StepsABCDEF + Steps_CA + Steps_CB) * StepHeight;
#declare HOP_Height = (StepsABCDEF + Steps_OA + Steps_OB) * StepHeight;
#declare C_StepRadius = 62.5;
#declare O_StepRadius = 34.0;
#declare C_RadiusX = -28.8;
#declare C_RadiusZ = 44.7;
#declare O_RadiusX = -70.4;
#declare O_RadiusZ = 18.7;
// hall axis alignment angle
#declare HallAxis = 11.25;
#declare SinHA2 = sin(radians(HallAxis *2));
#declare CosHA2 = cos(radians(HallAxis *2));

#macro Podium(X,Y,Z)
difference {
    // basic box shape
    box { <0,0,0> <-P_Width, P_HeightABCDEF, P_Length> }
    union {
    // subtract southern steps
    #local i = 0;
    #local ExtraLanding = 0;
    #while (i < StepsABCD)
        box { <1, i*StepHeight, P_Length - i*StepWidth - ExtraLanding>
              <-P_Width-1, P_HeightABCDEF + 1, P_Length+1> }
        #local i = i + 1;
        #if (i = StepsA)
            #local ExtraLanding = ExtraLanding + LandingAB;
        #end
        #if (i = StepsA+StepsB)
            #local ExtraLanding = ExtraLanding + LandingBC;
        #end
    #end
    // subtract south-eastern steps
    #local i = 0;
    #local ExtraLanding = 0;
    #while (i < StepsABC)
        box { <-S_StairWidth-1, i*StepHeight, P_Length - i*StepWidth - ExtraLanding - SE_StairOffset>
              <-P_Width-1, P_HeightABCDEF + 1, P_Length+1> }
        #local i = i + 1;
        #if (i = StepsA)
            #local ExtraLanding = ExtraLanding + LandingAB;
        #end
        #if (i = StepsA+StepsB)
            #local ExtraLanding = ExtraLanding + LandingBC;
        #end
    #end
    // subtract gap between south and south-eastern steps
    box { <-S_StairWidth, -1, P_Length - (StepsABC-1)*StepWidth - ExtraLanding - SE_StairOffset>
          <-P_Width + SE_StairWidth, P_HeightABCDEF+1, P_Length+1> }
    // subtract eastern steps
    #local i = StepsABC;
    #local ExtraLanding = 0;
    #while (i < StepsABCDEF)
        box { <-P_Width+E_StairWidth, i*StepHeight, P_Length - (i-StepsABC)*StepWidth - ExtraLanding - E_StairOffset>
              <-P_Width-1, P_HeightABCDEF + 1, P_ModLength - StepsABC*StepWidth> }
        #local i = i + 1;
        #if (i = StepsABCD + StepsE)
            #local ExtraLanding = ExtraLanding + LandingEF;
        #end
    #end
    // subtract gap between eastern and western steps
    box { <-P_Width + E_StairWidth + C_GapWidth, StepsABC*StepHeight, P_Length - (StepsABCDEF-StepsABC)*StepWidth - ExtraLanding - E_StairOffset>
          <-P_Width + E_StairWidth, P_HeightABCDEF+1, P_ModLength - StepsABC*StepWidth> }
    // subtract western steps
    #local i = StepsABCD;
    #local ExtraLanding = LandingDE;
    #while (i < StepsABCDEF)
        box { <1, i*StepHeight, P_Length - (i-StepsABC)*StepWidth - ExtraLanding - C_StairOffset>
              <-P_Width-1, P_HeightABCDEF + 1, P_ModLength> }
        #local i = i + 1;
        #if (i = StepsABCD + StepsE)
            #local ExtraLanding = ExtraLanding + LandingEF;
        #end
    #end
    // subtract restaurant steps
    #local i = StepsABC;
    #while (i < StepsABCD)
        // eastern
        box { <-ER_StairOffset + (i-StepsABC)*StepWidth, i*StepHeight, P_Length - (i-StepsABC)*StepWidth - C_StairOffset>
              <-P_Width + E_StairWidth + C_GapWidth, P_HeightABCDEF + 1, P_ModLength - (i)*StepWidth> }
        // western
        box { <-WR_StairOffset - (i-StepsABC)*StepWidth, i*StepHeight, P_Length - WR_StairWidth>
              <1, (i+1)*StepHeight+0.00001, P_ModLength - (i)*StepWidth> }
        // little western
        box { <-LR_StairOffset, i*StepHeight, P_Length - (i-StepsABC)*StepWidth - C_StairOffset - LandingDE>
              <1, (i+1)*StepHeight+0.00001, P_Length - WR_StairWidth> }
        #local i = i + 1;
    #end
    } // end union

    // texture
    texture {
        pigment { rgb <1,0.8,0.5> }
    }

    // move to final position
    translate <X,Y,Z>
}
// northern podium sections
union {
    // central hall steps
    #local i = 0;
    #while (i < Steps_CA)
        box { <0, P_HeightABCDEF, 0>
              <-P_Width, P_HeightABCDEF + (i+1)*StepHeight, H_StairOffset - i*StepWidth> }
        #local i = i + 1;
    #end

    // concert hall angled steps
    union {
        #local i = 0;
        #while (i < Steps_CA)
            box { <0, 0, 0>
                  <-H_StairWidth, P_HeightABCDEF + (i+1)*StepHeight, H_StairOffset - i*StepWidth> }
            #local i = i + 1;
        #end
        rotate <0,-HallAxis*2,0>
        translate <H_StairOffset*SinHA2,0,HCA_StairOffset>
    }

    // opera theatre angled steps
    union {
        #local i = 0;
        #while (i < Steps_CA)
            box { <0, 0, 0>
                  <-H_StairWidth, P_HeightABCDEF + (i+1)*StepHeight, H_StairOffset - i*StepWidth> }
            #local i = i + 1;
        #end
        rotate <0,HallAxis*2,0>
        translate <H_StairWidth*CosHA2 - P_Width - H_StairOffset*SinHA2,
                   0, HOA_StairOffset - H_StairWidth*SinHA2>
    }

    // concert hall northern steps
    difference {
        union {
            // concert hall straight steps
            union {
                #local i = 0;
                #while (i < Steps_CB)
                    box { <0, 0, -HC_StairExtra>
                          <-H_StairWidth, HP_Height + (i+1)*StepHeight, -i*StepWidth> }
                    #local i = i + 1;
                #end
                translate <H_StairOffset*SinHA2, 0, HCA_StairOffset>
            }
            // concert hall angled steps
            union {
                #local i = 0;
                #while (i < Steps_CB)
                    box { <0, 0, -HC_StairExtra>
                          <-H_StairWidth, HP_Height + (i+1)*StepHeight, -i*StepWidth> }
                    #local i = i + 1;
                #end
                rotate <0,-HallAxis*2,0>
                translate <H_StairWidth*CosHA2 - HCB_StairOffset, 0, H_StairWidth * SinHA2>
            }
        }
        // concert hall circular steps
        union {
            #local i = 0;
            #local Extra = 0;
            #while (i < Steps_CC)
                cylinder { <0,0,0> <0, HCP_Height+0.001 - i*StepHeight, 0> C_StepRadius + i*StepWidth + Extra }
                #local i = i + 1;
                #if (i = Steps_CC-1)
                    #local Extra = HCC_StairOffset;
                #end
            #end
            inverse
            translate <C_RadiusX,0,C_RadiusZ>
        }
    }

    // opera theatre northern steps
    difference {
        union {
            // opera theatre straight steps
            union {
                #local i = 0;
                #while (i < Steps_CB)
                    box { <0, 0, -HO_StairExtra>
                          <-H_StairWidth, HP_Height + (i+1)*StepHeight, -i*StepWidth> }
                    #local i = i + 1;
                #end
                translate <H_StairWidth - P_Width - H_StairOffset*SinHA2, 0, HOA_StairOffset>
            }
            // opera theatre angled steps
            union {
                #local i = 0;
                #while (i < Steps_CB)
                    box { <0, 0, -HO_StairExtra>
                          <-H_StairWidth, HP_Height + (i+1)*StepHeight, -i*StepWidth> }
                    #local i = i + 1;
                #end
                rotate <0,HallAxis*2,0>
                translate <-HOB_StairOffset, 0, 0>
            }
        }
        // opera theatre circular steps
        union {
            #local i = 0;
            #local Extra = 0;
            #while (i < Steps_OC)
                cylinder { <0,0,0> <0, HOP_Height+0.001 - i*StepHeight, 0> O_StepRadius + i*StepWidth + Extra }
                #local i = i + 1;
                #if (i = Steps_OC-1)
                    #local Extra = HOC_StairOffset;
                #end
            #end
            inverse
            translate <O_RadiusX,0,O_RadiusZ>
        }
    }

    // texture
    texture {
        pigment { rgb <1,0.8,0.5> }
    }

    // move to final position
    translate <X,Y,Z>
}
#end
