// shell.inc
// Defines geometrical shell macro for opera House shells

#declare SkinThickness = 2;

#declare ShellTexture =
texture {
    pigment { rgb <1,1,1> }
}

// shell macro
#macro Shell(XCentre, YCentre, ZCentre, R, Phi1, Theta1, Phi2, Theta2, Skin, Bubble)
#local PX1 = sin(radians(Phi1)) * cos(radians(Theta1));
#local PY1 = -sin(radians(Theta1));
#local PZ1 = -cos(radians(Phi1)) * cos(radians(Theta1));
#local PX2 = -sin(radians(Phi2)) * cos(radians(Theta2));
#local PY2 = sin(radians(Theta2));
#local PZ2 = cos(radians(Phi2)) * cos(radians(Theta2));
// a semi-transparent bubble to show the enclosing sphere
#if (Bubble)
sphere { <XCentre, YCentre, ZCentre> R-0.001
    texture { pigment { rgbt <1,1,1,0.8> } }
}
#end
union{
    // the shell itself (west half)
    intersection {
        sphere { <0,0,0>, R }
        plane { <-1,0,0>, XCentre } // small circle cut
        plane { <PX1, PY1, PZ1>, 0 } // great circle cut 1
        plane { <PX2, PY2, PZ2>, 0 } // great circle cut 2
        #if (Skin)
            sphere { <0,0,0>, R-SkinThickness inverse }
        #end
        translate <XCentre, YCentre, ZCentre>
    }
    // the east half of the shell
    intersection {
        sphere { <0,0,0>, R }
        plane { <-1,0,0>, XCentre } // small circle cut
        plane { <PX1, PY1, PZ1>, 0 } // great circle cut 1
        plane { <PX2, PY2, PZ2>, 0 } // great circle cut 2
        #if (Skin)
            sphere { <0,0,0>, R-SkinThickness inverse }
        #end
        translate <XCentre, YCentre, ZCentre>
        matrix <-1,0,0
                0,1,0
                0,0,1
                0,0,0>
    }
    texture { ShellTexture }
}
#end // macro Shell()
