
 //  first declare some defaults if not already done in scene script.

 #ifndef (Flying)        #declare Flying        = 0    #end
 #ifndef (WingType)      #declare WingType      = 0    #end
 #ifndef (WingAngle)     #declare WingAngle     = 0    #end
 #ifndef (LegThickn)     #declare LegThickn     = 0.02 #end
 #ifndef (WithoutShadow) #declare WithoutShadow = 0    #end
 #ifndef (FastButterfly) #declare FastButterfly = 0    #end

 #ifndef (WingText)
   #declare WingText = texture{pigment {Blue}finish {ambient 0.3}}
 #end

 #ifndef (BodyText)
   #declare BodyText = texture{pigment{Gray40}finish {ambient 0.3}normal{bumps 0.51 scale 0.005}}
 #end

 #ifndef (LegText)
  #declare LegText   = texture{pigment{Gray10} finish {ambient 0.3 phong .4}}
 #end

#ifndef (EyeText)
  #declare EyeText   = texture{pigment {color Gray20} finish{specular 0.5 }}
#end


//  declare the legs for a staying butterfly  (only if Flying=0)

#if(Flying=0)
#declare Legs=object{

// ****** front
union{
union{
cylinder {<0,.05,0> , <-.2,-.20,.10> , LegThickn}
sphere {<-.2,-.20,0.10>,LegThickn}
cylinder {<-.2,-.20,0.10> , < -.2,.1,0.2> , LegThickn}
sphere {<-.2,.1,0.2>,LegThickn}
cone {<-.2,.1,.2> , LegThickn <-.2,-.55,.4> , LegThickn/2}
scale 0.3
translate <0,-.05,.1>
}

// ****** middle
union{
cylinder {<0,.05,0> , <-.2,-.20,-.10> , LegThickn}
sphere {<-.2,-.20,-0.10>,LegThickn}
cylinder {<-.2,-.20,-0.10> , < -.2,.1,-0.2> , LegThickn}
sphere {<-.2,.1,-0.2>,LegThickn}
cone {<-.2,.1,-.2> , LegThickn <-.2,-.50,-.45> , LegThickn/2}
scale 0.3
translate <0,-.05,.025>
}

// ****** rear
union{
cylinder {<0,.05,0> , <-.2,-.20,-.10> , LegThickn}
sphere {<-.2,-.20,-0.10>,LegThickn}
cylinder {<-.2,-.20,-0.10> , < -.2,.1,-0.2> , LegThickn}
sphere {<-.2,.1,-0.2>,LegThickn}
cone {<-.2,.1,-.2> , LegThickn <-.2,-.5,-.65> , LegThickn/2}
scale 0.3
translate <0,-.05,-.1>
}
}
  }
#end

// declare the legs for a flying butterfly (if Flying=1)

#if (Flying=1)//  ********** Legs flying
#declare Legs=object{
// ****** front
union{
union{
cylinder {<0,.05,0> , <-.1,-.10,.0> , LegThickn}
sphere {<-.1,-.10,0.0>,LegThickn}
cylinder {<-.1,-.10,0.0> , < -.1,.0,0.20> , LegThickn}
sphere {<-.1,.0,0.20>,LegThickn}
cone {<-.1,.0,.20> , LegThickn <-.2,-.25,-.3> , LegThickn/2}
scale 0.3
translate <0,-.05,.1>
}

// ****** middle
union{
cylinder {<0,.05,0> , <-.2,-.15,-.15> , LegThickn}
sphere {<-.2,-.15,-0.15>,LegThickn}
cylinder {<-.2,-.15,-0.15> , < -.2,.1,-0.25> , LegThickn}
sphere {<-.2,.1,-0.25>,LegThickn}
cone {<-.2,.1,-.25> , LegThickn <-.2,-.10,-.9> , LegThickn/2}
scale 0.3
translate <0,-.05,.025>
}

// ****** rear
union{
cylinder {<0,.05,0> , <-.2,-.15,-.15> , LegThickn}
sphere {<-.15,-.15,-0.15>,LegThickn}
cylinder {<-.15,-.15,-0.15> , < -.15,.1,-0.25> , LegThickn}
sphere {<-.15,.1,-0.25>,LegThickn}
cone {<-.15,.1,-.25> , LegThickn <-.15,-.10,-.9> , LegThickn/2}
scale 0.3
translate <0,-.05,-.1>
}
}
  }
#end

// declare the body
#declare Body=
  object{
   union{
     sphere{<0,0,0.25>,0.055 scale <0.6,1,1>}            // head

     // antennas
        union {cylinder{0*z,0.6*z,0.0055} cylinder{0.55*z,0.65*z,0.010}
        rotate<-45,-20,0> translate <-0.005,0.01,0.25> texture {LegText}} // antenna left

     union {cylinder{0*z,0.6*z,0.0055} cylinder{0.55*z,0.65*z,0.010}
        rotate<-45, 20,0> translate < 0.005,0.01,0.25> texture {LegText}} // antenna right

     // eyes l/r
     sphere{<0,0,0>,0.025 scale <0.7,1.3,0.9> translate <-0.023,0.005,0.25> texture {EyeText}} //  eye left
     sphere{<0,0,0>,0.025 scale <0.7,1.3,0.9> translate < 0.023,0.005,0.25> texture {EyeText}} //  eye right

     // body
     sphere{0, 0.065 scale <0.6, 1.1, 5.0> translate z*-0.05}  // body front
     sphere{0, 0.050 scale <0.8, 1.0, 5.5> translate z*-0.43}  // body rear

object {Legs texture {LegText}}
object {Legs texture {LegText} scale <-1,1,1>}

     texture {BodyText}
     }
}


// declare a simple body if FastButterfly=1
#if (FastButterfly=1)
  #declare WingText = texture {pigment {color Red}finish{ambient 0.6}}
  #declare WingType = 0
  #declare BodyText = texture {pigment {color Blue}finish{ambient 0.4}}
  #declare Body     = union{cylinder{z*0.4,z*-0.6,0.07}
                            sphere  {z*0.4,0.1}
                            texture {BodyText}
                           }
#end


//   *******  now declare the wings  depending on WingType   *********

#if (WingType=0)
  #declare Wing=
   prism {
    linear_sweep
    linear_spline
    0,                 // sweep the following shape from here ...
    0.001,             // ... up through here
    8,                 // the number of points making up the shape ...
    <0.05,-.3>,<0,0>,<0,.2>,<-.7,.8>,<-.7,-.8>,<0,-.2>,<0,0>,<0.05,-.3>
    texture {WingText}
      }
#end

#if (WingType=1)
  #declare Wing=
   prism {
    linear_sweep
    cubic_spline
    0,                 // sweep the following shape from here ...
    0.001,             // ... up through here
    9,                 // the number of points making up the shape ...
    <0.05,-.1>,<0,-.05>,<-.10,.2>,<-.6,.3>,<-.9,0>,<-.09,-.9>,<-.05,-.3>,<0,-.05>,<0.05,-.1>
   texture {WingText}
        }
#end

#if (WingType=2)
  #declare Wing=
   prism {
    linear_sweep
    cubic_spline
    0,                 // sweep the following shape from here ...
    0.001,             // ... up through here
    9,                 // the number of points making up the shape ...
    <0.05,-.3>,<0,-.05>,<-.02,.1>,<-.7,.8>,<-.6,0>,<-.6,-.8>,<0,-.2>,<0,-.05>,<0.05,-.3>
   texture {WingText}
        }
#end

#if (WingType=3)
  #declare Wing=
   prism {
    linear_sweep
    cubic_spline
    0,                 // sweep the following shape from here ...
    0.001,             // ... up through here
    9,                 // the number of points making up the shape ...
    <0.05,-.3>,<0,0>,<-.1,.2>,<-.9,.7>,<-.8,0>,
    <-.08,-.99>,<-.15,-.35>,<0,0>,<0.05,-.3>
   texture {WingText}
        }
#end

#if (WingType=4)
  #declare Wing=
   prism {
    linear_sweep
    cubic_spline
    0,                 // sweep the following shape from here ...
    0.001,             // ... up through here
    17,                // the number of points making up the shape ...
    <0.05,-.3>,<0,0>,<-.1,.2>,<-.25,.5>,<-.9,.7>,<-.7,.45>,<-.45,0>,
    <-.58,-.35>,<-.55,-.55>,<-.45,-.75>,<-.425,-.9>,<-.4,-.7>,<-.3,-.6>,<-.2,-.4>,<-.1,-.3>,<0,0>,<0.05,-.1>
   texture {WingText}
        }
#end

#if (WingType=5)
  #declare Wing=
   prism {
    linear_sweep
    cubic_spline
    0,                 // sweep the following shape from here ...
    0.001,             // ... up through here
    17,                // the number of points making up the shape ...
    <0.05,-.3>,<0,0>,<-.1,.2>,<-.25,.5>,<-.7,.7>,<-.7,.45>,<-.55,0>,
    <-.6,-.35>,<-.55,-.55>,<-.45,-.75>,<-.225,-.9>,<-.3,-.7>,<-.175,-.6>,<-.15,-.4>,<-.1,-.3>,<0,0>,<.05,-.1>
   texture {WingText}
        }
#end

// now put together the body and the two wings and declare the ButterFly object

#declare ButterFly=
union{
      object {Body}
      object {Wing                rotate -z*WingAngle}
      object {Wing scale <-1,1,1> rotate  z*WingAngle}

  #if (WithoutShadow=1)
    no_shadow
  #end
     }

