/*

Untouched nature
----------------
Landscape designed by Eric van der Ree - Netherlands.
Finished in April 1999.

*/


                                       //  include files
#include "colors.inc"
#include "textures.inc"
#include "Pool.inc"
#include "Clouds.inc"
#include "Veg.inc"


                                       //  (de)activate parts of the scene
#declare Show_SunLight      = 1
#declare Show_Fog           = 1
#declare Show_Sky           = 1
#declare Show_HfClose       = 1
#declare Show_Grasses       = 1
#declare Show_HfMedium      = 1
#declare Show_HfFar         = 1
#declare Show_Pool          = 1
#declare Show_HaloClouds    = 1
#declare Show_TreeClose     = 1
#declare Show_TreePool      = 1
#declare Show_TreesFarRight = 1
#declare Show_Bushes        = 1
#declare Show_Butterflys    = 1
#declare Show_Text          = 1
#declare Show_Sun           = 1



                                       //  universal light
light_source
  { <-1500, 9000, 500> color White }


                                       //  sunlight
#if (Show_SunLight = 1)

light_source {
   <900, 0, 500>
    color red 1.00 green 0.75 blue 0.00
             }
light_source {
    <900, 0, 40>
    color red 1.00 green 0.75 blue 0.00
             }
light_source {
   <-900, 0, 500>
    color red 1.00 green 0.75 blue 0.00
             }
light_source {
    <-900, 0, 40>
    color red 1.00 green 0.75 blue 0.00
             }

#end


                                       //  universal fog
#if (Show_Fog = 1)

fog {fog_type 2
     distance 300
     color LightGrey
     turbulence 0.2
     fog_offset 10
     fog_alt 1
     up <0, 1, 0>
    }

#end



                                       //  the sky (with clouds)
#if (Show_Sky = 1)

#declare Pgm_Cloud =
pigment {
    bozo
    turbulence 0.8
    octaves 6
    omega 0.7
    lambda 2
    color_map {
        [0.0, 0.1   color red 1.00 green 0.60 blue 0.00
                    color red 1.00 green 0.75 blue 0.00]
        [0.1, 0.5   color red 1.00 green 0.75 blue 0.00
                    color Clear]
        [0.5, 1.001 color Clear color Clear]      }
scale <7, 1, 7>
}

#declare Txt_Clouds =
texture {
    pigment { color LightBlue }
    finish { ambient 0.7 diffuse 0 }
}
texture {
    pigment { Pgm_Cloud }
    finish { ambient 1.0 diffuse 0 }
}
texture {
    pigment { Pgm_Cloud  translate -0.15*y }
    finish { ambient 0.6 diffuse 0 }
}

#declare Mysky = sphere {
  <0,0,0>,0.98
  texture { Txt_Clouds }
                        }

difference {
   sphere { <0,0,0>,1 }
     object {Mysky}

     scale <3000,500,3000>
     texture { Txt_Clouds }
     no_shadow
           }

#end



                                       //  hill in the foreground
#if (Show_HfClose = 1)

height_field {
     tga "HfClose.tga"
     scale <200,32,200>
     translate <180,-85,20>
     texture {
       pigment {
         image_map {
           tga "greenmos.tga"
                   }
          turbulence 1.0
               }
             }
     smooth
}

#end


                                       // vegetation on the hill in the foreground
#if (Show_Grasses = 1)

#declare o01 = object { Tree2 }        //  - trees in the back
#include "VsClose1.inc"
object { Veg1 translate <180,-85,20> }

#declare o05 = object { Grass2 }       //  - grasses near the pool
#include "VsClose5.inc"
object { Veg5 translate <180,-85,20> }

#declare o05 = object { Grass }        //  - small bushes near the pool
#include "VsClose5.inc"
object { Veg5 translate <180,-85,20> }

#declare o06 = object { Grass2 }       //  - grasses on rest of the hill
#include "VsClose6.inc"
object { Veg6 translate <180,-85,20> }

#end


                                       //  mountains at medium distance
#if (Show_HfMedium = 1)

height_field {
     tga "HfMedium.tga"
     scale <200,85,200>
     translate <190,-90,130>
     texture {
       pigment {
         image_map {
           tga "greenmos2.tga"
                   }
              turbulence 1.0
               }
             }
     smooth
}

#end



                                       //  mountains further away
#if (Show_HfFar = 1)

height_field {
     tga "HfFar.tga"
     scale <200,140,200>
     translate <360,-85,260>
     texture {
       pigment {
         image_map {
           tga "greenmos3.tga"
                   }
              turbulence 1.0
               }
             }
     smooth
}

#end



                                       //  the pool on the right
#if (Show_Pool = 1)

plane {
     <0,1,0>, -64
       texture { PoolTexture }
      }

#end



                                       //  clouds
#if (Show_HaloClouds = 1)

object { HaloCloud_1                   //   - cloud around mountain at medium distance
         scale 15                             (in front of the sun)
         translate <270, -30, 170>
       }

object { HaloCloud_1                   //   - two clouds around mountains further away
         scale 15
         translate <340, -25, 230>
       }

object { HaloCloud_1
         scale 12
         translate <380, 10, 250>
       }

#end


                                       //  tree in the foreground
#if (Show_TreeClose = 1)

#declare Tseed = 2345
#declare TRH = 0.9
#declare TRL = 0.7
#declare TGH = 0.9
#declare TGL = 0.7
#declare TBH = 0.4
#declare TBL = 0.2
#include "Bstamme.inc"
object {Tree
        translate <235, -65, 60>
       }

#end

                                       //  tree near the pool
#if (Show_TreePool = 1)

#declare Tseed = 4422
#declare TRH = 0.9
#declare TRL = 0.7
#declare TGH = 0.8
#declare TGL = 0.6
#declare TBH = 0.4
#declare TBL = 0.2
#include "Bstamme.inc"
object {Tree
        translate <270, -68, 65>
       }

#end

                                       //  trees further away on the right
#if (Show_TreesFarRight = 1)

#declare Tseed = 5533
#declare TRH = 0.7
#declare TRL = 0.5
#declare TGH = 0.9
#declare TGL = 0.7
#declare TBH = 0.4
#declare TBL = 0.2
#include "Bstamme.inc"
object {Tree
        translate <285, -63, 100>
       }

#declare Tseed = 6644
#declare TRH = 0.9
#declare TRL = 0.7
#declare TGH = 0.7
#declare TGL = 0.5
#declare TBH = 0.4
#declare TBL = 0.2
#include "Bstamme.inc"
object {Tree
        translate <305, -60, 150>
       }

#end


                                       //  the two bushes on the foreground
#if (Show_Bushes = 1)

#include "defaults.inc"
#declare BarkTexture=3
#declare LeafShape=4
#declare LeafTexture=4
#declare LeafNum=8
#declare MinXDeg=50
#declare MaxXDeg=70
#declare IncXDeg=10
#declare MaxSplits=4
#declare MinSplits=3
#declare IncSplits=1.1
#declare BaseLen=0.2
#declare LengthInc=1.5
#declare LeafRandRot=True
#declare Tip=3
#declare TipPercent=0.8
#declare FlowerTexture=5

object {
    #declare SD1=seed(30)
    #include "trees.inc"
	translate <231, -60, 37>
}

object {
	#declare SD1=seed(60)
    #include "trees.inc"
	translate <238, -63, 47>
}

#end



                                       // the butterflys on the foreground (on the left)
#if (Show_Butterflys = 1)

#declare FastButterfly = 0
#declare Flying        = 1
#declare WingType      = 2
#declare WingText=
texture{pigment{image_map{
  png "fract914.png"
  map_type 0
  interpolate 2 } }
  finish {ambient 0.5 reflection 0.40 phong_size 50 phong 1}
  rotate <90,180,0>
  translate 0.5*z
  scale 1.6
  }
#include "butterfl.inc"
object {ButterFly scale 0.5 rotate < 20,20,130> translate <230.2, -58.5, 41>}

#declare WingText=
texture{pigment{image_map{
  png "fract903.png"
  map_type 0
  interpolate 2 } }
  finish {ambient 0.5 reflection 0.40 phong_size 50 phong 1}
  rotate <90,180,0>
  translate 0.5*z
  scale 1.6
  }
#include "butterfl.inc"
object {ButterFly scale 0.5 rotate < 200,220,30> translate <230.7, -56.5, 36>}
object {ButterFly scale 0.5 rotate < 40,150,80> translate <232.2, -57.5, 39.5>}

#end


                                       // signature (top left)
#if (Show_Text = 1)

text {
  ttf    "C:\WINDOWS\Fonts\Timesbi.ttf",
  "Eric van der Ree",
   0.1,
  <0.0,   0.0, 0.0>
  pigment { Gray35 }
  scale <1.00, 1.3, 1.3>
  rotate <80, 114, 75>
  translate  <260, -34.5, 55> }
text {
  ttf    "C:\WINDOWS\Fonts\Timesbi.ttf",
  "   April 1999   ",
   0.1,
  <0.0,   0.0, 0.0>
  pigment { Gray35 }
  scale <1.00, 1.3, 1.3>
  rotate <80, 114, 75>
  translate  <260, -35.8, 55> }

#end


                                       //  the sun and camera
#if (Show_Sun = 1)

#declare effect_location  = <565, 80, 900>;
#declare effect_scale     = 1.3;
#declare effect_intensity = 0.5;
#declare effect_type      = "SUN2"
#declare camera_location  = <230, -53, 25>;
#declare camera_look_at   = <553, -53, 698>;
#declare camera_sky       = <0, 1, 0>;
#include "LENS.INC"

#end

                                       // the camera (separate, same as included in
                                       //             the sun)
camera {
   location <230, -53, 25>
   sky       <0, 1, 0>
   up        <0, 1, 0>
   right     <1, 0, 0>
   look_at   <553, -53, 698>
}

