// Persistence of Vision Ray Tracer Scene Description
// File: eruption.pov
// Vers: 3.1e (3.1g/b1 beta release of Smellenbergh Unofficial Compile)
// Desc: Volcano erupting by use of DF3 file
// Date: May 18, 1999 - August 6, 1999
// Auth: Joost Egelie

global_settings {
	ambient_light rgb < 0.996078, 0.958824, 0.921569 >
	assumed_gamma 1.8
}
#include "colors.inc"
#include "textures.inc"

camera{
	location <0.1, 0.5, -9.0>
	direction 1.1*z
	sky <1,10,-0.5>
	up y
	right 4/3*x
	look_at <0.0, 3, 0.0>
	normal{ripples 0.01 turbulence 1 scale <0.05,0.06,0.05>}
}

#declare GroundTexture = 	texture {
	pigment{color rgb < 0.355550, 0.240528, 0.138567 > }
	finish {Dull}
}

sky_sphere  {
	pigment {
		crackle
		color_map{
			[0.0	color rgb 0        ]
			[1.0 color rgb <0.67,0,0>]
		}
		turbulence 1 scale 0.2}
}

height_field  {
	gif "htfield.gif"
	smooth 
	texture {GroundTexture}
	translate<-0.5,0,-0.5>
	scale<10,1.5,10>
}

height_field  {
	gif "htfield2.gif"
	smooth 
	texture {
		pigment{
			marble
			color_map {
				[ 0.0 color rgb < 0.937255, 0.121569, 0.113725 > ]
				[ 0.25 color rgb < 0.702941, 0.091176, 0.085294 > ]
				[ 0.5 color rgb < 0.996078, 0.337255, 0.109804 > ]
				[ 0.75 color rgb < 0.234314, 0.030392, 0.028431 > ]
				[ 1.0 color rgb < 0.000000, 0.000000, 0.000000 > ]
			}
			triangle_wave
		}
		finish{ambient color rgb < 0.898039, 0.227451, 0.254902 >}
	}
	translate<-0.5,0,-0.5>
	scale<11,1.5,11>
}

plane{y,0.01
	texture{
		GroundTexture
		normal{wrinkles 1 scale 0.05 turbulence 1}
	}
}

box{0,1
 texture{
   pigment{rgbt 1}
 }
   interior{
     media{
       emission 0.5
       scattering{1,0.1}
       intervals 10
       samples 1, 2
       confidence 0.9
       variance 1/128
       density{
         density_file df3 "smoke.df3"
				interpolate 1
         color_map{
				[0      rgb 0         ]
				[0.25   rgb 0.1       ]
				[0.5    rgb <0.5,0,0> ]
				[1      rgb <1,0.5,0> ]
         }
			turbulence 0.5
       }
     }
   }
   hollow
   translate <-0.5,-0.5,-0.5>
   scale <4,10,4>
	rotate<0,30,0>
	translate<0,1.5,0>
}



light_source{<0,6.7,0>
	color rgb < 1.000000, 0.33, 0.1 >
	fade_distance 90.0
	fade_power 1	//linear
	media_attenuation
}
light_source {<500,500,-500> rgb <0.2,0.1,0>}
