// Persistence of Vision Ray Tracer Scene Description File
// File: GoldGate.pov
// Vers: 3.1
// Desc: For the Internet Raytracing Competition
// Date: 08/30/99
// Auth: Bob Franke
//

#version 3.1;

#include "colors.inc"
#include "finish.inc"
#include "metals.inc"
#include "textures.inc"



#declare internationalOrange = color red 0.969 green 0.220 blue 0.062;
 
#declare goldenGate=
texture{  
  pigment{internationalOrange} 
  finish{
    specular .7 roughness 0.002
    ambient .05 
  } 
}             
 

#declare showtrees = 1;
#declare showhills = 1; 
#declare showCables = 1;
#declare showSky = 1;
#declare showwater = 1; 
#declare showClouds = 1;
#declare showgroundfog = 1;

//#declare fogtest = 1;   


global_settings
{
  assumed_gamma 2.2
    max_trace_level 50
}

// ----------------------------------------
camera
{

//  location  <2750+1000,400,-800> 
    location  <2750+1000,350,-800>*.90
//  location  <0,40000,-5000>
 

  direction 1.75*z
  right     4/3*x 
  right     800/450*x 
  
//  look_at   <500,200,2000> 
    look_at   <0,450,2200>
//  look_at   <0,200,2500>

}
                    


#declare internationalOrange = color red 0.969 green 0.220 blue 0.062;

light_source{
  0*x // light's position (translated below)
  color red 2.0  green 2.0  blue 1.75 // light's color
  translate <0,0,600000>
  rotate<-10.4,0,0>
  rotate<0,131,0>
}

// ----------------------------------------  

#ifdef (showSky)
  sky_sphere{
    pigment{
      gradient y
      color_map { [0.0 color blue 0.6] [1.0 color rgb 1] }  //*1.25
    }                                                        
    rotate<-30,-40,0>
  }
#else
  background { color red 0 green 0 blue .4 }
#end         
                                

// this is the object to put in the heightfield (see out.inc)
#declare o01 = union{
cone{<0,-125,0>,50,<0,75,0>,5  
  pigment {
    bozo
    color_map {
        [0.0 rgbf <0.0, 0.2, 0.0, 0.0>]
        [0.4 rgbf <0.0, 0.4, 0.0, 0.0>]
        [0.6 rgbf <1.0, 1.0, 1.0, 1.0>]
        [1.0 rgbf <1.0, 1.0, 1.0, 1.0>] 
    }             
    scale 3
  }
 }
}  
     
#declare cableF = 3/4200;     
#macro cable(xx,yy,zz,length) 
#declare addedR = ((-2100+xx)*-1) / 4200 *0.250;  
union{
   union{
     difference{     
       torus{1.75, .25+addedR rotate<90,0,0> translate<xx,yy,zz>  } 
       box{<0,0,-4>,<-1.8,-3,4> rotate<0,0,70> translate<xx,yy,zz>}
       box{<0,0,-4>,<1.8,-3,4> rotate<0,0,-70> translate<xx,yy,zz>}
     }
    
     cylinder{<1.75,0,0>,<1.75,-3,0>, 0.25+addedR rotate<0,0,-20> translate<xx,yy,zz>}  
     cylinder{<-1.75,0,0>,<-1.75,-3,0>, 0.25+addedR rotate<0,0,20> translate<xx,yy,zz>}
     cylinder{<.6,-3.5,0>,<.6,-6-length,0>, 0.25+addedR translate<xx,yy,zz> }
     cylinder{<-.6,-3.5,0>,<-.6,-6-length,0>, 0.25+addedR translate<xx,yy,zz> }
     box{<-1.1,-3.25,.25>,<1.1,-3.75,-.25> translate<xx,yy,zz>}  
   }
  
   union{
     difference{     
       torus{1.75, .25+addedR rotate<90,0,0> translate<0,0,-1> translate<xx,yy,zz> } 
       box{<0,0,-4>,<-1.8,-3,3> rotate<0,0,70> translate<xx,yy,zz>}
       box{<0,0,-5>,<1.8,-3,3> rotate<0,0,-70> translate<xx,yy,zz>}
     }
    
     cylinder{<1.75,0,-1>,<1.75,-3,-1>, 0.25+addedR rotate<0,0,-20> translate<xx,yy,zz>}  
     cylinder{<-1.75,0,-1>,<-1.75,-3,-1>, 0.25+addedR rotate<0,0,20> translate<xx,yy,zz>}
     
     cylinder{<.6,-3.5,-1>,<.6,-6-length,-1>, 0.25+addedR  translate<xx,yy,zz>}
     cylinder{<-.6,-3.5,-1>,<-.6,-6-length,-1>, 0.25+addedR  translate<xx,yy,zz>}
     box{<-1.1,-3.25,-.75>,<1.1,-3.75,-1.25> translate<xx,yy,zz>}  
   } 
   texture{  
     pigment{internationalOrange} 
     finish{ambient .5  roughness 0.015}
   } 
  }     
 
#end


#macro approachCable(xx,yy,zz,length)  
union{
   union{
     difference{     
       torus{1.75, .25 rotate<90,0,0> translate<xx,yy,zz>  } 
       box{<0,0,-4>,<-1.8,-3,4> rotate<0,0,70> translate<xx,yy,zz>}
       box{<0,0,-4>,<1.8,-3,4> rotate<0,0,-70> translate<xx,yy,zz>}
     }
    
     cylinder{<1.75,0,0>,<1.75,-3,0>, 0.25 rotate<0,0,-20> translate<xx,yy,zz>}  
     cylinder{<-1.75,0,0>,<-1.75,-3,0>, 0.25 rotate<0,0,20> translate<xx,yy,zz>}
     cylinder{<.6,-3.5,0>,<.6,-6-length,0>, 0.25 translate<xx,yy,zz> }
     cylinder{<-.6,-3.5,0>,<-.6,-6-length,0>, 0.25 translate<xx,yy,zz> }
     box{<-1.1,-3.25,.25>,<1.1,-3.75,-.25> translate<xx,yy,zz>}  
   }
  
   union{
     difference{     
       torus{1.75, .25 rotate<90,0,0> translate<0,0,-1> translate<xx,yy,zz> } 
       box{<0,0,-4>,<-1.8,-3,3> rotate<0,0,70> translate<xx,yy,zz>}
       box{<0,0,-5>,<1.8,-3,3> rotate<0,0,-70> translate<xx,yy,zz>}
     }
    
     cylinder{<1.75,0,-1>,<1.75,-3,-1>, 0.25 rotate<0,0,-20> translate<xx,yy,zz>}  
     cylinder{<-1.75,0,-1>,<-1.75,-3,-1>, 0.25 rotate<0,0,20> translate<xx,yy,zz>}
     
     cylinder{<.6,-3.5,-1>,<.6,-6-length,-1>, 0.25  translate<xx,yy,zz>}
     cylinder{<-.6,-3.5,-1>,<-.6,-6-length,-1>, 0.25  translate<xx,yy,zz>}
     box{<-1.1,-3.25,-.75>,<1.1,-3.75,-1.25> translate<xx,yy,zz>}  
   } 
   texture{  
     pigment{internationalOrange} 
     finish{ambient .5}
   } 
  }     
 
#end

     
#declare trees=
  texture{
    pigment{
      bozo
      color_map{
        [0.4 color rgb <0.337, 0.550, 0.435>*.7]
        [0.8 color rgb <0.337, 0.550, 0.435>*.6]
      }
      scale 1000
      translate<-500,0,0>
    }        
    finish {ambient .5 crand .04 }
  }

#declare Sea =
plane { y,9
  texture {
    T_Silver_1C
      normal {
        average
        normal_map {
          [ ripples 0.15 frequency 3 scale 0.008 translate <0, 0, 10> ]
          [ wrinkles 0.25 scale 0.01  ]  
          [ bumps .03 ]
        }
     } 
   scale <1000, 10000*1.2, 1000>*1.5     
  }
}
  
  
#declare groundCover = 
texture{
  pigment {
    bozo
    color_map {
        [0.0 rgb <0.45, 0.8, 0.55>*.35]
        [0.1 rgb <0.45, 0.8, 0.55>*.35]  
        [0.3 color NewTan/2]
        [0.5 color NewTan/2]
        [0.7 rgb <0.45, 0.8, 0.55>*.4]
        [1.0 rgb <0.45, 0.8, 0.55>*.4]
    }
  }
  finish {ambient .6 crand .02}
}  


#ifdef (showhills)
  height_field{
    tga             
    "sf9.tga"
    smooth  
    translate <-.5,0,-.5>  
    translate <-.39,0,0.34>     
    scale <44786,2700,44786> 
    texture{groundCover scale 1500}  
      
    normal {
      bozo
      normal_map {  
        [0.0 bumps .6 scale<.01,.02,.01> ]
        [0.15 bumps .6 scale<.01,.02,.01>]  
        
        [0.25 crackle 0.1 scale .0003]
        [0.55 crackle 0.1 scale .0003] 
        
        [0.65 bumps .6 scale<.01,.02,.01>]
        [1.0 bumps .6 scale<.01,.02,.01>]
      }
    scale 1500  
    }   
  }
#end                      


#ifdef (showtrees)
  #include "tree.inc" 
  object{xtrees
          translate<-44786/2,0,-44786/2> 
          translate <-0.39*44786,0,0.34*44786>           
        }
#end        




#declare moon=  
sphere{<0,0,0> 15000 
  pigment{
    image_map{
      gif "moon8.gif"
      map_type 1 
      interpolate 2 
      filter all .05
      once 
    }                                         
    rotate<0,17,0> 
  }
  clipped_by{plane{z,0} rotate<0,23,0>}
  rotate<0,0,0>

  translate<0,0,600000>
  rotate<-3.34,0,0>
  rotate<0,288.75,0> 
  no_shadow 
  finish {ambient .8  diffuse 0}
}


#declare link =         //steel cable
cylinder {<-50,0,0>,<50,0>, 2.0
  texture{goldenGate}  
}  
      

#declare bridge=
union{  
  #declare useAsInclude=1;
  #include "tower.pov"
  object{tower translate<0,0,-2100>}
  object{tower translate<0,0,2100>}  
  #include "roadway.pov"
  #declare xrot = 0;
  #declare xcount = 0;      
  #while (xcount < 45)
    object{roadSection rotate<0,90,0> translate<0,208000,0>  rotate<xrot,0,0> translate<0,-208000+225,0>}
    object{roadSection rotate<0,90,0> translate<0,208000,0> rotate<xrot*-1,0,0> translate<0,-208000+225,0>}
    #declare xrot = xrot + 0.02754605;
    #declare xcount = xcount + 1;
  #end 
       
#ifdef (showCables)
  #declare link_length = 1;
  #declare link_rotation = 0;
  #declare link_error = 0.001; // (fraction of link_length)
  #declare chain_start= <45,721,-2050>;
  #declare chain_end= <45,721,2050>;
  #declare chain_scale=.446/2100; 
  #declare chain_type = 2;
  #include "chain11.inc"   
   

  #declare link_length = 1;
  #declare link_rotation = 0;
  #declare link_error = 0.001; // (fraction of link_length)
  #declare chain_start=<-45,721,-2050>;
  #declare chain_end=<-45,721,2050>;
  #declare chain_scale=.446/2100; 
  #declare chain_type = 2;
  #include "chain11.inc"
           
  #declare link_length = 1;
  #declare link_rotation = 0;
  #declare link_error = 0.001; // (fraction of link_length)
  #declare chain_start=<45,710,-2150>;
  #declare chain_end=<45,266,-3175>;
  #declare chain_scale=.75/2100; 
  #declare chain_type = 2;
  #include "chain11.inc"
           
  #declare link_length = 1;
  #declare link_rotation = 0;
  #declare link_error = 0.001; // (fraction of link_length)
  #declare chain_start=<-45,710,-2150>;
  #declare chain_end=<-45,266,-3175>;
  #declare chain_scale=.75/2100; 
  #declare chain_type = 2;
  #include "chain11.inc"
           
  #declare link_length = 1;
  #declare link_rotation = 0;
  #declare link_error = 0.001; // (fraction of link_length)
  #declare chain_start=<45,710,2150>;
  #declare chain_end=<45,266,3175>;
  #declare chain_scale=.75/2100; 
  #declare chain_type = 2;
  #include "chain11.inc"
           
  #declare link_length = 1;
  #declare link_rotation = 0;
  #declare link_error = 0.001; // (fraction of link_length)
  #declare chain_start=<-45,710,2150>;
  #declare chain_end=<-45,266,3175>;
  #declare chain_scale=.75/2100; 
  #declare chain_type = 2;
  #include "chain11.inc"
           
   
//================================================================
  approachCable(45,711.5,-2150,470)    
  approachCable(45,681,-2200,440)    
  approachCable(45,650,-2250,410)    
  approachCable(45,621,-2300,380)    
  approachCable(45,594,-2350,350)    
  approachCable(45,567,-2400,325)    

  approachCable(-45,711.5,-2150,470)    
  approachCable(-45,681,-2200,440)    
  approachCable(-45,650,-2250,410)    
  approachCable(-45,621,-2300,380)    
  approachCable(-45,594,-2350,350)    
  approachCable(-45,567,-2400,325)    


//================================================================   
  cable(45,711.5,2150,470)    
  cable(45,681,2200,440)    
  cable(45,650,2250,410)    
  cable(45,621,2300,380)    
  cable(45,594,2350,350)    
  cable(45,567,2400,325) 
  cable(45,540,2450,298) 
  cable(45,513,2500,271) 
  cable(45,486,2550,244) 
  cable(45,459,2600,217) 
  cable(45,434,2650,190) 
  cable(45,412,2700,163) 
  cable(45,390,2750,150) 
  cable(45,370,2800,130) 
  cable(45,357,2850,115) 
  cable(45,335,2900,98) 
  cable(45,315,2950,80) 
  cable(45,300,3100,60)    
  cable(45,290,3150,60)    
  cable(45,280,3200,50)    

  cable(-45,711.5,2150,470)    
  cable(-45,681,2200,440)    
  cable(-45,650,2250,410)    
  cable(-45,621,2300,380)    
  cable(-45,594,2350,350)    
  cable(-45,567,2400,325) 
  cable(-45,540,2450,298) 
  cable(-45,513,2500,271) 
  cable(-45,486,2550,244) 
  cable(-45,459,2600,217) 
  cable(-45,434,2650,190) 
  cable(-45,412,2700,163) 
  cable(-45,390,2750,150) 
  cable(-45,370,2800,130) 
  cable(-45,357,2850,115) 
  cable(-45,335,2900,98) 
  cable(-45,315,2950,80) 
  cable(-45,300,3100,60)    
  cable(-45,290,3150,60)    
  cable(-45,280,3200,50)
//================================================================   
   
  cable(45,722,-2050,500)    
  cable(45,700,-2000,480)    
  cable(45,678,-1950,455)    
  cable(45,657,-1900,435)    
  cable(45,637,-1850,415)    
  cable(45,617,-1800,395)    
  cable(45,598,-1750,375)    
  cable(45,579,-1700,355)    
  cable(45,560,-1650,335)    
  cable(45,541,-1600,315)    
  cable(45,522,-1550,295)    
  cable(45,507,-1500,275)    
  cable(45,490,-1450,255)    
  cable(45,475,-1400,235)    
  cable(45,456,-1350,215)    
  cable(45,445,-1300,195)    
  cable(45,435,-1250,180)    
  cable(45,420,-1200,160) 
  cable(45,406,-1150,145)    
  cable(45,396,-1100,160)    
  cable(45,382,-1050,145)    
  cable(45,371,-1000,130)    
  cable(45,362,-950,120)    
  cable(45,353,-900,110)    
  cable(45,342,-850,100)    
  cable(45,337,-800,90)    
  cable(45,329,-750,80)    
  cable(45,322,-700,70)   
  cable(45,314,-650,62)    
  cable(45,306,-600,54)    
  cable(45,298,-550,48)   
  cable(45,292,-500,40)    
  cable(45,286,-450,32)    
  cable(45,281,-400,28)  
  cable(45,280,-350,40)    
  cable(45,278,-300,32)    
  cable(45,276,-250,28)    
  cable(45,273,-200,15)   
  cable(45,272,-150,15)   
  cable(45,271,-100,15)   
  cable(45,270,-50,15)   
  cable(45,269,0,15)   
  
  cable(45,722,2050,500)    
  cable(45,700,2000,480)    
  cable(45,678,1950,455)    
  cable(45,657,1900,435)    
  cable(45,637,1850,415)    
  cable(45,617,1800,395)    
  cable(45,598,1750,375)    
  cable(45,579,1700,355)    
  cable(45,560,1650,335)    
  cable(45,541,1600,315)    
  cable(45,522,1550,295)    
  cable(45,507,1500,275)    
  cable(45,490,1450,255)    
  cable(45,475,1400,235)    
  cable(45,456,1350,215)    
  cable(45,445,1300,195)    
  cable(45,435,1250,180)    
  cable(45,420,1200,160) 
  cable(45,406,1150,145)    
  cable(45,396,1100,160)    
  cable(45,382,1050,145)    
  cable(45,371,1000,130)    
  cable(45,362,950,120)    
  cable(45,353,900,110)    
  cable(45,342,850,100)    
  cable(45,337,800,90)    
  cable(45,329,750,80)    
  cable(45,322,700,70)   
  cable(45,314,650,62)    
  cable(45,306,600,54)    
  cable(45,298,550,48)   
  cable(45,292,500,40)    
  cable(45,286,450,32)    
  cable(45,281,400,28)  
  cable(45,280,350,40)    
  cable(45,278,300,32)    
  cable(45,276,250,28)    
  cable(45,273,200,15)   
  cable(45,272,150,15)   
  cable(45,271,100,15)   
  cable(45,270,50,15)   
  cable(45,269,0,15)   
  
  cable(-45,722,-2050,500)    
  cable(-45,700,-2000,480)    
  cable(-45,678,-1950,455)    
  cable(-45,657,-1900,435)    
  cable(-45,637,-1850,415)    
  cable(-45,617,-1800,395)    
  cable(-45,598,-1750,375)    
  cable(-45,579,-1700,355)    
  cable(-45,560,-1650,335)    
  cable(-45,541,-1600,315)    
  cable(-45,522,-1550,295)    
  cable(-45,507,-1500,275)    
  cable(-45,490,-1450,255)    
  cable(-45,475,-1400,235)    
  cable(-45,456,-1350,215)    
  cable(-45,445,-1300,195)    
  cable(-45,435,-1250,180)    
  cable(-45,420,-1200,160) 
  cable(-45,406,-1150,145)    
  cable(-45,396,-1100,160)    
  cable(-45,382,-1050,145)    
  cable(-45,371,-1000,130)    
  cable(-45,362,-950,120)    
  cable(-45,353,-900,110)    
  cable(-45,342,-850,100)    
  cable(-45,337,-800,90)    
  cable(-45,329,-750,80)    
  cable(-45,322,-700,70)   
  cable(-45,314,-650,62)    
  cable(-45,306,-600,54)    
  cable(-45,298,-550,48)   
  cable(-45,292,-500,40)    
  cable(-45,286,-450,32)    
  cable(-45,281,-400,28)  
  cable(-45,280,-350,40)    
  cable(-45,278,-300,32)    
  cable(-45,276,-250,28)    
  cable(-45,273,-200,15)   
  cable(-45,272,-150,15)   
  cable(-45,271,-100,15)   
  cable(-45,270,-50,15)   
  cable(-45,269,0,15)   
  
  
  cable(-45,722,2050,500)    
  cable(-45,700,2000,480)    
  cable(-45,678,1950,455)    
  cable(-45,657,1900,435)    
  cable(-45,637,1850,415)    
  cable(-45,617,1800,395)    
  cable(-45,598,1750,375)    
  cable(-45,579,1700,355)    
  cable(-45,560,1650,335)    
  cable(-45,541,1600,315)    
  cable(-45,522,1550,295)    
  cable(-45,507,1500,275)    
  cable(-45,490,1450,255)    
  cable(-45,475,1400,235)    
  cable(-45,456,1350,215)    
  cable(-45,445,1300,195)    
  cable(-45,435,1250,180)    
  cable(-45,420,1200,160) 
  cable(-45,406,1150,145)    
  cable(-45,396,1100,160)    
  cable(-45,382,1050,145)    
  cable(-45,371,1000,130)    
  cable(-45,362,950,120)    
  cable(-45,353,900,110)    
  cable(-45,342,850,100)    
  cable(-45,337,800,90)    
  cable(-45,329,750,80)    
  cable(-45,322,700,70)   
  cable(-45,314,650,62)    
  cable(-45,306,600,54)    
  cable(-45,298,550,48)   
  cable(-45,292,500,40)    
  cable(-45,286,450,32)    
  cable(-45,281,400,28)  
  cable(-45,280,350,40)    
  cable(-45,278,300,32)    
  cable(-45,276,250,28)    
  cable(-45,273,200,15)   
  cable(-45,272,150,15)   
  cable(-45,271,100,15)   
  cable(-45,270,50,15)   
  cable(-45,269,0,15)   
#end  //#ifdef (showCables)
} // union


object{ bridge
    rotate<0,-10,0>
  translate <1500,0,2000>  
}           

#ifdef (showwater) object{Sea} #end
object{moon}

                          
#declare containerTexture =
#ifdef (testings)
	texture {
		pigment { color Red*.8 }
	} 
#else
	texture {
		pigment { color rgbf<1,1,1,1> }
 		finish { ambient 1 diffuse 0.7 }
	} 
#end  

 #declare Rx = seed(64);
 #declare Ry = seed(765);
 #declare Rz = seed(64028);	   
 #declare Turb = seed(111);
 #declare Omeg = seed(876);  

  
#declare SmokeInt2 = 
	interior {
		media {
			scattering { 1, <.01,.01,.01,>/14 extinction 1.0 } 
			density { spherical
				color_map{  
					[0.0 color rgb <0.0,0.0,0.0> ]    // outside is transparent
					[0.4 color rgb <0,0,0> ]          // this prevents it from reaching the container
					[1.0 color rgbf <.80,.75,.75,.8>] // inside is opaque
				}
			turbulence 0.75
			omega .8 // default 0.5, higher = rougher     
    	}
		}
	}
	   
#declare fogMaterial = 
	material {
		texture {containerTexture  }
		#ifndef (testings) interior {SmokeInt2} #end
	}  
    

#macro addGroundFog (xx,yy,zz,xscale,xcolor )                       
  #ifndef (fogtest)
    object{  
      sphere { <0,0,0>,1.15 
      hollow 
      material { fogMaterial } 
      rotate<rand(Rx)*0,rand(Ry)*360,rand(Rz)*0> 
      scale xscale   
      translate<xx,yy,zz>       } 
    }                               
  #else
    object{  
      sphere { <0,0,0>,1.15 
      pigment{xcolor*.75}              
      finish { ambient .5 }
      scale xscale  
      translate<xx,yy,zz>       } 
    }                               
  
  #end
#end     
    
#ifdef (showgroundfog)
  addGroundFog (1200,150,4100 ,<1000,200,1000>,Red)  
  
  addGroundFog (1700,150,3500 ,<1000,200,1000>,Red) 
  addGroundFog (0,130,3500 ,<1000,200,1000>,Blue) 
  addGroundFog (-1000,130,3500 ,<1000,200,1000>,Blue) 
   
  addGroundFog (800,120,3000 ,<1000,200,1000>,Red)    
  addGroundFog (-3000,110,3000 ,<1000,200,1000>,Red)    
  addGroundFog (-5000,110,3000 ,<1000,200,1000>,Red)    
  addGroundFog (-8000,110,3000 ,<1000,200,1000>,Red)    
   
  addGroundFog (800,120,2000 ,<1000,200,1000>,Red)    
  addGroundFog (0,120,2000 ,<1000,200,1000>,Red)    
  addGroundFog (-1000,110,2000 ,<1000,200,1000>,Red) 
  addGroundFog (-2000,110,2000 ,<1000,200,1000>,Blue) 
    
  addGroundFog (800,110,1000 ,<1000,200,1000>,Red)   
  addGroundFog (0,110,1000 ,<1000,200,1000>,Red)   
  addGroundFog (-1000,110,1000 ,<1000,200,1000>,Red)    
  addGroundFog (-2000,110,1000 ,<1000,200,1000>,Blue)    

  addGroundFog (1200,150,4100 ,<1000,200,1000>,Red)
  addGroundFog (1700,150,3500 ,<1000,200,1000>,Red) 
  addGroundFog (0,150,3500 ,<1000,200,1000>,Blue) 
  addGroundFog (800,75,3000 ,<1000,200,1000>,Red)    
#end  

 //==========================================================
 
 #declare cloudInt = 
	interior {
		media {
			scattering { 1, <.01,.01,.01,>/16/75 extinction 1.0 } 

			density { spherical
				color_map{  
					[0.0 color rgb <0.0,0.0,0.0> ]    
					[0.4 color rgb <0,0,0> ]         
					[1.0 color rgbf <1.0,.8,.5,.8>]  
				}
			turbulence <1.5,1.5,1.5>
			omega .6 // default 0.5, higher = rougher     
    	}
		}
	}
	   
#declare cloudMaterial = 
	material {
		texture {containerTexture  }
		#ifndef (testings) interior {cloudInt} #end
	}  
    

#macro addCloud (xx,yy,zz,xscale,xcolor )                       
  #ifndef (fogtest)
    object{  
      sphere { <0,0,0>,1.15 
      hollow 
      material { cloudMaterial } 
      rotate<rand(Rx)*0,rand(Ry)*360,rand(Rz)*0> 
      scale xscale   
      translate<xx,yy,zz>       } 
    }                               
  #else
    object{  
      sphere { <0,0,0>,1.15 
      pigment{xcolor*.75}              
      finish { ambient .5 }
      scale xscale  
      translate<xx,yy,zz>       } 
    }                               
  
  #end
#end     
    
  
#ifdef (showClouds)
  addCloud (-190000,17000,62000 ,<100000,20000,100000>,Red)  
  #declare Rx = seed(66);
  #declare Ry = seed(987);
  #declare Rz = seed(3421);	   
  #declare Turb = seed(22);
  #declare Omeg = seed(77658);  
 
  addCloud (0,17000,200000 ,<100000,20000,100000>,Red)  
 #end   
 
 
#ifdef (showgroundfog)
  addGroundFog (1800,120,0 ,<1000,200,1000>,Red)   
  addGroundFog (800,120,0 ,<1000,200,1000>,Red)   
  addGroundFog (0,120,0 ,<1000,200,1000>,Red)   
  addGroundFog (-1000,120,0 ,<1000,200,1000>,Red)    
  addGroundFog (-2000,120,0 ,<1000,200,1000>,Blue)  
 
  addGroundFog (1800,120,-800 ,<1000,200,1000>,Red)   
  addGroundFog (800,120,-800 ,<1000,200,1000>,Red)   
  addGroundFog (0,120,-800 ,<1000,200,1000>,Red)   
  addGroundFog (-1000,120,-800 ,<1000,200,1000>,Red)    
  addGroundFog (-2000,120,-800 ,<1000,200,1000>,Blue) 
  
  addGroundFog (-4000,150,3000 ,<1000,200,1000>,Blue) 
#end

    
 
 
 //===========================================================

fog{   
//    color rgbf <.83,.83,.83,0>
    color rgbf <.80,.80,.80,0>
    fog_type 2
    fog_alt 35 // fade rate
    fog_offset 105
    distance 650
    turbulence 2
    omega 0.4
    translate<-1000,0,0>
}




/*
     Total length of Bridge including approaches:
     1.7 miles = 8,981 ft = 2,737 m

     Length of suspension span including main span and side spans:
     1.2 miles = 6,450 ft = 1,966 m

     Length of main span portion of suspended structure (distance
     between towers):
     4,200 ft = 1,280 m

     Length of one side span:
     1,125 ft = 343 m

     Width of Bridge:
     90 ft = 27 m

     Width of roadway between curbs:
     62 ft = 19 m

     Width of sidewalk:
     10 ft = 3 m

     Clearance above mean higher high water:
     220 ft = 67 m

     Deepest foundation below mean low water:
     110 ft = 34m

     Total weight of each anchorage:
     60,000 tons = 109,000,000 kg

     Original combined weight of Bridge, anchorages, and approaches:
     894,500 tons = 811,500,000 kg

     Total weight of Bridge, anchorages, and approaches (1937):
     894,500 tons = 811,500,000 kg

     Total weight of Bridge, anchorages, and approaches (1986)*:
     887,000 tons = 804,700,00 kg*

     Weight of Bridge not including anchorages and north and south
     approaches and including suspended structure, towers, piers and
     fenders, bottom lateral system and orthotropic redecking (1986)*:
     419,800 tons = 380,800,000 kg*

 *
   The total bridge weight listed for 1986 includes the reduction in
   weight due to the redecking in 1986. The weight of the original
   reinforced concrete deck and its supporting stringers was 166,397
   tons (150,952,000 kg). The weight of the new orthotropic steel plate
   deck, its two inches of epoxy asphalt surfacing, and its supporting
   pedestals is now 154,093 tons (139,790,700 kg). This is a total
   reduction in weight of the deck of 12,300 tons (11,158,400 kg), or
   1.37 tons (1133 kg) per lineal foot of deck.


     Live load capacity per lineal foot:
     4,000 lbs. = 1,814.4 kg

     Maximum transverse deflection, center span:
     27.7 ft = 8.4 m

     Maximum downward deflection, center span:
     10.8 ft = 3.3 m

     Maximum upward deflection, center span:
     5.8 ft = 1.77 m

 

 Concrete Quantities
                                         Cu. yd.
                                                        Cu. m.
 San Francisco Pier and Fender
                                         130,000
                                                         99,400
 Marin Pier
                                          23,500
                                                         18,000
 Anchorages, Pylons, and Cable Housing
                                         182,000
                                                       139,160
 Approaches
                                          28,500
                                                         21,800
 Paving
                                          25,000
                                                         19,115
    

    
 Structural Steel Quantities
                                            Tons
                                                           Kg.
 Main Towers
                                          44,400
                                                     40,280,000
 Suspended Structure
                                          24,000
                                                     21,772,000
 Anchorages
                                           4,400
                                                      3,991,000
 Approaches
                                          10,200
                                                      9,250,000



Towers

     Height of tower above water:
     746 ft = 227 m

     Height of tower above roadway:
     500 ft = 152 m

     Tower base dimension (each leg):
     33 x 54 ft = 10 x 16 m

     Load on each tower from main cables:
     61,500 tons = 56,000,000 kg

     Weight each tower:
     44,000 tons = 40,200,000 kg

     Transverse deflection of Towers:
     12.5 inches = 0.32 m

     Longitudinal deflection of Towers
     shoreward: 22 in = 0.56 m
     channelward: 18 in = 0.46 m



Main Cables

     Diameter of main cable with wrapping:
     36 3/8 in. = .92 m

     Length of one main cable:
     7,650 ft = 2,332 m

     Total length of wire used in one main cable:
     80,000 mi = 129,000 km 

     Number of wires in each cable:
     27,572

     Number of strands in each cable:
     61

     Weight of Main Cables, Suspender Cables & Accessories:
     24,500 tons = 22,200,000 kg



Primary Contractors

 Main Piers
                                     Pacific Bridge Company
 Anchorages and Approach Piers
                                     Barrett & Hilp
 Structural Steel of Suspension Span
                                     Bethlehem Steel Company
 Cables of the Suspension Span
                                     John A. Roebling's Sons
                                     Company
 Structural Steel of Approaches
                                     J.H. Pomeroy & Company, and
                                     Raymond Concrete Pile
                                     Company
 Presidio Approach Road
                                     Eaton & Smith
 Pavement for Suspension Spans and
 Approaches
                                     Pacific Bridge Company, and
                                     Barrett & Hilp
 Electrical Work
                                     Alta Electric & Mechanical
                                     Company


 



Bridge Lighting 

     Roadway Lights: 
     128 from abutment to abutment. These are high pressure sodium
     (HPS), 250 watt each. 
     These lights were installed in 1972, 35 years after the completion of
     the Bridge.

     Tower Sidewalk Lights:
     24 total for the sidewalks around both towers. These are low
     pressure sodium, 35 watts each.

     Tower Decorative Lighting:
     12 above the roadway for each tower. These are high pressure
     sodium, 400 watts each.
     There are also 12 below the roadway for each tower; four are 150
     watts, four are 250 watts, and four are 400 watts. All are HPS.

     Pier Navigation Lights:
     South pier has one 1000 watt beacon facing north, and four 116
     watt lights on the fender, one on each side.
     North pier has three 116 watt lights on three sides facing the water.

     Main Cable Lights:
     There are eight 116 watt lights on each cable.

     Tower Lights:
     Each tower has an airway beacon, each beacon has two 750 watt
     lamps.

     Midspan:
     Eight lights mark the center of the Bridge below the deck at
     midspan; four on each side in a vertical column. The top three
     lights are white, the bottom light green.









*/  



//      height=450 width=800   +A0.3   height=720 width=1280 +A0.3