// Persistence of Vision Ray Tracer Scene Description File
// File: ?.pov
// Vers: 3.1
// Desc: Basic Scene Example
// Date: mm/dd/yy
// Auth: ?[esp]
//

#version 3.1;
      
       
#ifndef (useAsInclude) 
     
  #include "colors.inc" 
  #include "textures.inc"

  #declare internationalOrange = color red 0.969 green 0.220 blue 0.062;
 
  #declare goldenGate=
  texture{  
    pigment{internationalOrange*.8} 
    finish{
      Shiny
      ambient .15 
    } 
  }     





        
  global_settings{
    assumed_gamma 2.2
  }

// ----------------------------------------
  camera{  location  <0.0, 45, -200.0>
    direction 1.5*z
    right     4/3*x
    look_at   <0.0, 31.0,  0.0>
  }

  sky_sphere{
    pigment{
      gradient y
      color_map { [0.0 color blue 0.6] [1.0 color rgb 1] }
    }
  }

  light_source{
    0*x // light's position (translated below)
    color red 2.0  green 2.0  blue 2.0  // light's color
    translate <-30, 40, -30>*100
  }
#end
// ----------------------------------------
//plane { y, -1 pigment {color rgb <0.7,0.5,0.3>}}  

#declare streetLight = 
union{
  cylinder{<0,20+32,0>,<0,40+32,0>,.5 }
  cylinder{<0,38+32,0>,<12,37.25+32,0>,.25 }

  object{
    torus{ 15,.5 rotate<90,0,0> 
    clipped_by{plane{y,0 inverse}} 
    clipped_by{plane{x,0 } }
      scale<1,.5,1>
      translate<15,30+32,0>
    }  
  }
  
  pigment{Red}
} 

#declare roadSection=
union{ 
  box{<50,27.5,-45>,<-50,27.4,45>  }
  box{<50,19.5,-45>,<-50,19.4,45>  }  
  
  box{<-50,28,45-1.3>,<50,25,45+1.3>}
  box{<-50,28,-45-1.3>,<50,25,-45+1.3>}   
  
  box{<-50,0,45-1.3>,<50,3,45+1.3>}
  box{<-50,0,-45-1.3>,<50,3,-45+1.3>}   
  
  box{<-4.5,22.5,-45-1.3>,<4.50,28,-45-1.4>}
  box{<-4.5,22.5,45+1.3>,<4.50,28,45+1.4> }

  box{<-50,22.5,-45-1.3>,<-45.5,28,-45-1.4>}
  box{<50,22.5,-45-1.3>,<45.5,28,-45-1.4>}

  box{<-50,22.5,45+1.3>,<-45.5,28,45+1.4>}
  box{<50,22.5,45+1.3>,<45.5,28,45+1.4>}
 
  box{<-29,0,-45-1.3>,<-21,5.5,-45-1.4>}
  box{<29,0,45+1.3>,<21,5.5,45+1.4> }

  box{<-29,0,45+1.3>,<-21,5.5,45+1.4>}
  box{<29,0,-45-1.3>,<21,5.5,-45-1.4> }    
  
  
  
  
  box{<-.9,0,45+1.3>,<.9,28,45>}
  box{<-.9,0,-45-1.3>,<.9,28,-45>}

  box{<-.9+25,0,45+1.3>,<.9+25,28,45>}
  box{<-.9+25,0,-45-1.3>,<.9+25,28,-45>}
  box{<-.9-25,0,45+1.3>,<.9-25,28,45>}
  box{<-.9-25,0,-45-1.3>,<.9-25,28,-45>}
  
  
  
  
  box{<-50,0,45+1.3>,<-49.1,28,45>}
  box{<-50,0,-45-1.3>,<-49.1,28,-45>}

  box{<50,0,45+1.3>,<49.1,28,45>}
  box{<50,0,-45-1.3>,<49.1,28,-45>}
            
  box{<-.75,1,-45>,<.75,35,-45-1.3>  rotate<0,0,-41> translate<-25,0,0,>}          
  box{<-.75,1,-45>,<.75,35,-45-1.3>  rotate<0,0,-41> translate<25,0,0,>}          
            
  box{<-.75,1,-45>,<.75,35,-45-1.3>  rotate<0,0,41> translate<-25,0,0,>}          
  box{<-.75,1,-45>,<.75,35,-45-1.3>  rotate<0,0,41> translate<25,0,0,>}          
            
  box{<-.75,1,45>,<.75,35,45+1.3>  rotate<0,0,-41> translate<-25,0,0,>}          
  box{<-.75,1,45>,<.75,35,45+1.3>  rotate<0,0,-41> translate<25,0,0,>}          
            
  box{<-.75,1,45>,<.75,35,45+1.3>  rotate<0,0,41> translate<-25,0,0,>}          
  box{<-.75,1,45>,<.75,35,45+1.3>  rotate<0,0,41> translate<25,0,0,>}                       
   
//============= start road bed =================
    
  box{<50,30.5,-30>,<-50,30,30> pigment{White*.5}}   
  difference{
    box{<50,30,30.75>,<-50,33,32.25>}
  box{<50.5,3,0>,<-50.5,-3,4> rotate<-20,0,0> translate<0,31,32.0>}
    pigment{White*.5}
  }  
  
  
  difference{
    box{<50,30,-30.75>,<-50,33,-32.25>}
    box{<50.5,3,0>,<-50.5,-3,-4> rotate<20,0,0> translate<0,31,-32.0>}
    pigment{White*.5}
  }
                    
                    
  object{streetLight  rotate<0,90,0> translate<0,-20,32> }
  object{streetLight  rotate<0,-90,0> translate<0,-20,-32> }
  box{<50,31.75,42>,<-50,31.35,31> pigment{White}} 
  box{<50,31.75,-42>,<-50,31.35,-31> pigment{White}}     
/*
  union{
  cylinder{<52,35,41.6>,<-52,35,41.6>, 0.35}
  cylinder{<52,35,-41.6>,<-52,35,-41.6>, 0.35}
 
  cylinder{<52,32.25,41.6>,<-52,32.25,41.6>, 0.35}
  cylinder{<52,32.25,-41.6>,<-52,32.25,-41.6>, 0.35}
 
  
  #declare xx = -50; 
  #while (xx < 51)  
    box{<xx-.1,35,41.6-.1>,<xx+0.1,31.5,41.6+.1>}
    box{<xx-.1,35,-41.6-.1>,<xx+0.1,31.5,-41.6+.1>}
    #declare xx = xx + 1.5151516;  
  #end  
  pigment{Red*100}
  }
*/
//=================  end road bed ============================= 

  box{<50,27.5,41.08>,<-50,31.35,40.92>}  
  box{<50,27.5,-41.08>,<-50,31.35,-40.92>}  
  
  box{<50,31.2,41.5>,<-50,31.35,40.5>}  
  box{<50,31.2,-41.5>,<-50,31.35,-40.5>}  
  

  box{<50,27.5,41.5>,<-50,27.75,40.5>}  
  box{<50,27.5,-41.5>,<-50,27.75,-40.5>}  

  texture{goldenGate}

}

#ifndef (useAsInclude)  
  object{roadSection  rotate<0,90,0>
}
#end  