// Persistence of Vision Ray Tracer Scene Description File
// File: ?.pov
// Vers: 3.1
// Desc: Basic Scene Example
// Date: mm/dd/yy
// Auth: ?[esp]
//
     
#version 3.1;


//#declare useAsInclude=1;
             
#ifndef (useAsInclude)  
  #include "colors.inc" 
  #include "textures.inc"

  #declare internationalOrange = color red 0.969 green 0.220 blue 0.062;
 
  #declare goldenGate=
  texture{  
    pigment{internationalOrange*.8} 
    finish{
      Shiny
      ambient .15 
    } 
  }             
 


  global_settings{
    assumed_gamma 2.2
  }

// ----------------------------------------
  camera{
    location  <45, 300, -1700>
    direction 1.95*z
    right     4/3*x
    look_at   <45, 350,  0.0>
  }

  sky_sphere{
    pigment{
      gradient y
      color_map { [0.0 color blue 0.6] [1.0 color rgb 1] }
    }
  }

  light_source{
    0*x // light's position (translated below)
    color red 2.0  green 2.0  blue 2.0  // light's color
    translate <10, 30, -30>*2000
  }

// ----------------------------------------
//plane { y, -1 pigment {color rgb <0.7,0.5,0.3>}}

  sphere { 0.0, 1 texture {pigment {radial frequency 8} finish{specular 1}} }
#end

#declare decTrim=
union{
  box{<0,0,6>,<1.5,-50,-6>}
  box{<0,0,5.75>,<3.0,-35,-5.75>}
  box{<0,0,5.5>,<4.5,-15,-5.5>}
  box{<0,0,5.25>,<6,-6.25,-5.25>}
  texture{goldenGate}     
}    




 #declare trim=
   box{<2,-6,-2>,<-2,-22,2> rotate<0,45,0> scale<3,1,1.25> translate<0,0,-4> texture{goldenGate} }  

#declare upperStrut=   
union{ 
  box{<-45,0,-6>,<45,-28,6>}   
   
  box{<0,0,-6>,<3.5,-3.5,6> rotate<0,0,45>   translate<24.5,0,0>}    
  box{<0,0,-6>,<-3.5,-3.5,6> rotate<0,0,-45> translate<-24.5,0,0>}    
  
  box{<26.975,2.475,-6>,<45,-28,6>}   
  box{<-26.975,2.475,-6>,<-45,-28,6>}   

  box{<0,0,-6>,<2.5,-2.5,6> rotate<0,0,45> translate<37.75,2.475,0> }    
  box{<0,0,-6>,<-2.5,-2.5,6> rotate<0,0,-45> translate<-37.75,2.475,0> }
  
    
  box{<-39.517,4.28,-6>,<-45,-28,6>}    
  box{<39.517,4.28,-6>,<45,-28,6>}    
  
  box{<45,1,1>,<-45,-1,-1>  rotate<45,0,0> translate<0,-1.414,-6> }
  box{<45,1,1>,<-45,-1,-1>  rotate<45,0,0> translate<0,-28+1.414,-6>} 


  box{<0,0,-6>,<2.2,2.2,6> rotate<0,0,-45> translate<24.5,-28,0>}    
  box{<0,0,-6>,<-2.2,-2.2,6> rotate<0,0,-45> translate<-24.5,-28,0>}
    
  box{<0,0,-6>,<-2.2,-2.2,6> rotate<0,0,-45> translate<-24.5,-28,0>}  
  box{<0,0,-6>,<2.2,2.2,6> rotate<0,0,45> translate<-24.5,-28,0>}  
  
  box{<-45,-10,-6>,<-24.4-1.555,-29.555,6>}   
  box{<45,-10,-6>,<24.5+1.555,-29.555,6>}  
    
  box{<0,0,6>,<2.2,-2.2,-6>  rotate<0,0,45> translate<31,-29.555,0> }  
  box{<0,0,6>,<-2.2,-2.2,-6>  rotate<0,0,-45> translate<-31,-29.555,0>}

  
  box{<32.555,-10,6>,<45,-31.11,-6> }  
  box{<-32.555,-10,6>,<-45,-31.11,-6> }  
                                                                         
  #declare xx=-32.5;
  #while (xx < 35) 
    object{trim translate<xx,0,0>}
    #declare xx=xx+5;  
  #end
  texture{goldenGate}  
}   

                          
#declare towerSection=                          
union{        
//section A
  box{<0,734,12.25>,<5.25,73,0> }   
           
//section B           
  difference{
    box{<0,642,15.66>,<8.66,73,0>}
    box{<5.25,1000,16>,<10,0,5.25>}                      
  }
           
//section C           
  difference{
    box{<0,585,19.25>,<8.66,73,0>}
    box{<5.25,1000,20>,<10,0,8.66>}
  }

//section D
  difference{
    box{<0,532,19.25>,<12.25,73,0>}
    box{<5.25,1000,20>,<15,0,8.66>}
    box{<8.66,1000,20>,<15,0,5.25>}
  }

//section E
  difference{
    box{<0,402,22.66>,<12.25,73,0>}
    box{<5.25,1000,23>,<15,0,12.25>}
    box{<8.66,1000,20>,<15,0,5.25>}
  }
   texture{goldenGate}
}              

#declare mtowerSection=                          
union{        
//section A
  box{<0,734,12.25>,<-5.25,73,0>}   
           
//section B           
  difference{
    box{<0,642,15.66>,<-8.66,73,0>}
    box{<-5.25,1000,16>,<-10,0,5.25>}                     
  }
           
//section C           
  difference{
    box{<0,585,19.25>,<-8.66,73,0>}
    box{<-5.25,1000,20>,<-10,0,8.66>}
  }

//section D
  difference{
    box{<0,532,19.25>,<-12.25,73,0>}    
    box{<-5.25,1000,20>,<-15,0,8.66>}
    box{<-8.66,1000,20>,<-15,0,5.25>}
  }

//section E
  difference{
    box{<0,402,22.66>,<-12.25,73,0>}
    box{<-5.25,1000,23>,<-15,0,12.25>}
    box{<-8.66,1000,20>,<-15,0,5.25>}
  }
                          

  #declare bottomStrut=
  union{
    box{<-45,-4,-5>,<45,4,5 >  }
    box{<-45,-4-80,-5>,<45,4-80,5 >}
  
    box{<-36,0,-5>,<-22,-16,5>  }  
    box{<36,0,-5>,<22,-16,5>  }   
           
    box{<-36,-80,-5>,<-22,-64,5>  }  
    box{<36,-80,-5>,<22,-64,5>  }
  
    box{<0,4,-5>,<100,-4,5> rotate<0,0,-48> translate<-36,0,0>} 
    box{<0,4,-5>,<-100,-4,5> rotate<0,0,48> translate<36,0,0>} 
  
    box{<-10,-28,-5>,<10,-50,5>}  
    texture{goldenGate} 
      
  } 
   texture{goldenGate}   
}              

#declare towerLeg=
union{
  object{towerSection rotate<0,0,0>}
  object{towerSection rotate<0,180,0>} 
  
  object{mtowerSection rotate<0,0,0>}
  object{mtowerSection rotate<0,180,0>} 
} 
        
 #declare gusset1=
 prism {
    linear_sweep
    linear_spline
    0, // sweep the following shape from here ...
    .5, // ... up through here
    5, // the number of points making up the shape ...
    <0,0>, <12,0>, <12,-1>, <0,-6>, <0,0>
    texture{goldenGate} 
    rotate<-90,0,0>
  }                 
  
 #declare gusset2=
 prism {
    linear_sweep
    linear_spline
    0, // sweep the following shape from here ...
    .5, // ... up through here
    5, // the number of points making up the shape ...
    <0,0>, <14,0>, <14,-1>, <0,-6>, <0,0>
    texture{goldenGate}  
    rotate<-90,0,0>
  }                 
  
 #declare gusset3=
 prism {
    linear_sweep
    linear_spline
    0, // sweep the following shape from here ...
    .5, // ... up through here
    5, // the number of points making up the shape ...
    <0,0>, <11,0>, <11,-1>, <0,-6>, <0,0>
    texture{goldenGate}  
    rotate<-90,0,0>
  }                 
  
 #declare xsidewalk=
 prism {
    linear_sweep
    linear_spline
    0, // sweep the following shape from here ...
    .5, // ... up through here
    21, // the number of points making up the shape ...
    <32.969,-15>, <32.969,10.398>, <23.39,21.899>, <7.083,23.817>,
    <-7.083,23.817>, <-23.39,21.899>, <-32.969,10.398>, <-32.969,-15>,
    <-23,-15>, <-23,5.75>, <-12.5,5.75>, <-12.5,9>, <-5,9>
    <-5,12>, <5,12>,<5,9>, <12.5,9>, <12.5,5.75>, <23,5.75>
    <23,-15>, <32.969,-15>
    pigment { White }
    rotate<0,0,0>
  }                 
  
  
  
#declare sidewalk=
union{  
  object{gusset1 rotate<0,-100> translate<-5,0,12> }
  object{gusset1 rotate<0,-80> translate<5,0,12> }

  object{gusset2 rotate<0,-135> translate<-12.5,0,9> }
  object{gusset2 rotate<0,-45> translate<12.5,0,9> } 
  
  
  object{gusset3 rotate<0,-25> translate<23,0,5.75> }
  object{gusset3 rotate<0,-155> translate<-23,0,5.75> }


  union{  
    cylinder{<32.969,0,10.398>,<32.969,4,10.398>, .25}
    cylinder{<-32.969,0,10.398>,<-32.969,4,10.398>, .25}
    cylinder{<23.39,0,21.899>,<23.39,4,21.899>, .25}
    cylinder{<-23.39,0,21.899>,<-23.39,4,21.899>, .25}
    cylinder{<7.083,0,23.816>,<7.083,4,23.817>, .25}
    cylinder{<-7.083,0,23.816>,<-7.083,4,23.817>, .25}

    cylinder{<32.969,3.75,10.398>,<23.39,3.75,21.899>, .25}
    cylinder{<32.969,1.75,10.398>,<23.39,1.75,21.899>, .25}

    cylinder{<-32.969,3.75,10.398>,<-23.39,3.75,21.899>, .25}
    cylinder{<-32.969,1.75,10.398>,<-23.39,1.75,21.899>, .25}


    cylinder{<7.083,3.75,23.817>,<23.39,3.75,21.899>, .25}
    cylinder{<-7.083,3.75,23.817>,<-23.39,3.75,21.899>, .25}

    cylinder{<7.083,1.75,23.817>,<23.39,1.75,21.899>, .25}
    cylinder{<-7.083,1.75,23.817>,<-23.39,1.75,21.899>, .25}

    cylinder{<7.083,3.75,23.817>,<-7.083,3.75,23.817>, .25}
    cylinder{<7.083,1.75,23.817>,<-7.083,1.75,23.817>, .25}
    texture{goldenGate}  
  }
  object{xsidewalk}
}

          
#declare towerTop=  
union{ 
  difference{
    union{
      box{<5,734.5,11>,<-5,742,-11>}  
      box{<5.5,734,11.5>,<-5.5,734.8,-11.5> pigment{Black}}  
 
      difference{
        cylinder{<5,720.65,0>,<-5,720.65,0>, 24}     
        box{<6,742,60>,<-6,690,-60>}
      }
    }  
    torus{24,2 rotate<0,0,90> translate<0,720.65,0>}
    torus{23,2 rotate<0,0,90> translate<0,720.65,0>}
    torus{22,2 rotate<0,0,90> translate<0,720.65,0>}
  }                

  difference{
    box{<2,742,3.5>,<-2,751,-3.5>}  
    
    box{<-8,0,0>,<8,-20,10> rotate<-15,0,0>  translate<0,755,0>}
    box{<-8,0,0>,<8,-20,-10> rotate<15,0,0>  translate<0,755,0>}
  }                                             
  
  cylinder{<0,751,0>,<0,750.75,0>,3} 
  
  torus{2.625,0.125  rotate<0,0,0> translate<0,752.5,0> }
  torus{2.625,0.125  rotate<0,0,0> translate<0,754,0> } 
        
  #declare xx = 0;
  #while (xx < 360)      
    cylinder{<2.625,751,0>,<2.625,754,0>,0.125 rotate<0,xx,0>}
    #declare xx=xx+45;
  #end  

  cylinder{<0,751,0>,<0,755,0>,0.5 }
  cylinder{<0,756,0>,<0,755,0>,1 }
  cylinder{<0,756,0>,<0,757,0>,0.125 }
   
   
  difference{ 
    sphere{<0,0,0>, 1  } 
    box{<-2,2,2>,<2,-2,.5>}                      
    scale<1,1,.625>
    translate<0,757.5,0>
    texture{Aluminum}  
  }                           
  texture{goldenGate} 
}
        

#declare pier=
union{
  difference{
    box{<-67,0,-32.5>,<67,42,32.5>}
    box{<-30,10,-50>,<30,50,-27.5>}
  }               
  #declare xx = -30;                                       
  #while (xx < 30)
    box{<1.5,10,1.5>,<-1.5,42,-1.5>  rotate<0,45,0>  translate<xx,0,-27.5>}
    #declare xx = xx + 6;
  #end  
  
  difference{
    cylinder{<0,-15,0>,<0,15,0>, 145 } 
    cylinder{<0,-25,0>,<0,25,0>, 135 }
    scale<1,1,.5> 
  }
  pigment{White*.8}
  finish {crand .15 }
}

#declare tower=
union{
  object{towerLeg translate<45,0,0>}
  object{towerLeg translate<-45,0,0>}  
  object{upperStrut translate<0,729,0>   }
  object{upperStrut translate<0,630,0>   }
  object{upperStrut scale<.9,15/11,1> translate<0,525,0>   }
  object{upperStrut scale<.9,15/11,1> translate<0,392,0>   }
    
  object{bottomStrut  translate<0,236,0>}
  object{bottomStrut  translate<0,156,0>}  
  object{towerTop translate<-45,0,0>} 
  object{towerTop translate<45,0,0>} 

  object{pier}  
  
  object{decTrim translate<-32.75,353,0>} 
  object{decTrim rotate<0,180,0>  translate<32.75,353,0>}  
  
  
  object{decTrim translate<-32.75,484,0>} 
  object{decTrim rotate<0,180,0>  translate<32.75,484,0>} 
  
  object{decTrim rotate<180,0,0> translate<-32.75,395,0>} 
  object{decTrim  rotate<180,0,0> rotate<0,180,0>  translate<32.75,395,0>} 
  
  
  object{decTrim scale<1,.6,1>   translate<-36.34,600,0>} 
  object{decTrim scale<1,.6,1>   rotate<0,180,0>  translate<36.34,600,0>} 
  
  
  object{decTrim scale<1,.6,1> rotate<180,0,0> rotate<0,0,0> translate<-36.34,528,0>} 
  object{decTrim scale<1,.6,1> rotate<180,0,0> rotate<0,180,0> translate<36.34,528,0>} 
  
  object{decTrim scale<1,.5,1>   translate<-39.75,698,0>} 
  object{decTrim scale<1,.5,1>  rotate<0,180,0> translate<39.75,698,0>} 
  
    object{decTrim scale<1,.5,1> rotate<180,0,0>  translate<-39.75,633,0>} 
    object{decTrim scale<1,.5,1> rotate<180,0,0> rotate<0,180,0> translate<39.75,633,0>} 

  
  
  
  object{sidewalk  rotate<0,90,0> translate<45,246,0>}
  object{sidewalk  rotate<0,-90,0> translate<-45,246,0>}  
  


  
  union{   
    box{<-9.5,73,27>,<9.5,44,-27>}
    box{<-13,73,16.5>,<13,44,-16.5>}
    box{<-16.5,73,9.5>,<16.5,44,-9.5>}
    translate<45,0,0>                                                                  
    texture{goldenGate} 
  }  
  union{   
    box{<-9.5,73,27>,<9.5,44,-27>}
    box{<-13,73,16.5>,<13,44,-16.5>}
    box{<-16.5,73,9.5>,<16.5,44,-9.5>}
    translate<-45,0,0>                                                                  
    texture{goldenGate} 
  }    
}  
  
#ifndef (useAsInclude)  
  object{tower  rotate<0,50,0>}
#end

                                                                   