
// POV-Ray Object File - Clipper Ship
// created 16-Aug-99
// last update 30-Aug-99
// 1999 Glenn McCarter
// This file does not render.  #include "ClipperShip.inc" in another .pov file
// Required #include files: (none)
//
// Objects:
// Ship -- a clipper ship based on the Ann McKim of 1832
//
// Intended scale is English system (inches)
// Uses LH coordinate reference system (Y=up)

// Requires the following files:
#include "SailFore01.inc"
#include "MainSail01.inc"
#include "ShipHull03.inc"

//===============================================
//             Variables
//===============================================


//===============================================
//             Textures
//===============================================

#declare HullTex =
	texture {
		pigment { color rgb <0.325,0.235,0.129> }
		normal { bumps .38 scale <1,1,.5>*1.5*Feet } 
		finish { ambient .13 specular .12 roughness .08 reflection 0 }
	}
#declare HullWhitewashTex =
	texture {
		pigment { color rgb <0.898,0.886,0.924> }
		normal { bumps .18 scale 5*Feet } 
		finish { ambient .17 specular .48 roughness .059 }
	}
#declare DeckTex =
	texture {
		pigment { color rgb <0.425,0.435,0.129> }
		normal { bumps .18 scale 0.5*Feet } 
		finish { ambient .13 specular .62 roughness .18 reflection 0 }
	}
#declare SparTex =
	texture {
		pigment { color rgb <0.425,0.335,0.229> }
		normal { bumps .08 scale 1.5*Feet } 
		finish { ambient .13 specular .32 roughness .08 reflection 0 }
	}
#declare SailTex =
	texture {
		pigment { color rgbf <0.898,0.886,0.804,.12> }
		normal { bumps .18 scale 5*Feet } 
		finish { ambient .23 specular .08 roughness .128 }
	}
#declare RopeTex =
	texture {
		pigment { color rgb <0.598,0.486,0.304> }
		normal { bumps .18 scale 1.1 } 
		finish { ambient .13 specular .08 roughness .128 }
	}
#declare PulleyTex =
	texture {
		pigment { color rgb <0.298,0.286,0.204> }
		normal { bumps .18 scale 1.1 } 
		finish { ambient .13 specular .39 roughness .068 }
	}


//===============================================
//						 Objects
//===============================================

//--------------- Clipper Ship --------------------


#declare ForeSail =
	object {
		ForeSailShape
		scale 600
		texture { SailTex }
	}
#declare MainSail =
	object {
		MainSailShape
		scale 600
		texture { SailTex }
	}

#declare BowGroup =
	union {
		object { ForeSail rotate <0,16,-24> translate <-38*Feet,2*Feet,0> }
		cylinder { // foresail forerope 1
			<0,0,0>,<-70,0,0>,0.85
			texture { RopeTex }
			rotate <0,0,23>
			translate <-34.0*Feet,4.0*Feet,-1>
		}
		cylinder { // foresail forerope 2
			<0,0,0>,<-70,0,0>,0.85
			texture { RopeTex }
			rotate <0,0,23>
			translate <-34.0*Feet,4.0*Feet,1>
		}
		cylinder { // foresail aftrope 1
			<0,0,0>,<18*Feet,0,0>,.85
			texture { RopeTex }
			rotate <0,-20,-44>
			translate <-8.0*Feet,10.0*Feet,-6*Feet>
		}
		cylinder { // foresail aftrope 2
			<0,0,0>,<18*Feet,0,0>,.85
			texture { RopeTex }
			rotate <0,-20,-44>
			translate <-8.0*Feet-1,10.0*Feet-1,-6.1*Feet>
		}
		object { ForeSail rotate <0,25,-24> translate <-14*Feet,2*Feet,0> }
		cylinder { // jibsail forerope 1
			<0,0,0>,<-70,0,0>,0.85
			texture { RopeTex }
			rotate <0,0,23>
			translate <-10.0*Feet,4.0*Feet,-1>
		}
		cylinder { // jibsail forerope 2
			<0,0,0>,<-70,0,0>,0.85
			texture { RopeTex }
			rotate <0,0,23>
			translate <-10.0*Feet,4.0*Feet,1>
		}
		cylinder { // jibsail aftrope 1
			<0,0,0>,<12*Feet,0,0>,.85
			texture { RopeTex }
			rotate <0,-20,-68>
			translate <10.5*Feet,8.0*Feet,-5*Feet>
		}
		cylinder { // jibsail aftrope 2
			<0,0,0>,<12*Feet,0,0>,.85
			texture { RopeTex }
			rotate <0,-20,-68>
			translate <10.5*Feet-1,8.0*Feet-1,-5*Feet>
		}
		torus { // jibsail aft connection
			5,.6
			texture { PulleyTex }
			rotate <-32,34,24>
			translate <10.5*Feet-1,8.0*Feet-1,-5*Feet>
		}
		cylinder { // 1Line1
			<0,0,0>,<0,60*Feet,0>,0.3
			rotate <0,0,-20>
			translate <-39*Feet,16,0>
			texture { RopeTex }
		}
		cylinder { // 1LineSupport1
			<0,0,0>,<0,4.6*Feet,0>,0.6
			rotate <0,0,-20>
			translate <-39*Feet,16,0>
			texture { RopeTex }
		}
		cylinder { // 1Line2
			<0,0,0>,<0,60*Feet,0>,0.3
			rotate <0,0,-24>
			translate <-39.1*Feet,16,0>
			texture { RopeTex }
		}
		cylinder { // 1Line3
			<0,0,0>,<0,60*Feet,0>,0.3
			rotate <0,0,-26>
			translate <-39.2*Feet,16,0>
			texture { RopeTex }
		}
		cylinder { // 2Line1
			<0,0,0>,<0,60*Feet,0>,0.3
			rotate <0,0,-22>
			translate <-14.1*Feet,16,0>
			texture { RopeTex }
		}
		cylinder { // 2Line2
			<0,0,0>,<0,60*Feet,0>,0.3
			rotate <0,0,-25>
			translate <-14.3*Feet,16,0>
			texture { RopeTex }
		}
		box { // bow support
			<-3*Feet,-36,-11>,<8*Feet,-10,11>
		}
		box { // bow support clamp
			<-1*Feet,-38,-13>,<-1.6*Feet,-8,13>
		}
		cylinder { // bowspar support clamp
			<-1*Feet,0,0>,<-1.6*Feet,0,0>,12
			translate <0,0,0>
		}
		cone { // bowspar
			<24*Feet,0,0>,10,<-16*Feet,0,0>,9.0
		}
		cone { // bowsprit
			<-7.3*Feet,0,0>,5.6,<-40*Feet,0,0>,3.4
			translate <0,14.6,0>
		}
		sphere { // bowsprit end
			<0,0,0>,3.4
			scale <4.3,1,1>
			translate <-40*Feet,14.6,0>
		}
		cylinder { // bowsprit end rope clamp
			<0,0,0>,<3,0,0>,4.8
			translate <-39.6*Feet,14.6,0>
			texture { PulleyTex }
		}
		box { // sprit fore binder
			<-1.8,-16,-13>,<2.8,24,13>
			translate <-15.5*Feet,0,0>
			texture { HullWhitewashTex }
		}
		cylinder { // spar binder bottom
			<-2.8,0,0>,<2.8,0,0>,11
			translate <-8*Feet,0,0>
			texture { HullWhitewashTex }
		}
		cylinder { // spar binder top
			<-2.8,0,0>,<2.8,0,0>,9
			translate <-8*Feet,12,0>
			texture { HullWhitewashTex }
		}
		cylinder { // left walk support
			<0,0,0>,<0,-60,0>,1.3
			rotate x*20
			translate <-16*Feet,0,0>
		}
		cylinder { // left walk support
			<0,0,0>,<0,-60,0>,1.3
			rotate x*-20
			translate <-16*Feet,0,0>
		}
		cylinder { // left front walk rope
			<0,0,0>,<-25*Feet,0,0>,.43
			rotate z*-14
			translate <-16*Feet,-60,0>
			rotate x*-20
			texture { RopeTex }
		}
		cylinder { // right front walk rope
			<0,0,0>,<-25*Feet,0,0>,.43
			rotate z*-14
			translate <-16*Feet,-60,0>
			rotate x*20
			texture { RopeTex }
		}
		cylinder { // left rear walk rope
			<12*Feet,0,0>,<0*Feet,0,0>,.43
			rotate z*15
			translate <-16*Feet,-60,0>
			rotate x*-20
			texture { RopeTex }
		}
		cylinder { // right rear walk rope
			<12*Feet,0,0>,<0*Feet,0,0>,.43
			rotate z*15
			translate <-16*Feet,-60,0>
			rotate x*20
			texture { RopeTex }
		}
		cylinder { // right bow chain
			<24*Feet,0,0>,<0,0,0>,1.13
			rotate <0,6,-16>
			translate <-12*Feet,-12,0>
			texture { RopeTex }
		}
		cylinder { // left bow chain
			<24*Feet,0,0>,<0,0,0>,1.13
			rotate <0,-6,-16>
			translate <-12*Feet,-12,0>
			texture { RopeTex }
		}
		texture { HullTex }
	} // end union


#declare FrontMast =
	union {
		cone { // main
			<0,0,0>,12,<0,62*Feet,0>,10
		}
		cone { // upper
			<0,55*Feet,0>,8,<0,70*Feet,0>,4
			translate <-6,0,0>
		}
		texture { SparTex }
	} // end union
#declare RS = seed(10395);
#declare RingGroup =
	union {
		#declare RN = 1;
		#while ( RN < 40 )
			torus {
				18,.45
				texture { PulleyTex }
				rotate <rand(RS)*12,0,rand(RS)*12>
				translate <4,RN*2*Feet,0>
			}
			#declare RN = RN + 1;
		#end
	} // end union
#declare TopGallantLowerSpar =
	union {
		cone { // left
			<0,0,0>,4.8,<0,0,26*Feet>,2.3
		}
		cone { // right
			<0,0,0>,4.8,<0,0,-26*Feet>,2.3
		}
		texture { SparTex }
	} // end union
#declare JibBoom =
	union {
		cone { // front
			<0,0,0>,3.2,<0,0,13*Feet>,5.6
		}
		cone { // rear
			<0,0,13*Feet>,5.6,<0,0,26*Feet>,3.2
		}
		rotate z*45
		texture { SparTex }
	} // end union
#declare FrontMastGroup =
	union {
		object { FrontMast }
		object { RingGroup }
		object { MainSail rotate <0,18,0> translate <0,12*Feet,0> }
		object { TopGallantLowerSpar rotate <0,-20,0> translate <-12,55*Feet,0> }
		object { JibBoom rotate <0,18,0> translate <12,49*Feet,0> }
	}

#declare MastRope =
	union {
		cylinder {
			<0,4*Feet,0>,<0,90*Feet,0>,.34
		}
		cylinder {
			<0,0*Feet,0>,<0,-4*Feet,0>,.34
			rotate x*-15
			translate <0,4*Feet,3>
		}
		cylinder {
			<0,0*Feet,0>,<0,-4*Feet,0>,.34
			rotate x*-15
			translate <0,4*Feet,-3>
		}
		cylinder { // upper pulley
			<-1,4*Feet,0>,<1,4*Feet,0>,2.0
			texture { PulleyTex }
		}
		cylinder { // lower pulley
			<-1,-4*Feet,0>,<1,-4*Feet,0>,2.0
			rotate x*-15
			translate <0,4*Feet,0>
			texture { PulleyTex }
		}
		texture { RopeTex }
	} // end union
#declare MastRopeGroup =
	union {
		object { MastRope rotate <0,0,0> translate <0,0,0> }
		object { MastRope rotate <0,0,-2.3> translate <-2*Feet,0,0> }
		object { MastRope rotate <0,0, 2.3> translate < 2*Feet,0,0> }
		object { MastRope rotate <0,0,-1.6> translate <-1.2*Feet,0,0> }
		object { MastRope rotate <0,0, 1.6> translate < 1.2*Feet,0,0> }
		box { // upper
			<-2.6*Feet,4.3*Feet,-5>,<2.6*Feet,4.54*Feet,5>
			texture { HullTex }
		}
		box { // lower
			<-2.6*Feet,0,-5>,<2.6*Feet,4,25>
			texture { HullTex }
		}
	} // end union

#declare DeckJunkHalf =
	union {
		box {
			<-5,0*Feet,-4>,<5,6.2*Feet,4>
			texture { HullWhitewashTex }
			translate <0*Feet,0,1*Feet>
		}
		box {
			<-8,-3*Feet,-14>,<8,2.2*Feet,14>
			texture { HullWhitewashTex }
			translate <7*Feet,0,3*Feet>
		}
		box {
			<-4.2,-3*Feet,-4>,<4.2,3.6*Feet,4>
			texture { HullTex }
			rotate <12,0,0>
			translate <3*Feet,0,3*Feet>
		}
		box {
			<-4.2,-3*Feet,-4>,<4.2,3.6*Feet,4>
			texture { HullTex }
			rotate <12,0,0>
			translate <6*Feet,0,4*Feet>
		}
		box {
			<-4.2,-3*Feet,-4>,<4.2,3.6*Feet,4>
			texture { HullTex }
			rotate <12,0,0>
			translate <9*Feet,0,5*Feet>
		}
		cylinder {
			<0,-4*Feet,0>,<0,3*Feet,0>,1.1*Feet
			texture { PulleyTex }
			translate <16*Feet,0,0>
		}
		cylinder {
			<0,-4*Feet,0>,<0,3.7*Feet,0>,0.5*Feet
			texture { PulleyTex }
			translate <16*Feet,0,0>
		}
	} // end union
#declare DeckJunk =
	union {
		object { DeckJunkHalf }
		object { DeckJunkHalf scale <1,1,-1> }
	}

#declare PulleyGroup =
	union {
		cylinder {
			<-1,0,0>,<1,0,0>,4
			texture { PulleyTex }
		}
		cylinder { // uprope1
			<0,0,0>,<0,70*Feet,0>,.3
			texture { RopeTex }
			translate <0,0,-4>
		}
		cylinder { // uprope2
			<0,0,0>,<0,70*Feet,0>,.3
			texture { RopeTex }
			translate <0,0,4>
		}
		cylinder { // downrope1
			<0,0,0>,<0,-5*Feet,0>,.3
			texture { RopeTex }
			translate <1.3,0,0>
		}
		cylinder { // downrope2
			<0,0,0>,<0,-5*Feet,0>,.3
			texture { RopeTex }
			translate <-1.3,0,0>
		}
	} // end union

#declare Ship = // origin at waterline under front of hull
	union {
		object { BowGroup rotate z*-20 translate <0,12.5*Feet,0> }
		object { FrontMastGroup rotate z*-8 translate <20*Feet,0,0> }
		object { MastRopeGroup rotate <8,0,-8> translate <20*Feet,12*Feet,-16*Feet> }
		object { MastRopeGroup scale <1,1,-1> rotate <-8,0,-8> translate <20*Feet,12*Feet,16*Feet> }
		object { DeckJunk translate <0,10*Feet,0> }
		object { PulleyGroup rotate <0,4,-11> rotate <5,0,0> translate <12*Feet,16*Feet,-6*Feet> }
		object { PulleyGroup rotate <0,-12,-11> rotate <-5,0,0> translate <12*Feet,16*Feet,6*Feet> }
		object { PulleyGroup rotate <0,-27,-11> rotate <5,0,0> translate <33*Feet,16*Feet,-18*Feet> }
		object { PulleyGroup rotate <0, 12,-11> rotate <-5,0,0> translate <33*Feet,16*Feet,18*Feet> }
		object { PulleyGroup rotate <0,-16,-11> rotate <5,0,0> translate <35*Feet,16*Feet,-18*Feet> }
		object { PulleyGroup rotate <0, 26,-11> rotate <-5,0,0> translate <35*Feet,16*Feet,18*Feet> }
		object { MastRopeGroup rotate <8,0,-8> translate <40*Feet,10*Feet,-22.6*Feet> }
		object { MastRopeGroup scale <1,1,-1> rotate <-8,0,-8> translate <40*Feet,10*Feet,22.6*Feet> }
		object { // port hull
			ShipHullShape
			texture { HullTex }
			rotate <-90,-90,0>
			scale 2
			translate <60*Feet,0,0>
		}
		object { // starboard hull
			ShipHullShape
			texture { HullTex }
			rotate <-90,-90,0>
			scale <2,2,-2>
			translate <60*Feet,0,0>
		}
		object { // port board
			WhiteSideShape
			texture { HullWhitewashTex }
			rotate <-90,-90,0>
			scale 2
			translate <60*Feet,0,0>
		}
		object { // starboard board
			WhiteSideShape
			texture { HullWhitewashTex }
			rotate <-90,-90,0>
			scale <2,2,-2>
			translate <60*Feet,0,0>
		}
		object { // port deck
			DeckShape
			texture { DeckTex }
			rotate <-90,-90,0>
			scale 2
			translate <60*Feet,0,0>
		}
		object { // starboard deck
			DeckShape
			texture { DeckTex }
			rotate <-90,-90,0>
			scale <2,2,-2>
			translate <60*Feet,0,0>
		}
		texture { HullTex }
	} // end union




