
// POV-Ray Object File - Clouds
// created 1-Aug-99
// last update 30-Aug-99
// 1999 Glenn McCarter
// This file does not render.  #include "Clouds.inc" in another .pov file
// Required #include files: (none)
//
// Objects:
// CloudGroup1 - a filler cloud group
// CloudGroup2 - a tall storm cloud group
//
// Intended scale is metric system (centimeters)
// Uses LH coordinate reference system (Y=up)


//===============================================
//             Variables
//===============================================

// IMPORTANT! Put the following lines in your main scene and uncomment them:
//-----------
//#declare GoodClouds = 1; // 1 turns on real density, otherwise use simple spheres
//#include "Clouds.inc"
//-----------

// This function applies a random rotation to any object
#declare RSeed = seed(101095);
#macro RandRot()
	<rand(RSeed)*360,rand(RSeed)*360,rand(RSeed)*360>
#end

//===============================================
//             Textures
//===============================================

#declare WhitePaint = // for quick cloud
	texture {
		pigment { color rgb<.93,.97,.99> }
		normal { bumps .02 scale 1*Feet }
		finish { ambient .2 diffuse .7 specular .6 roughness .05 }
	}

#declare CloudTestTex = // for testing only
	texture {
		pigment { color rgb<.5,.5,.5> }
		normal { bumps .3 scale 3*Feet }
		finish { ambient .1 diffuse .7 specular .5 roughness .2 }
	}
#declare StormCloudInt =
	interior {
		media {
//			scattering { 1, <.02,.02,.02,> extinction 1.0 } // stinking choking black
//			scattering { 3, <.01,.01,.01,> extinction 1.0 } // charcoal grey with fuzzy fur
			scattering { 1, <.003,.003,.002,> extinction 1.0 } // white with dark undersides
//			scattering { 1, <.002,.002,.002,> extinction 1.0 } // soft fluffy with hot spot
	    density { spherical
				color_map{
					[0.0 color rgb <0.0,0.0,0.0> ] // outside is transparent
					[0.4 color rgb <0,0,0> ] // still transparent, this prevents it from reaching the container
//					[1.0 color rgb <1,1,1> ] // inside region is opaque
//					[1.0 color rgb <.1,.1,.1> ] // inside region is a little transparent, deep dark clouds
					[1.0 color rgb <.065,.065,.065> ] // inside region is rather transparent, medium clouds
//					[1.0 color rgb <.025,.025,.025> ] // inside region is quite transparent, whispier clouds
//					[1.0 color rgb <.005,.005,.005> ] // inside region is quite transparent
				}
			turbulence .18 // stir it up a bit
			omega 0.835 // default is 0.5, higher = rougher
    	}
		}
	}
#declare CloudSurfTex =
	texture {
		pigment { color rgbf<1,1,1,1> }
		finish { ambient .1 diffuse 0.7 }
	}
#declare StormCloudMaterial =
	material {
		texture { CloudSurfTex }
		interior { StormCloudInt }
	}
#declare LtCloudInt = // lighter version
	interior {
		media {
			scattering { 1, <.002,.002,.002,> extinction 1.0 } // thicker fluffy grey
//			scattering { 1, <.001,.001,.001,> extinction 1.0 } // medium fluffy grey
//			scattering { 1, <.0001,.0001,.0001,> extinction 1.0 } // thin fluffy grey
	    density { spherical
				color_map{
					[0.0 color rgb <0.0,0.0,0.0> ] // outside is transparent
					[0.3 color rgb <0,0,0> ] // this prevents it from reaching the container
//					[1.0 color rgb <.15,.15,.15> ] // inside is almost transparent
					[1.0 color rgb <.95,.95,.95> ] // inside is almost opaque
				}
				scale .6
			turbulence .8 // very mixed up
			omega 0.835 // default 0.5, higher = rougher
    	}
		}
	}
#declare LtCloudMaterial =
	material {
		texture { CloudSurfTex }
		interior { LtCloudInt }
	}


//===============================================
//						 Objects
//===============================================


#declare Cloud1 =
	#switch ( GoodClouds )
	#case (0)
		sphere { <0,0,0>,1 texture { WhitePaint } scale 800*Feet } // quick test
	#break
	#case (1)
		sphere { <0,0,0>,1 hollow material { StormCloudMaterial } scale 1300*Feet } // render
	#break
	#end
#declare CloudGroup1 =
	union {
		object { Cloud1 rotate RandRot() scale <1.0,0.3,1.0>*1.0 translate <  1600*Feet,  0*Feet,  0*Feet> }
		object { Cloud1 rotate RandRot() scale <1.0,0.3,1.0>*1.5 translate < 30*Feet,340*Feet, 60*Feet> }
		object { Cloud1 rotate RandRot() scale <1.0,0.3,1.0>*1.7 translate <-395*Feet,900*Feet, 0*Feet> }
		object { Cloud1 rotate RandRot() scale <1.0,0.2,1.0>*2.5 translate <285*Feet,1940*Feet,-140*Feet> }
		object { Cloud1 rotate RandRot() scale <1.0,0.3,1.0>*1.0 translate <340*Feet,2840*Feet,-300*Feet> }
//		bounded_by { cylinder{<0,-15*Meters,0>,<0,260*Meters,0>,240*Meters} }
	}

#declare Cloud2 =
	#switch ( GoodClouds )
	#case (0)
		sphere { <0,0,0>,1 texture { WhitePaint } scale 600*Feet } // quick test
	#break
	#case (1)
		sphere { <0,0,0>,1 hollow material { LtCloudMaterial } scale 1100*Feet } // render
	#break
#end
#declare CloudGroup2 =
	union {
		object { Cloud1 rotate RandRot() scale <1.0,0.13,1.0>*4.0 translate <  -100*Feet,  0*Feet,  0*Feet> }
		object { Cloud1 rotate RandRot() scale <1.0,0.3,1.0>*2.5 translate < 230*Feet,420*Feet, 1160*Feet> }
		object { Cloud1 rotate RandRot() scale <1.0,0.3,1.0>*2.7 translate <-395*Feet,1300*Feet, 540*Feet> }
		object { Cloud1 rotate RandRot() scale <1.0,0.32,1.0>*3.6 translate <-1185*Feet,2240*Feet,-640*Feet> }
		object { Cloud1 rotate RandRot() scale <1.0,0.3,1.0>*5.0 translate <-340*Feet,3840*Feet,-1300*Feet> }
		object { Cloud1 rotate RandRot() scale <1.0,0.15,1.0>*7.0 translate <-800*Feet,5044*Feet,-2200*Feet> }
//		bounded_by { cylinder{<0,-15*Meters,0>,<0,260*Meters,0>,240*Meters} }
	}


