
// Glenn's POV-Ray Scene File - Waves
// created 31-Jul-99
// last update 31-Jul-99
// copyright 1999 Glenn McCarter (gmccarter@hotmail.com)

#include "Colors.inc"
#include "GIncludeRH.inc"
//#include "GRuler.inc"

#version 3.1;
global_settings {
	adc_bailout 0.003922
	ambient_light <1.0,1.0,1.0>
	assumed_gamma 1.0
	hf_gray_16 off
	irid_wavelength <0.25,0.18,0.14>
	max_intersections 64
	max_trace_level 10
	number_of_waves 10
  /* // Radiosity section: uncomment this to enable radiosity
  // calculations; must also turn on radiosity in your ini file.
	radiosity {
		brightness       3.3
		count            100
		distance_maximum 5
		error_bound      0.4
		gray_threshold   0.5
		low_error_factor 0.8
		minimum_reuse    0.015
		nearest_count    6
		recursion_limit  1
	}
  */ // end radiosity section
}

//===============================================
//             Variables
//===============================================


//===============================================
//             Cameras
//===============================================

#declare Render_Cam =
	camera {
//		perspective

		direction <0.0,     0.0,  1.0>
		sky       <0.0,     1.0,  0.0>  // Use left handed-system
		up        <0.0,     1.0,  0.0>  // Where Y is up
		right     <1.3333, 0.0,  0.0>
		angle .36
	/* // Focal Blur section: uncomment to enable focal blur
		blur_samples 6
		aperture .5    //lower value = wider range in focus
		focal_point <0,0,0>
	*/ // end focal blur
	location  <0, 0, -60*Feet>
	look_at   <0,0,0>
//		orthographic
}

camera { Render_Cam }

// {}

//===============================================
//             Textures
//===============================================

global_settings{number_of_waves 13 }

#declare WaveTex1 =
	texture {
		pigment { color rgb<0,0,0> }
//		normal { ripples 0.3 frequency 2 scale 160}
//		normal { granite 0.3  scale 1.60 }
//		normal { granite 0.8  scale <1.6,3.6,1.6> }
//		normal { bumps 0.8  scale <.16,.36,.16> }
//		normal { bumps 0.8  scale <.56,1.66,.56> }
		normal {
			average
			normal_map {
			[ granite 0.8  scale <1.6,3.6,1.6> ]
			[ bumps 0.8  scale <.56,1.66,.56> ]
		}
		}

		finish { ambient .10 specular .98 roughness .050 reflection 0 }
	}

#declare WaveTex2 =
	texture {
		pigment {
			wrinkles
			color_map {
				[ -0.10  color rgb<0,0,0> ]
				[ 1.10  color rgb<1,1,1> ]
//				[ -0.10  color rgb<1,1,1> ]
//				[ 1.10  color rgb<0,0,0> ]

			}
			scale <2.5,1,1>*1
//			turbulence .14
//			scale <2,1,1>*.3
		}
//		normal { bumps 0.8  scale <.16,.16,.16> }
		finish { ambient 0.90 specular .98 roughness .050 reflection 0 }
	}


//===============================================
//             Lighting
//===============================================

#declare Sun =
	light_source {
		<15*Miles,1*Miles,-8*Miles>
		color rgb <1,1,1>*1.0
	}
//object { Sun }


#declare TestCyl =
cone {
	<0,-20,-4>,0.3,<0,20,-4>,0.3
	texture { pigment { color rgb<1,1,1> } finish { ambient .8} }
}
//object { TestCyl }

//===============================================
//             Environment
//===============================================

background { color rgb <0.0, 0.0, 0.0> } // black
//background { color rgb <0.2, 0.4, 0.8> } // light blue

#declare GroundPlaneWhite =
  plane { y, 0
    texture {
      pigment{White}
    }
    hollow
  }
//object {GroundPlaneWhite translate y*0}

#declare WaterPlane =
  plane { z, 0
    texture { WaveTex2 }
    hollow
  }


//===============================================
//             Objects
//===============================================


//===============================================
//             Object Placement
//===============================================

object { WaterPlane }

