//
// Homecoming: entry for the irtc, july-august 1999
// (c) by J. Berger
//
#include "metrics.inc"
#include "colors.inc"
#include "textures.inc"
#include "kmetals.inc"
#include "shapes.inc"  
#include "jbtextures.inc"
#include "gindeau.inc"
#include "fixtures.inc"
#include "palan.inc"

#include "stones1.inc"

#declare camera_style = 1 ;				    // 1, 2 or 3

#declare do_boat	= yes ;
#declare do_map		= yes ;
#declare do_lighthouse	= yes ;
#declare do_haze	= yes ;
#declare do_rain	= yes ;
#declare do_window	= no ;

#declare high_detail	= yes ;

#declare quality       = 5 ;				    // multiple of 5!

global_settings {
  assumed_gamma 1.0
  ambient_light 0.05
  max_trace_level 10
}

#if (camera_style=1)
  camera {
    location <0.0, 2.8, -15>*m
    look_at  <0.0, 3, 0>*m
//    location <-15, 2.8, 0.0>*m
//    look_at <0.0, 3, 0.001>*m
    angle 40
  
    rotate -20*y
  }

#else
  #if (camera_style=2)
    camera {
      location <-500, 500, 1000>*m
      look_at <-500, 0, 1000>*m
      orthographic
      up 220*z*m
      right 220*1.333333333333*x*m
    }
  #else
    camera {
      location <-200, 161, 1000>*m
      look_at <-200, 161, 1020>*m
    }
  #end
#end

light_source {						    // this light gives the waves
							    // their appearance
  <0.0, 6.0, -50>*km
  color White
  media_interaction off
}
light_source {
  <0, 290, 0>*m
  #if (do_haze)
    color rgb <1.0, 1.0, 0.8>
  #else
    color rgb <1.0, 1.0, 0.8>
  #end
  media_interaction off
  spotlight
  point_at <0, 0, 0>
  radius 1
  falloff 2
}

/*sphere {
  0*m, 10*cm
  pigment { color Green }
}*/

#declare Joue = difference {
  union {
    difference {
      union {
	difference {
	  cylinder { <0, -10, 0>*m, <0, 0, 0>*m, 5*m }
	  cylinder { <0, -10.01, 0>*m, <0, 0.01, 0>*m, 4.9*m }
	}
	difference {
	  cylinder { <0, -1, 0>*cm, <0, 19, 0>*cm, 5.15*m }
	  cylinder { <0, -1.01, 0>*cm, <0, 19.01, 0>*cm, 4.75*m }
	}
	#if (high_detail)
	  #local i = 1 ;
	  #while (i < 8)
	    box { <-5, -10, 0>*m, <-4.75, 0, -0.075>*m rotate 11.5*y*i }
	    #local i = i+1 ;
	  #end
	#end
	scale <0.5, 1, 2>
	rotate 10*z
      }
      plane { -x, 0 }
      plane { z, 0 }
      
      bounded_by { box {<-2.54,-5, 0>*m, <0, 0.2, 10.3>*m } }
    }
    union { 
      box { <-5, -10, -10>*m, <-4.9, 0, 0>*m }
      box { <-5.15, -0.01, -10>*m, <-4.75, 0.19, 0>*m }
      
      #if (high_detail)
	#local i = 0 ;
	#while (i < 8)
	  box { <-5, -10, 0>*m, <-4.75, 0, -0.15>*m translate -i*m*z }
	  #local i = i+2 ;
	#end
      #end

      scale <0.5, 1, 1>
      rotate 10*z
    }
  }
  box { <-2.6, 0, 0.6>*m, <0, 0.3, 1.25>*m translate -1*m*y }
}

#declare Panel = union {
  difference {
    box { -<50*cm, 2*cm, 1*m>, <50*cm, 2*cm, 1*m> }
    box { -<45*cm, 3*cm, 90*cm>, <45*cm, 3*cm, 90*cm> }
  }
  #local i = 0 ;
  #while (i < 19)
    cylinder { <0, 0,-98*cm>, <0, 0, 98*cm>, 1.5*cm translate (-42.5+5*i)*cm*x }
    #local i = i+1 ;
  #end
  bounded_by { box { -<50*cm, 2*cm, 1*m>, <50*cm, 2*cm, 1*m> } }
}

#declare Boat = union {
  union {
    object { Joue }
    object { 
      Joue
      scale <-1, 1, 1>
    }
    #if (high_detail)
      difference {
	box {
	  <-13*cm, -2*m, -30*cm>, <13*cm, 50*cm, 20*cm>
	  rotate 5*x
	}
	plane { -y, -35*cm }
	translate 9.7*m*z
      }
    #end
    texture {
      pigment { color White }
      normal {
	bumps 0.15
	scale <1*cm, 1*cm, 1*m>
      }
    }
    texture { Stains }
    texture { TextMouillee }
    
    translate 1*m*y
  }
  union {						    // haubans
    cylinder { <0, 7*m, 0>, <0, 1.39*m, 9.74*m>, 1*cm }
    
    cylinder { <0, 7*m, 0>, <-1.4, 6, 0>*m, 1*cm }
    cylinder { <-1.4, 6, 0>*m, <-2.46*m, 82*cm, 0>, 1*cm }
    cylinder { <0, 7*m, 0>, <1.4, 6, 0>*m, 1*cm }
    cylinder { <1.4, 6, 0>*m, <2.46*m, 82*cm, 0>, 1*cm }
    texture {
      pigment { color Black }
      finish { F_MetalA }
    }
    texture { TextMouillee }
  }       
  object {
    Fixture1
    rotate 90*y
    translate <0, 1.35*m, 9.74*m>
    texture { Dark_Metal }
    texture { Stains }
    texture { TextMouillee }
  }
  object {
    Fixture1
    scale 1.5
    translate <-2.46*m, 75*cm, 0>
    texture { Dark_Metal }
    texture { Stains }
    texture { TextMouillee }
  }
  object {
    Fixture1
    scale 1.5
    translate <2.46*m, 75*cm, 0>
    texture { Dark_Metal }
    texture { Stains }
    texture { TextMouillee }
  }
  union {
    intersection {					    // deck
      box {
	<-2.5, -1, 0>*m, <2.5, 0, 10>*m 
      }
      #if (high_detail)
	union {
	  difference {
	    cylinder { <0, -10, 0>*m, <0, 0, 0>*m, 4.91*m }
	    plane { -x, -0.01 }
	    scale <0.5, 1, 2>
	    rotate 10*z
	  }
	  difference { 
	    cylinder { <0, -10, 0>*m, <0, 0, 0>*m, 4.91*m }
	    plane { x, -0.01 }
	    scale <0.5, 1, 2>
	    rotate -10*z
	  }
	  translate 1*m*y
	}
      #end
    }
    box { <-2.5, -1, -10>*m, <2.5, 0, 0>*m }
    texture {
      pigment { 
	brick
	pigment { color Black }, pigment { DMFWood1 scale 1*m }
	brick_size <10, 1, 1>*m
	mortar 10*cm
	rotate 90*y
	rotate 90*z
	scale 0.25
	turbulence 0.05
	translate 10*cm*y
      }
      normal {
	bumps 0.15
	scale <1*cm, 1*cm, 1*m>
      }
    }
    texture { Stains }
    texture { TextMouillee }
  }
  union {
    cone { <0, -1, 0>*m, 15*cm, <0, 7, 0>*m, 10*cm }	    // mast
    sphere { 7*m*y, 10*cm }
    texture {
      pigment {
	gradient y
	pigment_map {
	  [ 0.0 bozo
	    color_map {
	      [ 0.0 color <53, 86, 206>/255 ]
	      [ 1.0 color <70, 108, 206>/255 ]
	    }
	    scale 5*cm
	  ]
	  [ 0.3 bozo
	    color_map {
	      [ 0.0 color <53, 86, 206>/255 ]
	      [ 1.0 color <70, 108, 206>/255 ]
	    }
	    scale 5*cm
	  ]
	  [ 0.3 color White ]
	  [ 1.0 color White ]
	}
	scale 7*m
	turbulence 0.1
      }
      normal {
	bumps 0.15
	scale <1*cm, 1*m, 1*cm>
      }
    }
    texture { Stains }
    texture { TextMouillee }
  } 
  union {
    cylinder { <-1.45, 6, 0>*m, <1.45, 6, 0>*m, 5*cm }
    sphere { <-1.45, 6, 0>*m, 5*cm }
    sphere { <1.45, 6, 0>*m, 5*cm }
    texture {
      pigment { color White }
      normal {
	bumps 0.15
	scale <1*m, 1*cm, 1*cm>
	}
    }
    texture { Stains }
    texture { TextMouillee }
  }
  object { Palan }
  #if (high_detail)
    union {						    // lamp
      box { -<20, 25, 40>*cm, <20, -20, 20>*cm }
      cylinder { -<15, 25, 0>*cm, <-15, 25, 0>*cm, 4*cm no_shadow }
      cylinder { <15, -25, 0>*cm, <15, 25, 0>*cm, 4*cm no_shadow }
      cylinder { <0, -25, 15>*cm, <0, 25, 17>*cm, 4*cm no_shadow }
      torus {
	15*cm, 4*cm
	no_shadow
      }
      //cylinder { <0, 20, 0>*cm, <0, 25, 0>*cm, 20*cm }
      intersection {
	sphere { <0, 40, 0>*cm, 20*cm scale <1, 0.5, 1> }
	box { <-20, 20, -20>*cm, <20, 50, 20>*cm }
	bounded_by { box { <-20, 20, -20>*cm, <20, 50, 20>*cm } }
      }
      translate <0, 5.15*m, 20*cm>
      texture { 
	pigment { color rgb <0.1, 0.1, 0.1> }
	finish {
	  brilliance 2
	  diffuse 0.3
	  metallic
	  specular 0.80
	  roughness 1/20
	  reflection 0.1
	}
      }
      texture { Stains }
      texture { TextMouillee }
    }
    union {						    // shadows...
      cylinder { -<15, 25, 0>*cm, <-15, 25, 0>*cm, 3.9*cm }
      //cylinder { -<15, 25, 0>*cm, <-15, 25, 0>*cm, 2*cm }

      cylinder { <15, -25, 0>*cm, <15, 25, 0>*cm, 3.9*cm }
      //cylinder { <15, -25, 0>*cm, <15, 25, 0>*cm, 2*cm }

      cylinder { <0, -25, 15>*cm, <0, 25, 17>*cm, 3.9*cm }
      //cylinder { <0, -25, 15>*cm, <0, 25, 17>*cm, 2*cm }
      
      torus { 15*cm, 3.9*cm }
      //torus { 15*cm, 2*cm }
      
      translate <0, 5.15*m, 20*cm>
      pigment { color rgbf 1 }
      interior { 
	fade_distance 3*cm
	fade_power 2
      }
      
      bounded_by { sphere { <0, 5.15, 0.20>*m, 1*cm } }	    // anyway, they're only visible
							    // from the light_source
    }
      
    cylinder {						    // lamp glass
      <0, 4.92*m, 20*cm>, <0, 5.37*m, 20*cm>, 15*cm
      texture {
	pigment { rgb <1.0, 1.0, 0.8> }
	finish { ambient 1 }
      }
      texture { TextMouillee }
      no_shadow
      double_illuminate
      hollow
    }
  #end
  union {
    #if (high_detail)
      superellipsoid {					    // "guindeau"
	<0.2, 0.2>
	scale <0.75, 0.5, 0.375>*m
	#if (0) } #end					    // for xemacs
    #else
      box {
	-<0.75, 0.5, 0.375>*m, <0.75, 0.5, 0.375>*m
    #end
      texture { Dark_Metal }
      texture { Stains }
      texture { TextMouillee }
    }
    intersection {
      object {
	Hyperboloid_Y
	scale 12.5*cm
      }
      box { -20*cm, 20*cm }
      texture { T_Brass_1A }
      texture { TextMouillee }
      translate 71*cm*y+30*cm*x
    }
    intersection {
      object {
	Hyperboloid_Y
	scale 12.5*cm
      }
      box { -20*cm, 20*cm }
      texture { T_Brass_1A }
      texture { TextMouillee }
      translate 71*cm*y-30*cm*x
    }
    translate 3*m*z
  }  
  union {						    // trappe de cale
    box { <-1.275, -1, -1.275>*m, <1.275, 0.5, 1.275>*m }
    difference {
      #if (high_detail)
	superellipsoid {
	  <0.1, 0.1>
	  scale <1.5*m, 5*cm, 1.5*m>
	  #if (0) } #end				    // for xemacs
      #else
	box {
	  -<1.5*m, 5*cm, 1.5*m>, <1.5*m, 5*cm, 1.5*m>
      #end
	translate 50*cm*y
      }
      box { <-1.3*m, 52*cm, -1.3*m>, <-0.1*m, 60*cm, 1.3*m> }
      box { <1.3*m, 52*cm, -1.3*m>, <0.1*m, 60*cm, 1.3*m> }
    }
    #if (high_detail)
      cylinder { <0, 110, -145>*cm, <0, 110, 145>*cm, 5*cm scale <1, 0.5, 1> }
      sphere { <0, 110,-145>*cm, 5*cm scale <1, 0.5, 1> }
      sphere { <0, 110, 145>*cm, 5*cm scale <1, 0.5, 1> }
    #end
    texture {
      pigment { 
	bozo
	color_map {
	  [ 0.0 color <53, 86, 206>/255 ]
	  [ 1.0 color <70, 108, 206>/255 ]
	}
	scale 5*cm
      }
      normal {
	brick 0.15
	brick_size <10, 1, 1>*m
	mortar 5*cm
	rotate 90*y
	rotate 90*z
	scale 0.1
	turbulence 0.01
	translate 1*cm*y
      }
    }
    texture { Stains }
    texture { TextMouillee }
    translate <0, 0, -2.5>*m
  }                    
  object {
    guindeau
    translate <0, 0, -5.6>*m
  }
  #if (high_detail)
    union {						    // engine door
      object { 
	Panel
	rotate 20*z
	translate <-47*cm, 1.3*m, 0>
      }
      object { 
	Panel
	rotate -20*z
	translate <47*cm, 1.3*m, 0>
      }
      cylinder { <0, 1.47*m, 1*m>, <0, 1.47*m, -1*m>, 3*cm }
      difference {
	box { <-90, 50, 98>*cm, <90*cm, 1.5*m, 96*cm> }
	plane { -y, 0 rotate 20*z translate <-47*cm, 1.3*m, 0> }
	plane { -y, 0 rotate -20*z translate <47*cm, 1.3*m, 0> }
      }
      translate -7.5*m*z
      texture {
	pigment {
	  bozo
	  color_map {
	    [ 0.0 White   ]
	    [ 1.0 White/2 ]
	  }
	  scale 1*cm
	}
      }
      texture { Stains }
      texture { TextMouillee }
    }    
  #end
  difference {
    union {						    // cabin
      box { <-2, -1, -6>*m, <2, 1, -20>*m }
      difference {
	box { <-2, 0, -14>*m, <2, 4.5, -20>*m }
	box { <-0.95, 4.03, -13.9>*m, <-2.5*cm, 4.4*m, -14.1*m> }
	box { <1.7, 4.03, -13.9>*m, <2.5*cm, 4.4*m, -14.1*m> }
      }
      pigment { color White }
      //finish { ambient 10 }
      texture { Stains }
      texture { TextMouillee }
    }
    box { 
      <-1.98, 1, -14.02>*m, <1.98, 4.45, -19.98>*m 
      pigment { color Black }
    }
  }   
  #if (do_window)
    box {
      <-2, 0, -14>*m, <2, 4.5, -20>*m
      pigment { color rgbft 1 }
      interior { ior 0.9 }
      normal { 
	marble //0.1
	slope_map {
	  [ 0.0 <0.00, 0.0> ]
	  [ 0.9 <0.00, 0.0> ]
	  [ 1.0 <0.03, 0.0> ]
	}
	rotate 90*x
	rotate 90*z
	scale 5*cm 
	turbulence 0.5
      }
      hollow
    }
  #end
  union {						    // engine vents
    cylinder { 0, 75*cm*y, 10*cm }
    difference {
      sphere { 0, 40*cm }
      plane { -z, 0 }
      scale <0.75, 0.75, 1>
      translate <0, 75, 10>*cm
    }
    pigment { 
      bozo
      color_map {
        [ 0.0 color <53, 86, 206>/255 ]
        [ 1.0 color <70, 108, 206>/255 ]
      }
      scale 5*cm
    }
    texture { Stains }
    texture { TextMouillee }
    translate <1.5, 1, -7>*m
  }
  union {
    cylinder { 0, 75*cm*y, 10*cm }
    difference {
      sphere { 0, 40*cm }
      plane { -z, 0 }
      scale <0.75, 0.75, 1>
      translate <0, 75, 10>*cm
    }
    pigment { 
      bozo
      color_map {
        [ 0.0 color <53, 86, 206>/255 ]
        [ 1.0 color <70, 108, 206>/255 ]
      }
      scale 5*cm
    }
    texture { Stains }
    texture { TextMouillee }
    translate <-1.5, 1, -7>*m
  } 
  light_source {
    <0, 5.15, 0.20>*m
    color (White+Yellow)*300

    fade_distance 32*cm
    fade_power 4
  }
  #if (do_haze)
    disc {
      <0, 5, 3>*m, z, 3*m
      pigment { rgbf 1.0 }
    }  
    hollow						    // must be here!!
  #end
}

#if (do_boat)
  object {
    Boat
  
    rotate -5*x
    rotate 10*z
    rotate -25*y
  }
#end

#if (do_map)
  height_field {
    gif "coastf.ghf"
    smooth
    water_level 0.02
    
    scale <2*km, 200*m, 2*km>
    translate -1500*m*x-10*m*y

    normal {
      gradient y
      sine_wave
      turbulence 0.2
      scale 10*m
    }
    
    pigment {
      gradient y
      sine_wave
      color_map {
	[ 0.0 color Yellow ]
	[ 1.0 color (Yellow+White)/2 ]
      }
      turbulence 0.2
      scale 10*m
    }
  }
#end

/*cylinder {
  <0, 0, 0>*m, <0, 195, 1000>*m, 2*m
  
  rotate -12*y
  
  pigment { color Green }
  finish { ambient 1 }
}*/

#if (do_lighthouse)
  difference {
    union {
      cylinder { <-200, 161, 1020>*m, <-200, 170, 1020>*m, 20*m }
      cylinder { <-200, 169, 1020>*m, <-200, 240, 1020>*m, 10*m }
      cylinder { <-200, 229, 1020>*m, <-200, 231, 1020>*m, 15*m }
      sphere { <-200, 240, 1020>*m, 10*m }
      
      texture { 
	T_Stone8 
	scale 10*cm
      }
      finish { phong 0 }
      normal { bumps 1 scale 10*cm }
    }
    box { <-10.1, 1, -6.5>*m, <10.1, 10, 6.5>*m translate <-200, 231, 1020>*m pigment { color Black } }
    box { <-6.5, 1, -10.1>*m, <6.5, 10, 10.1>*m translate <-200, 231, 1020>*m pigment { color Black } }
  }
  light_source {
    <-200, 236, 1020>*m
    color White*16384 //8192
    spotlight
    radius 0.4
    falloff 0.4001
    tightness 100
    //point_at <10, 2.8, 2000>*m
    point_at <0, 5, -15>*m
    looks_like { sphere { 0, 10*cm pigment { color White } } }
    fade_distance 5*m //50*cm
    fade_power 3 //2
  }
#end

#declare GoodWeather = texture {
//  pigment { Blood_Sky }
//  pigment { color Red }
  pigment {
    bozo
    color_map {
      [ 0.0 rgb <0.3, 0.2, 0.1> ]
      [ 0.5 rgb <0.9, 0.7, 0.5> ]
      [ 0.6 rgb <0.9, 0.7, 0.4>*1.1 ]
      [ 1.0 rgb <0.9, 0.7, 0.3>*1.2 ]
    }
    turbulence 0.3
  }
  #if (do_haze)
    finish { ambient 400 diffuse 0 }
  #else
    finish { ambient 1 diffuse 0 }
  #end
  scale 64*m/(2*km)
}
#declare BadWeather = texture {
  pigment {
    bozo
    color_map {
      [ 0.0 rgb <0.0, 0.0, 0.0> ]
      [ 0.5 rgb <0.1, 0.1, 0.1> ]
      [ 0.6 rgb <0.3, 0.2, 0.1> ]
      [ 1.0 rgb <0.9, 0.7, 0.5> ]
    }
    turbulence 0.3
  }
//  pigment { color Green }
  #if (do_haze)
    finish { ambient 100 diffuse 0.5 }
  #else
    finish { ambient 1 diffuse 0.5 }
  #end
  normal {
    bozo
    turbulence 0.3
  }
  scale 64*m/(2*km)
}

plane {							    // sky
  -y, -300*m
  texture {
    spherical
    texture_map {
      [ 0.0 GoodWeather ] 
      [ 0.4 GoodWeather ]
      [ 0.6 BadWeather  ]
      [ 1.0 BadWeather  ]
    }
    scale 4*km
  }
}

#if (do_haze)
  cylinder {
    0, 400*m*y, 2*km
    //pigment { rgbt <0, 0.5, 0, 0.1> }
    pigment { rgbf 1 } 
    interior {
      media {
	intervals 4*quality
	scattering { 3, rgb <0.9, 0.9, 1.0>/300 }
	samples 1, 3 //quality/5, quality //1, 10
	confidence 0.9999
	variance 1/1000
	ratio 0.9
	density {
	  cylindrical
	  color_map {
	    [ 0.0 color rgb 0.0 ]
	    [ 0.1 color rgb 1.0 ]
	    [ 1.0 color rgb 1.0 ]
	  }
	  turbulence 0.1
	  scale 2*km
	}
	density {
	spotted
	  color_map {
	    [ 0.0 color 0.6 ]
	    [ 0.5 color 0.6 ]
	    [ 1.0 color 2.0 ]
	  }
	  frequency 2.0
	  scale  <0.001, 0.001, 0.1>*2
	  rotate <90.0, 0.0, -10.0>
	  //rotate -20*y
	}   
      }
    } 
    hollow  
    translate -15*m*z
    rotate -20*y
  }
#end

#if (do_rain)
  plane {
    -z, 14*m
    texture {
      pigment {
	spotted
	color_map {
	  [ 0.0 rgbft <1.0, 1.0, 1.0, 0.0, 1.0> ]
	  [ 0.9 rgbft <1.0, 1.0, 1.0, 0.0, 1.0> ]
	  [ 1.0 rgbft <0.8, 0.8, 0.8, 0.4, 0.0> ]
	}
	frequency 2.0
	scale  <0.001, 0.001, 0.1>
	rotate    <90.0, 0.0, -10.0>
      }
    }             
    finish {
      ambient 0.8
      diffuse 0.0
    }
    
    hollow
    rotate -20*y
  }
#end

height_field {
  png "waves.png"
  smooth
  
  translate <-0.5, 0, -0.5>				    // to center it at origin
  rotate 90*y
  scale <100, 5, 100>*m
  translate -2*m*y+12*m*z
  
  pigment {
    color <0.01, 0.01, 0.02>
  }
  finish {
    phong 1
    phong_size 100
    reflection 0.1
    diffuse 0.1
  }
}
plane {
  y, 0

  pigment {
    color <0.01, 0.01, 0.02>
  }
  normal {
    marble 1.0
    sine_wave
    turbulence 0.2
    rotate 90*x
  }
  finish {
    phong 1
    phong_size 100
    reflection 0.1
//    diffuse 0.1
  }
  translate <-0.5, 0, -0.5>
  rotate 90*y
  scale <100, 5, 100>*m
  translate -2*m*y+12*m*z
}
