// Hopefully this'll be a nice pyramid scene

#include "colors.inc"
#include "shapes.inc"
#include "textures.inc"
#include "metals.inc"
#include "DO_Palm1.inc"

background { color Black }
   #declare star_count = 2000;
   #declare star_scale = .3;
   #include "GALAXY.SF"
   #declare galaxy_seed = 1;
   #declare star_count = 500;
   #declare star_type = 3;
   #declare star_colour = <1, .9, .7>;
   #declare star_scale = 0.8; 
   #include "GALAXY.SF"
camera {
	location <-50,5,-140>
	look_at <-20,30,0>
}
#declare Pyramid =
  mesh {
        triangle { <-1, 0, 1>, <0, 1, 0>, <1, 0, 1> }
        triangle { <-1, 0, 1>, <0, 1, 0>, <-1, 0, -1> }
        triangle { <1, 0, -1>, <0, 1, 0>, <-1, 0, -1> }
        triangle { <1, 0, 1>, <0, 1, 0>, <1, 0, -1> }
}
light_source { <20, 350, -20> color Gray15 }
light_source {
	<200, 410, 400>
	color rgb <0.3, 0.3, 0.1>
	spotlight
	radius 50
	falloff 100
	tightness 5
	point_at <-50, 0, 30>
	jitter
}
light_source {
	<440, 540, 400>
	color rgb Gray15
	spotlight
	radius 40
	falloff 85
	tightness 10
	point_at <440,570,500>
}
#declare PyramidStone =
  texture {
	pigment { color Gray95 }
	normal {dents .75 scale .25}
}
#declare PyramidGold =
  texture {
  	pigment { color Goldenrod }
	finish {F_MetalC}
}
object {
	Pyramid
	scale <60,90,60>
	texture {PyramidStone}
	translate <15, -1, -15>
	hollow
}
object {
	Pyramid
	scale <3.0025,4.505,3.0025>
	texture {PyramidGold}
	translate <15, 84.5, -15>
	hollow
}
object {
	Pyramid
	scale <4.17,6.666,4.17>
	texture {PyramidStone}
	translate <22, -1, -85>
	hollow
}
object {
	Pyramid
	scale <66,99,66>
	texture {PyramidStone}
	translate <-150, -1, 150>
	hollow
}
object {
	Pyramid
	scale <3.3,4.955,3.3>
	texture {PyramidGold}
	translate <-150,93.155,150>
	hollow
}

object { // Perfect!
	DO_Palm1
	rotate <0,0,-10>
	rotate <0,45,0>
	translate <-48.5,3.7,-138>
}

object { // Eh... oh well
	DO_Palm1
	rotate <5,0,-25>
	rotate <0,45,0>
	scale 5
	translate <-50,3,80>
}
plane { <0, 1, 0>, 00
	texture {
	pigment { color rgb <1.0, 0.98, 0.35> }
	finish {crand 0.3}
	}
	hollow
}
height_field {
        tga "hf.tga"
        texture {
                pigment { color rgb <1.0, 0.98, 0.35> }
                finish {crand 0.3}
        }
        scale <600, 35, 600>
        translate <-300,-19,-220>
	hollow
}
sphere{ <440,570,600>, 30
	pigment {Gray75}
	normal {wrinkles 1 scale 1.1}
	finish {ambient 0.7} 
	hollow
}

sphere { 0, 70
	pigment {color rgbt <1,1,1,1>}
	halo {
		attenuating
		spherical_mapping
		linear
		turbulence 1.54
		color_map {
			[ 0 color rgbt <0.5, 0.5, 0.5, 1> ]
			[ 1 color rgbt <0.3, 0.3, 0.3, 0.983> ]
		}
		samples 90
		scale 40
	} 
	hollow
	translate <-50, 200, 250>
}
sphere { 0, 90
	pigment {color rgbt <1,1,1,1>}
	halo {
		attenuating
		spherical_mapping
		linear
		turbulence 0.76
		color_map {
			[ 0 color rgbt <0.5, 0.5, 0.5, 1> ]
			[ 1 color rgbt <0.3, 0.3, 0.3, 0.983> ]
		}
		samples 100
		scale 60
	}
	hollow
	translate <-60, 220, 220>
}
sphere { 0, 80
	pigment {color rgbt <1,1,1,1>}
	halo {
		attenuating
		spherical_mapping
		linear
		turbulence 0.92
		color_map {
			[ 0 color rgbt <0.5, 0.5, 0.5, 1> ]
			[ 1 color rgbt <0.3, 0.3, 0.3, 0.983> ]
		}
		samples 80
		scale 50
	}
	hollow
	translate <-141,230,230>
}
sphere { 0, 90 // LEAVE THIS ONE ALONE
	pigment {color rgbt <1,1,1,1>}
	halo {
		attenuating
		spherical_mapping
		linear
		turbulence 1.32
		color_map { // KEEP LEAVING IT ALONE
			[ 0 color rgbt <0.5, 0.5, 0.5, 1> ]
			[ 1 color rgbt <0.3, 0.3, 0.3, 0.983> ]
		}
		samples 100
		scale 60
	}
	hollow
	translate <30, 200, 200>
} // END OF ONE TO LEAVE ALONE

