// ==== Standard POV-Ray Includes ====
#include "colors.inc"	// Standard Color definitions
#include "textures.inc"	// Standard Texture definitions    

#include "Ufo.inc"

#declare oldtin=texture{pigment{red 0.81976 green 0.8465 blue 0.198413}
   finish{metallic}}  
#declare gold=texture{Gold_Metal}  
#declare chrome=texture{Chrome_Metal}
#declare bronze=texture{Bronze_Metal}
#declare copper=texture{Copper_Metal}
#declare silver=texture{Silver_Metal}
#declare brass=texture{Brass_Metal}
#declare frame=texture{Gold_Metal}
 
camera  // just shows front and flying ufo
{
  location  <80,5,-120>
  look_at   <-2,0,0>
  angle 35
}     
#declare Stars=
box{<0,0,0>,<1,1,1>
  texture{pigment{image_map{tga "sky2.tga"}}}
  scale<140000,140000,0.01>
  rotate<0,-40,0>
  }    
object{Stars
translate<-150000,-70000,100000>}
     
/*camera  // further view
{
  location  <210,17,-200>
  look_at   <40,0,0>
  angle 35
} 
// Sky background
#declare Stars=
box{<0,0,0>,<1,1,1>
  texture{pigment{image_map{tga "sky2.tga"}}}
  scale<140000,140000,0.01>
  rotate<0,-45,0>
  }    
object{Stars
translate<-170000,-70000,100000>}
*/
    
   
//light_source{<1000,1000,-1000>  color red 1  green 1  blue 1.0}  
light_source {
    <1000,1000,-1000>
    color White
    spotlight
    radius 15
    falloff 2000
    tightness 10
    point_at <0, 0, 0>
  }

light_source{<1000,-1000,1000>  color red 1  green 1  blue 1}

#declare Lamp=
union{
cylinder{<0,0,0>,<0,-0.2,0>0.2
  texture{silver}}
sphere{<0,-0.2,0>,0.2
  texture{NBglass}}
light_source{<0,-0.3,0> rgb<0.2,0.2,0>}
}      
      
#declare Flange=
prism {
  linear_sweep // or conic_sweep for tapering to a point
  linear_spline // linear_spline | quadratic_spline | cubic_spline
  -0.15,        // height 1
   0.15,        // height 2
  4,          // number of points
  <0,0>,<3,0>,<-0.2,1.8>,<0,0>
  translate<0,0,2.5>
  rotate<15,0,0>
}

#declare TopStrut=
union{
cylinder{<0,0,0>,<0,1.2,0>0.16}
cylinder{<0,-0.4,0>,<0,0.4,0>,0.35}
box{<-0.35,1.0,-0.35>,<0.35,1.85,0.35>}
cylinder{<0,1.85,0>,<0,3,0>0.05
  texture{Gold_Metal}}
translate<0,2.5,0>
texture{brass}
}     

#declare BottomStrut=
object{TopStrut
  rotate<180,0,0>}
  
#declare StrutPair=
union{
object{TopStrut}
object{BottomStrut}
cylinder{<-0.9,0,0>,<0.9,0,0>2.6
  texture{brass}}
}

#declare Arm=
union{
cylinder{<0,0,0>,<60,0,0>,2.5}
cylinder{<-1,4,0>,<61,4,0>,0.3}     
cylinder{<-1,-4,0>,<61,-4,0>,0.3}  
cylinder{<54.5,0,0>,<60,0,0>3}
cylinder{<54.5,4,0>,<60,4,0>0.8}  
cylinder{<54.5,-4,0>,<60,-4,0>0.8}
box{<54.5,-4,-0.8>,<60,4,0.8>} 
//object{StrutPair
 // translate<5,0,0>}   
object{StrutPair
  translate<10,0,0>}
//object{StrutPair
  //translate<15,0,0>}
object{StrutPair
  translate<20,0,0>}
//object{StrutPair
  //translate<25,0,0>}
object{StrutPair
  translate<30,0,0>}
//object{StrutPair
  //translate<35,0,0>}
object{StrutPair
  translate<40,0,0>}
//object{StrutPair
  //translate<45,0,0>}
object{StrutPair
  translate<50,0,0>}
//object{StrutPair
  //translate<55,0,0>}
object{Flange}  
object{Flange
  rotate<30,0,0>}  
object{Flange
  rotate<60,0,0>}
object{Flange
  rotate<90,0,0>}
object{Flange
  rotate<120,0,0>}
object{Flange
  rotate<150,0,0>}
object{Flange
  rotate<180,0,0>}
object{Flange
  rotate<210,0,0>}
object{Flange
  rotate<240,0,0>}
object{Flange
  rotate<270,0,0>}
object{Flange
  rotate<300,0,0>}
object{Flange
  rotate<330,0,0>}
translate<12.5,0,15>
texture{copper}
}  

#declare BlankHub=
union{  
cone{<0,0,0>,12.4,<0,0,3>,12.85}
cylinder{<0,0,3>,<0,0,30>,13}       
cone{<0,0,30>,13,<0,0,40>,8}
box{<-7.5,-3,-0.2>,<7.5,3,0.5>
  texture{frame}}
texture{bronze}
}             
 
// Landing Platform

#declare Support=
difference{
prism {
  linear_sweep // or conic_sweep for tapering to a point
  linear_spline // linear_spline | quadratic_spline | cubic_spline
  -0.5,        // height 1
   0.5,        // height 2
  4,          // number of points
  <0,0>,<3,0>,<0,-3>,<0,0>
}
cylinder{<1,-0.6,-1>,<1,0.6,-1>,0.5}
  rotate<-90,0,0>
  rotate<0,90,0>
} 

#declare RunwaySign=
box{<0,0,0>,<1,1,1>
  texture{pigment{image_map{tga "sign.tga"}}}
  scale<7,7,0.01>
  rotate<90,0,0> 
  translate<-3.5,0,-3.5>
  }
 
#declare Platform=
union{
box{<-6,-3,-3>,<6,-2.5,0>}
object{Support
  translate<-5.5,-3,0>}   
object{Support
  translate<-0,-3,0>}
object{Support
  translate<5.5,-3,0>} 
object{RunwaySign
  translate<0,-2.49,0.7>}
texture{oldtin}
}  
  
#declare Viewer1=   
union{
difference{
box{<0,0,-1>,<6,3,0>}  
box{<0.2,0.2,-0.8>,<5.8,2.8,0>}
box{<2.7,1,-1.1>,<3.3,2,0>}     
box{<1.7,1,-1.1>,<2.3,2,0>}
box{<0.7,1,-1.1>,<1.3,2,0>}
box{<3.7,1,-1.1>,<4.3,2,0>}
box{<4.7,1,-1.1>,<5.3,2,0>}
  translate<-7,5,0>
texture{silver}
} 
//light_source{<-4,6.5,-0.2> color red 1 green 1 blue 0 shadowless} 
//light_source{<-2,6.5,-0.2> color red 1 green 1 blue 0 shadowless} 
//light_source{<-6,6.5,-0.2> color red 1 green 1 blue 0 shadowless} 
}

#declare Viewer2=
union{
difference{
sphere{<0,0,0>,3}  
sphere{<0,0,0>,2.8}
box{<-0.5,-0.3,-3.1>,<0.5,0.3,0>}  
box{<-0.5,-0.3,-3.1>,<0.5,0.3,0>  
  rotate<0,35,0>}  
box{<-0.5,-0.3,-3.1>,<0.5,0.3,0>  
  rotate<0,-35,0>}
translate<3.5,6.5,0>
  texture{silver}
}
//light_source{<3.5,6.5,-0.3> color red 1 green 1 blue 0 shadowless}  
//light_source{<2.5,6.5,-0.3> color red 1 green 1 blue 0 shadowless}  
//light_source{<4.5,6.5,-0.3> color red 1 green 1 blue 0 shadowless}
} 

#declare Warning=
box{<0,0,0>,<1,1,1>
  texture{pigment{image_map{tga "warning.tga"}}}
  scale<7,7,0.01>
  }    
  

#declare Hub1=
union{
difference{
object{BlankHub}
box{<-7,-2.5,-0.5>,<7,2.5,10>
  texture{oldtin}}  
}
object{Platform}
object{Viewer1}
object{Viewer2}
object{Warning translate<-3.5,-11,-0.01>} 
}

#declare CentreHub=
union{
cylinder{<0,0,0>,<0,0,28>,8}
cylinder{<0,0,12>,<0,0,16>,8.2}  
cylinder{<0,0,6>,<0,0,8>,8.2} 
cylinder{<0,0,20>,<0,0,22>,8.2} 
translate<0,0,37>
texture{gold}
} 
    
#declare Window=
box{<-1,-0.5,-6>,<1,0.5,6>
  translate<0,72.5,0>
  texture{pigment{color Black}}//brass}
  }  
  
#declare WindowPair=
union{
object{Window}
object{Window
  rotate<0,0,3>}
}  

#declare WindowSet=
union{
#declare Count=0;
#while (Count<360)
  object{WindowPair rotate<0,0,Count>}
  #declare Count=Count+10;
#end  }

#declare WindowLights=
union{
#declare Count=0;
#while (Count<360)
  light_source{<0,72.5,0> color red 1 green 1 blue 0 shadowless rotate<0,0,Count>}
  #declare Count=Count+20;
#end  }
    
#declare Rim=
union{
difference{
torus{72.5,5
  rotate<-90,0,0>}
object{WindowSet}
//object{WindowLights}
}
difference{
  cylinder{<0,0,-3.5>,<0,0,3.5>,72.5}
  cylinder{<0,0,-3.6>,<0,0,3.6>,67.5}  
} 
  texture{brass}
  translate<0,0,15>
}
  
#declare Wheel=
union{
object{Hub1}
object{Arm}   
object{Arm
  rotate<0,0,90>}  
object{Arm
  rotate<0,0,180>}
object{Arm
  rotate<0,0,270>} 
object{Rim}
}                 

#declare FrontWheel=
union{
object{Wheel}
object{Lamp translate<-3,-3,-2>}   
object{Lamp translate<3,-3,-2>}
light_source{<0,2.2,3> rgb<1,1,0>} 
}

#declare BackWheel=
object{Wheel
  rotate<0,180,0>
  translate<0,0,102>
}
/******************************************************/
#declare Stn=
union{
object{FrontWheel}
object{CentreHub}
object{BackWheel}
}

object{Stn}// no_shadow}  

/******************************************************/
object{RedSaucer 
  scale<0.45,0.45,0.45>
  translate<0,-1.5,5> }    
  
/*object{RedSaucer 
  scale<0.45,0.45,0.45>
  translate<0,-1.5,-50> }   
*/
  
object{RedSaucer 
  scale<0.45,0.45,0.45>
  rotate<0,0,-15>
  translate<43,-5,-80> }      
  
/*sky_sphere {
    pigment {image_map{tga "sky2.tga"}
    rotate<30,0,30>
      }}*/
  
  