#include "kolors.inc"
#include "metals.inc"
#include "electr.inc"
#include "woods.inc"
#include "textures.inc"
#include "marc.inc"
#include "TOMTREE.inc"

camera {
       location <0.75,0.31,9.25>
//       location <0.75,0.45,9.25>
//	   location <25,10,25>
       angle 50
       look_at  <12,0.45,0>}


light_source {<0,4000,10000> LightGldnrod1*2 }

background {Gray80}

sky_sphere {pigment{granite pigment_map{
            [0.5  LightSteelBlue1]
            [1.0  Gray90A]}
            turbulence 1.5
            octaves 7.5
		    omega 0.65
            scale 0.5}
            scale <200,20,200>}

// **************************************************** tile

#declare tile = object{

box {<0,0,0>,<1,1,-0.01>  
     texture{material_map {gif "second.gif"
                           texture{T_Gold_3B}
                           texture{pigment {Chartreuse4}}}}
    }
}

// **************************************************** tile 1

#declare tile1 = object{
 union{
// --------------------------------------------- platine
object{ tile translate <0,0,0> }
// --------------------------------------------- resistors
object{resistor(Yellow,Brown,Black,Silver)
       rotate <0,0,0>
       translate <0.325,0.375,0>}

object{resistor(Red,Red,Green,Gold)
       rotate <0,0,0>
       translate <0.425,0.375,0>}

object{resistor(Violet1,Red,Green,Gold)
       rotate <0,0,0>
       translate <0.375,0.425,0>}

object{resistor(Green,Red,Green,Silver)
       rotate <0,0,0>
       translate <0.075,0.525,0>}

object{resistor(Orange,Brown,Brown,Gold)
       rotate <0,0,-90>
       translate <0.775,0.825,0>}
// --------------------------------------------- transistors
object{transistor
       translate <0.575,0.325,0>}

object{transistor
       translate <0.575,0.075,0>}

object{transistor
       rotate <0,0,90>
       translate <0.975,0.125,0>}

object{transistor
       rotate <0,0,90>
       translate <0.975,0.25,0>}

object{transistor
       rotate <0,0,180>
       translate <0.175,0.825,0>}
// --------------------------------------------- 16 pin chip
object{pin16chip
       translate <0.625,0.575,0>}
// --------------------------------------------- 10 pin chip
object{pin10chip
       translate <0.875,0.325,0>}
// --------------------------------------------- condensators
object{condensator
       translate <0.775,0.725,0>}

object{condensator
       translate <0.825,0.725,0>}

object{condensator
       translate <0.875,0.725,0>}

object{condensator
       translate <0.025,0.825,0>}
 }
}

// **************************************************** tile 2

#declare tile3 = object{
 union{
// --------------------------------------------- platine
  object{ tile translate <0,0,0> }
// --------------------------------------------- condensators
  object{condensator2 translate<0.625,0.675,0>}
  object{condensator2 translate<0.575,0.675,0>}
  object{condensator2 translate<0.525,0.675,0>}
  object{condensator2 translate<0.475,0.675,0>}
  object{condensator2 translate<0.425,0.675,0>}
  object{condensator2 translate<0.375,0.675,0>}
  object{condensator2 translate<0.325,0.675,0>}
  object{condensator2 translate<0.275,0.675,0>}
  object{condensator3 rotate<0,0,90> translate<0.275,0.075,0>}
  object{condensator4 rotate<0,0,0> translate<0.025,0.425,0>}
// --------------------------------------------- resistors
  object{resistor(Red,Brown,Blue,Silver) translate <0.875,0.725,0>}
  object{resistor(Orange,Brown,Black,Silver) translate <0.825,0.725,0>}
  object{resistor(Black,White,Black,Gold) translate <0.775,0.725,0>}
 }
}

// **************************************************** tile3

#declare tile4 = object{
union{
 object{ tile translate <0,0,0> rotate<0,0,0>}
 object{condensator3 rotate<0,0,90> translate<0.275,0.075,0>}
 object{TREE scale 0.25 rotate<90,0,0> translate <0.325,0.075,0.335>}
 object{height_field {tga "hill.tga"
        water_level 0.1
    	translate <-0.5,0,-0.5>
        scale <1,0.2,1>
        scale 0.125
        pigment{DarkOliveGreen1}
        rotate<90,0,0>
        translate <0.325,0.075,0.314>        
                     }
       }
 }
}

// *************************************************** scene


#declare tseed = seed(235867);
#declare rmax = 30.0;
#declare tnum = 0;
#declare i = 0;

union{
#while (i < 40)
 
 #declare j = 0;

 #while (j < 40)
   #declare tvector = <i,j,0> + <0.5,0.5,0>;
   #declare rvector = vlength(tvector);
   #declare secangl = degrees( 
                       acos(
                        vdot(tvector,<1,0,0>)/vlength(tvector)));
   #if (secangl > 10.0)
      #if (secangl < 80.0)
         #if (rvector < rmax)
          #declare ttype = rand(tseed);
		  #if ((i = 1) & (j = 1))
             object{ tile4 translate <i,j,0> } 
          #else
             #if (ttype > 0.5)
                object{ tile1 translate <i,j,0> }
             #else
                object{ tile3 translate <i,j,0> }
             #end
         #end
         #declare tnum = tnum + 1;
       #end
     #end
   #end
   #declare j = j + 1;
 #end
 
 #declare i = i + 1;
#end
rotate <-90,0,0>
translate <0,0,10>
}

#debug concat("\n",str(tnum,4,0)," tiles have been used!\n") 

// object {tile4 rotate <-90,0,0> translate <1,0,9>}