global_settings                                                                                    
{
  assumed_gamma 1.0
}                                                                 

#include "colors.inc" 
#include "glass.inc"
#include "metals.inc"

#default{ texture{ pigment{rgb <0,0,0>}
                   normal{granite 0.02 scale <0.005,0.005,0.005>}
                   finish{ambient 0.2}
                 }
        }    

#local zoom=2.0;

// ----------------------------------------
                 
#local sky_color1=<0.85,0.85,0.85>;
#local sky_color2=<0.75,0.75,0.75>;
#local sky_color3=<0.30,0.45,0.70>;
#local sky_color4=<0.20,0.40,0.80>;
                 
// >>> modified P_Cloud2 (from file "skies.inc", line 58) <<<
#declare P_Cloud2 = pigment {
  wrinkles
  turbulence 0.65
  octaves 6
  omega 0.7
  lambda 2
  color_map {
    [0.0, 0.15   color rgb sky_color1 color rgb sky_color2 ]
    [0.15, 0.4   color rgb sky_color2 color rgb sky_color3 ]
    [0.4, 1.001 color rgb sky_color3 color rgb sky_color4 ]
  }
  scale <6, 1, 6>
}
                              
                              
// ----------------------------------------
camera
{
  location  <75.0, 4, 75.0>
  direction 1.5*z
  right     4/3*x*1/zoom
  up            y*1/zoom
  look_at   <0.0, 13.0,  0.0>  
//  look_at   <0.0, 0.0,  0.0>  
}

sky_sphere
{
  pigment {P_Cloud2 scale 0.20}
}          
       
light_source
{
  0*x // light's position (translated below)
  color rgb 2*<1,1,1>  // light's color
  translate <200, 200, 100>
}
                     
    
//------------------------------------------------------------------------------------------  
           
#declare feuer_an=0;

                                
height_field {
    png "uzrotsnd.htf"
    smooth
    texture { gradient y  turbulence 0.9
              texture_map{ [0.0  pigment { color 0.0*Blue} finish{ reflection <0.4,0.4,0.3> phong 0 specular 0} normal { ripples 2 turbulence 10 }]
                           [0.8  pigment { color 0.1*Blue}  finish{ reflection <0.4,0.4,0.3> specular 0 phong 0 phong_size 40} normal { ripples 2 turbulence 10 }]
                           [0.9  pigment { color 0.1*White}  finish{ reflection 0.3 phong 0.3 phong_size 40} normal { ripples 2 turbulence 10 }]
                           [1.0  pigment { color White}   finish{ reflection 0.0 phong 0.5 phong_size 40} normal { ripples 2 turbulence 10 }]
                      } 
               
            }   
    translate <-.5, -.5, -.5>
    scale <100, .4, 100>   
    rotate <0,180,0>
}           

 /* 
plane { <0,1,0>, 0 
        texture { pigment { color NavyBlue}
        //          normal  { waves }
                }
        //interior{ ior 1.33 }
      }
   */   
fog { fog_type 2 
      distance 4000
      color Gray50
      fog_offset 100
      fog_alt  50   
    }
                            
      
#declare texture_kuppel = texture  { pigment { color Black }  
                                     normal  { bumps 0 }
                                     finish  { phong 0.6
                                               phong_size 20
                                             }              
                                   }        

#declare texture_white  = texture  { pigment { color White }
                                     finish  { phong 0.6
                                               phong_size 20
                                             }              
                                   }        

#declare turm = union  { lathe { cubic_spline  9,    
                                 < 7.50,  -0.50>,
                                 < 4.5,   0.00>,  
                                 < 3.40,   5.60>,
                                 < 2.90,  10.60>,
                                 < 2.67,  14.40>,
                                 < 2.65,  17.10>,
                                 < 2.65,  18.30>,
                                 < 2.65,  22.10>,
                                 < 2.65,  22.60>
                                 sturm
                                 texture { pigment { gradient y
                                                     pigment_map { [ 0.00/22.10 Black]
                                                                   [ 5.61/22.10 Black]
                                                                   [ 5.61/22.10 White]
                                                                   [10.61/22.10 White]
                                                                   [10.61/22.10 Red  ]
                                                                   [14.41/22.10 Red  ]
                                                                   [14.41/22.10 White]
                                                                   [18.31/22.10 White]
                                                                   [18.31/22.10 Red  ]
                                                                   [22.10/22.10 Red  ]
                                                                 }
                                                     scale <1,22.11,1>        
                                                   }  
                                               finish  { phong 0.4
                                                         phong_size 20
                                                       }              
                                         }                        
                               }   

                         cylinder { <0,21.80,0> <0,22.00,0> 2.95
                                    texture  { pigment { color Red }
                                               finish  { phong 0.6
                                                         phong_size 20
                                                       }              
                                             }        
                                  } 
                         cylinder { <0,21.50,0> <0,21.80,0> 2.80
                                    texture  { pigment { color Red }
                                               finish  { phong 0.6
                                                         phong_size 20
                                                       }              
                                             }        
                                  } 
                         cylinder { <0,18.20,0> <0,18.40,0> 2.80
                                    texture  { pigment { color Red }
                                               finish  { phong 0.6
                                                         phong_size 20
                                                       }              
                                             }        
                                  } 
                         cylinder { <0,0.6,0> <0,-22,0> 5.50
                                    texture  { pigment { color Black }
                                               normal  { bozo scale <0.001,0.001,0.001> }
                                               finish  { phong 0.6
                                                         phong_size 20
                                                       }              
                                             }        
                                  } 
                               
                       }                                      

#declare erker = union { cylinder { <0,18.30,0> <0,22.10,0> 1 
                                    texture  { pigment { color Red }
                                               finish  { phong 0.6
                                                         phong_size 20
                                                       }              
                                             }        
                                  } 
                         sphere   { <0,18.30,0> 0.95
                                    texture  { pigment { color Red }
                                               finish  { phong 0.6
                                                         phong_size 20
                                                       }              
                                             }        
                                  }         
                         cylinder { <0,18.20,0> <0,18.40,0> 1.2
                                    texture  { pigment { color Red }
                                               finish  { phong 0.6
                                                         phong_size 20
                                                       }              
                                             }        
                                  } 
                         cylinder { <0,21.50,0> <0,21.80,0> 1.1
                                    texture  { pigment { color Red }
                                               finish  { phong 0.6
                                                         phong_size 20
                                                       }              
                                             }        
                                  } 
                         cylinder { <0,21.80,0> <0,22.00,0> 1.2
                                    texture  { pigment { color Red }
                                               finish  { phong 0.6
                                                         phong_size 20
                                                       }              
                                             }        
                                  } 
                         sphere   { <0,17.25,0> 0.3        
                                    texture  { pigment { color Red }
                                               finish  { phong 0.6
                                                         phong_size 20
                                                       }              
                                             }        
                                  }           
                       }        
                       
#declare hauptgallerie = union { difference { cylinder { <0,0,0> <0,1.38,0> 1.7 }
                                              union    { box      { <-3,-0.1,0> <3,1.5,3> }
                                                         cylinder { <0,-0.1,0> <0,1.5,0> 1.6
                                                                    texture { T_Chrome_5E }
                                                                  } 
                                                       }  
                                              texture  { pigment { color White }
                                                         finish  { phong 0.6
                                                                   phong_size 20
                                                                 }              
                                                       }        
                                            }
                                 #local i=0; #local delta_i=6;
                                 #while (i<delta_i)
                                   #local pos_1 = 1.7*<cos(i*pi/delta_i),sin(i*pi/delta_i)>;           
                                   #local pos_2 = 1.6*<cos(i*pi/delta_i),sin(i*pi/delta_i)>;           
                                   #local pos_3 = 1.7*<cos((i+1)*pi/delta_i),sin((i+1)*pi/delta_i)>;           
                                   #local pos_4 = 1.6*<cos((i+1)*pi/delta_i),sin((i+1)*pi/delta_i)>;           
                                   prism { 0, 0.1, 5,
                                           pos_1, pos_2, pos_4, pos_3, pos_1
                                           texture  { pigment { color White }
                                                      finish  { phong 0.6
                                                                phong_size 20
                                                              }              
                                                    }        
                                         }
                                   prism { 0.64, 0.74, 5,
                                           pos_1, pos_2, pos_4, pos_3, pos_1
                                           texture  { pigment { color White }
                                                      finish  { phong 0.6
                                                                phong_size 20
                                                              }              
                                                    }        
                                         }
                                   prism { 1.28, 1.38, 5,
                                           pos_1, pos_2, pos_4, pos_3, pos_1
                                           texture  { pigment { color White }
                                                      finish  { phong 0.6
                                                                phong_size 20
                                                              }              
                                                    }        
                                         }
                                   prism { 0.1, 1.28, 5,
                                           pos_1, pos_2, pos_2+0.1*(pos_4-pos_2), pos_1+0.1*(pos_3-pos_1), pos_1
                                           texture  { pigment { color White }
                                                      finish  { phong 0.6
                                                                phong_size 20
                                                              }              
                                                    }        
                                         }
                                   prism { 0.1, 1.28, 5,
                                           pos_3, pos_4, pos_4-0.1*(pos_4-pos_2), pos_3-0.1*(pos_3-pos_1), pos_3
                                           texture  { pigment { color White }
                                                      finish  { phong 0.6
                                                                phong_size 20
                                                              }              
                                                    }        
                                         }    
                                   prism { 0.1, 1.28, 5,
                                           pos_1+0.1*(pos_3-pos_1), pos_3-0.1*(pos_3-pos_1), pos_4-0.1*(pos_4-pos_2), pos_2+0.1*(pos_4-pos_2), pos_1+0.1*(pos_3-pos_1)
                                           texture { T_Old_Glass
                                                     normal  { bumps 0 } }
                                           interior { ior 1.5 }
                                         }
                                   #local i=i+1;
                                 #end 
                                 #if (feuer_an=1)
                                   light_source { <0,0,0>
                                                  color rgb <1,1,0>
                                                  looks_like { 
                                 #else
                                   object {           object {                 
                                 #end  
                                                               union { sphere { <0,0,0> 0.3
                                                                                texture { pigment {color rgb <1,1,0> }
                                                                                          finish { ambient 10 }
                                                                                        }
                                                                              }           
                                                                       cylinder { <0,0,0> <0,-1,0> 0.2       
                                                                                  texture { pigment {color Black}
                                                                                            finish { ambient 0.0
                                                                                                     phong 0.0
                                                                                                     specular 0.0
                                                                                                   }
                                                                                          }
                                                                                }           
                                                                     }          
                                                             } 
                                                  translate <0,0.8,0.20>
                                                } 
                               }          

#declare hauptfeuer = union { cylinder { <0,22.10,0> <0,24.16,0> 1.7
                                         texture  { pigment { color White }
                                                    finish  { phong 0.6
                                                              phong_size 20
                                                       }              
                                                  }        
                                       }                   
                              object { hauptgallerie translate <0,24.16,0> rotate <0,150,0> }         
                              intersection { sphere { <0,25.53,0> 1.7 }
                                             cylinder { <0,25.53,0>  <0,27.01,0> 2 }
                                             texture  { texture_kuppel }
                                           }           
                              intersection { torus    { 1.7+0.15 0.15 }
                                             cylinder { <0,0,0>  <0,-1,0> 2 }
                                             translate <0,25.53+0.07,0>
                                             texture  { texture_kuppel }
                                           }    
                              cylinder { <0,25.53+1.7,0> <0,25.53+1.7+0.4,0> 0.2
                                         texture  { texture_kuppel }
                                       }                           
                              sphere   { <0,25.53+1.7+0.6,0> 0.3        
                                         texture  { texture_kuppel }
                                       }             
                              cylinder { <0,25.53+2.3,0> <0,25.53+3.0,0> 0.05
                                         texture  { texture_kuppel }
                                       }                           
                            }                                     
                    
#declare nebengallerie = object { hauptgallerie
                                  scale <1/1.7,0.8,1/1.7>
                                  translate <0,22.71,0>
                                  rotate <0,180,0>
                                }  

#declare nebenfeuer = union { cylinder { <0,22.10,0> <0,22.71,0> 1 // <0,23.82,0> 1
                                         texture  { pigment { color White }
                                                    finish  { phong 0.6
                                                              phong_size 20
                                                            }              
                                                  }        
                                       }
                              object { nebengallerie rotate <0,150,0> }         
                              intersection { sphere { <0,23.82,0> 1 }
                                             cylinder { <0,23.82,0>  <0,27,0> 1.50 }
                                             texture  { texture_kuppel }
                                           }           
                              intersection { torus    { 1+0.15 0.15 }
                                             cylinder { <0,0,0>  <0,-1,0> 2 }
                                             translate <0,23.82+0.07,0>
                                             texture  { texture_kuppel }
                                           }    
                              cylinder { <0,24.82,0> <0,25.22,0> 0.2
                                         texture  { texture_kuppel }
                                       }                           
                              sphere   { <0,25.22,0> 0.3        
                                         texture  { texture_kuppel }
                                       }           
                              cylinder { <0,25.22,0> <0,25.22+0.5,0> 0.05
                                         texture  { texture_kuppel }
                                       }                           
                            }                                     

#declare erker_gelaender = union { torus { 0.95 0.04
                                           translate <0,22.60,0>
                                         }
                                   torus { 0.95 0.04
                                           translate <0,23.10,0>
                                         }      
                                   torus { 0.95 0.04
                                           translate <0,23.30,0>
                                         }      
                                   #local i=0;
                                   #while (i<10)
                                     cylinder { <0.95*cos(2*pi/10*i),22.09,0.95*sin(2*pi/10*i)>
                                                <0.95*cos(2*pi/10*i),23.30,0.95*sin(2*pi/10*i)>
                                                0.04
                                              }     
                                     sphere   { <0.95*cos(2*pi/10*i),23.30,0.95*sin(2*pi/10*i)> 0.08 }      
                                     sphere   { <0.95*cos(2*pi/10*i),23.10,0.95*sin(2*pi/10*i)> 0.08 }      
                                     sphere   { <0.95*cos(2*pi/10*i),22.60,0.95*sin(2*pi/10*i)> 0.08 }      
                                     #local i=i+1;
                                   #end  
                                   texture  { pigment { color White }
                                            }               
                                 }                      
                       
#declare haupt_gelaender = union { torus { 2.60 0.04
                                           translate <0,22.60,0>
                                         }
                                   torus { 2.60 0.04
                                           translate <0,23.10,0>
                                         }      
                                   torus { 2.60 0.04
                                           translate <0,23.30,0>
                                         }      
                                   #local i=0;
                                   #while (i<27)
                                     cylinder { <2.60*cos(2*pi/27*i),22.09,2.60*sin(2*pi/27*i)>
                                                <2.60*cos(2*pi/27*i),23.30,2.60*sin(2*pi/27*i)>
                                                0.04
                                              }     
                                     sphere   { <2.60*cos(2*pi/27*i),23.30,2.60*sin(2*pi/27*i)> 0.08 }      
                                     sphere   { <2.60*cos(2*pi/27*i),23.10,2.60*sin(2*pi/27*i)> 0.08 }      
                                     sphere   { <2.60*cos(2*pi/27*i),22.60,2.60*sin(2*pi/27*i)> 0.08 }      
                                     #local i=i+1;
                                   #end  
                                   texture  { pigment { color White }
                                            }               
                                 }                      
#local erker_offset=0.2;                       
#declare gelaender = union { difference { union { object { erker_gelaender 
                                                           translate <cos(0*pi/180)*(2.65+erker_offset),0,sin(0*pi/180)*(2.65+erker_offset)>
                                                         }  
                                                  object { erker_gelaender 
                                                           translate <cos(240*pi/180)*(2.65+erker_offset),0,sin(240*pi/180)*(2.65+erker_offset)>
                                                         }      
                                                }
                                          cylinder {<0,20,0> <0,30,0> 2.64}               
                                        }  
                             difference { object { haupt_gelaender }
                                          union { cylinder { <0,20,0> <0,30,0> 0.99
                                                             translate <cos(0*pi/180)*(2.65+erker_offset),0,sin(0*pi/180)*(2.65+erker_offset)>
                                                           }  
                                                  cylinder { <0,20,0> <0,30,0> 0.99
                                                             translate <cos(240*pi/180)*(2.65+erker_offset),0,sin(240*pi/180)*(2.65+erker_offset)>
                                                           }  
                                                }
                                        }  
                            }       


                    
#declare rotersand = object { union { object { turm }                              
                                      object { gelaender }
                                      object { erker 
                                               translate <cos(0*pi/180)*(2.65+erker_offset),0,sin(0*pi/180)*(2.65+erker_offset)>
                                             }  
                                      object { erker 
                                               translate <cos(120*pi/180)*(2.65+erker_offset),0,sin(120*pi/180)*(2.65+erker_offset)>
                                             }  
                                      object { erker 
                                               translate <cos(240*pi/180)*(2.65+erker_offset),0,sin(240*pi/180)*(2.65+erker_offset)>
                                             }      
                                      object { nebenfeuer
                                               translate <cos(120*pi/180)*(2.65+erker_offset),0,sin(120*pi/180)*(2.65+erker_offset)>
                                             }      
                                      union  { box { <0.6,22.10,0> <-0.6,23.82,2.65> 
                                                     texture { pigment { color White }
                                                               finish  { phong 0.6
                                                                         phong_size 20
                                                                       }              
                                                             }        
                                                   }          
                                               intersection { cylinder { <0,23.82,0> <0,23.82,2.65> 0.75 }
                                                              box      { <0.8,30,0> <-0.8,23.82,2.65> } 
                                                              texture { texture_kuppel }
                                                            }                                 
                                               rotate <0,-30,0>
                                             }  
                                      object { hauptfeuer }       
                                    }  
                            }       
                             
                   
object { rotersand rotate <0,-30,0> //parallelize (<0,1,0>, <50, 4, 150>)
      }    
      
