// ===========================================================================
//
// (C) Ian Shumsky / OuterArm 1999
//
// ===========================================================================

#include "colors.inc"
#include "skies.inc"
#include "headstone.inc"

//
// All Global settings.
//

#version 3.1;

global_settings
{
	assumed_gamma 1.0
}

global_settings
{
	max_trace_level 64 // needed for the sky stack
}

global_settings
{
	ambient_light rgb <230 / 255, 241 / 255, 247 / 255>
}

global_settings
{
	radiosity
	{
		count 800
		error_bound 0.2
		gray_threshold 0.5
		distance_maximum 0
		low_error_factor 0.7
		nearest_count 9
		minimum_reuse 0.01
		brightness 3.3
		recursion_limit 1
	}
}

//
// Place the camera...
//

camera
{
	location <1.5, 0.6, -1.25>
	look_at <3.25, 0.7, 0.005>
}

//
// Place the lights...
//

#declare sun_colour = <240 / 255, 247 / 255, 253 / 255>;
#declare sky_colour = SkyBlue * 0.8;

light_source
{
	<18000 , 36000, -49000 >
	color sun_colour * 1.1
}

light_source
{
	<5.25, 0.6, -1.5>
	color sun_colour / 3
	shadowless
}

//
// Add the sky and clouds.
//

#declare trace_clouds = 1;
#include "ian_sky.inc"

//
// Add the grass and ground.
//

#declare trace_grass = 4;
#include "grass.inc"

//
// Add the soil around the headstones.
//

#declare trace_soil = 1;
#include "soil.inc"

//
// Add the headstones.
//

#declare Px = 0;
#while (Px < 3)
	#declare Pz = 0;
	#while (Pz < 1)
		#declare Iz = 0;
		#while (Iz < 2)
			#declare Ix = 0;
			#while (Ix < 20)
				Headstone(<(Px * (12)) + (Ix * 0.5), 0, (Pz * 11) + (Iz * 2.2)>)
				#declare Ix = Ix + 1;
			#end
			#declare Iz = Iz + 1;
		#end
		#declare Pz = Pz + 1;
	#end
	#declare Px = Px + 1;
#end

//
// Add the trees.
//

#declare trace_trees = 1;
#include "tree.inc"

//
// Add a flower.
//

#declare trace_flower = 1;

#if (trace_flower > 0)
	#include "Rose.inc"
	#declare flower_rand = seed (1);
	object
	{
		Rose
		rotate z*(88 + (rand (flower_rand) * 4))
		rotate y*(rand (flower_rand) * 360)
		rotate x*(-2 + (rand (flower_rand) * 4))
		scale 2.54/80
		translate <2.98 + (rand (flower_rand) / 25), 0.3, -0.20>
	}
#end

