// ===========================================================================
//
// (C) Ian Shumsky / OuterArm 1999
//
// ===========================================================================
//
// The work done by this file depends upon the value of trace_grass. The
// following table gives details:
//
//   0 - Black plane
//   1 - Green plane
//   2 - Grass patches defined as boxes with image map
//   3 - Simple grass blade, true grass patches
//   4 - Full defined grass blade
//
// ===========================================================================

#include "colors.inc"

//
// Two simple macros which rotate an appropraite grass patch object and move
// it to the passed location.
//

#declare rot_rand = seed (1);

#macro place_patch_1 (patch_location)
	#local rot = rand (rot_rand) * 4;

	#if (rot < 1)
		#local rot_value = 0;
	#else
		#if (rot < 2)
			#local rot_value = 90;
		#else
			#if (rot < 3)
				#local rot_value = 180;
			#else
				#local rot_value = 270;
			#end
		#end
	#end

	object
	{
		grass_patch_1
		rotate y*rot_value
		translate patch_location
	}
#end

#macro place_patch_2 (patch_location)
	#local rot = rand (rot_rand) * 2;

	#if (rot < 1)
		#local rot_value = 0;
	#else
		#local rot_value = 180;
	#end

	object
	{
		grass_patch_2
		rotate y*rot_value
		translate patch_location
	}
#end

#if (trace_grass < 2)
	plane
	{
		<0, 1, 0>, 0
		pigment
		{
			#if (trace_grass = 0)
				colour Black
			#else
				colour Green
			#end
		}
	}
#else
	#if (trace_grass = 2)
		#declare grass_patch_1 = box
		{
			<-0.25, 0, -0.25> <0.25, 0.1, 0.25>
			pigment
			{
				image_map
				{
					tga "grass_image_map.tga"
				}
				rotate x*90
				scale <0.5, 1, 0.5>
			}
		}

		#declare grass_patch_2 = box
		{
			<-0.25, 0, -0.35> <0.25, 0.1, 0.35>
			pigment
			{
				image_map
				{
					tga "grass_image_map.tga"
				}
				rotate x*90
				scale <0.5, 1, 0.5>
			}
		}
	#else
		//
		// Build a proper patch of grass from individual blades.
		//

		#declare Blanc1 = rgb <0.90, 0.81, 0.81>;
		#declare Green1 = rgb <230, 170, 50> / 255;
		#declare Green2 = rgb <110, 160, 8> / 255;

		#declare SpottedPig = pigment
		{
			spotted
			color_map
			{
				[0.0, 0.2 color Tan*1.3 color Tan*0.4]
				[0.2, 0.3 color Tan*0.4 color Green2]
				[0.3, 1.01 color Green2 color Green2*1.2]
			}
			scale 0.01
		}

		#declare EarthPig = pigment
		{
			spotted
			color_map
			{
				[0 color Tan*0.3]
				[0.6 color Tan*0.3]
				[0.6 color Clear]
				[1 color Clear]
			}
			scale <0.001, 2, 0.001>
		}

		#declare GreenPig = pigment
		{
			Green1 * 1.3
		}

		#declare GrassTxt = texture
		{
			pigment
			{
				gradient y
				turbulence 0.2
				pigment_map
				{
					[0.00 EarthPig]
					[0.15 GreenPig]
					[0.9 SpottedPig]
					[1.00 EarthPig]
				}
			}
			finish
			{
				ambient 0.01
				diffuse 0.7
				specular 0.4
				roughness 0.015
			}
		}

		//
		// Build an individual blade
		//

		#declare zBrin0 = 7;
		#declare zBrin = zBrin0;
		#declare TetaZDebut = 0;
		#declare TetaZFin = 2*pi;
		#declare TetaYDebut = 0;
		#declare TetaYFin = pi;
		#declare rTerre = 150;

		#declare iTetaZ = pi/50;
		#declare iTetaY = pi/50;
		#declare TetaY = 0;
		#declare yMax = 0;
		#declare zBrin0 = 4;
		#declare zBrin = zBrin0;

		#declare BScale = 500; // 1 = mm, 10 = cm, 1000 = m

		#declare Blade = mesh
		{
			#declare CountRand = 1;
			#declare xS = 0;
			#declare zS0 = 0;
			#declare zBrin = zBrin0;
			#declare zBrinFin = zBrin0*0.1;
			#declare xS0 = 0;
			#declare yS0 = 0;
			#declare zS0 = zBrin;
			#declare Count = 1;
			#declare X3 = -1;
			#declare X2 = 46;
			#declare X1 = 3;
			#declare DV1 = 1;
			#declare DV2 = 2500;

			#if (trace_grass < 4)
				#declare nS = 2;
			#else
				#declare nS = 50;
			#end

			#declare dDebut = 5;
			#declare dFin = 0.5;
			#declare nC = 55;

			#while (Count<nS+1)
				#declare yS = Count*nC/nS;
				#declare xS = ((X3*pow(yS/DV1, 3))+(X2*pow(yS/DV1, 2))+(X1*yS/DV1))/DV2;
				#declare zS = (zBrin-(Count*(zBrin-zBrinFin)/nS));
				#declare ralpha = atan2(zS, xS);
				#declare ralpha0 = atan2(zS0, xS0);
				#declare xL = sqrt(pow(xS, 2)+pow(zS, 2));
				#declare xL0 = sqrt(pow(xS0, 2)+pow(zS0, 2));

				#declare xS0a = (xL0*cos(-ralpha0));
				#declare xS0b = (xL0*cos(ralpha0));
				#declare yS0a = yS0;
				#declare zS0a = (xL0*sin(-ralpha0));
				#declare zS0b = (xL0*sin(ralpha0));

				#declare xSa = (xL*cos(-ralpha));
				#declare xSb = (xL*cos(+ralpha));
				#declare ySa = yS;
				#declare zSa = (xL*sin(-ralpha));
				#declare zSb = (xL*sin(ralpha));

				#declare xM0 = xS0-(zS0/3);
				#declare xM = xS-(zS/3);

				#declare xM0a = xM0;
				#declare xMa = xM;

				#declare yM0a = yS0a;
				#declare yMa = ySa;

				#declare zM0a = 0;
				#declare zMa = 0;

				triangle
				{
					<xS0a/BScale, yS0a/BScale, zS0a/BScale>,
					<xMa/BScale, yMa/BScale, zMa/BScale>,
					<xSa/BScale, ySa/BScale, zSa/BScale>
				}

				triangle
				{
					<xS0a/BScale, yS0a/BScale, zS0a/BScale>,
					<xMa/BScale, yMa/BScale, zMa/BScale>,
					<xM0a/BScale, yM0a/BScale, zM0a/BScale>
				}
 
				triangle
				{
					<xS0b/BScale, yS0a/BScale, zS0b/BScale>,
					<xMa/BScale, yMa/BScale, zMa/BScale>,
					<xM0a/BScale, yM0a/BScale, zM0a/BScale>
				}

				triangle
				{
					<xS0b/BScale, yS0a/BScale, zS0b/BScale>,
					<xMa/BScale, yMa/BScale, zMa/BScale>,
					<xSb/BScale, ySa/BScale, zSb/BScale>
				}

				#if (ySa>yMax)
					#declare yMax = ySa;
				#end

				#declare yS0 = yS;
				#declare xS0 = xS;
				#declare zS0 = zS;
				#declare Count = Count+1;
			#end
		}

		//
		// Build the grass patch
		//

		#declare nBrinX = 25;
		#declare nBrinZ = 25;
		#declare iBrin = 10;
		#declare BScale = 1000;

		#declare R1 = seed (100);

		#declare grass_patch_1 = union
		{
			#declare cX = -nBrinX;
			#while (cX<nBrinX)
				#declare cZ = -nBrinZ;
				#while (cZ<nBrinZ)
					#declare scBrin = (rand(R1)+rand(R1))*0.5 +0.5;
					#declare tetaBrin = 360*(rand(R1)+rand(R1));
					#declare mvX = iBrin*(1-rand(R1)-rand(R1));
					#declare mvZ = iBrin*(1-rand(R1)-rand(R1));

					object
					{
						Blade
						scale 0.5
						rotate <tetaBrin/50, tetaBrin, tetaBrin/50>
						scale scBrin*2
						translate <((cX*iBrin) +mvX)/BScale, 0, ((cZ*iBrin)+mvZ)/BScale>
					}

					#declare cZ = cZ+1;
				#end
				#declare cX = cX+1;
			#end

			texture
			{
				GrassTxt
				scale (yMax*1.2)/500
				translate (y-0.1)/500
			}
		}

		#declare nBrinX = 25;
		#declare nBrinZ = 35;
		#declare iBrin = 10;

		#declare grass_patch_2 = union
		{
			#declare cX = -nBrinX;
			#while (cX<nBrinX)
				#declare cZ = -nBrinZ;
				#while (cZ<nBrinZ)
					#declare scBrin = (rand(R1)+rand(R1))*0.5 +0.5;
					#declare tetaBrin = 360*(rand(R1)+rand(R1));
					#declare mvX = iBrin*(1-rand(R1)-rand(R1));
					#declare mvZ = iBrin*(1-rand(R1)-rand(R1));

					object
					{
						Blade
						scale 0.5
						rotate <tetaBrin/50, tetaBrin, tetaBrin/50>
						scale scBrin*2
						translate <((cX*iBrin) +mvX)/BScale, 0, ((cZ*iBrin)+mvZ)/BScale>
					}

					#declare cZ = cZ+1;
				#end
				#declare cX = cX+1;
			#end

			texture
			{
				GrassTxt
				scale (yMax*1.2)/500
				translate (y-0.1)/500
			}
		}
	#end

	//
	// Position all the grass patches. Start with the first row we can see.
	//

	place_patch_1 (<2.5, 0.05, -1.2>)
	place_patch_1 (<3, 0.05, -1.2>)
	place_patch_1 (<3.5, 0.05, -1.2>)
	place_patch_1 (<4, 0.05, -1.2>)
	place_patch_1 (<4.5, 0.05, -1.2>)
	place_patch_1 (<5, 0.05, -1.2>)
	place_patch_1 (<5.5, 0.05, -1.2>)
	place_patch_1 (<6, 0.05, -1.2>)
	place_patch_1 (<6.5, 0.05, -1.2>)
	place_patch_1 (<7, 0.05, -1.2>)
	place_patch_1 (<7.5, 0.05, -1.2>)
	place_patch_1 (<8, 0.05, -1.2>)
	place_patch_1 (<8.5, 0.05, -1.2>)
	place_patch_1 (<9, 0.05, -1.2>)
	place_patch_1 (<9.5, 0.05, -1.2>)

	//
	// Row 2
	//

	place_patch_1 (<2, 0.05, -0.7>)
	place_patch_1 (<2.5, 0.05, -0.7>)
	place_patch_1 (<3, 0.05, -0.7>)
	place_patch_1 (<3.5, 0.05, -0.7>)
	place_patch_1 (<4, 0.05, -0.7>)
	place_patch_1 (<4.5, 0.05, -0.7>)
	place_patch_1 (<5, 0.05, -0.7>)
	place_patch_1 (<5.5, 0.05, -0.7>)
	place_patch_1 (<6, 0.05, -0.7>)
	place_patch_1 (<6.5, 0.05, -0.7>)
	place_patch_1 (<7, 0.05, -0.7>)
	place_patch_1 (<7.5, 0.05, -0.7>)
	place_patch_1 (<8, 0.05, -0.7>)
	place_patch_1 (<8.5, 0.05, -0.7>)
	place_patch_1 (<9, 0.05, -0.7>)
	place_patch_1 (<9.5, 0.05, -0.7>)
	place_patch_1 (<10, 0.05, -0.7>)
	place_patch_1 (<10.5, 0.05, -0.7>)
	place_patch_1 (<11, 0.05, -0.7>)
	place_patch_1 (<11.5, 0.05, -0.7>)
	place_patch_1 (<12, 0.05, -0.7>)
	place_patch_1 (<12.5, 0.05, -0.7>)
	place_patch_1 (<13, 0.05, -0.7>)
	place_patch_1 (<13.5, 0.05, -0.7>)
	place_patch_1 (<14, 0.05, -0.7>)
	place_patch_1 (<14.5, 0.05, -0.7>)
	place_patch_1 (<15, 0.05, -0.7>)
	place_patch_1 (<15.5, 0.05, -0.7>)
	place_patch_1 (<16, 0.05, -0.7>)
	place_patch_1 (<16.5, 0.05, -0.7>)
	place_patch_1 (<17, 0.05, -0.7>)
	place_patch_1 (<17.5, 0.05, -0.7>)
	place_patch_1 (<18, 0.05, -0.7>)
	place_patch_1 (<18.5, 0.05, -0.7>)
	place_patch_1 (<19, 0.05, -0.7>)
	place_patch_1 (<19.5, 0.05, -0.7>)
	place_patch_1 (<20, 0.05, -0.7>)
	place_patch_1 (<20.5, 0.05, -0.7>)
	place_patch_1 (<21, 0.05, -0.7>)
	place_patch_1 (<21.5, 0.05, -0.7>)
	place_patch_1 (<22, 0.05, -0.7>)
	place_patch_1 (<22.5, 0.05, -0.7>)

	//
	// Row 3
	//

	place_patch_1 (<2.5, 0.0, 0.5>)
	place_patch_1 (<3, 0.0, 0.5>)
	place_patch_1 (<12.5, 0.0, 0.5>)
	place_patch_1 (<13, 0.0, 0.5>)
	place_patch_1 (<13.5, 0.0, 0.5>)
	place_patch_1 (<14, 0.0, 0.5>)
	place_patch_1 (<14.5, 0.0, 0.5>)
	place_patch_1 (<15, 0.0, 0.5>)
	place_patch_1 (<15.5, 0.0, 0.5>)
	place_patch_1 (<16, 0.0, 0.5>)
	place_patch_1 (<16.5, 0.0, 0.5>)
	place_patch_1 (<17, 0.0, 0.5>)

	//
	// Row 4
	//

	place_patch_1 (<2.5, 0.0, 1>)
	place_patch_1 (<3, 0.0, 1>)
	place_patch_1 (<15.5, 0.0, 1>)
	place_patch_1 (<16, 0.0, 1>)
	place_patch_1 (<16.5, 0.0, 1>)
	place_patch_1 (<17, 0.0, 1>)
	place_patch_1 (<17.5, 0.0, 1>)
	place_patch_1 (<18, 0.0, 1>)
	place_patch_1 (<18.5, 0.0, 1>)
	place_patch_1 (<19, 0.0, 1>)
	place_patch_1 (<19.5, 0.0, 1>)
	place_patch_1 (<20, 0.0, 1>)
	place_patch_1 (<20.5, 0.0, 1>)

	//
	// Row 5
	//

	place_patch_1 (<3, 0.0, 1.5>)
	place_patch_1 (<3.5, 0.0, 1.5>)
	place_patch_1 (<19, 0.0, 1.5>)
	place_patch_1 (<19.5, 0.0, 1.5>)
	place_patch_1 (<20, 0.0, 1.5>)
	place_patch_1 (<20.5, 0.0, 1.5>)
	place_patch_1 (<21, 0.0, 1.5>)
	place_patch_1 (<21.5, 0.0, 1.5>)
	place_patch_1 (<22, 0.0, 1.5>)
	place_patch_1 (<22.5, 0.0, 1.5>)
	place_patch_1 (<23, 0.0, 1.5>)
	place_patch_1 (<23.5, 0.0, 1.5>)
	place_patch_1 (<24, 0.0, 1.5>)
	place_patch_1 (<24.5, 0.0, 1.5>)

	//
	// Filler 1
	//

	place_patch_2 (<10, 0.0, 0>)
	place_patch_2 (<10.5, 0.0, 0>)
	place_patch_2 (<11, 0.0, 0>)
	place_patch_2 (<11.5, 0.0, 0>)

	//
	// Filler 2
	//

	place_patch_2 (<22, 0.0, 0>)
	place_patch_2 (<22.5, 0.0, 0>)
	place_patch_2 (<23, 0.0, 0>)
	place_patch_2 (<23.5, 0.0, 0>)

	//
	// Filler 3
	//

	place_patch_2 (<23, 0.0, 2.2>)
	place_patch_2 (<23.5, 0.0, 2.2>)
#end

