// ===========================================================================
//
// (C) Ian Shumsky / OuterArm 1999
//
// ===========================================================================
//
// This include file builds headstones. It also includes a macro which
// poitions the headstones at the passed location.
//
// The amount of detail on the stones is controlled by the detail flag. This
// flag can be true or false.
//
// ===========================================================================

#declare Next_name = 1;

#declare Name = ""
#declare Name_length = 0;
#declare Regiment = ""
#declare Regiment_flag = false;
#declare Date = ""
#declare Date_length = 0;

#include "inscription.inc"

#declare detail = true;
//#declare detail = false;

//
// Modified versions of Stones.inc textures
//

//----- Translucent T_Grnt0
#declare T_Grnt0a = texture
{
	pigment
	{
		granite
		turbulence 0.6
		color_map
		{
			[0.000, 0.153 color rgbf <0.729, 0.502, 0.451, 0.306> color rgbf <0.769, 0.686, 0.592, 0.792>]
			[0.153, 0.398 color rgbf <0.769, 0.686, 0.592, 0.792> color rgbf <0.843, 0.753, 0.718, 0.396>]
			[0.398, 0.559 color rgbf <0.843, 0.753, 0.718, 0.396> color rgbf <0.780, 0.667, 0.561, 0.976>]
			[0.559, 0.729 color rgbf <0.780, 0.667, 0.561, 0.976> color rgbf <0.741, 0.659, 0.576, 0.820>]
			[0.729, 1.001 color rgbf <0.741, 0.659, 0.576, 0.820> color rgbf <0.729, 0.502, 0.451, 0.306>]
		}
	}
}

//-----Filter Creams With T_Cracks
#declare T_Grnt9a = texture
{
	pigment
	{
		granite
		turbulence 0.6
		color_map
		{
			[0.000, 0.216 color rgbf <0.812, 0.812, 0.812, 0.835> color rgbf <0.745, 0.843, 0.835, 0.847>]
			[0.216, 0.241 color rgbf <0.745, 0.843, 0.835, 0.847> color rgbf <0.404, 0.337, 0.337, 0.463>]
			[0.241, 0.267 color rgbf <0.404, 0.337, 0.337, 0.463> color rgbf <0.773, 0.729, 0.745, 0.622>]
			[0.267, 0.759 color rgbf <0.773, 0.729, 0.745, 0.622> color rgbf <0.914, 0.843, 0.725, 0.651>]
			[0.759, 0.784 color rgbf <0.914, 0.843, 0.725, 0.651> color rgbf <0.153, 0.133, 0.208, 0.437>]
			[0.784, 0.810 color rgbf <0.153, 0.133, 0.208, 0.437> color rgbf <0.812, 0.812, 0.812, 0.835>]
			[0.810, 1.001 color rgbf <0.812, 0.812, 0.812, 0.835> color rgbf <0.812, 0.812, 0.812, 0.835>]
		}
	}
}

//------------- Gray Granite with white patches
#declare T_Stone8 = texture
{
	pigment
	{
		color White
	}
	finish
	{
		ambient 0.6
		crand 0.06
		diffuse 0.7
	}
}
texture
{
	T_Grnt0a
	scale <0.02, 0.02, 0.02>
	rotate <0, 0, -30>
}
texture
{
	T_Grnt9a
	scale <0.02, 0.02, 0.02>
	rotate <0, 0, 40>
	finish
	{
		phong 1.0
		ambient 0.2
		diffuse 0.5
		phong_size 90
	}
}

#if (detail = true)
	#declare Headstone_01 = merge
	{
		box
		{
			<-0.19, 0, -0.09>, <0.19, 1, 0.09>
		}
		box
		{
			<-0.18, 0, -0.1>, <0.18, 1, 0.1>
		}
		cylinder
		{
			<-0.18, 0, -0.09>, <-0.18, 1, -0.09>, 0.01
		}
		cylinder
		{
			<0.18, 0, 0.09>, <0.18, 1, 0.09>, 0.01
		}
		cylinder
		{
			<-0.18, 0, 0.09>, <-0.18, 1, 0.09>, 0.01
		}
		cylinder
		{
			<0.18, 0, -0.09>, <0.18, 1, -0.09>, 0.01
		}
		intersection
		{
			merge
			{
				cylinder
				{
					<0, 0.6, -0.09>, <0, 0.6, 0.09>, 0.5
				}
				cylinder
				{
					<0, 0.6, -0.1>, <0, 0.6, 0.1>, 0.49
				}
				object
				{
					torus
					{
						0.49, 0.01
					}
					rotate x*90
					translate <0, 0.6, -0.09>
				}
				object
				{
					torus
					{
						0.49, 0.01
					}
					rotate x*90
					translate <0, 0.6, 0.09>
				}
			}
			merge
			{
				box
				{
					<-0.19, 1, -0.09>, <0.19, 2, 0.09>
				}
				box
				{
					<-0.18, 1, -0.11>, <0.18, 2, 0.11>
				}
				cylinder
				{
					<-0.18, 1, -0.09>, <-0.18, 2, -0.09>, 0.01
				}
				cylinder
				{
					<0.18, 1, 0.09>, <0.18, 2, 0.09>, 0.01
				}
				cylinder
				{
					<-0.18, 1, 0.09>, <-0.18, 2, 0.09>, 0.01
				}
				cylinder
				{
					<0.18, 1, -0.09>, <0.18, 2, -0.09>, 0.01
				}
			}
		}
	}
#else
	#declare Headstone_01 = box
	{
		<-0.19, 0, -0.09>, <0.19, 1, 0.09>
	}
#end

#declare PierreTxt=texture
{
	pigment
	{
		crackle
		turbulence 0.5
		lambda 3
		color_map
		{
			[0.000, 0.154 color rgbf <0.894, 0.886, 0.886, 0.000> color rgbf <0.745, 0.745, 0.753, 0.000>]
			[0.154, 0.308 color rgbf <0.745, 0.745, 0.753, 0.000> color rgbf <0.902, 0.902, 0.859, 0.000>]
			[0.308, 0.444 color rgbf <0.902, 0.902, 0.859, 0.000> color rgbf <0.729, 0.706, 0.694, 0.000>]
			[0.444, 0.615 color rgbf <0.729, 0.706, 0.694, 0.000> color rgbf <0.588, 0.592, 0.635, 0.000>]
			[0.615, 0.803 color rgbf <0.588, 0.592, 0.635, 0.000> color rgbf <0.608, 0.616, 0.659, 0.000>]
			[0.803, 1.001 color rgbf <0.608, 0.616, 0.659, 0.000> color rgbf <0.894, 0.886, 0.886, 0.000>]
		}
	}
	normal
	{
		crackle 2
		turbulence 0.5
		lambda 3
	}
	finish
	{
		ambient 0.01
		diffuse 0.5
		specular 0.1
		roughness 0.2
	}
	scale 1
}

#declare cross_1 = merge
{
	box
	{
		<-0.01, -0.2, 0>, <0.01, 0.1, -1>
	}
	box
	{
		<-0.1, -0.01, 0>, <0.1, 0.01, -1>
	}
}

#declare cross_2 = merge
{
	box
	{
		<-0.01, -0.1, 0>, <0.01, 0.1, -1>
	}
	box
	{
		<-0.1, -0.01, 0>, <0.1, 0.01, -1>
	}
}

#declare cross_3 = merge
{
	//
	// Main cross.
	//

	box
	{
		<-0.01, -0.2, 0>, <0.01, 0.1, -1>
	}
	box
	{
		<-0.1, -0.01, 0>, <0.1, 0.01, -1>
	}

	//
	// small boxes on cross bar
	//

	box
	{
		<-0.1, -0.015, 0>, <-0.105, 0.015, -1>
	}
	box
	{
		<0.1, -0.015, 0>, <0.105, 0.015, -1>
	}

	//
	// small boxes on top and bottom
	//

	box
	{
		<-0.015, 0.1, 0>, <0.015, 0.105, -1>
	}
	box
	{
		<-0.015, -0.2, 0>, <0.015, -0.205, -1>
	}
}

#declare sod_part1 = difference
{
	cylinder
	{
		<0, 0, 0>, <0, 0, -0.2>, 1
	}
	box
	{
		<-10, 0.5, -10>, <10, 10, 10>
	}
	box
	{
		<-10, 0.5, -10>, <10, 10, 10>
		rotate z*120
	}
	box
	{
		<-10, 0.5, -10>, <10, 10, 10>
		rotate z*240
	}
}

#declare sod_part2 = difference
{
	object
	{
		sod_part1
	}
	object
	{
		sod_part1
		scale <0.8, 0.8, 10>
	}
}

#declare star_of_david = union
{
	object
	{
		sod_part2
	}
	object
	{
		sod_part2
	rotate z*180
	}
}

#declare Headstone_texture = texture
{
	T_Stone8
}

#declare r1 = seed (1);

#macro Headstone (Location)
Get_inscription ()

difference
{
	object
	{
		Headstone_01
		scale <0.9 + (rand (r1) / 50), 0.9 + (rand (r1) / 50), 0.9 + (rand (r1) / 50)>
	}
	#if (detail = true)
		#declare cross_type = rand(r1);

		#if (cross_type < 0.5)
			object
			{
				cross_1
				translate <-0.001 + (rand (r1) / 500), 0.6 + (rand (r1) / 10), -0.085>
			}
		#else
			#if (cross_type < 0.65)
				object
				{
					cross_2
					translate <-0.001 + (rand (r1) / 500), 0.6 + (rand (r1) / 10), -0.085>
				}
			#else
				#if (cross_type < 0.9)
					object
					{
						cross_3
						translate <-0.001 + (rand (r1) / 500), 0.6 + (rand (r1) / 10), -0.085>
					}
				#else
					object
					{
						star_of_david
						scale <0.1, 0.1, 1>
						translate <-0.001 + (rand (r1) / 500), 0.6 + (rand (r1) / 10), -0.085>
					}
				#end
			#end
		#end

		texture
		{
			Headstone_texture
			translate <rand (r1) * 10, rand (r1) * 10, rand (r1) * 10>
		}
	#else
		pigment
		{
			colour Gray90
		}
	#end

	rotate <0, -1 + (2 *rand (r1)), 0>
	rotate <-1 + (2 *rand (r1)), 0, 0>
	rotate <0, 0, -1 + (2 *rand (r1))>
	translate Location
	translate <-0.01 + (rand (r1) / 50), -0.01 + (rand (r1) / 50), -0.01 + (rand (r1) / 50)>
}
#end
