// =========================================================================== 
//
// (C) Ian Shumsky / OuterArm 1999
//
// =========================================================================== 
//
// This include file provides the sky for the scene. The detail of the sky
// is controllled by the trace_sky switch. This switch can take any of the
// following values:
//
// 0 - No clouds
// 1 - All clouds with most definition
// 2 - All clouds, but less levels
//
// =========================================================================== 

//
// The colour of the sky.
//

sky_sphere
{
	pigment
	{
		sky_colour
	}
}

//
// The cloud planes. These cloud planes are based on those developed by
// in his Canyon entry of the 'Landmarks' IRTC round.
//

#if (trace_clouds > 0)
	#if (trace_clouds = 2)
		#declare num_planes = 4;
	#else
		#declare num_planes = 20;
	#end

	#declare clouds_height = 5000;
	#declare plane_dist = 40;
	#declare textu_dist = 40;
	#declare cnt_planes = 1;

	//
	// Create the first cloud layer. This layer is quite dark and broody.
	//

	union
	{
		#while (cnt_planes <= num_planes)
			#declare p = sky_colour * .5 + White * .5;
			#declare p1 = p * (1 - (cnt_planes / num_planes)) + White * (cnt_planes / num_planes);
			#declare p2 = p * .9 * (1 - (cnt_planes / num_planes)) + White * .9 * (cnt_planes / num_planes);

			plane
			{
				y, 0
				texture
				{
					pigment
					{
						agate
						octaves 9
						lambda 3
						turbulence 4
						color_map
						{
							[0.0 Clear]
							[0.6 Clear]
							[0.7 p1 filter 0.7 + 0.1 * (cnt_planes / num_planes)]
							[1.0 p2 filter 0.7 + 0.1 * (cnt_planes / num_planes)]
						}
						scale 1000000
					}
					finish
					{
						ambient sun_colour
					}
					translate (clouds_height + textu_dist * cnt_planes) * y
				}

				no_shadow
				translate (clouds_height + plane_dist * cnt_planes) * y
			}

			#declare cnt_planes = cnt_planes + 1;
		#end
		translate 7000 * z
	}

	//
	// The second layer of clouds. This layer has a different base texture
	// which gives a more 'solid' type cloud. It is also higher than the first
	// level.
	//

	#declare clouds_height = 7500;
	#declare cnt_planes = 1;

	union
	{
		#while (cnt_planes <= num_planes)
			#declare p = sky_colour * .5 + White * .5;
			#declare p1 = p * (1 - (cnt_planes / num_planes)) + White * (cnt_planes / num_planes);
			#declare p2 = p * .9 * (1 - (cnt_planes / num_planes)) + White * .9 * (cnt_planes / num_planes);

			plane
			{
				y, 0
				texture
				{
					pigment
					{
						marble
						octaves 9
						lambda 3
						turbulence 4
						color_map
						{
							[0.0 Clear]
							[0.6 Clear]
							[0.7 p1 filter 0.7 + 0.1 * (cnt_planes / num_planes)]
							[1.0 p2 filter 0.7 + 0.1 * (cnt_planes / num_planes)]
						}
						scale 1000000
					}
					finish
					{
						ambient sun_colour
					}
					translate (clouds_height + textu_dist * cnt_planes) * y
				}

				no_shadow
				translate (clouds_height + plane_dist * cnt_planes) * y
			}

			#declare cnt_planes = cnt_planes + 1;
		#end
		translate 7000 * z
	}

	//
	// Finally, place a third level of clouds for a final 'whispy' set
	// of clouds.
	//

	#declare num_planes = 2;
	#declare clouds_height = 15000;
	#declare plane_dist = 40;
	#declare textu_dist = 40;
	#declare cnt_planes = 1;

	union
	{
		#while (cnt_planes <= num_planes)
			#declare p = White*1.2;
			#declare p1 = p*(1-(cnt_planes/num_planes))+White*(cnt_planes/num_planes);
			#declare p2 = p*.9*(1-(cnt_planes/num_planes))+White*.9*(cnt_planes/num_planes);

			plane
			{
				y, 0
				texture
				{
					pigment
					{
						ripples
						octaves 9
						lambda 3
						turbulence 4
						color_map
						{
							[0.0 Clear]
							[0.4 Clear]
							[0.7 p1 filter 0.8+0.1*(cnt_planes/num_planes)]
							[1.0 p2 filter 0.8+0.1*(cnt_planes/num_planes)]
						}
						scale 100000
					}
					finish
					{
						ambient sun_colour
					}
					translate (clouds_height+textu_dist*cnt_planes)*y
				}
				no_shadow
				translate (clouds_height+plane_dist*cnt_planes)*y
			}
			#declare cnt_planes = cnt_planes+1;
		#end
		rotate y*45
	}
#end
