
// Glenn's Rose POV-Ray Object File
// This file does not render.  #include "Rose.inc" in another .pov file
// first concept 19-Sep-97  last update 19-Sep-97
// copyright 1997 Glenn McCarter

// A single red rose
// Intended scale is English system (inches)
// rose stem runs along -X, bloom into +X, origin at base of bloom
// Uses RH coord system

//===============================================
//             Textures
//===============================================

#declare RoseTex = texture
{
	pigment
	{
		color rgb <.99,.02,.12>
	}
	finish
	{
		ambient .02
		specular .35
		roughness .12
	}
}

#declare LeafGreen = texture
{
	pigment
	{
		color rgb<.08,.55,.05>
	}
	finish
	{
		ambient .02
		specular .76
		roughness .02
	}
}

#declare StemTex = texture
{
	pigment
	{
		color rgb<.16,.43,.08>
	}
	finish
	{
		ambient .02
		specular .67
		roughness .05
	}
}

//===============================================
//             Objects
//===============================================

#include "RoseLeaf.inc"
#include "Rosepetl.inc"

#declare LeafWithStem =
	union {
		object { Leaf // runs into +X, already translated
			scale 1
			translate <.0,0,-.0>
		}
		object { LeafStem // runs into +X
			scale 1
			translate <.0,0,-.0>
		}
		texture { LeafGreen }
		translate <0,0,0>
	} // end union

#declare Thorn =
	cone {
		<0,0,0>,.2,<0,0,.4>,.01
		scale <1,.3,1>
		texture { StemTex }
	}
#declare RoseStem =
	object { Stem
		texture { StemTex }
	}
#declare RoseStemAssy =
	union {
		object { RoseStem rotate <0,90,0> rotate <180,0,0> }
		object { LeafWithStem rotate <-10,60,0> translate <-4,0,0> rotate <-130,0,0> }
		object { LeafWithStem rotate <10,40,0> translate <-4.8,0,0> rotate <120,0,0> }
		object { Thorn translate <0,.18,0> rotate <40,0,0> translate <-5,0,0> }
		object { Thorn translate <0,.18,0> rotate <-60,0,0> translate <-3,0,0> }
		object { Thorn translate <0,.18,0> rotate <60,0,0> translate <-4,0,0> }
		object { Thorn translate <0,.18,0> rotate <-120,0,0> translate <-4.5,0,0> }
		scale .6
	}

#declare OuterPetal =
	object { PetalLarge1
		scale .4
		texture { RoseTex }
		translate <0,0,-.0>
	}
#declare MainPetal =
	object { PetalLarge
		scale .4
		texture { RoseTex }
		translate <0,0,-.0>
	}
#declare MedPetal =
	object { PetalMed
		scale .4
		texture { RoseTex }
		translate <0,0,-.0>
	}
#declare SmallPetal =
	object { PetalNarrow
		scale .4
		texture { RoseTex }
		translate <0,0,-.0>
	}
#declare RoseBloom =
	union {
		#declare PCount = 0
		#while (PCount < 4)
			object { OuterPetal rotate <0,18,0> translate <0,0,-.3> rotate <PCount*90,0,0> }
			object { MainPetal rotate <0,13,0> translate <0,0,-.2> rotate <PCount*90+20,0,0> }
			object { MedPetal rotate <0,09,0> translate <0,0,-.1> rotate <PCount*90+50,0,0> }
			object { SmallPetal rotate <0,05,0> translate <0,0,-.0> rotate <PCount*90+70,0,0> }
		#declare PCount = PCount+1
		#end
	}

#declare Rose =
	union {
		object { RoseStemAssy }
		object { RoseBloom rotate <0,20,0> }
	}
