// ===========================================================================
//
// (C) Ian Shumsky / OuterArm 1999
//
// ===========================================================================
//
// Some soil. The creation and placement depends upon the value of the
// trace_soil switch. Valid values are:
//
//   0 - do not trace soil
//   1 - trace soil
//
// ===========================================================================

#if (trace_soil > 0)
	//
	// Create a heightfield object for a part of the soil.
	//

	#declare mhf_1 = height_field
	{
		gif "soil_under_headstone_hf_1.gif"
		smooth
		translate <-0.5, 0.05, -0.5>
		scale <0.5, 0.04, 0.7>
	}

	//
	// Create a second heightfield object. The source image for the second
	// heightfield is a mirror of the source image for the first. This means
	// that they will seamlessly fit together.
	//

	#declare mhf_2 = height_field
	{
		gif "soil_under_headstone_hf_2.gif"
		smooth
		translate <-0.5, 0.05, -0.5>
		scale <0.5, 0.04, 0.7>
	}

	//
	// Now, build a single object of 20 base heightfields and texture it.
	//

	#declare Px = 0;

	#declare soil = union
	{
		#declare Ix = 0;

		#while (Ix < 20)
			#if (mod (Ix, 2) = 0)
				object
				{
					mhf_1
					translate <(Ix * 0.5), 0, 0>
				}
			#else
				object
				{
					mhf_2
					translate <(Ix * 0.5), 0, 0>
				}
			#end

			#declare Ix = Ix + 1;
		#end

		texture
		{
			pigment
			{
				granite
				lambda 2
				turbulence 4
				color_map
				{
					[0.00 rgb <45/255, 44/255, 8/255> / 3]
					[0.02 rgb <53/255, 47/255, 40/255> / 3]
					[0.04 rgb <74/255, 48/255, 14/255> / 3]
					[0.06 rgb <76/255, 48/255, 45/255> / 3]
					[0.08 rgb <80/255, 77/255, 45/255> / 3]
					[0.10 rgb <118/255, 112/255, 3/255> / 3]
					[0.12 rgb <138/255, 84/255, 18/255> / 3]
					[0.14 rgb <134/255, 113/255, 24/255> / 3]
					[0.16 rgb <108/255, 81/255, 18/255> / 3]
					[0.20 rgb <108/255, 81/255, 46/255> / 3]
					[0.24 rgb <112/255, 108/255, 79/255> / 3]
					[0.28 rgb <133/255, 87/255, 47/255> / 3]
					[0.32 rgb <138/255, 115/255, 80/255> / 3]
					[0.36 rgb <167/255, 142/255, 54/255> / 3]
					[0.40 rgb <171/255, 143/255, 80/255> / 3]
					[1.00 rgb <140/255, 111/255, 48/255> / 3]
				}
				scale 0.5
			}
			normal
			{
				bumps 0.6
				scale 0.1
			}
		}
	}

	//
	// Finally, place the soil object in the scene where needed.
	//

	#declare Px = 0;
	#while (Px < 3)
		#declare Pz = 0;

		#while (Pz < 1)
			#declare Iz = 0;

			#while (Iz < 2)
				#declare Ix = 0;

				object
				{
					soil
					translate <(Px * (12)) + (Ix * 0.5), 0, (Pz * 11) + (Iz * 2.2) - 0.1>
				}
				#declare Iz = Iz + 1;
			#end

			#declare Pz = Pz + 1;
		#end

		#declare Px = Px + 1;
	#end
#end
