// ===========================================================================
//
// (C) Ian Shumsky / OuterArm 1999
//
// ===========================================================================
//
// This include file defines and adds trees to the scene. Its use is
// controlled by the trace_trees switch. Valid value are:
//
//   0 - Don't trace trees
//   1 - Add trees
//
// The tree is the output of LParser.
//
// ===========================================================================

#if (trace_trees > 0)
	#declare bark_colour = rgb <44/255, 32/255, 10/255>;

	#declare tree_texture = texture
	{
		pigment
		{
			crackle
			turbulence 0.4
			lambda 3.2
			color_map
			{
				[0 color bark_colour*.3]
				[0.1 color bark_colour*.4]
				[0.6 color bark_colour*.8]
				[1 color bark_colour*1.2]
			}
		}
		finish
		{
			ambient 0.1
		}
		scale <0.2, 0.7, 0.2>*1
	}

	#declare branch_object = object
	{
		cone
		{
			<0, 0, 0>, 1.1, <0, 1.5, 0>, 1
		}
	}

	#declare bare_tree = union
	{
		#include "trunk.inc"
		texture
		{
			tree_texture
			scale 20
		}
		scale 0.006
	}

	#declare tree_rand = seed (1);

	object
	{
		bare_tree
		rotate y*(rand (tree_rand) * 360)
		translate <50, 0, 5>
	}

	object
	{
		bare_tree
		rotate y*(rand (tree_rand) * 360)
		translate <50, 0, 15>
	}
#end
