// Persistence of Vision Ray Tracer Scene Description File
// File: 38Ahoror.pov
// Vers: 3.1
// Desc: For the Internet Raytracing Competition (IRTC)
// Date: 10/30/99
// Auth: Bob Franke
//

#version 3.1;              

//#declare simpleTexture = 1;    
  #declare planeRotate = 1;     
  #declare showClouds = 1;    
//#declare useBlur = 1; 
  #declare showMan = 1;

#include "colors.inc"
#include "finish.inc"
#include "textures.inc"
#include "metals.inc"

global_settings{
  assumed_gamma 2.4  
  max_trace_level 50
}

//============================================== 

light_source{ <-20, 30, -30>*10000  color White * 1.15/2}
light_source{ <20, 30, -30>*10000  color White * 1.55/2}
light_source{ <10, 30, -30>*10000  color White * .3}
light_source{ <0, -5, 1>  color White*.9 fade_distance 10 fade_power 2 shadowless}    
//============================================== 

camera{ 
  location  <0.0, 0.5, -4.5>
  direction 1.6*z
  right     4/3*x
  look_at   <0.0, 0.0,  0.0>
  rotate<0,0,-4>  

  #ifdef (useBlur)
    focal_point < 0, 0,  0>  
    aperture 0.015    
    blur_samples 50    
  #end  
}     
//============================================== 

#macro flyingGlass (showit)
  #local saveX = rand(Ry);
  #local saveY = rand(Rx);
     
  prism {
    linear_sweep
    linear_spline  
    -0.01, 
     0.01, 
    5,   
    <saveX,saveY>, 
    <rand(Rx),rand(Ry)>, 
    <rand(Rx),rand(Ry)>, 
    <rand(Rx),rand(Ry)>, 
    <saveX,saveY> 

   rotate<rand(Ry)*360,rand(Ry)*360,rand(Ry)*360>   
    scale .3     
    translate<-2.4,-1.25,.35>
    texture{Glass2}   
    #if (showit = 1)
      translate<rand(Ry)*3,rand(Ry)*2,rand(Ry)*.5>
    #else
       translate<rand(Ry)*20,rand(Ry)*2,rand(Ry)+1>
    #end  
    #ifdef (planeRotate)
      rotate<0,0,-8>  
    #end  
  }      
 #end
//============================================== 

#macro glassAtWindowEdge (xx,yy)
  #local saveX = rand(Ry);
  #local saveY =  rand(Rx);
     
  prism {
    linear_sweep
    linear_spline  
    -0.01, 
     0.01,
    5, 
    <saveX,saveY>, 
    <rand(Rx),rand(Ry)>, 
    <rand(Rx),rand(Ry)>, 
    <rand(Rx),rand(Ry)>, 
    <saveX,saveY> 
    
    rotate<90,0,0>
    scale .5       
    translate<xx,yy,0.1518+.005>
    #ifdef (planeRotate)
      rotate<0,0,-8>  
    #end  
    texture{Glass2}      
  }      
 #end
//============================================== 

#declare wallTexture = 
#ifdef (simpleTexture)
  texture{ pigment{NewTan}}   
#else  
  texture{
    pigment{
      bozo
      turbulence 0.4
      color_map{
       	[0.00 color NewTan*1.1]
        [1.00 color NewTan*.85*1.1]
      }
      scale .1
    }    
    normal{
      wrinkles .5
      scale .01  
    }
  }
#end  
//============================================== 

#declare Blue_Sky33 = 
pigment {
    granite
    turbulence 0.15 
    omega .6
    color_map {
        [0.0 rgbf <1, 1, 1,0>*1.6]
        [0.6 rgbf 1]
        [1.0 rgbf 1]
    }
    scale 1  
    translate<0,0,-1.5>
}  

sky_sphere{
  pigment{Blue*.8}
}  
//============================================== 
  
#declare window=  
union{
  difference{ // the basic window frame 
    difference{   
      superellipsoid{ < 0.4 .0625>  scale<1,1.3,.33/2>  translate<0,0,.15>}
      superellipsoid{ < 0.4 .0625> scale<1,1.3,10>*.85 }
      texture{wallTexture rotate<0,0,90> translate<5,0,0> scale .9 } 
      #ifndef(simpleTexture) 
        finish {specular .9 roughness 0.001}
      #end   
    }  
    box{<-.90,-1.2,.25/12>,<.90,1.1,.625/12 > translate<0,0,.25/12> }
  } 

  difference{ // add an inside surface with high ambient
    difference{   
      superellipsoid{ < 0.4 .0625>  scale<1,1.3,.33/2>  translate<0,0,.15>}
      superellipsoid{ < 0.4 .0625> scale<1,1.3,10>*.849 }
      texture{wallTexture rotate<0,0,90> translate<5,0,0> scale .9 } 
      #ifndef(simpleTexture) 
        finish{ Shiny ambient .5}
      #end   
    }  
    box{<-1.90,-2.2,.876/12>,<1.90,2.1,-2.625/12 >  }  
  } 
  
  difference{ // add the outer Aluminum frame
    difference{   
      superellipsoid{ < 0.4 .0625>  scale<1,1.3,.33/2>  translate<0,0,.15>}
      superellipsoid{ < 0.4 .0625> scale<1,1.3,10>*.825 }
    }    
    box{<-1.90,-2.2,2/12>,<1.90,2.1,-2.625/12 >  }  
    texture{Aluminum      
      normal {
        bumps -0.005
        scale 0.000001
      }
    }  
  } 

  union{ // add the window shade
    box{<-.90,1.01,.25/12>,<.9,1.1,.5/12> }  
    cylinder{<-.9,1.01,.375/12>,<.9,1.01,.375/12>, .125/12 }
    cylinder{<0,1.045,.375/12>,<0,1.07,.375/12>, 3/12 scale<1,1,.5> }
    torus{3/12, 0.0125 scale<1,1,.5> translate <0,1.0575,0> }          
    texture{
      pigment{Wheat*.95}  
      finish{
        phong 0.6
        phong_size 10 
      }  
    }  
    translate<0,0,.25/12>
  }   
}  
//==============================================   

#declare wall2 = 
union{
  union{
    difference{
      box{<-5,-3,.000001>,<5,3,.33>}  
      superellipsoid{ < 0.4 .0625> scale<1,1.3,10>*.9 } // hole for the window
    }  

    height_field{ // add the ribs
      tga             
      "wall3.tga"       
      translate<-.5,0,-.5>   
      water_level .000001
      rotate<-90,0,0>  
      scale <9,9,.1>        
    }              
    texture{wallTexture translate<5,0,0> } 
  } //union
  
  object{window }
} //union   
//============================================== 

#declare engine=
union{
  difference{
    object{
      sphere{<0,0,0>, 3.25}
      clipped_by{plane{x,.5}}
      translate<-.5,0,0>
      scale<2.5,1.0122,1>
    }   
    object{                               
      sphere{<0,0,0>, 2.75}
      clipped_by{plane{x,.5}}
      translate<-.5,0,0>
      scale<2.5,1.0122,1>
    }   
    pigment{Wheat*.8}     
    finish{Shiny}
  }       
  torus{3,.25 texture{Chrome_Texture scale<1,1,1>} rotate<0,0,90>}
  sphere{<0,0,0>, 1 
    scale<3,.8,.3> 
    rotate<0,0,5>
    translate<-3,2.875,0>  
    texture{ T_Silver_3C }
  }
}
//============================================== 

#declare wing=
union{
  difference{
    cylinder{<2,0,0>,<35,0,0>,2 scale<1,.3,1> }
    box{<-5,-10,-3>, <25,0,3>}
    box{<5,-3,.5>, <18,3,2>} 
    union{                                            
      cylinder{<1.25/12,.5,0>,<1.25/12,0,0>, .25/12 rotate<0,0+45,0>} 
      cylinder{<1.25/12,.5,0>,<1.25/12,0,0>, .25/12 rotate<0,90+45,0>} 
      cylinder{<1.25/12,.5,0>,<1.25/12,0,0>, .25/12 rotate<0,180+45,0>} 
      cylinder{<1.25/12,.5,0>,<1.25/12,0,0>, .25/12 rotate<0,270+45,0>}  
      translate <10,0,.25>
    }
    texture{ T_Silver_3C  
    finish{ambient .9 diffuse .1}  
    }
  }

  box{<5,0,0>, <17.95,-.25/12,1.25>
    rotate<-20,0,0>
    translate<0,.5,.55>   
    texture{ T_Silver_3C 
      finish{ambient .7 diffuse .3}
    }
  }
  sphere{<0,0,0>, 2.75 scale<.2,.3,1> translate<35,0,0> texture{ T_Silver_1A }}
}
//============================================== 

#declare airPlane=
union{
  object{wall2}
  box{<-20,-2.875,-20>,<20,-3,1.25/12> pigment{White}} 
  object{wing scale<1.5,1,1.375> rotate<0,-90,0>  translate<-3+.5,-4,4.5>}
  object{engine translate<.75+.5,-7.61,15>}
} 
//============================================== 
                              
                              
//==============================================
//===========<< assemble the scene >>==========                              
object{
  airPlane  
  no_shadow         
  #ifdef (planeRotate)
    rotate<0,0,-8>  
  #end  
}


#ifdef ( showClouds )
  plane{y, -950.0 
    hollow on  
    pigment{ Blue_Sky33 scale<1,6,2>*4000} 
//    no_shadow 
  } 

  fog{
    color rgbft <.7, 0.7,.8,0, 0>
    fog_type 2
    fog_alt 1000
    fog_offset -10000
    distance 1500
  }    
#end  

//======<< start add the ground planes >>========
plane{y, -5100.0    
  texture{
    pigment{
      image_map{
        tga "image2.tga" 
        map_type 0      
        interpolate 2    
      }   
    }
    translate<-.5,0,-.5>
    rotate<90,0,0>
    finish {ambient .4  diffuse .6}
  scale 10000
    translate<0,0,26000>
  }
} 

plane{y, -5000.0    
  texture{
    pigment{
      image_map{
        tga "image2.tga"
        map_type 0 
        interpolate 2
        once 
      } // image_map
    }
    translate<-.5,0,-.5>
    rotate<90,0,0>
    finish {ambient .5  diffuse .5}
    scale 10000
    translate<2000,5,16000>
  }

  texture{
    pigment{
      image_map{
        tga "image2.tga" 
        map_type 0 
        interpolate 2 
        once 
      } // image_map
    }
    translate<-.5,0,-.5>
    rotate<90,0,0>
    finish {ambient .5  diffuse .5}
    scale 10000
    translate<3000,10,20000>
  }  
}   
//======<< end add the ground planes >>========



// =======<< start add the falling man >>===========
#ifdef ( showMan )                     
  #include "fullman2.inc"              
  #include "parts.inc"                 
                                       
  #declare theMan=                     
  union{                               
    object{ man                        
      scale 12                         
      rotate<0,160,0>                  
      translate<0,-6.5,7>	             
    }	                                 
                                       
    object{ parts                      
      scale 12                         
      rotate<0,160,0>                  
      translate<.185,-.76,3.7265>	     
    }	                                 
  }                                    
                                       
  object{theMan                        
    translate<0,0,0>                   
    #ifdef (planeRotate)               
      rotate<0,0,-8>                   
    #end                               
//    no_shadow                        
  }                                    
#end 
// =======<< end add the falling man >>===========


//======<< start add flying glass >>=============
#declare Rx = seed(76);
#declare Ry = seed(121);

#declare ii = 1;
#while (ii < 75)
  #declare ii = ii + 1;
  flyingGlass(1)    
#end 

// add the rest of the 100 pieces out of sight
// this allows me to vary the number of pieces
// of glass from 1 to 100 without disturbing
// the order of the random numbers for the
// following calls to  glassAtWindowEdge
#while (ii < 100)
  #declare ii = ii + 1;
  flyingGlass(0)    
#end  
//======<< start add flying glass >>=============

//====== add a few pieces around the window edge
glassAtWindowEdge (-1.1,1.0)
glassAtWindowEdge (-1.2,.9)
glassAtWindowEdge (-1.2,.6)
glassAtWindowEdge (-1.2,0)
glassAtWindowEdge (-1.15,-.5)

glassAtWindowEdge (0.65,1.0)
glassAtWindowEdge (0.55,.9)
glassAtWindowEdge (0.65,.6)
glassAtWindowEdge (0.65,0)   

glassAtWindowEdge (0.65,0)
glassAtWindowEdge (0.8,-.5)
glassAtWindowEdge (0.5,-.75)
glassAtWindowEdge (0.0,-.85)

