// Fence and Gate

#declare gBase = intersection {
	box { -1, 1 translate y }
	plane { < 1,  1,  1>, 0 translate < .5, 2, .5> }
	plane { < 1,  1, -1>, 0 translate < .5, 2,-.5> }
	plane { <-1,  1,  1>, 0 translate <-.5, 2, .5> }
	plane { <-1,  1, -1>, 0 translate <-.5, 2,-.5> }
	texture { T_Stone55 }
}

#declare gStake = intersection {
	box {	<-.25, 0, -.25>, <.25, 12, .25> }
	plane { < 1,  .2,  1>, 0 translate y*12 }
	plane { < 1,  .2, -1>, 0 translate y*12 }
	plane { <-1,  .2,  1>, 0 translate y*12 }
	plane { <-1,  .2, -1>, 0 translate y*12 }
	rotate y*45
}	

#declare gCrest = difference {
	sphere { 0, 1 }
	sphere { 0, 1 scale <1, .70, 1> }
	plane { z, 0 rotate x*30 }
	plane { -z, 0 rotate x*-30 }
}

#declare gPost = union {
	object { gStake }
	object { 
		gCrest
		scale <1.2, 1.0, 0.6>
		translate y*11
	}
	object { 
		gCrest
		rotate x*180
		scale <0.8, 1.0, 0.6>
		translate y*9.2
	}
	object { 
		gCrest
		scale <1.2, 1.0, 0.6>
		rotate y*90
		translate y*11
	}
	object { 
		gCrest
		rotate x*180
		scale <0.8, 1.0, 0.6>
		rotate y*90
		translate y*9.2
	}
	texture { gMetal }
}

#declare GatePost = union {
	object { gBase }
	object { gPost translate y*2 }
}

#declare gInner = sqrt(2)*.25;

#macro oRing(Inner, Outer)
	lathe {
		linear_spline
		5
		<Outer+Inner, 0>, <Outer, -Inner>, <Outer-Inner, 0>, <Outer, Inner>, <Outer+Inner, 0> 
		rotate x*90
	}
#end

#declare gCurve = intersection {
	oRing(gInner, 2.0)
	plane { -x, 0 }
	plane { y, 0 }
}

#macro gStile(Low, High)
	box {	<-.25, Low, -.25>, <.25, High, .25> rotate y*45 }
#end
		
#macro gRail(Low, High)
	box {	<Low, -.25, -.25>, <High, .25, .25> rotate x*45 }
#end
		
#declare fRing = object { oRing(gInner, 1) }

#declare gDiag = object { 
	gRail(-5, 5) rotate z*-45
	clipped_by { box { -1.125, 1.125 } }
}

#declare gOrth = object { gDiag scale <-1, 1, 1> }

#declare gCorner = intersection {
	gStile(-.5, .5)
	gRail(-.5, .5)
}

#declare Gate = union {
	//Rails
	object { gRail(0, 6.75) translate y*2.5 }
	object { gRail(0, 6.75) translate y*10.5 }
	object { gRail(4, 4.75) translate y*14.5 }
	object { gRail(2.25, 4.50) translate y*0.5 }
	//Stiles
	gStile(2.5, 10.5)
	object { gStile(0.5, 10.5) translate x*2.25 }
	object { gStile(0.5, 10.5) translate x*4.50 }
	object { gStile(2.5, 12.5) translate x*6.75 }
	//Curves
	object { gCurve translate y*12.5 }
	object { gCurve rotate z*180 translate <4, 12.5, 0> }
	object { gCurve rotate z*-90 translate <4.75, 12.5, 0> }
	object { gCurve rotate z*  0 translate <4.75, 12.5, 0> }
	object { gCurve rotate z* 90 translate <4.75, 12.5, 0> }
	object { gCurve rotate z* 90 translate y*.5 }
	object { gCurve translate <4.75, 2.5, 0> }
	//Corners
	object { gCorner translate y*10.5 }
	object { gCorner translate y*2.5 }
	object { gCorner translate <2.25, 0.5, 0> }
	object { gCorner translate <4.50, 0.5, 0> }
	object { gCorner translate <6.75, 2.5, 0> }
	//Decoration
	object { fRing translate <3.75, 12.5, 0> }
	object { oRing(gInner, 1.125) translate <3.375, 8.25, 0> }
	object { oRing(gInner, 1.125) translate <3.375, 4.75, 0> }
	object { gDiag translate < 1.125, 9.375, 0> }
	object { gOrth translate < 5.625, 9.375, 0> }
	object { gDiag translate < 5.625, 3.625, 0> }
	object { gOrth translate < 1.125, 3.625, 0> }
	object { gDiag translate < 1.125, 5.875, 0> }
	object { gOrth translate < 5.625, 5.875, 0> }
	object { gDiag translate < 5.625, 7.125, 0> }
	object { gOrth translate < 1.125, 7.125, 0> }

	texture { gMetal }
}

#declare fRail = gRail(-8, 8)

#declare fStile = union {
	object { gStake scale <1, 0.55, 1> }
	object { gStake scale <1, -.55, 1> }
}

#declare fDiag = intersection {
	object { fRail rotate z*-45 }
	plane { x, 1 }
	plane { -x, 1 }
}

#declare fOrth = object { fDiag scale <-1, 1, 1> }

#declare Fence = union {
	// Rails
	object { fRail translate y*2.5 }
	object { fRail translate y*10.5 }

	// Stiles
	object { fStile translate <-6, 6.5, 0> }
	object { fStile translate <-4, 6.5, 0> }
	object { fStile translate <-2, 6.5, 0> }
	object { fStile translate < 0, 6.5, 0> }
	object { fStile translate < 2, 6.5, 0> }
	object { fStile translate < 4, 6.5, 0> }
	object { fStile translate < 6, 6.5, 0> }
	
	// Rings
	object { fRing translate <-5, 8.5, 0> }
	object { fRing translate <-5, 4.5, 0> }
	object { fRing translate < 5, 8.5, 0> }
	object { fRing translate < 5, 4.5, 0> }
	object { fRing translate <-1, 9.5, 0> }
	object { fRing translate <-1, 3.5, 0> }
	object { fRing translate < 1, 9.5, 0> }
	object { fRing translate < 1, 3.5, 0> }
	object { fRing translate <-7, 6.5, 0> }
	object { fRing translate < 7, 6.5, 0> }

	// Diagonals
	object { fDiag translate <-7, 9.5, 0> }
	object { fOrth translate < 7, 9.5, 0> }
	object { fDiag translate < 7, 3.5, 0> }
	object { fOrth translate <-7, 3.5, 0> }
	object { fDiag translate <-3, 7.5, 0> }
	object { fOrth translate < 3, 7.5, 0> }
	object { fDiag translate < 3, 5.5, 0> }
	object { fOrth translate <-3, 5.5, 0> }
	object { fDiag translate <-1, 5.5, 0> }
	object { fOrth translate < 1, 5.5, 0> }
	object { fDiag translate < 1, 7.5, 0> }
	object { fOrth translate <-1, 7.5, 0> }
	
	texture { gMetal }
}
