// Persistence of Vision Ray Tracer Scene Description File
// File: .pov
// Vers: 3.1
// Desc: solves the problem of light from the candle making them area lights, 6.5 hrs
// 2a has area light solution
// Date: 99/03/23 start
// Auth: Matthias M. Giwer 

#include "colors.inc"	// Standard Color definitions
#include "textures.inc"	// Standard Texture definitions

global_settings { assumed_gamma 2.2 
				max_trace_level 5
				max_intersections 64
}
/*
light_source
{
  0*x 
  color red 1.0  green 1.0  blue 1.0
  translate <0, 7.9, 6>
  //fade_distance 5 fade_power 1.5
 }

light_source
{
  0*x 
  color red 1.0  green 1.0  blue 1.0
  translate <0, 7.9, -6>
  //fade_distance 5 fade_power 1.5 
  //shadowless
 }
  */

camera
{
  location  <0.0, 5.95, -2> //-1.9z
  direction 1*z
  up        y 
  right     4/3*x 
  look_at   <0.0, 5.95,  2.0>
}

//floor
box { <-1,-1,-1> <1,  1,  1>
   scale <40,.001,40>
   texture {
      pigment {color rgb <1,1,1>}
      finish {ambient 0.5}
//      normal {}
   }
}

//ceiling
box { <-1,-1,-1> <1,  1,  1>
   scale <40,.001,40>
   translate <0,9.2,0>
   texture {
      pigment {color rgb <.6,.6,.7>}
      finish {ambient 0.5}
//      normal {}
   }
}

//back wall
box { <-1,-1,-1> <1,  1,  1>
   scale <40,.001,40>
   rotate 90*x
   translate <0,0,18>
   texture {
      pigment {image_map{ tga "C:\images\hallow.tga"  map_type 0} scale .01}
      finish {ambient 0.5}
   }
}

#include "doors.inc"

object {door1  translate <-3.5,3,18>  }

#declare cross = union {
box { <-.5,-.5,-.5>, <.5,.5,.5>
        texture {pigment {color <.1,.1,.1>} finish{specular 1 ambient 1}}
        scale <.1,1,.1> // vertical
        }
        

box { <-.5,-.5,-.5>, <.5,.5,.5>
        texture {pigment {color <.1,.1,.1>} finish{specular 1 ambient 1}}
        scale <.75,.1,.1>
        translate .185*y
        }             
}
object {cross  translate <3.25,5.5,17.9>      }

//left wall
box { <-1,-1,-1> <1,  1,  1>
   scale <40,.001,40>
   rotate 90*z
   translate <-10,0,0> // -6 0 0
   texture {
      pigment {image_map{ tga "C:\images\hallow.tga"  map_type 0} scale .01}
      finish {ambient 0.5}
//      normal {}
   }
}

//right wall
box { <-1,-1,-1> <1,  1,  1>
   scale <40,.001,40>
   rotate 90*z
   translate <6,0,0>
   texture {
      pigment {image_map{ tga "C:\images\hallow.tga"  map_type 0} scale .01}
      finish {ambient 0.5}
//      normal {}
   }
}

//front wall
union {

difference {

box { <-1,-1,-1> <1,  1,  1>
   scale <40,.001,40>
   //rotate 90*x
   translate <0,0,0>
   texture {
      pigment {image_map{ tga "C:\images\hallow.tga"  map_type 0} scale .01}
      finish {ambient 0.5}
//      normal {}
   }
} // end box

cylinder {<-1,0,0> <1,0,0> .9
   scale <.0011,.85,.85>
   rotate 90*z
   //translate <0,6,0>
   hollow
}
   rotate 90*x
   translate <0,6.1,0> 
} //end difference

intersection { 
torus {1*1.3,.1}
box {<-1,-1,-1> <1,1,1> translate <-1,0,-1>} 
rotate 45*y
   texture {Yellow_Pine scale 0.05 rotate 3*z} 
   scale <1,1,1>
   rotate 90*x
   translate <0,5.75,0>
   scale <1,1,.4>
//}
scale .6
translate <0,2.65,0>
}

intersection { 
torus {1*1.3,.1}
box {<-1,-1,-1> <1,1,1> translate <-1,0,-1>} 
rotate 135*y
   texture {Yellow_Pine scale 0.05 rotate 90*y rotate -6*z rotate 7*x} 
   scale <1,1,1>
   rotate 90*x
   translate <0,5.75,0>
   scale <1,1,.4>
//}
scale .6
translate <0,2.65,0>
}

intersection { 
torus {1*1.3,.1}
box {<-1,-1,-1> <1,1,1> translate <-1,0,-1>} 
rotate 225*y
   texture {Yellow_Pine scale 0.05 rotate 180*y rotate -8*z rotate 4*x} 
   scale <1,1,1>
   rotate 90*x
   translate <0,5.75,0>
   scale <1,1,.4>
//}
scale .6
translate <0,2.65,0>
}

intersection { 
torus {1*1.3,.1}
box {<-1,-1,-1> <1,1,1> translate <-1,0,-1>} 
rotate -45*y
   texture {Yellow_Pine scale 0.05 rotate 90*y rotate -5*z rotate -2*x} 
   scale <1,1,1>
   rotate 90*x
   translate <0,5.75,0>
   scale <1,1,.4>
//}
scale .6
translate <0,2.65,0>
}

//mantle
box { <-1,-1,-1> <1,1,1> scale <0.93,1,1> translate 0*z translate 4.2*y
   texture {Yellow_Pine scale 0.05 rotate 90*y rotate -0*z rotate -0*x}
}



} //end union

#declare bug = union {

sphere { 0.0, 1 scale < 1,2,.3>*.5 // body
   texture {pigment {color <.3,.3,.35>} finish{ specular .5  ambient .5}}
   normal { crackle .75 scale .008} }

sphere { 0.0, 1 scale < 1,2,.3>*.4 translate -0.08*z // underbelly
   texture {pigment {color <.33,.33,.38>} finish{ specular .5}}
   normal {crackle .45 scale .09} }

difference {
sphere { 0.0, 1 } 
box { <-1,-1,-1> <1,1,1> translate <-1,0,1>}   
   scale < 1,2,.3>*.4 rotate <-5,0,5> translate <0.04, -0.01, .08> // left wing
   texture {pigment {radial frequency 1} finish{ specular .5}} 
}

difference {
sphere { 0.0, 1 } 
box { <-1,-1,-1> <1,1,1> translate <1,0,1>}   
   scale < 1,2,.3>*.4 rotate <-5,0,-5> translate <-0.04, -0.01, .08> // right wing
   texture {pigment {radial frequency 3} finish{ specular .5}} 
}

#declare leg = union { // leg
union {   
cylinder { 0*x 4*x 0.25}
sphere { 0.0, .25}
sphere {  4*x, .25}
}
union { // mid leg
cylinder { 0*x 3*x  0.2}
sphere { 0*x, .2}
sphere {  3*x, .2}
rotate 45*y translate 4*x
}
union { //bot leg
cylinder { 0*x 2*x 0.15}
sphere { 0*x, .15}
sphere {  2*x, .15}
rotate 90*y translate (4+(3/1.414))*x translate -(3/1.414)*z 
}
   texture {pigment {color <.4,.45,.4>} finish{ specular 1  ambient .5} 
   normal {crackle -1 scale .001} }
   scale <.225 ,.15,.15>       
}
// six legs
object { leg rotate 0*x translate <0.1, 0, -0.2> }

object { leg rotate 60*z translate <0.1, 0, -0.2> translate .2*y }

object { leg rotate -30*z translate <0.1, 0, -0.2> translate -.2*y }

object { leg rotate 180*z translate <-0.1, 0, -0.2> }

// mirror leg that is touching
object { leg rotate -18*x rotate 180*z rotate -60*z rotate -35*y translate <-0.1, 0, -0.2> translate .2*y }

object { leg rotate 180*z rotate 25*z rotate 0*x translate <-0.1, 0, -0.2> translate -.2*y }
// end legs

#declare head = union {
sphere { 0.0, 1 scale < 1,2, .5>*.2 rotate<0,90,90> translate <0,1,0> //head
   texture {pigment {color <.25,.25,.3>} finish{ specular 1 ambient .5} 
   normal {crackle 1 scale .04}} }

sphere { 0.0, 1 scale < 1,1, 1>*.1 translate <.2, 1.06, 0> //right eye
   texture {pigment {hexagon pigment {color rgb<0,0,0> }
                             pigment {color rgb<0,1,0>}
                             pigment {color rgb<1,1,0>} } finish { specular 1
                                                               ambient .5} 
                                   rotate -30*x scale .0035 } }

sphere { 0.0, 1 scale < 1,1, 1>*.1 translate <-.2,1.06,0> //left eye
   texture {pigment {hexagon pigment {color <0,0,0> }
                             pigment {color <0,1,0>}
                             pigment {color <1,1,0>} } finish { specular 1
                                                               ambient .5} 
                                    rotate -30*x scale .0035 } }

sphere { 0.0, 1 scale < 1,1.1, .3>*.075 rotate 90*x translate <0,1.0,-0.2> //mouth
   texture {pigment {color <.5,.5,.6>} finish{ specular .75 ambient .5} }
   normal { crackle 1 scale .02} }

sphere { 0.0, 1 scale < 1, 1.2, .3>*.075 rotate 90*x translate <-0.05, 1.0, -0.2> //mouth
   texture {pigment {color <.4,.4,.5>} finish{ specular 1 ambient .5}}
   normal {crackle -.5 scale .01} }

sphere { 0.0, 1 scale < 1, 1.2, .3>*.075 rotate 90*x translate <0.05, 1.0, -0.2> //mouth
   texture {pigment {color <.4,.4,.5>} finish{ specular 1 ambient .5}} 
   normal {crackle -.5 scale .01}}

#declare c = 1;
#while (c<50)

sphere { 0.0, 1 scale < 1,1.5, 1>*.013 translate <.22+(c/150), 1+(c/100),0.125+(c/300)*cos(c/45)> //right antenna
   texture {pigment {color <.3,.31,.3>} finish{ specular 1 ambient .5}} }

sphere { 0.0, 1 scale < 1,1.5, 1>*.013 translate <-.22-(c/200), 1+(c/100),0.125+(c/100)*cos(c/40)> //left antenna
   texture {pigment {color <.31,.31,.3>} finish{ specular 1 ambient .5}} }

#declare c = c+1;
#end
}

// for animating the head back to zero, move, put back 
object { head translate <0, -1, 0> rotate -10*x 
                                   rotate 1*y 
                                   rotate 0*z translate <0, 1, 0>}

} // end bug union

object { bug rotate -30*x scale 2 translate <0,4.5,4>}

#include "candlestick.inc"

object {candle1 scale .13 rotate 45*y translate <0.65, 5.5, -.25>}
object {candle1 scale .13 rotate 50*y translate <-0.63, 5.5, -.25>}
object {candle1 scale .13 rotate 50*y translate <0.65, 5.5, .25>}
object {candle1 scale .13 rotate 45*y translate <-0.63, 5.5, .25>}

candle1

#declare acandle = union {
cylinder
{
  0*y,  1*y, .05 texture {
                          pigment {color rgbft <.9,.9,.75,.1,0.1>}
                          finish {ambient .5 diffuse .5} }
  translate <0,-1,0>
}

//#declare tear = 

union {



  light_source {
    <0, -.75, 0> color rgb<1,1,.5> fade_distance .5 fade_power 2
  area_light <.05,0,0> <0,.05,.10>
    3, 3 
    adaptive 1
    jitter 
  
  }
  
  light_source {
    <0, -.99, 0> color rgb<.25,.25,1>*.5 fade_distance .5 fade_power 4 //5 
        area_light <.05,-.2,0> <0,.4,.10>
    3, 3 
    adaptive 1
    jitter
    
  }
  
  lathe {
    cubic_spline
11,
<0,1>,
<0.00756218,0.951057>,
<0.0561285,0.809017>,
<0.166744,0.587785>,
<0.328582,0.309017>,
<0.5,0>,
<0.622475,-0.309017>,
<0.642273,-0.587785>,
<0.531657,-0.809017>,
<0.301455,-0.951057>,
<0,-1>

texture {
    pigment { color rgbft<1,1,1,0,1> }
    finish { ior 0.9 
      ambient 0 
      diffuse 0 
      phong 5 phong_size 7
    }    
}    
    scale <1,2,1> 
  }        scale .07 translate .14*y      
}
} 


object {acandle scale 2 rotate 3*y translate 2.125*y 
scale .13 translate <0.65, 5.5, -.25>}

object {acandle scale 2 translate 2.125*y 
scale .13 translate <-0.63, 5.5, -.26>}

object {acandle scale 2 rotate -3*y translate 2.125*y 
scale .13 translate <0.65, 5.5, .25>}

object {acandle scale 2 translate 2.125*y 
scale .13 translate <-0.63, 5.5, .26>}


#declare book = union {
 
difference {
 
box {<-1,-1,-1>, <1,1,1> texture {pigment {color <.5,.1,.0>} 
        finish{ambient .8 specular .5}
        normal {crackle -1} scale <.005,.005,.01>          
        } 
        scale <7,.5,5>
}                      

box {<-1,-1,-1>, <1,1,1> scale <7,.5,5> scale <1.1,.9,1> translate .2*z}
            
} // difference       
      
// follows pages edges
box {<-1,-1,-1>, <1,1,1> texture {pigment {color <.7,.5,0>} finish{specular 1 ambient 1}
        normal {crackle -2} scale 0.1 scale <2,1,2> 
        } 
        scale <7,.5,5> scale <.95,.9,.95> translate .1*z
}
            
text 
{
  ttf             // font type (only TrueType format for now)
  "c:\windows\fonts\agincort.ttf",  // Microsoft Windows-format TrueType font file name
//  "c:\windows\fonts\arial.ttf",  // Microsoft Windows-format TrueType font file name
  "The Directors (c) Matt Giwer",      // the string to create
  .5,              // the extrusion depth
  0               // inter-character spacing
  scale <1,.75,1> // <0.75, 0.75, 0.75>
  texture { pigment { color <.8,.6,.2> } finish {ambient 1 specular 1 }
  normal {bumps 1} scale .01 }
    translate <-6, -.225, -5.1> } 
 
 
}                          

object { book scale <1,1.4,1>/30 rotate 22*y translate 5.22*y 
translate -.2*x translate -.23*z } // rotate 17*y}

object { book scale <1,1.4,1>/30 rotate 180*x rotate -22*y translate 5.22*y
translate -.2*x translate .43*z }

