// Table and Cage Wagons  include objects
//
  
#declare Table=union{
  box{<-1,.85,-.5><1,.87,.5> texture{T_Wood1 rotate<0,90,0> scale .25}}
  box{<-.95,.7,-.45><.95,.85,.45> texture{T_Wood1}}
  box{<-.97,.85,-.47><-.9,0,-.4> texture{T_Wood1 rotate<90,0,0> scale .25}}
  box{<.97,.85,-.47><.9,0,-.4> texture{T_Wood1 rotate<90,0,0> scale .25}}
  box{<-.97,.85,.47><-.9,0,.4> texture{T_Wood1 rotate<90,0,0> scale .25}}  
  box{<.97,.85,.47><.9,0,.4> texture{T_Wood1 rotate<90,0,0> scale .25}}
}

#declare Wagon_Metal=texture{pigment{color Gray50} normal{bumps .7 scale .00051}} 
                     
#declare WagonWheel=union{
  difference{                            // rim of wheel
     cylinder{<-.051,0,0><.051,0,0> .16}
     cylinder{<-.11,0,0><.11,0,0> .15}
  }
  cylinder{<-.053,0,0><.053,0,0> .03}
  cylinder{<-.06,0,0><.06,0,0> .025}
  #declare Count=0;
  #while (Count<180)
     cylinder{<0,-.16,0><0,.16,0> .015 rotate<Count,0,0>}
     #declare Count=Count+45;
  #end
 texture{Wagon_Metal} 
} 

#declare Wagon_Axel_Back=union{
  object{WagonWheel translate<-.3,0,0>}
  object{WagonWheel translate<.3,0,0>}
  cylinder{<-.3,0,0><.3,0,0> .02 texture{Wagon_Metal}}
  box{<-.23,0,-.05><-.21,.2,.05> texture{Wagon_Metal}}
  cylinder{<-.23,0,0><-.21,0,0> .05 texture{Wagon_Metal}}
  box{<.23,0,-.05><.21,.2,.05> texture{Wagon_Metal}}
  cylinder{<.23,0,0><.21,.2,0> .05 texture{Wagon_Metal}}  
}  
#declare Wagon_Axel_Front=union{
  object{WagonWheel translate<-.3,0,0>}
  object{WagonWheel translate<.3,0,0>}
  cylinder{<-.3,0,0><.3,0,0> .02 texture{Wagon_Metal}}
  cylinder{<0,-.05,0><0,.05,0> .1 texture{Wagon_Metal}}
  cylinder{<0,.05,0><0,.06,0> .08 texture{Wagon_Metal}}
  cylinder{<0,.06,0><0,.08,0> .1 texture{Wagon_Metal}}
  cylinder{<0,.08,0><0,.2,0> .065 texture{Wagon_Metal}}
  cone{<0,0,0>.025 <0,0,-2> .015 texture{T_Wood1 rotate<90,45,90> scale .25} rotate<-5,0,0> translate<0,.04,0> }  // tongue
}

#declare Wagon_Wheel_Base=union{
   object{Wagon_Axel_Back translate<0,0,.5>}
   object{Wagon_Axel_Front rotate<0,-20,0> translate<0,0,-.5>}
}   
                      
#declare Wagon_Base_Rim=difference{
    box{<-.35,0,-.65><.35,.05,.65>}
    box{<-.32,-.1,-.62><.32,.051,.62>}
   texture{Wagon_Metal}
}

#declare WGH=.75;  // wagon cage height                        
#declare Wagon_Base=union{
  object{Wagon_Base_Rim}  
  object{Wagon_Base_Rim translate<0,WGH,0>}

  #declare Count=-.35;
  #while (Count<(.35-.7/6))
    box{<0,0,-.62><.7/6-.015,.04,.62> translate<Count,0,0> 
        texture{T_Wood1 scale .1 translate<Count*10,0,-Count*10>} normal {bumps .4 scale .1}}
    #declare Count=Count+(.7/6);
  #end

  #declare Count=-.635;
  #while (Count<=.635)
    cylinder{<.335,.05,Count><.335,WGH,Count> .015 } 
    sphere{<.35,.025,Count> .01 } 
    sphere{<.35,WGH+.025,Count> .01}
    cylinder{<-.335,.05,Count><-.335,WGH,Count> .015 }
    sphere{<-.35,.025,Count> .01}   
    sphere{<-.35,WGH+.025,Count> .01}
    cylinder{<-.335,WGH+.025,Count><.335,WGH+.025,Count> .015 }     // top bar 

    #if((Count> -.325)&(Count<.335))    
      cylinder{<Count,.05,-.635><Count,WGH,-.635> .015 }
      sphere{<Count,.025,-.65> .01}
      sphere{<Count,WGH+.025,-.65> .01}
      cylinder{<Count,.05,.635><Count,WGH,.635> .015 }
      sphere{<Count,.025,.65> .01}
      sphere{<Count,WGH+.025,-.65> .01}
    #end
    #declare Count=Count+1.3/8;
  #end
  texture{Wagon_Metal}
}         

#declare Wagon=union{
   object{Wagon_Wheel_Base translate<0,.15,0>}
   object{Wagon_Base translate<0,.35,0>}
}

#declare Wagon_Bent=union{
  difference{
    object{Wagon}
    box{<.36,.4,-.7><.3,.8,-.17>}  // cut out bars...
    box{<.345,.35,-.7><.36,.4,-.17> texture{pigment{color Gray50}}}   // part of base metal to make failure point
    cylinder{<.335,.35,-.635><.335,.4,-.635>.0155}
    cylinder{<.335,.35,-.4725><.335,.4,-.4725> .0155}
    cylinder{<.335,.35,-.31><.335,.4,-.31> .0155}
  }
                                    
  // Failure point
//    box{<.345,.35,-.65><.3,.4,-.17>}
    union{
       box{<0,0,0> <.005,.05,-.45>}
       cylinder{<.01,.025,-.43><-.05,.025,-.46>.005}
       sphere{<.01,.025,-.43> .01}
       sphere{<.0095,.025,-.265> .01}
       sphere{<.0085,.025,-.1> .01}
      rotate<0,-3,0> translate<.345,.35,-.17>
    }
       
  // Add bar length back in
    cone{<.335,.8,-.635>.015 <.35,.7,-.65> .015 }//texture{Wagon_Metal}}  // corner bar
    cone{<.35,.7,-.65> .015 <.4,.72,-.7> .015 }//texture{Wagon_Metal}}
    cone{<.4,.72,-.7> .015  <.41,.8,-.78> .015 }//texture{Wagon_Metal}}
    
    cone{<.335,.8,-.4725> .015 <.35,.75,-.4725> .015}        // second bar 
    cone{<.35,.75,-.4725> .015 <.43,.65,-.4725> .015} 
    cone{<.43,.65,-.4725> .015  <.52,.58,-.5> .015}
    
    cone{<.335,.8,-.31> .015  <.36,.7,-.32> .015}        // third bar
    cone{<.36,.7,-.32> .015   <.4,.65,-.2> .015}
    cone{<.4,.65,-.2> .015  <.51,.73,-.1> .015}
      
    texture{Wagon_Metal}  
    //texture{pigment{color Red}} 
}  
