#declare OFlamme = merge {sphere {0,1}cylinder{0,3*y,1} // flamme
 #if(area)
 light_source {-.4*y color rgb clt area_light .2*y,x,10,1 fade_distance fd fade_power 2}
 #else
 light_source {-.2*y color rgb clt fade_distance fd fade_power 2}
 #end
//cylinder {-.3*y,-.1*y,.1 pigment {color rgbf<1,0,0,0>} finish {ambient 1} no_shadow translate -2*z}
 pigment{rgbf 1}
 interior {media {
  emission rgb<1,1,0>
  absorption rgb .5
  density {spherical color_map {
   [0 rgb 0]
   [.1 rgb <1,.1,0>]
   [.2 rgb <1,.5,0>]
   [.6 rgb<1,1,0>]
   [.8 rgb 1]
  } scale <1,1.6,1> translate -.8*y turbulence <.1,.4,.1> octaves 5 lambda 5 omega 1
 } #if(area) samples 1,1e3 variance 1e-4 confidence 1-1e-4 #end // samples -> parsing
 }}
 scale <.6,2,.6>
 hollow on
 scale 1/.45
}

#declare OTorche = union { // torche
 sphere {0,1 scale <.3,.2,.3>}
 intersection {sphere {0,.3 scale <1,14,1>} plane {y,0}}
 texture {TTorche rotate rand(s)*360*y}
 translate -1.4*y
 scale 1/.45
}
#declare OOeil = union { // oeil+paupiere
 sphere {0,1 texture {TGlobe}} // blanc
 sphere {0,.3 scale <1,1,.7> translate -z texture {TPup} rotate -<12,20,0>} // noir
 
 intersection {sphere {0,1.01} plane {-z,0} rotate <0,-40,-10>} // voile
 union { // sup
  intersection {sphere {0,1 scale <1.2,1.1,1.1> translate .1*x} plane {-y,0}}
  torus {1.1,.1 scale <1,2,1>}
  rotate <30,-20,-30>
 }
 union { // inf
  intersection {sphere {0,1.1} plane {y,0}}
  torus {1,.1 scale <1,2,1>}
  rotate <-45,10,-30>
 }
 texture {TSkin}
 translate <-1.2,.6,-2.5> // oeil gauche
}

#declare OSem = union { // elements symetriques
 object {OOeil}
 sphere {0,1 scale <1.8,1.1,.8> rotate <50,30,10> translate -<1.2,1,2.4>} // joue
 intersection { // levre sup
  cylinder {-y,0,1 scale <2,1,.5> rotate <-10,0,-15>}
  cone {<0,-2,0>,.4,0,0 scale <1,1,.5> translate -.5*z rotate -10*x inverse}
  plane {x,0}
  translate <0,-1.2,-2.7>
 }

 union { // dents sup
  cone {0,.3,-.8*y,0 rotate 17*z translate <-.2,0,0>}
  cone {0,.3,-.8*y,0 rotate 19*z translate <-.6,0,.04>}
  cone {0,.3,-1.2*y,0 rotate 21*z translate <-1,0,.1>}
  cone {0,.3,-.8*y,0 rotate 23*z translate <-1.4,0,.15>}
  rotate <-10,0,-15>
  translate <0,-2,-2.7>
  texture {TTooth}
 }
 union { // dents inf
  cone {0,.2,.8*y,0 rotate 30*z translate <-.2,0,0>}
  cone {0,.2,.6*y,0 rotate 28*z translate <-.6,0,.06>}
  cone {0,.15,.4*y,0 rotate 24*z translate <-1,0,.15>}
  cone {0,.15,.35*y,0 rotate 20*z translate <-1.4,0,.22>}
  cone {0,.15,.25*y,0 rotate 15*z translate <-1.8,.2,.3>}
  rotate <-20,0,-30>
  translate <.2,-3.8,-2.1>
  texture {TTooth}
 }

 difference { // oreille
  union {
   sphere {0,.6 scale <1,1,.5> rotate <20,60,0> translate <-3,-.6,0>} // lobe
   sphere {0,.6 scale <1.5,2,.5> rotate 60*y rotate <45,0,30> translate <-3.2,.4,.2>}
  }
   sphere {0,.4 scale <1,1,.5> rotate <20,60,0> translate <-3.2,-.6,-.2>}
   sphere {0,.4 scale <1.5,2,.5> rotate 60*y rotate <45,0,30> translate <-3.4,.4,0>}
   sphere {0,.4 scale <1,1,.5> rotate <20,60,0> translate <-3,-.2,-.2>} // trou
 }
 sphere {0,.3 scale <1,1,.7> rotate 60*y translate <-3,-.3,-.4>} // boule

 texture {TSkin}
}

#declare OTete = union{ // tete
 object {OSem} // moitie gauche
 object {OSem scale <-1,1,1>} // droite

 difference {
  sphere {0,1 scale <3,4,3>} // crane
  sphere {0,1 scale <2,1,5> translate <0,-2.4,-4>}// bouche
 }
 sphere {0,1 scale <1,.6,1.5> translate <0,-.3,-2.5>} // nez sup
 intersection {sphere {0,1} plane {y,0} // nez inf
  scale <1,1,1.5> translate <0,-.3,-2.5>}
 sphere {0,1 scale <1,.4,1> translate -<0,3.6,1.6>} // levre inf
 intersection { // zygomatiques
  torus {1,.15 rotate -100*x scale <2,3,5>}
  plane {y,0}
  translate <0,-.8,-2>
 }
 sphere {0,1 scale<.6,1,1> translate<0,-4,0>} // cou
 texture {TSkin}
}

#declare OSCasque = union { // demi-casque
 intersection {
  sphere {0,4 translate <1,0,0>}
  plane {x,0}
  plane {-y,-1}
  scale <.96,1.2,.74>
  translate -y
 }
 union { // corne
  #declare da=10 ; #declare a=da ; #declare p1=-1.4*y ; #while(a<=80)
  #declare p0=p1 ; #declare p1=vrotate(-1.4*y,-a*z) ;
   cone {p0,((.1-.4)*(a-da)/80+.4),p1,((.1-.4)*a/80+.4)}
   sphere {p1,((.1-.4)*a/80+.4)}
  #declare a=a+da ; #end
  rotate -20*z
  translate <-1.6,2.6,0>
  texture {TCorne}
 }
}
#declare OCasque = union {
 torus {2.6,.4 scale <1,1.6,1> texture {THache}}
 #declare a=0 ; #while(a<360)
  sphere {0,.3 texture {TGold} translate -2.9*z rotate a*y}
 #declare a=a+24 ; #end
 object {OSCasque}
 object {OSCasque scale <-1,1,1>}
 texture {TWood}
}

#declare OCol = torus { // col
 1,.6 scale <1,1,2>
 clipped_by {plane {y,0 inverse}}
 clipped_by {sphere {-2*z,2 inverse}}
 rotate -30*x
 texture {TTunique}
}

#declare OSGlaive = intersection { // demi-lame
 cylinder {-5*y,20*y,5 translate <4.6,0,1>}
 cylinder {-5*y,20*y,5 translate <-4.6,0,1>}
 sphere {0,1 scale <10,40,10> translate 9.6*x translate z}
 sphere {0,1 scale <10,40,10> translate -9.6*x translate z}
 plane {z,0}
 translate 5*y
 texture {TLame}
}

#declare OGlaive = union {
 sphere {0,1 scale <.5,2.5,.7> texture {TWood}} // manche
 cylinder {-.4*x,.4*x,1 translate -3*y texture {TMetal}} // base
 sphere {0,1 scale <.6,.9,.9> translate -3*y texture {TGold}} // base
 sphere {0,1 scale <.8,.5,2.8> translate 2*y texture {TMetal}}// garde
 object {OSGlaive translate 2*y}
 object {OSGlaive scale <1,1,-1> translate 2*y}
}

#macro OHand(vh1,vh2) union { // main
 sphere {0,1 scale <.3,.5,.5> translate <0,-.4,0>} // poignet
 sphere {0,1 scale <.4,.8,1> translate -y} // carpe
 sphere {0,.3 translate <.2,-1.5,.6> scale <2,1,1>} // phalanges 1
 sphere {0,.3 translate <.2,-1.7,.2> scale <2,1,1>}
 sphere {0,.3 translate <.2,-1.7,-.2> scale <2,1,1>}
 sphere {0,.3 translate <.2,-1.5,-.6> scale <2,1,1>}
 sphere {0,.3 scale <1,1,2.4> rotate <-30,0,60> rotate -30*y translate <.6,-.6,-.8>} // pouce
 sphere {0,.3 scale <1,2,1> translate <.9,-1.1,.6>} //p2
 sphere {0,.3 scale <1,2,1> translate <.9,-1.3,.2>}
 sphere {0,.3 scale <1,2,1> translate <.9,-1.3,-.2>}
 sphere {0,.3 scale <1,2,1> translate <.9,-1.1,-.6>}

 #if(vdot(vh1,vh1)=0)
 object {OGlaive scale .6 translate .2*y rotate -90*x translate <.5,-1,0>} // hache
 #else
 object {OTorche translate 10*y rotate -90*x translate <.5,-1,0>} // torche
 #end
 translate <-.2,.4,0> // le poignet a l'origine

 texture {TSkin}
 rotate vh1 rotate vh2
}#end

#macro OForeArm(vf1,vf2,vh1,vh2) union { // avant-bras
 object {OHand(vh1,vh2) translate <.4,-3,-.6> rotate 30*y} // main
 sphere {0,.5} // coude
 sphere {0,1 scale <.6,1.4,.6> rotate <10,30,10> translate <0,-1.4,-.4>} // ab dos
 sphere {0,1 scale <.6,1.4,.4> rotate <5,-30,5> translate -<.2,1,.6>} // ab dessus
 sphere {0,1 scale <.4,1.4,.4> rotate <10,0,-3> translate <.2,-1.4,-.6>}
 rotate -30*y
 texture {TSkin}
 rotate vf1 rotate vf2
}#end

#macro OArm(va1,va2,vf1,vf2,vh1,vh2) union { // bras
 object {OForeArm(vf1,vf2,vh1,vh2) translate <0,-3.2,-.2>} // avant-bras
 sphere {0,1 scale <1,3.6,1.4> clipped_by {plane {-y,0}} texture {TTunique} translate -1.5*y} // manche
 sphere {0,1 scale <.8,2,1>} // epaule
 sphere {0,1 scale <.6,1.6,.8> translate -<.2,1.6,.5>} // biceps
 sphere {0,1 scale <.03,1.6,.83> translate -<.2,1.6,.5>} // a nerve on the biceps
 sphere {0,1 scale <.8,2,1> rotate 20*x translate <0,-1.2,0>} // bras
 texture {TSkin}
 translate -1.6*y
 rotate va1 rotate va2
 translate <-3.4,1,1.8>
}#end

#declare OPied = union { // pied
 sphere {0,1}
 intersection {sphere {0,1 scale <2.4,1,1>} plane {x,0}}
 intersection {sphere {0,1 scale <2.4,1,4>} plane {x,0} plane {-z,0}}
 intersection {sphere {0,1 scale <1,1,4>} plane {-z,0}}
 sphere {<0,1,3>,1 texture {TTunique}}
 scale 1.4
 texture {TPied}
}

#declare OBud = union {
 object {OTete translate 6.8*y rotate 45*y} // tete
 object {OCasque rotate 5*x translate <0,9,.2> rotate 45*y} // casque
 object {OCol translate <0,1.7,-.2>} // col
 object {OArm(<0,20,-20>,<20,0,0>,<0,30,0>,<50,0,0>,0,<-60,0,0>)} // bras gauche
 object {OArm(<0,30,-10>,<15,0,0>,<0,30,0>,<50,-60,0>,<0,-20,0>,<0,0,0>) scale <-1,1,1>} // bras droit

 #declare trd = .015 ;
 #macro blb(sth) 0,sqrt(1/(1-sqrt(trd/sth))),sth #end
 blob {
  threshold trd
  sphere {blb(1) scale <3.2,3.1,2.6> texture {TTunique} rotate -10*x translate <0,0,1.8>} // torse
  sphere {blb(1) scale <2.8,4,2.6> texture {TTunique} rotate -6*x translate <0,-3.6,2.4>} // ventre
 sphere {blb(1) scale <2,1.4,1.4> texture {TTunique} translate <-1.9,1,1.8>} // epaule
 sphere {blb(1) scale <2,1.4,1.4> texture {TTunique} translate <-1.9,1,1.8> scale <-1,1,1>} // epaule
 }

 object {OPied rotate 20*y translate -<2.4,8.2,1.2>}
 object {OPied rotate 20*y translate -<2.4,8.2,1.2> scale <-1,1,1>}
 object {OFlamme translate <.85,4.2,-5.4>}
 translate 8.5*y
}
