// Persistence Of Vision raytracer version 3.0 file
// File by Patrick Dugan

#version 3.0
global_settings { 
   assumed_gamma 2.2 
   max_trace_level 25   // default is 5... Higher numbers for black reflections that shouldn't be there...
}

#include "colors.inc"
#include "metals.inc"
#include "textures.inc"

camera {
   location <3, 2, -0.75>
   look_at <0, -0.5, 0>  
   angle 75
   aperture 0.25
   focal_point <0.85,1.85,0.3>
   blur_samples 37
   confidence 0.975
   variance 1/255 
}


light_source {<8, 8, -5> color White * 1
    spotlight
    point_at <0,0,0.7>
    radius 3
    falloff 11
} 

#declare Chain_Texture =
texture {
    pigment { color red 0.30 green 0.35 blue 0.40 }
    finish {
        ambient 0.3
        diffuse 0.7
        reflection 0.15
        brilliance 8
        specular 0.8
        roughness 0.1
        metallic
    }
}

#declare Gold_Texture2   =
   texture {
      pigment{ rgb <1.0, 0.65, 0.40>}   // Gold color
      finish{
         metallic
         reflection 0.8
         ambient 0.2
         diffuse 0.5
         phong 1.0
      }
   }


#declare BloodRed = color red 0.4 green 0.05 blue 0

#declare Bloodpool =
blob {
   threshold 0.2
   sphere { <0,0,0>, 1.5, 0.7 scale <0.75,1,1.5>
   }
   sphere { <0,2,0>, 2, 0.7 scale <0.75,1,2.5>
   }
   pigment{BloodRed}
   finish {
      crand 0.05
      ambient 0.2
      diffuse 0.6
      reflection 0.5
      brilliance 2.0
   }

}

#declare BloodSpot =
   sphere { <0,0,0>, 1 scale <1,0.33,1>
      pigment{BloodRed}
      finish {
         crand 0.05
         ambient 0.2
         diffuse 0.6
         reflection 0.5
         brilliance 2.0
      }
   }



#declare Bighook =
difference {
   torus { 2.5, 0.35        // major and minor radius
      rotate -90*x      // so we can see it from the top
   }
   box {
    < 1, 0.9, 1>,  // Near lower left corner
    <-6,-5,-1>   // Far upper right corner
   }
   sphere { <0.2,-0.5,0>, 2
   }
}

#declare Fishhook =
union {
   torus { 0.7, 0.45        // major and minor radius
      rotate -90*x      // so we can see it from the top
   }
   cylinder {
      <0.5, 0, 0>,     // Center of one end
      <3, 0, 0>,     // Center of other end
      0.40           // Radius
      open           // Remove end caps
   }
   object{Bighook
      translate <5.3,-1,0>
      scale <1,0.7,1>
      scale <1,1.7,1>
   }
  texture { Chain_Texture }
  hollow
}

#declare PinNail =
union {
   sphere { <0,33,0>, 1 scale <0.08,0.03,0.08>
      texture { Chrome_Texture }
   }
   cylinder {
      <0, 1, 0>,     // Center of one end
      <0, 0, 0>,     // Center of other end
      0.03           // Radius
      open           // Remove end caps
      texture { Chain_Texture }      
   }
   scale 0.40
}


#declare Glow =
sphere { <0,0,0>, 1.005
   pigment { color rgbt <1, 1, 1, 1> }
      interior {
         media {
           emission 1
           density {
              spherical
              color_map {
                 [ 0.0 color rgb <0.5, 0.00, 0> ]
                 [ 0.25   color rgbt <0, 2, 4,  1> ]
                 [ 1   color rgbt <0, 4, 4, -1> ]
              }
           }
         }
      }
   hollow
   scale 1.2
}


#declare AntiGlow =
sphere { <0,0,0>, 1.005
   pigment { color rgbt <1, 1, 1, 1> }
      interior {
         media {
           emission 10  // 3
           density {
              spherical               
              color_map {
                 [ 0 color rgbt <0, 0, 0, 1> ]
                 [ 1 color rgbt <-1, -1, -1, -1> ]
              }
           }
         }
      }
   hollow
   scale 1.2
   scale <0.12,0.12,0.22> 
}
 
 
// Dark wood with a,ish hue to it.
#declare EbonyWood = 
pigment {
    wood
    turbulence 0.2
    color_map {
        [0.6 rgb <0.15, 0.07, 0.02>]
        [0.8 rgb <0.11, 0.05, 0.02>]
        [1.0 rgb <0.05, 0.01, 0.01>]
    }
}


#declare BoxTexture =
    texture {EbonyWood scale 0.2
   finish {
      crand 0.05
      ambient 0.4
      diffuse 0.6
      reflection 0.2
      brilliance 3.0
   }
}


#declare Panel1 =
object {
   union {
      height_field {
         tga "HellSide3.tga"
         texture {Gold_Texture2}
         translate <-0.5, -0.5, -0.5>
         scale <1,0.02,1>
         rotate x * 90
         rotate z * 90
         hollow
      }
      box {<-0.55,-0.55,-0.005>,<0.55,0.55,0.1>
         texture {BoxTexture}
         hollow
      }
   }
}      
      
#declare Panel2 =
object {
   union {
      height_field {
         tga "HellSide2.tga"
         texture {Gold_Texture2}
         translate <-0.5, -0.5, -0.5>
         scale <1,0.02,1>
         rotate x * 90
         rotate z * 90
         hollow
      }
      box {<-0.55,-0.55,-0.005>,<0.55,0.55,0.1>
         texture {BoxTexture}
         hollow
      }
   }
    translate <0,0.6,-0.55>
    rotate x*90
}      

#declare Panel3 =
object {
   union {
      height_field {
         tga "HellSide1.tga"
         texture {Gold_Texture2}
         translate <-0.5, -0.5, -0.5>
         scale <1,0.02,1>
         rotate x * 90
         rotate z * 90
         hollow
      }
      box {<-0.55,-0.55,-0.005>,<0.55,0.55,0.1>
         texture {BoxTexture}
         hollow
      }
   }
    translate <-0.6,0,-0.55>
    rotate y*90
    rotate z*180
}      


#declare Hell1 =
union{
   object {Panel1}
   object {Panel2}
   object {Panel3}
   hollow
}


#declare HellCube =
union{
   object{Hell1}
   object{Hell1
      translate<0,0.55,-0.6>
      rotate y*-90
      rotate x*-90
      rotate z*-90
      rotate y*-180
   }
  translate <0.5,0.6,0> 
}

object {HellCube}  

#declare RealDarkBlue = color red 0.1 green 0.0 blue 0.4;

fog{ color Black distance 200}

object{Glow scale 0.7 translate <0.55,0.6,0.6>}

/*The tabletop surface*/

#declare AntiM =
object {
   union {
      #declare A = 0               
      #while (A < 360)
         object{AntiGlow 
            translate <0,0,-0.6>         
            rotate y * A
         }
         #declare A = A + 27.69230769;
      #end           
   }
}

object {AntiM
   translate <0.55,0.6,0.6>
}

#declare Welts =
object {
   union {
      #declare A = 0               
      #while (A < 360)
         sphere {<0,0,0>, 1
            scale <0.11,0.04,0.15>
            translate <0,-0.020,-2.42>
            rotate y * A         
         }
         #declare A = A + 27.69230769;
      #end           
   }
}
   
union{
   plane { -y,  0
      translate <0, 0, 0.3>
      hollow
   }
   plane { z, 10 pigment {Black}   hollow }
   object {Welts
      translate <0.5,0,0.6>
   }
   texture {Rosewood}
   finish {
      crand 0.05
      ambient 0.4
      diffuse 0.6
      reflection 0.2
      brilliance 3.0
   }
}
                          
#declare AllLink =
object {
   union {
      #declare link_thick = 0.1 //  rad
      #declare link_width = 0.2 //  rad
      #declare half_torus = intersection {
        torus { link_width,link_thick }
        plane { x,0 }
        translate x*(link_width-link_thick)
      }
      #declare cyl_link = cylinder {
        <link_width-link_thick,0,0>,<1-(link_width-link_thick),0,0>, link_thick
      }
      #declare link = union {
        object { half_torus }
        object { half_torus scale <-1,1,1> translate x*1 }
        object { cyl_link translate z*link_width }
        object { cyl_link translate -z*link_width }
        rotate x*0
        texture { Chain_Texture }
        translate x*-0.5
        scale 1
        translate x*0.5
      }
      #declare link_length = 0.1
      #declare link_rotation = 41.5 
      #declare link_error = 0.01
      #declare chain_start=<0.5,0.65,0.3>
      #declare chain_end=<0.5,0.14,-1.35>  //  -2.35
      #declare chain_scale= 0.001
      #include "chain11.inc"

      object{Fishhook
         scale 0.04
         rotate z*-13
         rotate y*90
         translate <0.5,0.13,-1.42>  // 1.37
       }
      object{Bloodpool
         scale <0.06,0.06,0.01>
         rotate x*90          
         translate <0.5,0,-1.84>
      }
      light_source {<0, 8, 0> color White * 2
          spotlight
          point_at <0.5,0,-1.84>
          radius 0.7
          falloff 7
      }
   }
   translate <-0.5,0,-0.5>  // Needed to bring it to the center
}

#declare AllOne =
object {
   union {
      #declare A = 0
      #while (A < 360)
         object{AllLink translate <0,0.5,-0.2> rotate y * A}
         #declare A = A + 27.69230769;
      #end
   }
}
   
object {AllOne   translate <0.5,-0.5,0.6> }
   
#declare A = 0
#declare B = seed(2452435)
#declare C = seed(5784337)
#declare D = seed(8834550)
#declare E = seed(1234123)
#declare F = seed(4321234)

#while (A < 200)

   #if (rand(F)>0.5)            // position on X axis
      #declare G = rand(B) * -0.7
   #else
      #declare G = rand(B) * 0.7
   #end
   #declare G = G + 0.5

   #if (rand(F)>0.5)            // position on Z axis
      #declare I = rand(D) * -0.7
   #else
      #declare I = rand(D) * 0.7
   #end
   #declare I = I + 0.5

   #declare H = rand(C) / -10   // position on Y axis
   #declare H = H - 0.04

   #if (rand(F)>0.5)            // rotation on Z axis
      #declare J = rand(E) * -30
   #else
      #declare J = rand(E) * 30
   #end

   #if (rand(F)>0.5)            // rotation on X axis
      #declare K = rand(E) * -30
   #else
      #declare K = rand(E) * 30
   #end

   object {PinNail
              rotate z * J
              rotate x * K
              translate <G,H,I>
          }
   object{BloodSpot scale 0.1 translate<G,0,I>}

   #declare A = A + 1

#end


