#include "colors.inc"
#include "textures.inc"
#include "stones.inc"
#include "metals.inc"

background { Black }

//Render Switches
#declare ShowSkull = on;
#declare ShowFace = on;
 #declare ShowFaceHalo = on;
#declare ShowGlobalFlame = on;
#declare ShowSky = on;
#declare ShowVolcano = on;
#declare ShowText = on;
#declare ShowWorship = on;
 #declare ShowParm = on;
 #declare ShowMaster = on;
#declare ShowGirls = on;
#declare ShowSkeleton = on;
#declare ShowSignature = on;

camera {
        location  <0, 1, -11>
        direction <0, 0,  1>
        up        <0, 1,  0>
        right   <4/3, 0,  0>
        look_at   <0, 0, 0>
}

light_source {<0, 100, -150> color White*.8 }
light_source {<75, 100, -150> color White*.7 }
light_source {<-75, 100, -150> color White*.7 }

#if ( ShowSkeleton = on )
#include "skeleton.inc"
object { Skeleton   //#1
         rotate <-90, 0, 0>
         rotate <0, 180, 0>
         rotate <0, 60, 0>
         scale .1
         translate <18, -35.5, 70>
       }
object { Skeleton   //#2
         rotate <-90, 0, 0>
         rotate <0, 180, 0>
         rotate <0, 50, 0>
         scale .1
         translate <24, -33.5, 65>
       }
object { Skeleton   //#3
         rotate <-90, 0, 0>
         rotate <0, 180, 0>
         rotate <0, 45, 0>
         scale .1
         translate <30, -31.5, 60>
       }
object { Skeleton   //#4
         rotate <-90, 0, 0>
         rotate <0, 180, 0>
         rotate <0, 50, 0>
         scale .1
         translate <35, -29.3, 55>
       }
object { Skeleton   //#5
         rotate <-90, 0, 0>
         rotate <0, 180, 0>
         rotate <0, 60, 0>
         scale .1
         translate <40, -27.5, 50>
       }
#end  // Skeleton

#if ( ShowGirls = on )  //---------------------------------------------
#declare Girls = texture { PinkAlabaster }
#include "hvfesmkn.inc"
#declare AllGirls = union {
object { Hvfesmkn  //Left, Front  
         rotate <-90,90,0>
         rotate <0,15,0>
         translate <-1.5, 0, -6>
       }
object { Hvfesmkn  //Right, Front
         rotate <-90,90,0> 
         rotate <0,-15,0>
         translate <1.5,0,-6>
       }
object { Hvfesmkn  //Left, 2nd  
         rotate <-90,90,0>
         rotate <0,15,0>
         translate <-3, 0, -12>
       }
object { Hvfesmkn  //Right, 2nd
         rotate <-90,90,0> 
         rotate <0,-15,0>
         translate <3,0,-12>
       }
object { Hvfesmkn  //Left, 3rd  
         rotate <-90,90,0>
         rotate <0,15,0>
         translate <-4.5, -1, -18>
       }
object { Hvfesmkn  //Right, 3rd
         rotate <-90,90,0> 
         rotate <0,-15,0>
         translate <4.5,0,-18>
       }
object { Hvfesmkn  //Left, 4th  
         rotate <-90,90,0>
         rotate <0,15,0>
         translate <-6, -1.5, -24>
       }
object { Hvfesmkn  //Right, 4th
         rotate <-90,90,0> 
         rotate <0,-15,0>
         translate <6,0,-24>
       }

}
object { AllGirls
         rotate <-20,0,0>
         rotate <0,35,0>
         translate <0,-4.5,35>
       }
#end  // Girls



#if ( ShowWorship = on )  //--------------------------------------------------
#declare Worship = union {
//                           
#if ( ShowParm = on )  //---------
height_field { gif "parm.gif" water_level 2/255
                 texture { pigment { image_map { gif "parm.gif" interpolate 2 filter 0,1}
                 rotate x*90 }
                 finish {crand 0.05 reflection 0 diffuse 0.5 ambient 0.5}
                }                     
                //smooth     
                translate <-.5, 0, -.5>
                scale <125, 100, 100>
                rotate <-90, 0, 0>
                translate <0, 50, 125> 
             }               
#end // Parm                
//                         
#if ( ShowMaster = on )  //-----------
#declare Sepaman_Valley = 
texture {
    pigment {
        granite
        color_map {
            [0.0, 0.3 color rgb <0.82, 0.57, 0.46>  
                      color rgb <0.82, 0.57, 0.46>]
            [0.3, 0.6 color rgb <1.0, 0.0, 0.0>
                      color rgb <0.85, 0.85, 0.95>]
            [0.6, 1.0 color rgb <0.82, 0.57, 0.46>  
                      color rgb <0.85, 0.85, 0.95>]
        }
    }
    finish { diffuse .7 ambient .3
        metallic
        brilliance 6.0
        reflection 0.3
        phong 0.75
    }
}
#include "sepaman.inc"
object { Sepaman
         scale 2
         rotate <0, 90, 0>
         translate <0, 10, 0>
       }
#end // Master
//
} // End of Worship Union
object { Worship
         translate <0, -15, 75>
       }  
#end // Worship


#if ( ShowSkull = on )  //-----------------------------------------------
#declare T_Stone20 =
texture{T_Grnt27 scale <0.7, 0.99, 0.7> rotate <0, 0, 40>}
texture{T_Grnt12a scale <1, 1.3, 2> rotate <0, 0, 40>}
texture{T_Grnt20a scale <1.9, 3, 0.5> rotate <0, 0, -50>}
texture{T_Crack1 scale <1, 0.6, 1> rotate <10, 0, -20>
        finish { phong 0.1 phong_size 10}
       }
#declare _0_____Black = texture { T_Stone20 }
#include "skulsmot.inc"
object { SkulSmot
         rotate <90, 0, 0>
         rotate <0, 10, 0>
         rotate <0, 0, 180>
         rotate <0, 30, 0>
         translate <6, -4, 15>
       }
#end

#if ( ShowFace = on )  //-------------------------------------------
union {
       blob {
             threshold 0.600000
             component 1.000000, 1.000000, <0.000000, 0.375000, 0.000000>
             component 1.000000, 1.000000, <0.000000, -0.375000, 0.000000>
             component 1.000000, 0.170000, <0.000000, -0.012658, -0.628692>
             component 1.000000, 0.150000, <0.000000, 0.100000, -0.500000>
             component 1.000000, 0.120000, <0.000000, 0.200000, -0.400000>
             component 1.000000, 1.000000, <0.000000, 0.375000, 0.500000>
             component 1.000000, 0.100000, <0.150000, 0.000000, -0.550000>
             component 1.000000, 0.100000, <-0.150000, 0.000000, -0.550000>
             component -2.000000, 0.200000, <-0.250000, 0.500000, -0.350000>
             component -2.000000, 0.200000, <0.250000, 0.500000, -0.350000>
             component -2.000000, 0.277649, <-0.329114, 0.434599, -0.375527>
             component -2.000000, 0.270736, <0.312236, 0.413502, -0.362869>
             texture { pigment { Sapphire_Agate }
                       finish { ambient 0.5  specular 1  roughness  .0001 
                                phong .25 phong_size 75 brilliance 4 
                              }
                     }  
             scale 0.5
             translate <0, 0, -0.5>        
            }
       sphere { <0, 0, 0>, 1.5 
                 hollow
                 texture { pigment {rgbt<1, 1, 1, 1>}
                           finish { ambient 0  diffuse 0 }
                           #if ( ShowFaceHalo = on ) // <------ Halo Temp Out
                           halo { emitting
                                  linear
                                  spherical_mapping
                                  max_value 2
                                  samples 20 
                                  aa_level 2
                                  aa_threshold 0.5
                                  color_map {
                                             [0.20 color rgbt<1, 0, 0,  1>]  //Red
                                             [0.30 color rgbt<1, 1, 0, -1>]  //Yellow
                                             [0.40 color rgbt<1, 1, 1,  1>]  //Clear
                                             [0.50 color rgbt<1, 0, .6, -1>]  //Red-Violet
                                             [0.60 color rgbt<1, 1, 1,  1>]  //Clear
                                             [1.00 color rgbt<1, 1, 1,  1>]  //Clear
                                            }
                                  turbulence 0.9
                                  octaves 9
                                  omega .7
                                  lambda 2.1
                                  scale 1.35
                                }
                           #end // <----Halo Temp Out                    
                         }  
                rotate <0, -30, 0>        
              }
       scale 6
       translate <7, 2, 15>
      }         
#end

//Global Flame
#if ( ShowGlobalFlame = on )  //--------------------------------
sphere { 0, 1 
         hollow
         texture { pigment {rgbt<1, 1, 1, 1>}
                   finish { ambient 0  diffuse 0 }
                   halo { emitting
                          linear
                          spherical_mapping
                          turbulence 1.0
                          max_value 2
                          samples 15 
                          aa_level 2
                          aa_threshold 0.5
                          color_map {
                                     [0.00 color rgbt<1, 0, 0,  1>]  //Red
                                     [0.20 color rgbt<1, 0, 0,  -1>]  //Red
                                     [0.30 color rgbt<1, 1, 0, -1>]  //Yellow
                                     [0.40 color rgbt<1, 1, 1,  1>]  //Clear
                                     [1.00 color rgbt<1, 1, 1,  1>]  //Clear
                                    }
                          scale .6
                        }
                 }
         rotate <0, -90, 0>
         scale <7, 7, 7,>
       }
#end

#if ( ShowVolcano = on )  //---------------------------------------------------------------
plane { z, 290
        inverse
        hollow
        texture { finish { ambient .5  diffuse .5  }
                           pigment { image_map { gif "volcano.gif" once interpolate 2
                                     filter 255,1  filter 254,1  filter 253,1
                                     filter 252,1  filter 251,1  filter 250,1
                                     filter 249,1  filter 248,1  filter 247,1
                                     filter 246,1  filter 245,1  filter 244,1
                                     filter 243,1  filter 242,1  filter 241,1
                                     filter 240,1  filter 239,1  filter 238,1
                                     filter 237,1  filter 236,1  filter 235,1
                                     filter 234,1  filter 233,1  filter 232,1
                                     filter 231,1  filter 230,1  filter 229,1
                                     filter 228,1  filter 227,1  filter 226,1
                                     filter 225,1  filter 224,1  filter 223,1
                                     filter 222,1  filter 221,1  filter 220,1
                                     filter 219,1  filter 218,1  filter 217,1
                                     filter 216,1  filter 215,1  filter 214,1
                                     filter 213,1  filter 212,1  filter 211,1
                                     filter 210,1  filter 209,1  filter 208,1
                                     filter 207,1  filter 206,1  filter 205,1
                                     filter 204,1  filter 203,1  filter 202,1
                                     filter 201,1  filter 200,1  filter 199,1
                                     filter 198,1  filter 197,1  filter 196,1
                                     filter 195,1  filter 194,1  filter 193,1
                                     filter 192,1  filter 191,1  filter 190,1
                                     filter 189,1  filter 188,1  filter 187,1
                                     filter 186,1  filter 185,1  filter 184,1
                                     filter 183,1  filter 182,1  filter 181,1
                                     //   
                                     filter 127,1  filter 126,1  filter 125,1
                                     filter 124,1  filter 123,1  filter 122,1
                                     filter 121,1  filter 120,1  filter 119,1
                                     filter 118,1  filter 117,1  filter 116,1
                                     filter 115,1  filter 114,1  filter 113,1
                                     filter 112,1  filter 111,1  filter 110,1
                                     filter 109,1  filter 108,1  filter 107,1
                                   }
                           translate <-0.45, -0.59, 0>
                           scale <475, 375, 1> } }
       }
#end

#if ( ShowSky = on )  //---------------------------------------------------------------
sphere { <0, 0, 0>, 1
        inverse
        hollow
        scale <500, 500, 500>
        texture { finish { ambient .5  diffuse .5  }
                           pigment { image_map { gif "flames.gif" once interpolate 2 }
                           translate <-0.5, -0.59, 0>
                           scale <565, 475, 1> } }
       }
#end
                                           
#if ( ShowText = on ) //-------------------------------------------------------------
text { ttf "ribbon.ttf" "Ye serpents, ye generation of vipers," 0.15, 0
       texture { T_Copper_4E  pigment { rgb<255/255,255/255,75/255> } finish {ambient .5 } }
       translate < -6.4, 4.4, 0 >
     }
text { ttf "ribbon.ttf" "how can ye escape the Damnation of Hell?" 0.15, 0
       texture { T_Copper_4E  pigment { rgb<255/255,255/255,75/255> } finish {ambient .5 } }
       translate < -5.8, 3.6, 0 >
     }
#end

#if ( ShowSignature = on ) //-------------------------------------------------------------
text { ttf "ribbon.ttf" "PcVaughan" 0.15, 0
       texture { T_Stone44 scale 0.5 }
       scale 0.5
       rotate <70,0,0>
       translate < -7.5, -5.55, 0 >
     }
#end
