// Persistence of Vision Ray Tracer Scene Description File
// File: cloaca.pov
// Vers: 3.1
// Desc: Un monstruo en algun tipo de cloaca o desague.
// Date: Agosto-Septiembre 1999
// Auth: J. F. Tuduri 
// Render final: 2h 2m 47s

// Primero se debe hacer un render de height.pov a 320x240 AA como TGA. Para crear 
// el heightfiled para el agua.

global_settings {assumed_gamma 1.8}

// **************** CAMARAS ****************************
#declare cam1 =
camera {location  <0,4.5,5> look_at   <1,2,10>} 

#declare cam2 =                                           // !!!
camera {location  <2.3,3.1,8> look_at   <-2.2,1.6,13.8>}

#declare cam3 =
camera {location  <1.8,2.4,12> look_at  <1.8,1.5,13.5>}

#declare cam4 =
camera {location  <2.3,2,12> look_at  <-1.55,1.5,12.95>}

camera {cam2}

//***************** LUCES ******************************

// create a regular point light source
#declare light1 =
light_source
{
  0*x // light's position (translated below)
  color rgb .65  // light's color
  translate <0, 4.5, 14.75>
} 

#declare light2 =
// An area light (creates soft shadows)
// WARNING: This special light can significantly slow down rendering times!
light_source
{
  0*x // light's position (translated below)
  color rgb .68  // light's color --- 1 --
  area_light
  <.5, 0, 0> <0, 0, .5> // lights spread out across this distance (x * z)
  10, 10 //10                // total number of lights in grid (4x*4z = 16 lights)
  adaptive 2          // 0,1,2,3... 
  jitter              // adds random softening of light
  fade_distance 10 //5
  fade_power 2   //1
  translate <0, 4.5, 14.75>   // <x y z> position of light
}

object {light2}    

light_source
{
  0*x // light's position (translated below)
  color rgb .5  // light's color  .7
  translate <-2, 2.5, 5>
  shadowless
} 


// *****************  CAOS ***********************
// Texturas  

#declare cemento = 
texture { 
        pigment {
                bozo
                turbulence .5
                frequency 3
                color_map {
                            [0.2 rgb <.25,.25,.25>]
                            [0.8 rgb <.3,.3,.3>]
                            [1 rgb <.15,.2,.15>]}
                }
        normal {bumps .2 scale .05 turbulence .1}
        finish {diffuse .6} //.5
        }
#declare revoque =
texture { 
        pigment {
                bozo
                turbulence 0
                frequency 1 
                scale 5
                color_map {
                            [0.3 rgb <.05,.05,.1>]
                            [0.55 rgbt <.05,.05,.1,1>]
                            [0.6 rgb <.1,.1,.15>]
                            [1 rgb <.15,.19,.25>]}
                }
        normal {dents .5 scale .2 turbulence .1}
        finish {diffuse .6}  //.5
        }

// ***
difference{                                                // Caos
           union {
                  cylinder {<0,2.5,-40>,<0,2.5,80>,2.7}
                  cylinder {<-20,2.5,15>,<20,2.5,15>,2.7}
                  }
           union {
                  cylinder {<0,2.5,-40>,<0,2.5,80>,2.5 open}
                  cylinder {<-20,2.5,15>,<20,2.5,15>,2.5 open}
                  }
                  texture {cemento}
                   texture {revoque}
                  //pigment {CadetBlue}
                  finish {ambient .5}
                  }


              
// ************************ PISO ***************************   
//***                          
 difference{                                            // * PISO GRANDE *
           union{                                       
                 box {<1.5,-2,-40>,<10,1.48,80>}
                 box {<-10,-2,-40>,<-1.5,1.48,80>}}
           box {<-15,-3,16>,<15,2,14>}                
                        
                        //pigment {Blue}
                        texture {cemento}
                        texture {revoque}
                        } 
                        
                        
// ************************* BALDOZAS **************************

// *** Texturas ***

#declare t_bal = 
        texture {pigment {agate
                         turbulence .7
                         color_map {[.3 rgb <.2,.2,.4>]
                                     [.6 rgb <.25,.25,.3>]
                                     [1 rgb <.15,.15,.3>]}}
                finish {reflection .05 phong .5 phong_size 90 metallic diffuse .6}
                normal {dents 1 scale .5}
                }
                
#declare t_bal_v =
        texture {pigment {bozo
                          turbulence 1
                          color_map {
                                     [.3 rgb <.05,.2,.1>]
                                     [.6 rgb <.2,.35,.24>]
                                     [.95 rgb <.25,.3,.25>]}
                         }
                finish {diffuse .5}
                normal {bumps .2 scale .3}
                }
                
#declare bal1 =
union {
cylinder {<0,0,0>,<.05,0,0>,.01 translate <0,.018,0>}
sphere {<0,0,0>,.01 scale <1.2,1,1> translate <0,.018,0>}
sphere {<0,0,0>,.01 scale <1.2,1,1> translate <.05,.018,0>}
}

#declare bal2 = union {
object {bal1 rotate <0,45,0> translate <.06,0,.05>}
object {bal1 rotate <0,-45,0> translate <.02,0,.05>}}

#declare bal3 = union{
#declare X = 0.04;
        #while (X < .7)
        object {bal2 translate x*X}
        #declare X = X + .1;
        #end
        }


#declare baldoza =
#declare radio_de_cil = .005;
union {
difference {
box {<0,0,0>,<.8,.02,1.3> }
        
cylinder {<0,.02,0>,<0,.02,1.3>, radio_de_cil}
cylinder {<.8,.02,0>,<.8,.02,1.3>,radio_de_cil}
cylinder {<0,.02,0>,<.8,.02,0>,radio_de_cil}
cylinder {<0,.02,1.3>,<.8,.02,1.3>,radio_de_cil}}

#declare Z = 0.04;
        #while (Z < 1.2)
        object {bal3 translate z*Z}
        #declare Z = Z + .1;
        #end
             
                                     }
union {
#declare cer_der = 12.7;                               // Cerca-Derecha
        #while (cer_der > 8.7)
        object {baldoza translate <1.5,1.48, cer_der>}
        #declare cer_der = cer_der -1.3;
        #end 
        
object {baldoza translate <1.5,1.48,16>}               // Lejos-Derecha
object {baldoza translate <1.5,1.48,17.3>}
object {baldoza translate <1.5,1.48,18.6>}
box {<2.3,1.48,18>,<1.5,1.5,80>}//1.5

#declare cer_der_x = 2.3;                               // Cerca-Derecha-Cruza
        #while (cer_der_x < -4)
        object {baldoza translate <cer_der_x,1.48, 12.7>}
        #declare cer_der_x = cer_der_x +.8;
        #end

#declare cer_izq = 12.7;                               // Cerca-Izquierda
        #while (cer_izq > 7)
        object {baldoza translate <-2.3,1.48, cer_izq>}
        #declare cer_izq = cer_izq -1.3;
        #end 

#declare lej_izq = 16;                               // Lejos-Izquierda
        #while (lej_izq < 26)
        object {baldoza translate <-2.3,1.48, lej_izq>}
        #declare lej_izq = lej_izq +1.3;
        #end
box {<-2.3,1.48,20>,<-1.5,1.5,80>}
        
#declare cer_izq_x = -3.1;                               // Cerca-Izquierda-Cruza
        #while (cer_izq_x > -5)
        object {baldoza translate <cer_izq_x,1.48, 12.7>}
        #declare cer_izq_x = cer_izq_x -.8;
        #end

#declare lej_izq_x = -3.1;                               // Lejos-Izquierda-Cruza
        #while (lej_izq_x > -8)
        object {baldoza translate <lej_izq_x,1.48, 16>}
        #declare lej_izq_x = lej_izq_x -.8;
        #end 
        
        texture {
                         spotted
                         turbulence .1
                         frequency 1
                         texture_map {
                                      [.3 t_bal]
                                      [1  t_bal_v]
                                     }}
                                     //pigment {Yellow}
                                     }
                                      

// ************************* BARANDAS **************************

// ***** texturas ********
         
#declare t_bar = texture {pigment {color rgb <.12,.12,.26>}
                   normal{granite scale .1 turbulence 3} //scale .05
                   finish {phong .1 phong_size 50 metallic reflection .01}
          }
#declare t_bar2 = texture {pigment {granite
                                      color_map {
                                       [.3 rgb <.187,.254,.189>] //g.354
                                       [.7 rgb <.376,.224,.153>] //r .476
                                       [1 rgb <.2,.05,.1>]}}  //r.3
                             normal{granite scale .2 turbulence 3}
                             finish {diffuse .6}
                             }


#declare bar_h=
        union{
              cylinder {<0,1,0>,<2,1,0>,.02}
              sphere {<0,1,0>,.03}
              }
                 
#declare baranda =         // baranda ,0,0,0-1,1.4,0
union {
object {bar_h}
object {bar_h translate <0,-.5,0>}
cylinder {<0,1,0>,<0,0,0>,.02}
sphere {<0,0,0>,.03}
       //quick_color {Navy}
       rotate <0,90,0>
       }
union {       
#declare b = 18.1;                             //barandas lejos-derecha
#while (b < 80)
  object { baranda translate <1.55,1.5,b>}
  #declare b = b + 2;
  #end
#declare b = 18.1;                             //barandas lejos-izquierda
#while (b < 80)
  object { baranda translate <-1.55,1.5,b>}
  #declare b = b + 2;
  #end

union {
//object {bar_h rotate <0,7,0> translate <.6,-.98,.58>}  //caito en el piso
object {bar_h translate <0,-.5,0>}
cylinder {<0,1,0>,<0,0,0>,.02}
sphere {<0,0,0>,.03}
       rotate <0,90,0>
       translate <1.55,1.5,13.95>
       }
       
#declare b = 11.95;                            //barandas cerca-derecha
#while (b > -40)
  object { baranda translate <1.55,1.5,b>}
  #declare b = b - 2;
  #end


#declare b = 13.95;                             //barandas cerca-izuierda
#while (b > -40)
  object { baranda translate <-1.55,1.5,b>}
  #declare b = b - 2;
  #end



#declare b = 1.55;                             //barandas cruzan-lejos-derecha
#while (b < 6)
  object { baranda rotate <0,-90,0> translate <b,1.5,16.05>}
  #declare b = b + 2;
  #end
  
#declare b = 1.55;                             //barandas cruzan-cerca-derecha
#while (b < 6)
  object { baranda rotate <0,-90,0> translate <b,1.5,13.95>}
  #declare b = b + 2;
  #end
       
#declare b = -1.55;                             //barandas cruzan-lejos-izquierda
#while (b > -6)
  object { baranda rotate <0,90,0> translate <b,1.5,16.05>}
  #declare b = b - 2;
  #end

#declare b = -1.55;                             //barandas cruzan-cerca-izquierda
#while (b > -6)
  object { baranda rotate <0,90,0> translate <b,1.5,13.95>}
  #declare b = b - 2;
  #end
  
         texture {       
                 agate                                                 // Textura
                 turbulence .9
                 scale <10,.7,10>  //5,.7.5
                 texture_map{
                             [.8 t_bar]
                             [1  t_bar2]}
                             }
                                              
                                             /* pigment {Green}*/
                                             }
       
                            

// ********************** AGUA ******************
//agua 

height_field
{
  tga               
  "height.tga"    
   smooth        
  scale <30,.5,70>
  translate <-15,.8,0>
          texture {
         pigment {spotted
                  turbulence .7
                  color_map {
                             [.2 rgbf <.1123,.2,.134,.6>] //9
                             [.5 rgbf <.15,.3,.343,.6>]
                             [.8 rgbf <.0768,.254,.142,.6>]
                             [1 rgbf <.134,.223,.243,.6>]}
                            }
         normal {bumps 0.2 scale 1 turbulence .2}  //scale 1,.7,.7
         finish {reflection .3//.4
                 irid {
                       0.2
                       thickness .3
                       turbulence .1
                      }
                      }}
         interior {caustics 10 ior 1.33}//pigment {Green}
}



box {<-20,0,0>,<20,.8,80> pigment {spotted
                                   turbulence 1
                                   color_map{
                                             [.1 rgbf <.05,.15,.1,.1>]
                                             [1 rgbt <.02,.1,.134,1>]}
                                             }
                          normal {bumps 0.3 scale <1,.7,.7> turbulence .2}
                                             }
                                             
box {<-20,0,0>,<20,.6,80> pigment {spotted
                                   turbulence 1.5
                                   color_map{
                                             [.3 rgbf <.05,.1,.15,.1>]
                                             [1 rgbt <.02,.1,.134,1>]}
                                             }
                                   normal {bumps 0.3 scale <1,.7,.7> turbulence .2}
                                             }


// *************** FOG ****************


  /*fog {
    distance 20    //22 50
    color rgbf<.9,1,.9,.8>
    turbulence 0.5
    turb_depth 0.4
    fog_type 1
    fog_offset .5
    fog_alt .1
      } */


// *********** TUBOS ********************
// *** Texturas ***

#declare t_tubo1=
       texture { pigment {color rgb <.3,.2,.15>}   //.4.2.2
                 finish {phong .3 phong_size 50 metallic}
                 normal {dents .5 scale .5}
                 }
                 
#declare t_tubo3=
       texture { pigment {color rgb <.2,.2,.3>}
                 finish {phong .3 phong_size 50 metallic}
                 normal {dents .5 scale .5}
                 }
                 
#declare t_tubo2=
       texture { pigment {bozo
                          turbulence 7
                          color_map {
                                     [.4 rgb <.15,.24,.1>]
                                     [.7 rgb <.1,.175,.05>]
                                     [1 rgb <.16,.212,.123>]
                                     }}
                 finish {diffuse .5}
                 normal {bumps .7 scale .2}
                 }
// *** 
#declare tubo =
union { 
       cylinder {<0,0,0>,<59,0,0>,.05}
       sphere {<0,0,0>, .05}
       cylinder {<0,0,0>,<0,0,-59>,.05 }
       }
       
#declare tubo2 =
union { 
       cylinder {<0,0,0>,<59,0,0>,.025}
       sphere {<0,0,0>, .025}
       cylinder {<0,0,0>,<0,0,-59>,.025 }
      }

union{ 
object {tubo2 translate <2.35,1.95,12.55>}
object {tubo2 rotate x*180 translate <2.35,1.95,17.45>}
object {tubo2 rotate <180,0,180> translate <-2.345,1.95,17.45>}       

texture {bozo
         turbulence 15
         scale <1,1,30>
         texture_map
         {[.5 t_tubo3]
          [1 t_tubo2]}}
      }
union {

object {tubo translate <2.335,1.8,12.6>}
object {tubo rotate x*180 translate <2.335,1.8,17.4>}
object {tubo rotate <180,0,180> translate <-2.325,1.8,17.4>}

union {                                                         // el tubo roto
sphere {<0,0,0>,.05 translate <-2.325,1.8,12.6>}
cylinder {<0,0,0>,<-60,0,0>,.05 open translate <-2.325,1.8,12.6>}
cylinder {<0,0,0>,<0,0,-.87>,.05 open translate <-2.325,1.8,12.6>}
cylinder {<0,0,-1.63>,<0,0,-60>,.05  open translate <-2.325,1.8,12.6>}
sphere {<0,0,-1.63>,.05 translate <-2.325,1.8,12.6>}
cylinder {<0,0,0>,<0,0,.76>,.05 open rotate <16,4,0> translate <-2.325,1.8,10.99> }
      }

texture {bozo
         turbulence 25
         scale <1,1,30>
         texture_map
         {[.5 t_tubo1]
          [1 t_tubo2]}}
}
   
// ************************ AROS ***************************               

#declare aro=
torus {2.5,.02
       rotate <90,0,0> 
       translate <0,2.5,0>
       }
       
#declare b = 6.7;
#while (b < 60)
  object { aro translate <0,0,b> 
                texture {cemento}
                        texture {revoque}
        }
         
  #declare b = b + 5.5;
  #end 
 
// ************************* REJAS **************************
#declare t_reja = texture {pigment {color rgb <.12,.12,.16>}
                   normal{wrinkles scale .1}
                   finish {phong .8 phong_size 40 metallic reflection .01}
          }
#declare t_reja_v = texture {pigment {granite
                                      color_map {
                                       [.3 rgb <.087,.154,.089>]  //le reste -.1 a todo
                                       [.7 rgb <.076,.124,.053>]}}
                             normal{granite scale .5}
                             finish {diffuse .6}
                             }
                   
#declare Z = 20;//20                            // Z indica la posicion en el tunel de toda la reja

#declare reja =
union {
difference {                                                  // El aro grande
            cylinder {<0,2.5,Z-.03>,<0,2.5,Z+.03>, 2.6}
            cylinder {<0,2.5,Z-.03>,<0,2.5,Z+.03>, 2.48 open}
             }

union {                                                       // barrotes sobre pasarela
        cylinder {<1.55,0,Z>,<1.5,5,Z>,.025}
        cylinder {<-1.55,0,Z>,<-1.5,5,Z>,.025}
        cylinder {<-1.75,4.01,Z>,<-1.75,5,Z>,.02}
        cylinder {<1.75,4.01,Z>,<1.75,5,Z>,.02}
        }
union {                                                       // barrotes horizontales
        box {<-1.56,3,Z-.03>,<1.56,3.03,Z+.03>}
        box {<-2.5,4,Z-.03>,<2.5,4.03,Z+.03>}
        box {<-1.56,1.5,Z-.03>,<1.56,1.53,Z+.03>}
        }

#declare X = -1.3;                                            // barrotes altos sobre el agua
        #while (X < 1.5)
        cylinder {<X,1.51,Z>,<X,5,Z>,.02}
        #declare X = X + .26;
        #end
                                                              
#declare malla =                                              // barrotes en el agua
union{
cylinder {<0,0,0>,<0,2,0>,.015 rotate z*40 translate <-1,-0.01,Z>}
cylinder {<0,0,0>,<0,2,0>,.015 rotate z*-40 translate <-2.7,-0.01,Z>}
}


#declare X = 0;
        #while (X < 4)
        object {malla translate <X,0,0>}
        #declare X=X+.15;
        #end
                 
        texture {       
                 agate                                                 // Textura
                 turbulence .9
                 scale <.7,5,.7> 
                 texture_map{
                             [.8 t_reja]
                             [1  t_reja_v]}
                 }
        }
        
object {reja}

// ************* MONSTRUO ********************* 

#declare mons_tex = 
texture {pigment {spotted  //spotted
                  turbulence .7  //.7
                  color_map {
                             [.2 rgb <.3,.4,.6>] //.4.5.7
                             [.5 rgb <.4,.5,.6>] //.5.6.7
                             [.8 rgb <.35,.43,.5>]  //.6.65.7
                             [1 rgb <.41,.43,.6>]} //.65.65.7
                             }
	         normal {bumps .8  scale .05 turbulence .7}
	         finish {reflection .4 }  //.2
	        }
	        

#include "monstruo.inc"
object {tens_grande  rotate <15,0,0> scale 1.3 translate <-.3,1.8,13.3> texture {mons_tex}}  //z 13
object {tens_chico  rotate <15,0,0> scale 1.3 translate <-.3,1.8,12.5> texture {mons_tex}} 

object {cuerpo  rotate <0,0,0> scale 1.3 translate <-.3,.5,13> texture {mons_tex finish {diffuse .4}}}  

